/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.radial.StationRadialDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.RadialDatasetTable;
import ucar.nc2.ui.point.StationRegionDateChooser;
import ucar.nc2.ui.widget.IndependentDialog;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class StationRadialViewer
extends JPanel {
    private PreferencesExt prefs;
    private StationRadialDataset sds;
    private StationRegionDateChooser chooser;
    private BeanTable stnTable;
    private RadialDatasetTable rdTable;
    private JSplitPane splitH = null;
    private JSplitPane splitV = null;
    private IndependentDialog infoWindow;
    private boolean eventsOK = true;
    private boolean debugStationRegionSelect = false;
    private boolean debugStationDatsets = false;
    private boolean debugQuery = false;

    public StationRadialViewer(PreferencesExt prefs) {
        this.prefs = prefs;
        this.chooser = new StationRegionDateChooser();
        this.chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Station")) {
                    Station selectedStation = (Station)e.getNewValue();
                    if (StationRadialViewer.this.debugStationRegionSelect) {
                        System.out.println("selectedStation= " + selectedStation.getName());
                    }
                    StationRadialViewer.this.eventsOK = false;
                    StationRadialViewer.this.stnTable.setSelectedBean(selectedStation);
                    StationRadialViewer.this.eventsOK = true;
                }
            }
        });
        this.stnTable = new BeanTable(StationBean.class, (PreferencesExt)prefs.node("StationBeans"), false);
        this.stnTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StationBean sb = (StationBean)StationRadialViewer.this.stnTable.getSelectedBean();
                StationRadialViewer.this.setStation(sb);
                if (StationRadialViewer.this.debugStationRegionSelect) {
                    System.out.println("stnTable selected= " + sb.getName());
                }
                if (StationRadialViewer.this.eventsOK) {
                    StationRadialViewer.this.chooser.setSelectedStation(sb.getName());
                }
            }
        });
        this.rdTable = new RadialDatasetTable((PreferencesExt)prefs.node("RadialDatasetTable"));
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentDialog(null, true, "Station Information", infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.splitH = new JSplitPane(1, false, this.stnTable, this.chooser);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 400));
        this.splitV = new JSplitPane(0, false, this.splitH, this.rdTable);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
    }

    public void setDataset(FeatureDataset dataset) {
        this.sds = (StationRadialDataset)dataset;
        if (this.debugStationDatsets) {
            System.out.println("PointObsViewer open type " + dataset.getClass().getName());
        }
        CalendarDate startDate = dataset.getCalendarDateStart();
        CalendarDate endDate = dataset.getCalendarDateEnd();
        if (startDate != null && endDate != null) {
            this.chooser.setDateRange(new DateRange(startDate.toDate(), endDate.toDate()));
        }
        ArrayList<StationBean> stationBeans = new ArrayList<StationBean>();
        try {
            List stations = this.sds.getStations();
            if (stations == null) {
                return;
            }
            for (Station station : stations) {
                stationBeans.add(new StationBean(station));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        this.stnTable.setBeans(stationBeans);
        this.chooser.setStations(stationBeans);
        this.rdTable.clear();
    }

    public void setStation(StationBean sb) {
        try {
            RadialDatasetSweep rsds = this.sds.getRadarDataset(sb.getName(), new Date());
            this.rdTable.setDataset(rsds);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.stnTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
    }

    public class StationBean
    implements Station {
        private Station s;

        public StationBean(Station s) {
            this.s = s;
        }

        public String getName() {
            return this.s.getName();
        }

        public String getDescription() {
            return this.s.getDescription();
        }

        public String getWmoId() {
            return this.s.getWmoId();
        }

        public double getLatitude() {
            return this.s.getLatitude();
        }

        public double getLongitude() {
            return this.s.getLongitude();
        }

        public double getAltitude() {
            return this.s.getAltitude();
        }

        public LatLonPoint getLatLon() {
            return this.s.getLatLon();
        }

        public boolean isMissing() {
            return this.s.isMissing();
        }

        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }

        public int getNobs() {
            return -1;
        }
    }
}

