/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.tools.DatasetHtmlWriter;
import thredds.ui.catalog.CatalogTreeView;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.HtmlBrowser;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextGetPutPane;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.ComboBox;

public class CatalogChooser
extends JPanel {
    private static final String HDIVIDER = "HSplit_Divider";
    private static final String FILECHOOSER_DEFAULTDIR = "FileChooserDefaultDir";
    private PreferencesExt prefs;
    private String eventType = null;
    private ComboBox catListBox;
    private CatalogTreeView tree;
    private HtmlBrowser htmlViewer;
    private FileManager fileChooser;
    private JSplitPane split;
    private JLabel statusLabel;
    private JPanel buttPanel;
    private JLabel sourceText;
    private RootPaneContainer parent = null;
    private boolean datasetEvents = true;
    private boolean catrefEvents = false;
    private String currentURL = "";
    private FileManager catgenFileChooser;
    private boolean debugEvents = false;
    private boolean showHTML = false;

    public CatalogChooser(PreferencesExt prefs, boolean showComboChooser, boolean showOpenButton, boolean showFileChooser) {
        this.prefs = prefs;
        JPanel topPanel = null;
        if (showComboChooser) {
            this.catListBox = new ComboBox((PersistenceManager)prefs);
            JButton connectButton = new JButton("Connect");
            connectButton.setToolTipText("read this catalog");
            connectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String catalogURL = (String)CatalogChooser.this.catListBox.getSelectedItem();
                    CatalogChooser.this.tree.setCatalog(catalogURL.trim());
                }
            });
            JPanel topButtons = new JPanel(new FlowLayout(0, 5, 0));
            topButtons.add(connectButton);
            topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)new JLabel("Catalog URL"), "West");
            topPanel.add((Component)this.catListBox, "Center");
            topPanel.add((Component)topButtons, "East");
            if (showFileChooser) {
                PreferencesExt fcPrefs = (PreferencesExt)prefs.node("FileManager");
                FileFilter[] filters = new FileFilter[]{new FileManager.XMLExtFilter()};
                this.fileChooser = new FileManager(null, null, filters, fcPrefs);
                AbstractAction fileAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String filename = CatalogChooser.this.fileChooser.chooseFilename();
                        if (filename == null) {
                            return;
                        }
                        CatalogChooser.this.tree.setCatalog("file:" + filename);
                    }
                };
                BAMutil.setActionProperties(fileAction, "FileChooser", "open Local catalog...", false, 76, -1);
                BAMutil.addActionToContainer(topButtons, fileAction);
                PreferencesExt catgenPrefs = (PreferencesExt)prefs.node("CatgenFileManager");
                this.catgenFileChooser = new FileManager(null, null, null, catgenPrefs);
                this.catgenFileChooser.getFileChooser().setFileSelectionMode(2);
                this.catgenFileChooser.getFileChooser().setDialogTitle("Run CatGen on Directory");
                AbstractAction srcEditAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TextGetPutPane sourceEditor = new TextGetPutPane(null);
                        IndependentWindow sourceEditorWindow = new IndependentWindow("Source", BAMutil.getImage("threddsIcon.png"), sourceEditor);
                        sourceEditorWindow.setBounds(new Rectangle(50, 50, 725, 450));
                        sourceEditorWindow.show();
                    }
                };
                BAMutil.setActionProperties(srcEditAction, "Edit", "Source Editor", false, 69, -1);
                BAMutil.addActionToContainer(topButtons, srcEditAction);
            }
        }
        this.tree = new CatalogTreeView();
        this.tree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (CatalogChooser.this.debugEvents) {
                    System.out.println("CatalogChooser propertyChange name=" + e.getPropertyName() + "=");
                }
                if (e.getPropertyName().equals("Catalog")) {
                    String catalogURL = (String)e.getNewValue();
                    CatalogChooser.this.setCurrentURL(catalogURL);
                    if (CatalogChooser.this.catListBox != null) {
                        CatalogChooser.this.catListBox.addItem(catalogURL);
                    }
                    CatalogChooser.this.firePropertyChangeEvent(e);
                } else if (e.getPropertyName().equals("Selection")) {
                    DatasetNode ds = CatalogChooser.this.tree.getSelectedDataset();
                    if (ds == null) {
                        return;
                    }
                    if (ds instanceof Dataset) {
                        CatalogChooser.this.showDatasetInfo((Dataset)ds);
                    }
                    if (ds instanceof CatalogRef) {
                        CatalogRef ref = (CatalogRef)ds;
                        String href = ref.getXlinkHref();
                        if (href != null) {
                            try {
                                URI uri = ref.getParentCatalog().resolveUri(href);
                                CatalogChooser.this.setCurrentURL(uri.toString());
                            }
                            catch (URISyntaxException ee) {
                                throw new RuntimeException(ee);
                            }
                        }
                    } else if (ds.getParent() == null) {
                        CatalogChooser.this.setCurrentURL(CatalogChooser.this.tree.getCatalogURL());
                    }
                } else if (e.getNewValue() instanceof Dataset) {
                    CatalogChooser.this.firePropertyChangeEvent((Dataset)e.getNewValue(), e.getPropertyName());
                }
            }
        });
        this.htmlViewer = new HtmlBrowser();
        this.htmlViewer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("datasetURL")) {
                    DatasetNode node;
                    String datasetURL = (String)e.getNewValue();
                    if (CatalogChooser.this.debugEvents) {
                        System.out.println("***datasetURL= " + datasetURL);
                    }
                    if ((node = CatalogChooser.this.tree.getSelectedDataset()) == null) {
                        return;
                    }
                    if (node instanceof Dataset) {
                        Dataset dataset = (Dataset)node;
                        Access access = dataset.findAccess(datasetURL);
                        CatalogChooser.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "InvAccess", null, access));
                    }
                } else if (e.getPropertyName().equals("catrefURL")) {
                    String urlString = (String)e.getNewValue();
                    if (CatalogChooser.this.debugEvents) {
                        System.out.println("***catrefURL= " + urlString);
                    }
                    CatalogChooser.this.tree.setCatalog(urlString.trim());
                }
            }
        });
        this.split = new JSplitPane(1, false, this.tree, this.htmlViewer);
        if (prefs != null) {
            this.split.setDividerLocation(prefs.getInt(HDIVIDER, 400));
        }
        JPanel statusPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel("not connected");
        this.sourceText = new JLabel();
        statusPanel.add((Component)this.statusLabel, "West");
        statusPanel.add((Component)this.sourceText, "East");
        this.buttPanel = new JPanel();
        JButton openfileButton = new JButton("Open File");
        this.buttPanel.add((Component)openfileButton, null);
        openfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogChooser.this.eventType = "File";
                try {
                    CatalogChooser.this.tree.acceptSelected();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    JOptionPane.showMessageDialog(CatalogChooser.this, "ERROR " + t.getMessage());
                }
                finally {
                    CatalogChooser.this.eventType = null;
                }
            }
        });
        JButton openCoordButton = new JButton("Open CoordSys");
        this.buttPanel.add((Component)openCoordButton, null);
        openCoordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogChooser.this.eventType = "CoordSys";
                try {
                    CatalogChooser.this.tree.acceptSelected();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    JOptionPane.showMessageDialog(CatalogChooser.this, "ERROR " + t.getMessage());
                }
                finally {
                    CatalogChooser.this.eventType = null;
                }
            }
        });
        JButton acceptButton = new JButton("Open dataset");
        this.buttPanel.add((Component)acceptButton, null);
        acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogChooser.this.eventType = "Dataset";
                try {
                    CatalogChooser.this.tree.acceptSelected();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    JOptionPane.showMessageDialog(CatalogChooser.this, "ERROR " + t.getMessage());
                }
                finally {
                    CatalogChooser.this.eventType = null;
                }
            }
        });
        this.setLayout(new BorderLayout());
        if (showComboChooser) {
            this.add((Component)topPanel, "North");
        }
        this.add((Component)this.split, "Center");
        if (showOpenButton) {
            JPanel botPanel = new JPanel(new BorderLayout());
            botPanel.add((Component)this.buttPanel, "North");
            botPanel.add((Component)statusPanel, "South");
            this.add((Component)botPanel, "South");
        }
    }

    private void makeSourceEditWindow() {
        TextGetPutPane sourceEditor = new TextGetPutPane(null);
        IndependentWindow sourceEditorWindow = new IndependentWindow("Source", BAMutil.getImage("threddsIcon.png"), sourceEditor);
        sourceEditorWindow.setBounds(new Rectangle(50, 50, 725, 450));
        sourceEditorWindow.show();
    }

    public void save() {
        if (this.catListBox != null) {
            this.catListBox.save();
        }
        if (this.prefs != null) {
            if (this.fileChooser != null) {
                this.fileChooser.save();
            }
            if (this.catgenFileChooser != null) {
                this.catgenFileChooser.save();
            }
            this.prefs.putInt(HDIVIDER, this.split.getDividerLocation());
        }
    }

    private void firePropertyChangeEvent(Dataset ds, String oldPropertyName) {
        String propertyName = this.eventType != null ? this.eventType : oldPropertyName;
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, null, ds);
        this.firePropertyChangeEvent(event);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void addButton(JButton b) {
        this.buttPanel.add((Component)b, null);
        this.buttPanel.revalidate();
    }

    public void setAccessOnly(boolean accessOnly) {
        this.tree.setAccessOnly(accessOnly);
    }

    public void setCatrefEvents(boolean catrefEvents) {
        this.catrefEvents = catrefEvents;
    }

    public void setDatasetEvents(boolean datasetEvents) {
        this.datasetEvents = datasetEvents;
    }

    public void setSelectedItem(String item) {
        if (this.catListBox != null) {
            this.catListBox.setSelectedItem(item);
        }
    }

    public void setSelectedDataset(Dataset ds) {
        this.tree.setSelectedDataset(ds);
        this.showDatasetInfo(ds);
    }

    public DatasetNode getSelectedDataset() {
        return this.tree.getSelectedDataset();
    }

    public Catalog getCurrentCatalog() {
        return this.tree.getCatalog();
    }

    public CatalogTreeView getTreeView() {
        return this.tree;
    }

    public String getCurrentURL() {
        return this.currentURL;
    }

    private void setCurrentURL(String currentURL) {
        this.currentURL = currentURL;
        this.sourceText.setText(currentURL);
        this.statusLabel.setText("Connected...");
    }

    public void setCatalog(Catalog catalog) {
        this.tree.setCatalog(catalog);
    }

    public void setCatalog(String catalogURL) {
        this.tree.setCatalog(catalogURL.trim());
    }

    private void showDatasetInfo(Dataset ds) {
        if (ds == null) {
            return;
        }
        Formatter sbuff = new Formatter();
        DatasetHtmlWriter writer = new DatasetHtmlWriter();
        writer.writeHtmlDescription(sbuff, ds, true, false, this.datasetEvents, this.catrefEvents, true);
        if (this.showHTML) {
            System.out.println("HTML=\n" + sbuff);
        }
        this.htmlViewer.setContent(ds.getName(), sbuff.toString());
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        this.parent = parent;
        return new Dialog(parent, title, modal);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            JButton dismissButton = new JButton("Dismiss");
            CatalogChooser.this.buttPanel.add((Component)dismissButton, null);
            dismissButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Dialog.this.setVisible(false);
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)CatalogChooser.this, "Center");
            this.pack();
        }
    }
}

