/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ucar.ui.widget.BAMutil;

public class PopupMenu
extends JPopupMenu {
    private JComponent parent;

    public PopupMenu(JComponent parent, String menuTitle) {
        this(parent, menuTitle, false);
    }

    public PopupMenu(JComponent parent, String menuTitle, boolean anyButton) {
        super(menuTitle);
        this.parent = parent;
        this.setBorderPainted(true);
        this.setLabel(menuTitle);
        parent.addMouseListener(new PopupTriggerListener(anyButton){

            @Override
            public void showPopup(MouseEvent e) {
                PopupMenu.this.show(PopupMenu.this.parent, e.getX(), e.getY());
            }
        });
    }

    public void addAction(String menuName, Action act) {
        act.putValue("Name", menuName);
        super.add(act);
    }

    public void addAction(String menuName, String iconName, Action act) {
        this.addAction(menuName, BAMutil.getIcon(iconName, true), act);
    }

    public void addAction(String menuName, ImageIcon icon, Action act) {
        act.putValue("Name", menuName);
        act.putValue("SmallIcon", icon);
        JMenuItem mi = this.add(act);
        mi.setHorizontalTextPosition(2);
    }

    public void addActionCheckBox(String menuName, AbstractAction act, boolean state) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(menuName, state);
        mi.addActionListener(new BAMutil.ActionToggle(act, mi));
        act.putValue("state", state);
        this.add(mi);
    }

    public JComponent getParentComponent() {
        return this.parent;
    }

    public static abstract class PopupTriggerListener
    extends MouseAdapter {
        private boolean anyButton = false;

        PopupTriggerListener(boolean anyButton) {
            this.anyButton = anyButton;
        }

        PopupTriggerListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.anyButton || e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.anyButton || e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.anyButton || e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public abstract void showPopup(MouseEvent var1);
    }
}

