/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import ucar.ui.util.Resource;

public class BAMutil {
    public static final String SELECTED_ICON = "SelectedIcon";
    public static final String TOGGLE = "isToggle";
    public static final String MNEMONIC = "mnemonic";
    public static final String ACCEL = "accelerator";
    public static final String STATE = "state";
    private static String defaultResourcePath = "/resources/ui/icons/";
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final boolean isMacOs = osName.startsWith("mac os x");
    private static final int META_KEY = isMacOs ? 4 : 2;
    private static boolean debug;
    private static boolean debugToggle;

    public static void setResourcePath(String path) {
        defaultResourcePath = path;
    }

    public static String getResourcePath() {
        return defaultResourcePath;
    }

    public static ImageIcon getIcon(String name, boolean errMsg) {
        ImageIcon ii = Resource.getIcon(defaultResourcePath + name + ".gif", errMsg);
        if (ii == null) {
            Resource.getIcon(defaultResourcePath + name + ".png", errMsg);
        }
        return ii;
    }

    public static Image getImage(String name) {
        Image ii = name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".gif") ? Resource.getImage(defaultResourcePath + name) : Resource.getImage(defaultResourcePath + name + ".gif");
        return ii;
    }

    public static Cursor makeCursor(String name) {
        return Resource.makeCursor(defaultResourcePath + name + ".gif");
    }

    public static AbstractButton makeButtcon(Icon icon, Icon selected, String tooltip, boolean is_toggle) {
        AbstractButton butt = is_toggle ? new JToggleButton() : new JButton();
        if (debug) {
            System.out.println("   makeButtcon" + icon + " " + selected + " " + tooltip + " " + is_toggle);
        }
        if (icon != null) {
            butt.setIcon(icon);
        }
        if (selected != null) {
            if (is_toggle) {
                butt.setSelectedIcon(selected);
            } else {
                butt.setRolloverIcon(selected);
                butt.setRolloverSelectedIcon(selected);
                butt.setPressedIcon(selected);
                butt.setRolloverEnabled(true);
            }
        }
        butt.setMaximumSize(new Dimension(28, 28));
        butt.setPreferredSize(new Dimension(28, 28));
        butt.setToolTipText(tooltip);
        butt.setFocusPainted(false);
        return butt;
    }

    public static AbstractButton makeButtcon(String iconName, String tooltip, boolean is_toggle) {
        ImageIcon icon = BAMutil.getIcon(iconName, false);
        ImageIcon iconSel = BAMutil.getIcon(iconName + "Sel", false);
        return BAMutil.makeButtcon(icon, iconSel, tooltip, is_toggle);
    }

    private static JMenuItem makeMenuItem(Icon icon, Icon rollover, String menu_cmd, boolean is_toggle, int mnemonic, int accel) {
        JMenuItem mi = is_toggle ? new JCheckBoxMenuItem(menu_cmd) : new JMenuItem(menu_cmd);
        if (icon != null) {
            mi.setIcon(icon);
        }
        if (rollover != null) {
            mi.setRolloverIcon(rollover);
            mi.setRolloverSelectedIcon(rollover);
            mi.setPressedIcon(rollover);
            mi.setRolloverEnabled(true);
        }
        mi.setHorizontalTextPosition(2);
        if (mnemonic != 0) {
            mi.setMnemonic(mnemonic);
        }
        if (accel != 0) {
            mi.setAccelerator(KeyStroke.getKeyStroke(accel, META_KEY));
        }
        return mi;
    }

    private static JMenuItem makeMenuItemFromAction(Action act) {
        Boolean tog = (Boolean)act.getValue(TOGGLE);
        boolean is_toggle = tog != null && tog != false;
        Integer mnu = (Integer)act.getValue(MNEMONIC);
        int mnemonic = tog == null ? -1 : mnu;
        Integer acc = (Integer)act.getValue(ACCEL);
        int accel = acc == null ? 0 : acc;
        return BAMutil.makeMenuItem((Icon)act.getValue("SmallIcon"), (Icon)act.getValue(SELECTED_ICON), (String)act.getValue("ShortDescription"), is_toggle, mnemonic, accel < 0 ? 0 : accel);
    }

    public static JMenuItem addActionToMenu(JMenu menu, Action act, int menuPos) {
        boolean is_toggle;
        JMenuItem mi = BAMutil.makeMenuItemFromAction(act);
        if (menuPos >= 0) {
            menu.add((Component)mi, menuPos);
        } else {
            menu.add(mi);
        }
        Boolean tog = (Boolean)act.getValue(TOGGLE);
        boolean bl = is_toggle = tog != null && tog != false;
        if (is_toggle) {
            Boolean state;
            if (debugToggle) {
                System.out.println("addActionToMenu: " + act.getValue("ShortDescription") + " " + act.getValue(STATE));
            }
            if ((state = (Boolean)act.getValue(STATE)) == null) {
                state = Boolean.FALSE;
            }
            act.putValue(STATE, state);
            mi.setSelected(state);
        }
        Action myAct = is_toggle ? new ToggleAction(act) : act;
        mi.addActionListener(myAct);
        act.addPropertyChangeListener(new myActionChangedListener(mi));
        return mi;
    }

    public static JMenuItem addActionToMenu(JMenu menu, Action act) {
        return BAMutil.addActionToMenu(menu, act, -1);
    }

    public static JMenuItem addActionToPopupMenu(JPopupMenu pmenu, Action act) {
        boolean is_toggle;
        JMenuItem mi = BAMutil.makeMenuItemFromAction(act);
        pmenu.add(mi);
        Boolean tog = (Boolean)act.getValue(TOGGLE);
        boolean bl = is_toggle = tog != null && tog != false;
        if (is_toggle) {
            Boolean state;
            if (debugToggle) {
                System.out.println("addActionToMenu: " + act.getValue("ShortDescription") + " " + act.getValue(STATE));
            }
            if ((state = (Boolean)act.getValue(STATE)) == null) {
                state = Boolean.FALSE;
            }
            act.putValue(STATE, state);
            mi.setSelected(state);
        }
        Action myAct = is_toggle ? new ToggleAction(act) : act;
        mi.addActionListener(myAct);
        act.addPropertyChangeListener(new myActionChangedListener(mi));
        return mi;
    }

    private static AbstractButton _makeButtconFromAction(Action act) {
        Boolean tog = (Boolean)act.getValue(TOGGLE);
        boolean is_toggle = tog != null && tog != false;
        return BAMutil.makeButtcon((Icon)act.getValue("SmallIcon"), (Icon)act.getValue(SELECTED_ICON), (String)act.getValue("ShortDescription"), is_toggle);
    }

    public static AbstractButton addActionToContainerPos(Container c, Action act, int pos) {
        Boolean tog;
        boolean is_toggle;
        AbstractButton butt = BAMutil._makeButtconFromAction(act);
        if (pos < 0) {
            c.add(butt);
        } else {
            c.add((Component)butt, pos);
        }
        if (debug) {
            System.out.println(" addActionToContainerPos " + act + " " + butt + " " + pos);
        }
        boolean bl = is_toggle = (tog = (Boolean)act.getValue(TOGGLE)) != null && tog != false;
        if (is_toggle) {
            Boolean state;
            if (debugToggle) {
                System.out.println("addActionToContainerPos: " + act.getValue("ShortDescription") + " " + act.getValue(STATE));
            }
            if ((state = (Boolean)act.getValue(STATE)) == null) {
                state = Boolean.FALSE;
            }
            act.putValue(STATE, state);
            butt.setSelected(state);
        }
        Action myAct = is_toggle ? new ToggleAction(act) : act;
        butt.addActionListener(myAct);
        act.addPropertyChangeListener(new myActionChangedListener(butt));
        return butt;
    }

    public static AbstractButton makeButtconFromAction(Action act) {
        boolean is_toggle;
        AbstractButton butt = BAMutil._makeButtconFromAction(act);
        Boolean tog = (Boolean)act.getValue(TOGGLE);
        boolean bl = is_toggle = tog != null && tog != false;
        if (is_toggle) {
            Boolean state;
            if (debugToggle) {
                System.out.println("addActionToContainerPos: " + act.getValue("ShortDescription") + " " + act.getValue(STATE));
            }
            if ((state = (Boolean)act.getValue(STATE)) == null) {
                state = Boolean.FALSE;
            }
            act.putValue(STATE, state);
            butt.setSelected(state);
        }
        Action myAct = is_toggle ? new ToggleAction(act) : act;
        butt.addActionListener(myAct);
        act.addPropertyChangeListener(new myActionChangedListener(butt));
        return butt;
    }

    public static AbstractButton addActionToContainer(Container c, Action act) {
        return BAMutil.addActionToContainerPos(c, act, -1);
    }

    public static void setActionProperties(AbstractAction act, String icon_name, String action_name, boolean is_toggle, int mnemonic, int accel) {
        if (icon_name != null) {
            act.putValue("SmallIcon", BAMutil.getIcon(icon_name, true));
            act.putValue(SELECTED_ICON, BAMutil.getIcon(icon_name + "Sel", false));
        }
        act.putValue("ShortDescription", action_name);
        act.putValue("LongDescription", action_name);
        act.putValue(TOGGLE, is_toggle);
        act.putValue(MNEMONIC, mnemonic);
        act.putValue(ACCEL, accel);
    }

    public static void setActionPropertiesToggle(AbstractAction act, String icon_name, String action_name, boolean toggleValue, int mnemonic, int accel) {
        BAMutil.setActionProperties(act, icon_name, action_name, true, mnemonic, accel);
        act.putValue(STATE, toggleValue);
    }

    private static class myActionChangedListener
    implements PropertyChangeListener {
        private AbstractButton button;

        myActionChangedListener(AbstractButton b) {
            this.button = b;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (debugToggle) {
                System.out.print("myActionChangedListener " + propertyName + " " + e.getNewValue());
                AbstractAction act = (AbstractAction)this.button.getAction();
                System.out.print(" " + (act == null ? "" : act.getValue("ShortDescription")));
            }
            switch (propertyName) {
                case "Name": {
                    String text = (String)e.getNewValue();
                    this.button.setText(text);
                    this.button.repaint();
                    break;
                }
                case "enabled": {
                    Boolean enabledState = (Boolean)e.getNewValue();
                    this.button.setEnabled(enabledState);
                    this.button.repaint();
                    break;
                }
                case "state": {
                    Boolean state = (Boolean)e.getNewValue();
                    this.button.setSelected(state);
                    this.button.repaint();
                }
            }
        }
    }

    private static class ToggleAction
    extends AbstractAction {
        private Action orgAct;

        ToggleAction(Action orgAct) {
            this.orgAct = orgAct;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean state = (Boolean)this.orgAct.getValue(BAMutil.STATE);
            this.orgAct.putValue(BAMutil.STATE, state == false);
            if (debugToggle) {
                System.out.println("ToggleAction: " + this.orgAct.getValue("ShortDescription") + " " + this.orgAct.getValue(BAMutil.STATE));
            }
            this.orgAct.actionPerformed(e);
        }
    }

    public static class ActionToggle
    extends AbstractAction {
        private Action orgAct;
        private AbstractButton button;

        public ActionToggle(Action oa, AbstractButton b) {
            this.orgAct = oa;
            this.button = b;
            this.orgAct.putValue(BAMutil.STATE, Boolean.TRUE);
            this.orgAct.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String propertyName = e.getPropertyName();
                    if (debugToggle) {
                        System.out.println("propertyChange " + propertyName + " " + e.getNewValue());
                    }
                    switch (propertyName) {
                        case "Name": {
                            String text = (String)e.getNewValue();
                            button.setText(text);
                            button.repaint();
                            break;
                        }
                        case "enabled": {
                            Boolean enabledState = (Boolean)e.getNewValue();
                            button.setEnabled(enabledState);
                            button.repaint();
                            break;
                        }
                        case "state": {
                            Boolean state = (Boolean)e.getNewValue();
                            button.setSelected(state);
                            button.repaint();
                        }
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean state = (Boolean)this.orgAct.getValue(BAMutil.STATE);
            this.orgAct.putValue(BAMutil.STATE, state == false);
            this.orgAct.actionPerformed(e);
        }
    }
}

