/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ui.util.ScreenUtils;

public class IndependentWindow
extends JFrame {
    private static Logger log = LoggerFactory.getLogger(IndependentWindow.class);

    public IndependentWindow(String title, Image iconImage) {
        super(title);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("lookAndFeel")) {
                    SwingUtilities.updateComponentTreeUI(IndependentWindow.this);
                }
            }
        });
        if (null != iconImage) {
            this.setIconImage(iconImage);
        }
    }

    public IndependentWindow(String title, Image iconImage, Component comp) {
        this(title, iconImage);
        this.setComponent(comp);
    }

    public void setComponent(Component comp) {
        Container cp = this.getContentPane();
        cp.removeAll();
        cp.add(comp, "Center");
        try {
            this.pack();
        }
        catch (IllegalArgumentException e) {
            log.error("Possible problem setting icon (?)", (Throwable)e);
        }
    }

    @Override
    public void show() {
        this.setState(0);
        super.toFront();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IndependentWindow.super.show();
            }
        });
    }

    public void showIfNotIconified() {
        if (this.getState() == 1) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IndependentWindow.super.show();
            }
        });
    }

    @Override
    public void setBounds(Rectangle r) {
        Rectangle screenSize = ScreenUtils.getScreenVirtualSize();
        Rectangle result = r.intersection(screenSize);
        if (!result.isEmpty()) {
            super.setBounds(result);
        }
    }
}

