/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableAligner
implements TableColumnModelListener {
    private final JTable table;
    private final int alignment;

    public TableAligner(JTable table, int alignment) {
        this.table = table;
        this.alignment = alignment;
        TableAligner.installInAllColumns(table, alignment);
    }

    public static void installInAllColumns(JTable table, int alignment) {
        for (int colViewIndex = 0; colViewIndex < table.getColumnCount(); ++colViewIndex) {
            TableAligner.installInOneColumn(table, colViewIndex, alignment);
        }
    }

    public static void installInOneColumn(JTable table, int colViewIndex, int alignment) {
        TableCellRenderer cellRenderer;
        TableColumn tableColumn = table.getColumnModel().getColumn(colViewIndex);
        TableCellRenderer headerRenderer = tableColumn.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        if (!(headerRenderer instanceof RendererAlignmentDecorator)) {
            tableColumn.setHeaderRenderer(new RendererAlignmentDecorator(headerRenderer, alignment));
        }
        if ((cellRenderer = tableColumn.getCellRenderer()) == null) {
            cellRenderer = table.getDefaultRenderer(table.getColumnClass(colViewIndex));
        }
        if (!(cellRenderer instanceof RendererAlignmentDecorator)) {
            tableColumn.setCellRenderer(new RendererAlignmentDecorator(cellRenderer, alignment));
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        TableAligner.installInOneColumn(this.table, e.getToIndex(), this.alignment);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    private static class RendererAlignmentDecorator
    implements TableCellRenderer {
        private final TableCellRenderer delegate;
        private final int alignment;

        private RendererAlignmentDecorator(TableCellRenderer delegate, int alignment) {
            this.delegate = delegate;
            this.alignment = alignment;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellRendererComp = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (cellRendererComp instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)cellRendererComp).setHorizontalAlignment(this.alignment);
            }
            return cellRendererComp;
        }
    }
}

