/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import ucar.ui.table.RowSorter;
import ucar.ui.table.TableRow;
import ucar.ui.table.TableRowAbstract;
import ucar.ui.table.ThreadSorter;
import ucar.ui.table.TreeTableModel;
import ucar.ui.table.TreeTableModelAbstract;

public class TreeTableModelSorted
extends TreeTableModelAbstract {
    private boolean treeSort;
    private RowSorter rowSorter;
    private ThreadSorter threadSorter;
    private String[] colName;
    private ArrayList rowList;
    private ArrayList treeList;
    private boolean useThreads;
    private boolean threadsOn;
    private int threadCol = -1;
    private int indentCol = -1;
    private int sortCol;
    private boolean reverse;
    private boolean debug;
    private boolean debugTM;
    private boolean debugSort;
    private boolean showNodeName;

    public TreeTableModelSorted(String[] colName, ArrayList rows) {
        this(null, colName, rows);
        this.treeSort = true;
    }

    public TreeTableModelSorted(ThreadSorter threadSorter, String[] colName, ArrayList rows) {
        super(null);
        this.threadSorter = threadSorter;
        this.useThreads = threadSorter != null;
        this.colName = colName;
        if (this.useThreads) {
            String[] newColName = new String[colName.length + 1];
            System.arraycopy(colName, 0, newColName, 0, colName.length);
            this.threadCol = colName.length;
            newColName[this.threadCol] = "Threads";
            this.colName = newColName;
            this.indentCol = threadSorter.getIndentCol();
        }
        this.rowList = new ArrayList(rows);
        this.sort();
        this.root = this;
    }

    public boolean isTreeSort() {
        return this.treeSort;
    }

    public boolean useThreads() {
        return this.useThreads;
    }

    public boolean isThreadsOn() {
        return this.threadsOn;
    }

    public void setThreadsOn(boolean threadsOn) {
        this.threadsOn = threadsOn;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public int getSortCol() {
        return this.sortCol;
    }

    public void setSortCol(int sortCol) {
        this.sortCol = sortCol;
    }

    public void setSorter(RowSorter sorter) {
        this.rowSorter = sorter;
    }

    public ArrayList getRows() {
        return this.rowList;
    }

    public void setRows(ArrayList rows) {
        this.rowList = new ArrayList(rows);
        this.sort();
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public void sort() {
        this.sort(this.sortCol, this.reverse);
    }

    public boolean sort(int sortCol) {
        this.reverse = sortCol == this.sortCol ? !this.reverse : false;
        this.sort(sortCol, this.reverse);
        return this.reverse;
    }

    public void sort(int sortCol, boolean reverse) {
        this.sortCol = sortCol;
        this.reverse = reverse;
        if (this.debugSort) {
            System.out.println("sortCol " + sortCol + " threads = " + this.threadsOn + " #rows = " + this.rowList.size());
        }
        if (this.rowSorter != null) {
            if (this.debugSort) {
                System.out.println("sortExternal");
            }
            this.sortExternal(sortCol, reverse);
            return;
        }
        if (this.threadsOn) {
            if (this.debugSort) {
                System.out.println("sortThread");
            }
            this.sortThread(sortCol, reverse);
            return;
        }
        if (this.debugSort) {
            System.out.println("standard sort");
        }
        this.rowList.sort(new TableRowAbstract.Sorter(sortCol, reverse));
        if (this.treeSort) {
            this.makeTreeList(sortCol, this.rowList);
        } else {
            this.treeList = this.rowList;
        }
    }

    private void sortExternal(int sortCol, boolean reverse) {
        this.rowList = this.rowSorter.sort(sortCol, reverse, this.rowList);
        this.treeList = new ArrayList();
        SortNode currentNode = null;
        TableRow last = null;
        int count = 0;
        for (int i = 0; i < this.rowList.size(); ++i) {
            TableRow row = (TableRow)this.rowList.get(i);
            if (last == null || this.rowSorter.isBreak(last, row)) {
                if (null != currentNode) {
                    currentNode.count = count;
                }
                currentNode = new SortNode(i);
                this.treeList.add(currentNode);
                count = 0;
            }
            ++count;
            last = row;
        }
        if (null != currentNode) {
            currentNode.count = count;
        }
    }

    private void sortThread(int sortCol, boolean reverse) {
        this.rowList = this.threadSorter.sort(sortCol, reverse, this.rowList);
        this.treeList = new ArrayList();
        SortNode currentNode = null;
        int count = 0;
        for (int i = 0; i < this.rowList.size(); ++i) {
            TableRow row = (TableRow)this.rowList.get(i);
            if (this.threadSorter.isTopThread(row)) {
                if (null != currentNode) {
                    currentNode.count = count;
                }
                currentNode = new SortNode(i);
                this.treeList.add(currentNode);
                count = 0;
            }
            ++count;
        }
        if (null != currentNode) {
            currentNode.count = count;
        }
        Collections.sort(this.treeList);
    }

    private void makeTreeList(int colNo, ArrayList rowList) {
        this.treeList = new ArrayList();
        SortNode currentNode = null;
        String current = "";
        int count = 0;
        for (int i = 0; i < rowList.size(); ++i) {
            TableRow row = (TableRow)rowList.get(i);
            String value = (String)row.getValueAt(colNo);
            if (!value.equals(current)) {
                if (null != currentNode) {
                    currentNode.count = count;
                }
                currentNode = new SortNode(i);
                this.treeList.add(currentNode);
                current = value;
                count = 0;
            }
            ++count;
        }
        if (null != currentNode) {
            currentNode.count = count;
        }
    }

    @Override
    public int getChildCount(Object parent) {
        int ret = 0;
        if (parent instanceof TreeTableModelSorted) {
            ret = this.treeList.size();
        } else if (parent instanceof SortNode) {
            ret = ((SortNode)parent).count - 1;
        }
        if (this.debugTM) {
            System.out.println(" getChildCount <" + parent + "> " + ret);
        }
        return ret;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object ret = null;
        if (parent instanceof TreeTableModelSorted) {
            ret = this.treeList.get(index);
        } else if (parent instanceof SortNode) {
            SortNode node = (SortNode)parent;
            ret = this.rowList.get(node.start + index + 1);
        }
        if (this.debugTM) {
            System.out.println(" getChild <" + parent + "> " + index + " = <" + ret + ">");
        }
        return ret;
    }

    public TableRow getRow(Object node) {
        TableRow ret = null;
        if (node instanceof TreeTableModelSorted) {
            ret = (TableRow)this.treeList.get(0);
        } else if (node instanceof SortNode) {
            SortNode snode = (SortNode)node;
            ret = snode.row;
        } else if (node instanceof TableRow) {
            ret = (TableRow)node;
            if (this.debug) {
                System.out.println(" getRow <" + ret + ">");
            }
        }
        return ret;
    }

    @Override
    public int getColumnCount() {
        return this.colName.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.colName[col];
    }

    @Override
    public Object getValueAt(Object node, int col) {
        Object ret = null;
        if (node instanceof TreeTableModelSorted) {
            ret = col == 0 ? "root2 " : "";
        } else if (node instanceof SortNode) {
            SortNode snode = (SortNode)node;
            ret = this.getValueAt(snode.row, col);
        } else if (node instanceof TableRow) {
            ret = this.getValueAt((TableRow)node, col);
        }
        if (this.debugTM) {
            System.out.println("   getValueAt <" + node + "> " + col + " = <" + ret + ">");
        }
        return ret;
    }

    private Object getValueAt(TableRow row, int col) {
        if (this.debug) {
            System.out.println(" getValueAt <" + row + ">" + col);
        }
        if (this.useThreads && col == this.threadCol) {
            return "T";
        }
        if (this.threadsOn && col == this.indentCol && !this.threadSorter.isTopThread(row)) {
            return "    " + row.getValueAt(col);
        }
        return row.getValueAt(col);
    }

    @Override
    public Class getColumnClass(int column) {
        if (this.treeSort && column == this.sortCol || this.useThreads && column == this.threadCol) {
            return TreeTableModel.class;
        }
        return Object.class;
    }

    public TableRow getRow(int rowno) {
        return (TableRow)this.rowList.get(rowno);
    }

    public TableRow getRow(TreePath path) {
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        if (node instanceof TableRow) {
            return (TableRow)node;
        }
        return ((SortNode)node).row;
    }

    public void addRowsToSetFromPath(JTree tree, TreePath path, Set set) {
        if (path == null) {
            return;
        }
        Object node = path.getLastPathComponent();
        if (node instanceof TableRow) {
            set.add(node);
        } else {
            SortNode snode = (SortNode)node;
            if (tree.isExpanded(path)) {
                set.add(this.rowList.get(snode.start));
            } else {
                for (int i = 0; i < snode.count; ++i) {
                    set.add(this.rowList.get(snode.start + i));
                }
            }
        }
    }

    public TreePath getPath(TableRow row) {
        int rowno = this.rowList.indexOf(row);
        if (rowno < 0) {
            return null;
        }
        if (!this.threadsOn && !this.treeSort) {
            Object[] path = new Object[]{this.root, row};
            return new TreePath(path);
        }
        for (Object o : this.treeList) {
            SortNode snode = (SortNode)o;
            if (rowno < snode.start || rowno >= snode.start + snode.count) continue;
            Object[] path = new Object[]{this.root, snode};
            return new TreePath(path);
        }
        System.out.println("getPath didnt find row " + rowno + " = " + row);
        return null;
    }

    public String toString() {
        return "root";
    }

    private class SortNode
    implements Comparable {
        int start;
        int count;
        TableRow row;

        SortNode(int start) {
            this(start, 0);
        }

        SortNode(int start, int count) {
            this.start = start;
            this.count = count;
            this.row = (TableRow)TreeTableModelSorted.this.rowList.get(start);
            if (TreeTableModelSorted.this.debug) {
                System.out.println("new sort node " + this);
            }
        }

        public int compareTo(Object o) {
            TableRow otherRow = ((SortNode)o).row;
            return TreeTableModelSorted.this.reverse ? otherRow.compare(this.row, TreeTableModelSorted.this.sortCol) : this.row.compare(otherRow, TreeTableModelSorted.this.sortCol);
        }

        public String toString() {
            return TreeTableModelSorted.this.treeSort ? TreeTableModelSorted.this.getValueAt(this.row, TreeTableModelSorted.this.sortCol).toString() : (TreeTableModelSorted.this.showNodeName ? " node " + this.row : " ");
        }
    }
}

