/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.table;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnWidthsResizer
implements TableModelListener,
TableColumnModelListener {
    private final JTable table;
    private final int fullScanCutoff;
    public static final int DEFAULT_FULL_SCAN_CUTOFF = 10000;

    public ColumnWidthsResizer(JTable table) {
        this(table, 10000);
    }

    public ColumnWidthsResizer(JTable table, int fullScanCutoff) {
        this.table = table;
        this.fullScanCutoff = fullScanCutoff;
        ColumnWidthsResizer.resize(table);
    }

    @Override
    public void tableChanged(final TableModelEvent e) {
        if (e.getFirstRow() == -1) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean doFullScan;
                boolean bl = doFullScan = ColumnWidthsResizer.this.table.getRowCount() <= ColumnWidthsResizer.this.fullScanCutoff;
                if (e.getColumn() == -1) {
                    ColumnWidthsResizer.resize(ColumnWidthsResizer.this.table, doFullScan);
                } else {
                    ColumnWidthsResizer.resize(ColumnWidthsResizer.this.table, e.getColumn(), doFullScan);
                }
            }
        });
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        boolean doFullScan = this.table.getRowCount() <= this.fullScanCutoff;
        ColumnWidthsResizer.resize(this.table, e.getToIndex(), doFullScan);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public static void resize(JTable table) {
        ColumnWidthsResizer.resize(table, ColumnWidthsResizer.doFullScanDefault(table));
    }

    public static void resize(JTable table, boolean doFullScan) {
        for (int col = 0; col < table.getColumnCount(); ++col) {
            ColumnWidthsResizer.resize(table, col, doFullScan);
        }
    }

    public static void resize(JTable table, int colViewIndex) {
        ColumnWidthsResizer.resize(table, colViewIndex, ColumnWidthsResizer.doFullScanDefault(table));
    }

    public static void resize(JTable table, int colViewIndex, boolean doFullScan) {
        int maxWidth = 0;
        TableColumn column = table.getColumnModel().getColumn(colViewIndex);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        Object headerValue = column.getHeaderValue();
        Component headerRendererComp = headerRenderer.getTableCellRendererComponent(table, headerValue, false, false, 0, colViewIndex);
        maxWidth = Math.max(maxWidth, headerRendererComp.getPreferredSize().width);
        if (doFullScan) {
            for (int row = 0; row < table.getRowCount(); ++row) {
                maxWidth = Math.max(maxWidth, ColumnWidthsResizer.getCellWidth(table, row, colViewIndex));
            }
        } else {
            maxWidth = Math.max(maxWidth, ColumnWidthsResizer.getCellWidth(table, 0, colViewIndex));
            maxWidth = Math.max(maxWidth, ColumnWidthsResizer.getCellWidth(table, table.getRowCount() / 2, colViewIndex));
            maxWidth = Math.max(maxWidth, ColumnWidthsResizer.getCellWidth(table, table.getRowCount() - 1, colViewIndex));
        }
        column.setPreferredWidth(++maxWidth);
    }

    public static int getCellWidth(JTable table, int rowViewIndex, int colViewIndex) {
        TableCellRenderer cellRenderer = table.getCellRenderer(rowViewIndex, colViewIndex);
        Object value = table.getValueAt(rowViewIndex, colViewIndex);
        Component cellRendererComp = cellRenderer.getTableCellRendererComponent(table, value, false, false, rowViewIndex, colViewIndex);
        return cellRendererComp.getPreferredSize().width;
    }

    private static boolean doFullScanDefault(JTable table) {
        return table.getRowCount() <= 10000;
    }
}

