/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.table;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import ucar.ui.table.TableRow;

public abstract class TableRowAbstract
implements TableRow {
    protected int tieBreakerCol = -1;
    protected int[] tryNext;

    @Override
    public abstract Object getValueAt(int var1);

    @Override
    public abstract Object getUserObject();

    @Override
    public void setNextSort(int[] nextSort) {
        this.tryNext = nextSort;
    }

    private int compareTie(TableRow other, int col) {
        if (this.tieBreakerCol >= 0) {
            if (col == this.tieBreakerCol) {
                return 0;
            }
            return this.compare(other, this.tieBreakerCol);
        }
        if (this.tryNext != null && col < this.tryNext.length) {
            int next = this.tryNext[col];
            if (next < 0) {
                return 0;
            }
            return this.compare(other, next);
        }
        return 0;
    }

    protected void setTryNext(int[] t) {
        this.tryNext = t;
    }

    @Override
    public int compare(TableRow other, int col) {
        String s2;
        String s1 = this.getValueAt(col).toString();
        int ret = s1.compareToIgnoreCase(s2 = other.getValueAt(col).toString());
        if (ret == 0) {
            return this.compareTie(other, col);
        }
        return ret;
    }

    protected int compareBoolean(TableRow other, int col, boolean b1, boolean b2) {
        if (b1 == b2) {
            return this.compareTie(other, col);
        }
        return b1 ? 1 : -1;
    }

    protected int compareInt(TableRow other, int col, int i1, int i2) {
        int ret = i1 - i2;
        if (ret == 0) {
            return this.compareTie(other, col);
        }
        return ret;
    }

    protected int compareLong(TableRow other, int col, long i1, long i2) {
        int ret = (int)(i1 - i2);
        if (ret == 0) {
            return this.compareTie(other, col);
        }
        return ret;
    }

    protected int compareDouble(TableRow other, int col, double d1, double d2) {
        int ret = Double.compare(d1, d2);
        if (ret == 0) {
            return this.compareTie(other, col);
        }
        return ret;
    }

    protected int compareDate(TableRow other, int col, Date d1, Date d2) {
        int ret = d2 == null ? 1 : (d1 == null ? -1 : d1.compareTo(d2));
        if (ret == 0) {
            return this.compareTie(other, col);
        }
        return ret;
    }

    protected int compareString(TableRow other, int col, String s1, String s2, boolean ignoreCase) {
        int ret = s2 == null ? 1 : (s1 == null ? -1 : (ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2)));
        if (ret == 0) {
            return this.compareTie(other, col);
        }
        return ret;
    }

    public String toString() {
        return "";
    }

    public static class Sorter
    implements Comparator,
    Serializable {
        private int col;
        private boolean reverse;

        public Sorter(int col, boolean reverse) {
            this.col = col;
            this.reverse = reverse;
        }

        public int compare(Object o1, Object o2) {
            TableRow row1 = (TableRow)o1;
            TableRow row2 = (TableRow)o2;
            return this.reverse ? row2.compare(row1, this.col) : row1.compare(row2, this.col);
        }
    }
}

