/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class MyMouseAdapter
extends MouseAdapter
implements Serializable {
    private int startx;
    private int starty;
    private int minMove = 4;
    private boolean debugEvent;

    @Override
    public void mousePressed(MouseEvent e) {
        this.startx = e.getX();
        this.starty = e.getY();
        if (this.debugEvent) {
            System.out.println("mousePressed " + this.startx + " " + this.starty);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int deltax = e.getX() - this.startx;
        int deltay = e.getY() - this.starty;
        int total = Math.abs(deltax) + Math.abs(deltay);
        if (total <= this.minMove) {
            this.click(e);
        } else {
            this.drag(e, deltax, deltay);
        }
        if (this.debugEvent) {
            System.out.println("mouseReleased " + e.getX() + " " + e.getY());
            if (deltax > 0 || deltay > 0) {
                System.out.println("  MOVED " + deltax + " " + deltay);
            }
        }
    }

    public void setMinMove(int minMove) {
        this.minMove = minMove;
    }

    public void click(MouseEvent e) {
    }

    public void drag(MouseEvent e, int deltax, int deltay) {
    }
}

