/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.Component;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ui.table.ColumnWidthsResizer;
import ucar.ui.table.TableAligner;
import ucar.ui.util.SwingUtils;

public class ImprovedFileChooser
extends JFileChooser {
    private static final Logger logger = LoggerFactory.getLogger(ImprovedFileChooser.class);
    private static final String osName = System.getProperty("os.name").toLowerCase();
    public static final boolean isMacOs = osName.startsWith("mac os x");
    private JDialog dialog;

    public ImprovedFileChooser() {
        this((File)null, (FileSystemView)null);
    }

    public ImprovedFileChooser(File currentDirectory) {
        this(currentDirectory, null);
    }

    public ImprovedFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        AbstractButton detailsViewButton = ImprovedFileChooser.getDetailsViewButton(this);
        if (detailsViewButton == null) {
            if (!isMacOs) {
                logger.warn("Couldn't find Details button!");
            }
            return;
        }
        detailsViewButton.doClick();
        List<JTable> tables = SwingUtils.getDescendantsOfType(JTable.class, this);
        if (tables.size() != 1) {
            logger.warn("Expected to find 1 JTable in the file chooser, but found " + tables.size());
            return;
        }
        JTable detailsTable = tables.get(0);
        if (detailsTable == null) {
            logger.warn("The details view table was null!");
            return;
        }
        ColumnWidthsResizer resizer = new ColumnWidthsResizer(detailsTable);
        detailsTable.getModel().addTableModelListener(resizer);
        detailsTable.getColumnModel().addColumnModelListener(resizer);
        TableAligner aligner = new TableAligner(detailsTable, 10);
        detailsTable.getColumnModel().addColumnModelListener(aligner);
        detailsTable.addPropertyChangeListener(new NewColumnModelListener(detailsTable, 10));
        detailsTable.setAutoResizeMode(2);
    }

    private static AbstractButton getDetailsViewButton(JFileChooser fileChooser) {
        AbstractButton detailsButton = SwingUtils.getDescendantOfType(AbstractButton.class, fileChooser, "Icon", UIManager.getIcon("FileChooser.detailsViewIcon"));
        if (detailsButton != null) {
            return detailsButton;
        }
        logger.debug("Couldn't find a Details View button in the File Chooser dialog. Searching in popup menu.");
        JComponent componentWithPopupMenu = SwingUtils.getDescendantOfType(JComponent.class, fileChooser, "ComponentPopupMenu", SwingUtils.NOT_NULL);
        if (componentWithPopupMenu == null) {
            return null;
        }
        JPopupMenu popupMenu = componentWithPopupMenu.getComponentPopupMenu();
        if (popupMenu == null) {
            return null;
        }
        for (JMenuItem menuItem : ImprovedFileChooser.getAllMenuItems(popupMenu)) {
            if (!menuItem.getText().equals("Details")) continue;
            return menuItem;
        }
        return null;
    }

    private static List<JMenuItem> getAllMenuItems(JPopupMenu popupMenu) {
        LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
        ImprovedFileChooser.getAllMenuItems(popupMenu, menuItems);
        return menuItems;
    }

    private static void getAllMenuItems(MenuElement menuElem, List<JMenuItem> menuItems) {
        if (menuElem instanceof JMenuItem) {
            menuItems.add((JMenuItem)menuElem);
        }
        for (MenuElement subMenuElem : menuElem.getSubElements()) {
            ImprovedFileChooser.getAllMenuItems(subMenuElem, menuItems);
        }
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        int returnValue = super.showDialog(parent, approveButtonText);
        this.dialog = null;
        return returnValue;
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        this.dialog = super.createDialog(parent);
        return this.dialog;
    }

    static {
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
    }

    private static class NewColumnModelListener
    implements PropertyChangeListener {
        private final JTable table;
        private final int alignment;

        private NewColumnModelListener(JTable table, int alignment) {
            this.table = table;
            this.alignment = alignment;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("columnModel")) {
                TableAligner aligner = new TableAligner(this.table, this.alignment);
                this.table.getColumnModel().addColumnModelListener(aligner);
            }
        }
    }
}

