/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ui.prefs.ComboBox;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.StopButton;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public abstract class AbstractPanel
extends JPanel {
    private static final String FRAME_SIZE = "FrameSize";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PreferencesExt prefs;
    protected ComboBox cb;
    protected JPanel buttPanel;
    protected JPanel topPanel;
    protected AbstractButton coordButt;
    protected StopButton stopButton;
    protected boolean addCoords;
    protected boolean busy;
    protected long lastEvent = -1L;
    protected boolean eventOK = true;
    protected IndependentWindow detailWindow;
    protected TextHistoryPane detailTA;
    protected static FileManager fileChooser;

    protected AbstractPanel(PreferencesExt prefs, String command) {
        this(prefs, command, true, true);
    }

    protected AbstractPanel(PreferencesExt prefs, String command, boolean addFileButton, boolean addCoordButton) {
        this(prefs, command, true, addFileButton, addCoordButton);
    }

    protected AbstractPanel(PreferencesExt prefs, String command, boolean addComboBox, boolean addFileButton, boolean addCoordButton) {
        this.prefs = prefs;
        this.buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.cb = new ComboBox(prefs);
        this.cb.addActionListener(e -> {
            logger.debug(" doit {} cmd={} when={} class={}", new Object[]{this.cb.getSelectedItem(), e.getActionCommand(), e.getWhen(), this.getClass().getName()});
            if (this.eventOK && e.getWhen() > this.lastEvent + 100L) {
                this.doit(this.cb.getSelectedItem());
                this.lastEvent = e.getWhen();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AbstractPanel.this.closeOpenFiles();
                }
                catch (IOException e1) {
                    logger.warn("close failed");
                }
            }
        };
        BAMutil.setActionProperties(closeAction, "Close", "release files", false, 76, -1);
        BAMutil.addActionToContainer(this.buttPanel, closeAction);
        if (addFileButton) {
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = fileChooser.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    AbstractPanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
        }
        if (addCoordButton) {
            AbstractAction coordAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractPanel.this.addCoords = (Boolean)this.getValue("state");
                    String tooltip = AbstractPanel.this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                    AbstractPanel.this.coordButt.setToolTipText(tooltip);
                }
            };
            this.addCoords = prefs.getBoolean("coordState", false);
            String tooltip2 = this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
            BAMutil.setActionProperties(coordAction, "addCoords", tooltip2, true, 67, -1);
            coordAction.putValue("state", this.addCoords);
            this.coordButt = BAMutil.addActionToContainer(this.buttPanel, coordAction);
        }
        this.topPanel = new JPanel(new BorderLayout());
        if (addComboBox) {
            this.topPanel.add((Component)new JLabel(command), "West");
            this.topPanel.add((Component)this.cb, "Center");
            this.topPanel.add((Component)this.buttPanel, "East");
        } else {
            this.topPanel.add((Component)this.buttPanel, "East");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.detailTA = new TextHistoryPane();
        this.detailTA.setFont(new Font("Monospaced", 0, 12));
        this.detailWindow = new IndependentWindow("Details", BAMutil.getImage("app"), new JScrollPane(this.detailTA));
        Rectangle bounds = (Rectangle)prefs.getBean(FRAME_SIZE, new Rectangle(200, 50, 500, 700));
        this.detailWindow.setBounds(bounds);
    }

    public void doit(Object command) {
        if (this.busy) {
            return;
        }
        if (command == null) {
            return;
        }
        if (command instanceof String) {
            command = ((String)command).trim();
        }
        logger.debug("{} process={}", (Object)this.getClass().getName(), command);
        this.busy = true;
        if (this.process(command)) {
            this.setSelectedItem(command);
        }
        this.busy = false;
    }

    public abstract boolean process(Object var1);

    public void closeOpenFiles() throws IOException {
    }

    public void save() {
        this.cb.save();
        if (this.coordButt != null) {
            this.prefs.putBoolean("coordState", this.coordButt.getModel().isSelected());
        }
        if (this.detailWindow != null) {
            this.prefs.putBeanObject(FRAME_SIZE, this.detailWindow.getBounds());
        }
    }

    public void setSelectedItem(Object item) {
        this.eventOK = false;
        this.cb.addItem(item);
        this.eventOK = true;
    }

    public static void setFileChooser(FileManager chooser) {
        fileChooser = chooser;
    }

    public IndependentWindow getDetailWindow() {
        return this.detailWindow;
    }
}

