/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;

class LayoutM
implements LayoutManager2 {
    private final String name;
    private final Map<Component, Object> constraintMap = new HashMap<Component, Object>();
    private Rectangle globalBounds;
    private boolean debug;
    private boolean debugLayout;

    public LayoutM(String name) {
        this.name = name;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraint) {
        if (this.debug) {
            System.out.println(this.name + " addLayoutComponent= " + comp.getClass().getName() + " " + comp.hashCode() + " " + constraint);
        }
        if (!(constraint instanceof Constraint)) {
            throw new IllegalArgumentException("MySpringLayout must be Constraint");
        }
        this.constraintMap.put(comp, constraint);
        this.globalBounds = null;
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        if (this.debug) {
            System.out.println("maximumLayoutSize 2");
        }
        if (this.globalBounds == null) {
            this.layoutContainer(parent);
        }
        return this.globalBounds.getSize();
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        if (this.debug) {
            System.out.println("getLayoutAlignmentX 2");
        }
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        if (this.debug) {
            System.out.println("getLayoutAlignmentY 2");
        }
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        if (this.debug) {
            System.out.println(this.name + " invalidateLayout ");
        }
        this.globalBounds = null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (this.debug) {
            System.out.println("addLayoutComponent ");
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.debug) {
            System.out.println("removeLayoutComponent");
        }
        this.constraintMap.remove(comp);
        this.globalBounds = null;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.globalBounds == null) {
            this.layoutContainer(parent);
        }
        if (this.debug) {
            System.out.println(this.name + " preferredLayoutSize " + this.globalBounds.getSize() + " " + parent.getInsets());
        }
        return this.globalBounds.getSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (this.debug) {
            System.out.println("minimumLayoutSize");
        }
        if (this.globalBounds == null) {
            this.layoutContainer(parent);
        }
        return this.globalBounds.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (this.debug) {
                System.out.println(this.name + " layoutContainer ");
            }
            int n = target.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Container c;
                LayoutManager m;
                Component comp = target.getComponent(i);
                if (!(comp instanceof Container) || !((m = (c = (Container)comp).getLayout()) instanceof LayoutM)) continue;
                m.layoutContainer(c);
            }
            this.reset(target);
            this.globalBounds = new Rectangle(0, 0, 0, 0);
            while (!this.layoutPass(target)) {
                target.setPreferredSize(this.globalBounds.getSize());
            }
        }
    }

    private boolean layoutPass(Container parent) {
        if (this.debugLayout) {
            System.out.println("layout " + this.name);
        }
        boolean gotAll = true;
        Rectangle bounds = new Rectangle();
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            double y;
            double x;
            Component comp = parent.getComponent(i);
            Constraint cs = (Constraint)this.constraintMap.get(comp);
            if (cs.c == null) {
                Dimension size = comp.getPreferredSize();
                Rectangle cB = comp.getBounds();
                x = cs.xspace < 0 ? -(size.getWidth() + (double)cs.xspace) : (double)cs.xspace;
                y = cs.yspace < 0 ? -(size.getHeight() + (double)cs.yspace) : (double)cs.yspace;
                bounds.setRect(x, y, size.getWidth(), size.getHeight());
                comp.setBounds(bounds);
                cs.laidout = true;
                this.globalBounds = this.globalBounds.union(bounds);
                if (!this.debugLayout) continue;
                System.out.println("  " + this.name + " SET (absolute) " + comp.getClass().getName() + " bounds= " + cB + " prefrredSize= " + size);
                System.out.println("  new bounds= " + bounds);
                continue;
            }
            Constraint cs2 = (Constraint)this.constraintMap.get(cs.c);
            if (cs2.laidout) {
                Rectangle b2 = cs.c.getBounds();
                Dimension size = comp.getPreferredSize();
                Rectangle cB = comp.getBounds();
                x = cs.xspace == 0 ? b2.getX() : (cs.xspace < 0 ? -(size.getWidth() + (double)cs.xspace) : b2.getX() + b2.getWidth() + (double)cs.xspace);
                y = cs.yspace == 0 ? b2.getY() : (cs.yspace < 0 ? -(size.getHeight() + (double)cs.yspace) : b2.getY() + b2.getHeight() + (double)cs.yspace);
                bounds.setRect(x, y, size.getWidth(), size.getHeight());
                comp.setBounds(bounds);
                cs.laidout = true;
                this.globalBounds = this.globalBounds.union(bounds);
                if (!this.debugLayout) continue;
                System.out.println("  " + this.name + " SET (reletive) " + comp.getClass().getName() + " bounds= " + cB + " prefrredSize= " + size);
                System.out.println("  new bounds= " + bounds);
                continue;
            }
            gotAll = false;
            if (!this.debugLayout) continue;
            System.out.println("  " + this.name + " Missed " + comp.getClass().getName());
        }
        return gotAll;
    }

    private void reset(Container parent) {
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Constraint cs = (Constraint)this.constraintMap.get(c);
            cs.laidout = false;
        }
    }

    static class Constraint {
        Component c;
        int xspace;
        int yspace;
        boolean laidout;

        public Constraint(Component c, int xspace, int yspace) {
            this.c = c;
            this.xspace = xspace;
            this.yspace = yspace;
        }

        public String toString() {
            String cname = this.c == null ? "null" : (this.c instanceof JLabel ? ((JLabel)this.c).getText() : this.c.getClass().getName());
            return this.xspace + " " + this.yspace + " <" + cname + ">";
        }
    }
}

