/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ucar.ui.event.UIChangeEvent;
import ucar.ui.event.UIChangeListener;
import ucar.ui.table.TableRow;
import ucar.ui.table.ThreadSorter;
import ucar.ui.util.ListenerManager;
import ucar.ui.util.NamedObject;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.PopupMenu;

public class JTableSorted
extends JPanel {
    private static final boolean debug = false;
    static final Icon sortDownIcon = BAMutil.getIcon("SortDown", true);
    static final Icon sortUpIcon = BAMutil.getIcon("SortUp", true);
    static final Icon threadSortIcon = BAMutil.getIcon("ThreadSorted", true);
    static final Icon threadUnSortIcon = BAMutil.getIcon("ThreadUnsorted", true);
    private List<TableRow> rows;
    private String[] colName;
    private final JTable jtable;
    private final JScrollPane scrollPane;
    private final TableRowModel model;
    private boolean sortOK = true;
    private final ThreadSorter threadSorter;
    private int threadCol = -1;
    private final ListenerManager lm;

    public JTableSorted(String[] colName, List<TableRow> listRT) {
        this(colName, listRT, false, null);
    }

    public JTableSorted(String[] columnName, List<TableRow> listRT, boolean enableColumnManipulation, ThreadSorter threadSorter) {
        boolean hasThreads;
        this.colName = columnName;
        this.rows = listRT == null ? new ArrayList() : listRT;
        this.threadSorter = threadSorter;
        this.jtable = new JTable();
        this.jtable.setDefaultRenderer(Object.class, new MyTableCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.jtable);
        this.model = new TableRowModel();
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.jtable);
        this.add((Component)this.scrollPane, "Center");
        boolean bl = hasThreads = threadSorter != null;
        if (hasThreads) {
            String[] newColName = new String[this.colName.length + 1];
            System.arraycopy(this.colName, 0, newColName, 0, this.colName.length);
            this.threadCol = this.colName.length;
            newColName[this.threadCol] = "Threads";
            this.colName = newColName;
        }
        this.jtable.setModel(this.model);
        this.jtable.setSelectionMode(0);
        this.jtable.setAutoResizeMode(2);
        this.setColumnWidths(null);
        TableColumnModel tcm = this.jtable.getColumnModel();
        int ncolwt = hasThreads ? this.jtable.getColumnCount() - 1 : this.jtable.getColumnCount();
        for (int i = 0; i < ncolwt; ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setHeaderRenderer(new SortedHeaderRenderer(this.colName[i], i));
        }
        if (hasThreads) {
            TableColumn tc = tcm.getColumn(ncolwt);
            tc.setHeaderRenderer(new ThreadHeaderRenderer(ncolwt));
        }
        if (enableColumnManipulation) {
            PopupMenu popupMenu = new PopupMenu(this.jtable.getTableHeader(), "Visible");
            int ncols = this.colName.length;
            PopupAction[] acts = new PopupAction[ncols];
            for (int i = 0; i < ncols; ++i) {
                acts[i] = new PopupAction(this.colName[i]);
                popupMenu.addActionCheckBox(this.colName[i], acts[i], true);
            }
        }
        JTableHeader hdr = this.jtable.getTableHeader();
        hdr.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!JTableSorted.this.sortOK) {
                    return;
                }
                TableColumnModel tcm2 = JTableSorted.this.jtable.getColumnModel();
                int colIdx = tcm2.getColumnIndexAtX(e.getX());
                int colNo = JTableSorted.this.jtable.convertColumnIndexToModel(colIdx);
                int selidx = JTableSorted.this.jtable.getSelectedRow();
                Object selected = null;
                if (selidx >= 0) {
                    selected = JTableSorted.this.rows.get(selidx);
                }
                if (JTableSorted.this.lm.hasListeners()) {
                    JTableSorted.this.lm.sendEvent(new UIChangeEvent(this, "sort", null, colNo));
                }
                JTableSorted.this.model.sort(colNo);
                if (selidx >= 0) {
                    int newSelectedRow = JTableSorted.this.rows.indexOf(selected);
                    JTableSorted.this.jtable.setRowSelectionInterval(newSelectedRow, newSelectedRow);
                    JTableSorted.this.ensureRowIsVisible(newSelectedRow);
                }
                JTableSorted.this.repaint();
            }
        });
        this.lm = new ListenerManager("ucar.ui.event.UIChangeListener", "ucar.ui.event.UIChangeEvent", "processChange");
    }

    public void sort(int colNo, boolean reverse) {
        this.model.sort(colNo, reverse);
        this.jtable.setRowSelectionInterval(0, 0);
        this.ensureRowIsVisible(0);
    }

    public void setRows(ArrayList<TableRow> rowList) {
        this.rows = rowList;
        if (!this.rows.isEmpty()) {
            this.jtable.setRowSelectionInterval(0, 0);
        } else {
            this.jtable.clearSelection();
        }
        this.model.sort();
        this.jtable.revalidate();
    }

    public void removeRow(Object elem) {
        Iterator<TableRow> iter = this.rows.iterator();
        while (iter.hasNext()) {
            TableRow row = iter.next();
            if (row != elem) continue;
            iter.remove();
            break;
        }
        this.jtable.revalidate();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.jtable.getSelectionModel().addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.jtable.getSelectionModel().removeListSelectionListener(l);
    }

    public void addUIChangeListener(UIChangeListener l) {
        this.lm.addListener(l);
    }

    public void removeUIChangeListener(UIChangeListener l) {
        this.lm.removeListener(l);
    }

    public int getSelectedRowIndex() {
        return this.jtable.getSelectedRow();
    }

    public void setSortOK(boolean sortOK) {
        this.sortOK = sortOK;
    }

    public TableRow getSelected() {
        if (this.rows.isEmpty()) {
            return null;
        }
        int sel = this.jtable.getSelectedRow();
        if (sel >= 0) {
            return this.rows.get(sel);
        }
        return null;
    }

    public void setSelected(int row) {
        if (row < 0 || row >= this.rows.size()) {
            return;
        }
        this.jtable.setRowSelectionInterval(row, row);
        this.ensureRowIsVisible(row);
    }

    public void incrSelected(boolean increment) {
        if (this.rows.isEmpty()) {
            return;
        }
        int curr = this.jtable.getSelectedRow();
        if (increment && curr < this.rows.size() - 1) {
            this.setSelected(curr + 1);
        } else if (!increment && curr > 0) {
            this.setSelected(curr - 1);
        }
    }

    public JTable getTable() {
        return this.jtable;
    }

    public int[] getModelIndex() {
        int[] modelIndex = new int[this.colName.length];
        TableColumnModel tcm = this.jtable.getColumnModel();
        for (int i = 0; i < this.colName.length; ++i) {
            TableColumn tc = tcm.getColumn(i);
            modelIndex[i] = tc.getModelIndex();
        }
        return modelIndex;
    }

    private void ensureRowIsVisible(int nRow) {
        Rectangle visibleRect = this.jtable.getCellRect(nRow, 0, true);
        visibleRect.x = this.scrollPane.getViewport().getViewPosition().x;
        this.jtable.scrollRectToVisible(visibleRect);
        this.jtable.repaint();
    }

    private void setColumnWidths(int[] sizes) {
        TableColumnModel tcm = this.jtable.getColumnModel();
        for (int i = 0; i < this.jtable.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            int maxw = sizes == null || i >= sizes.length ? this.model.getPreferredWidthForColumn(tc) : sizes[i];
            tc.setPreferredWidth(maxw);
        }
    }

    private void setSortCol(int sortCol, boolean reverse) {
        TableColumnModel tcm = this.jtable.getColumnModel();
        for (int i = 0; i < this.jtable.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            SortedHeaderRenderer shr = (SortedHeaderRenderer)tc.getHeaderRenderer();
            shr.setSortCol(sortCol, reverse);
        }
    }

    private static class ThreadHeaderRenderer
    extends SortedHeaderRenderer {
        JPanel sort = new JPanel(new BorderLayout());
        JPanel unsort;

        ThreadHeaderRenderer(int modelCol) {
            super(modelCol);
            this.sort.setBorder(new BevelBorder(0));
            this.sort.add((Component)new JLabel(threadSortIcon), "Center");
            this.unsort = new JPanel(new BorderLayout());
            this.unsort.setBorder(new BevelBorder(0));
            this.unsort.add((Component)new JLabel(threadUnSortIcon), "Center");
            this.comp = this.unsort;
        }

        @Override
        void setSortCol(int sortCol, boolean reverse) {
            this.comp = sortCol == this.modelCol ? this.sort : this.unsort;
        }
    }

    private static class SortedHeaderRenderer
    implements TableCellRenderer {
        int modelCol;
        Component comp;
        JPanel compPanel;
        JLabel upLabel;
        JLabel downLabel;
        boolean hasSortIndicator;
        boolean reverse;

        protected SortedHeaderRenderer(int modelCol) {
            this.modelCol = modelCol;
        }

        SortedHeaderRenderer(String name, int modelCol) {
            this.modelCol = modelCol;
            this.upLabel = new JLabel(sortUpIcon);
            this.downLabel = new JLabel(sortDownIcon);
            this.compPanel = new JPanel(new BorderLayout());
            this.compPanel.setBorder(new BevelBorder(0));
            this.compPanel.add((Component)new JLabel(name), "Center");
            this.comp = this.compPanel;
        }

        void setSortCol(int sortCol, boolean reverse) {
            if (sortCol == this.modelCol) {
                if (!this.hasSortIndicator) {
                    this.compPanel.add((Component)(reverse ? this.upLabel : this.downLabel), "East");
                } else if (reverse != this.reverse) {
                    this.compPanel.remove(1);
                    this.compPanel.add((Component)(reverse ? this.upLabel : this.downLabel), "East");
                }
                this.reverse = reverse;
                this.hasSortIndicator = true;
            } else if (this.hasSortIndicator) {
                this.compPanel.remove(1);
                this.hasSortIndicator = false;
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.comp;
        }
    }

    private static class MyJTable
    extends JTable {
        private MyJTable() {
        }

        @Override
        public Point getToolTipLocation(MouseEvent e) {
            return e.getPoint();
        }
    }

    private static class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JComponent && value instanceof NamedObject) {
                ((JComponent)c).setToolTipText(((NamedObject)value).getDescription());
            }
            return c;
        }

        @Override
        public Point getToolTipLocation(MouseEvent e) {
            return e.getPoint();
        }
    }

    private static class SortList
    implements Comparator<TableRow>,
    Serializable {
        private final int col;
        private final boolean reverse;

        SortList(int col, boolean reverse) {
            this.col = col;
            this.reverse = reverse;
        }

        @Override
        public int compare(TableRow row1, TableRow row2) {
            return this.reverse ? row2.compare(row1, this.col) : row1.compare(row2, this.col);
        }
    }

    private class TableRowModel
    extends AbstractTableModel {
        private boolean reverse;
        private int sortCol = -1;

        private TableRowModel() {
        }

        @Override
        public int getRowCount() {
            return JTableSorted.this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return JTableSorted.this.colName.length;
        }

        @Override
        public String getColumnName(int col) {
            return JTableSorted.this.colName[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            TableRow selectedRow = (TableRow)JTableSorted.this.rows.get(row);
            if (col == JTableSorted.this.threadCol) {
                if (null == JTableSorted.this.threadSorter) {
                    return "";
                }
                return JTableSorted.this.threadSorter.isTopThread(selectedRow) ? " * " : "";
            }
            return selectedRow.getValueAt(col);
        }

        void sort() {
            this.sort(this.sortCol, this.reverse);
        }

        void sort(int sortCol) {
            this.reverse = sortCol == this.sortCol ? !this.reverse : false;
            this.sort(sortCol, this.reverse);
        }

        void sort(int sortCol, boolean reverse) {
            this.reverse = reverse;
            if (sortCol == JTableSorted.this.threadCol && JTableSorted.this.threadSorter != null) {
                JTableSorted.this.rows = JTableSorted.this.threadSorter.sort(sortCol, reverse, JTableSorted.this.rows);
            } else if (sortCol >= 0) {
                JTableSorted.this.rows.sort(new SortList(sortCol, reverse));
            }
            JTableSorted.this.setSortCol(sortCol, reverse);
            this.sortCol = sortCol;
        }

        public int getPreferredWidthForColumn(TableColumn col) {
            int hw = this.columnHeaderWidth(col);
            int cw = this.widestCellInColumn(col);
            return Math.max(hw, cw);
        }

        private int columnHeaderWidth(TableColumn col) {
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                return 10;
            }
            Component comp = renderer.getTableCellRendererComponent(JTableSorted.this.jtable, col.getHeaderValue(), false, false, 0, 0);
            return comp.getPreferredSize().width;
        }

        private int widestCellInColumn(TableColumn col) {
            int c = col.getModelIndex();
            int maxw = 0;
            for (int r = 0; r < this.getRowCount(); ++r) {
                TableCellRenderer renderer = JTableSorted.this.jtable.getCellRenderer(r, c);
                Component comp = renderer.getTableCellRendererComponent(JTableSorted.this.jtable, this.getValueAt(r, c), false, false, r, c);
                int width = comp.getPreferredSize().width;
                maxw = Math.max(width, maxw);
            }
            return maxw;
        }
    }

    private class PopupAction
    extends AbstractAction {
        private final String id;
        private TableColumn tc;

        PopupAction(String id) {
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean state = (Boolean)this.getValue("state");
            TableColumnModel tcm = JTableSorted.this.jtable.getColumnModel();
            if (state) {
                tcm.addColumn(this.tc);
            } else {
                this.hideColumn();
            }
            JTableSorted.this.revalidate();
        }

        public void hideColumn() {
            TableColumnModel tcm = JTableSorted.this.jtable.getColumnModel();
            int idx = tcm.getColumnIndex(this.id);
            this.tc = tcm.getColumn(idx);
            tcm.removeColumn(this.tc);
        }
    }
}

