/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.util;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.ImageIcon;

public class Resource {
    static Class<Resource> cl = Resource.class;
    private static boolean debug;
    private static boolean debugIcon;

    public static ImageIcon getIcon(String fullIconName, boolean errMsg) {
        ImageIcon icon = null;
        URL iconR = cl.getResource(fullIconName);
        if (debugIcon) {
            System.out.println("classLoader " + cl.getClassLoader());
            System.out.println("  Resource.getIcon on " + fullIconName + " = " + iconR);
        }
        if (iconR != null) {
            icon = new ImageIcon(iconR);
        }
        if (icon == null && errMsg) {
            System.out.println("  ERROR: Resource.getIcon failed on " + fullIconName);
        } else if (debugIcon) {
            System.out.println("  Resource.getIcon ok on " + fullIconName);
        }
        return icon;
    }

    public static Image getImage(String fullImageName) {
        Image image = null;
        URL url = cl.getResource(fullImageName);
        if (url != null) {
            image = Toolkit.getDefaultToolkit().createImage(url);
        }
        if (image == null) {
            System.out.println("  ERROR: Resource.getImageResource failed on " + fullImageName);
        }
        return image;
    }

    public static URL getURL(String filename) {
        return cl.getResource(filename);
    }

    public static Cursor makeCursor(String name) {
        Cursor cursor;
        Image image = Resource.getImage(name);
        if (null == image) {
            return null;
        }
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (debug) {
                ImageObserver obs = (image1, flags, x, y, width, height) -> true;
                System.out.println(" bestCursorSize = " + tk.getBestCursorSize(image.getWidth(obs), image.getHeight(obs)));
                System.out.println(" getMaximumCursorColors = " + tk.getMaximumCursorColors());
            }
            cursor = tk.createCustomCursor(image, new Point(17, 17), name);
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("NavigatedPanel createCustomCursor failed " + e);
            return null;
        }
        return cursor;
    }

    public static InputStream getFileResource(String resourcePath) {
        InputStream is;
        block8: {
            is = cl.getResourceAsStream(resourcePath);
            if (is != null) {
                if (debug) {
                    System.out.println("Resource.getResourceAsStream ok on " + resourcePath);
                }
                return is;
            }
            if (debug) {
                System.out.println("Resource.getResourceAsStream failed on (" + resourcePath + ")");
            }
            try {
                is = new FileInputStream(resourcePath);
                if (debug) {
                    System.out.println("Resource.FileInputStream ok on " + resourcePath);
                }
            }
            catch (FileNotFoundException e) {
                if (debug) {
                    System.out.println("  FileNotFoundException: Resource.getFile failed on " + resourcePath);
                }
            }
            catch (AccessControlException e) {
                if (!debug) break block8;
                System.out.println("  AccessControlException: Resource.getFile failed on " + resourcePath);
            }
        }
        return is;
    }
}

