/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.util;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public final class SwingUtils {
    public static final Object NOT_NULL = new Object();
    static Set<String> setExclude = new HashSet<String>();

    private SwingUtils() {
        throw new Error("SwingUtils is just a container for static methods");
    }

    public static <T extends JComponent> List<T> getDescendantsOfType(Class<T> clazz, Container container) {
        return SwingUtils.getDescendantsOfType(clazz, container, true);
    }

    public static <T extends JComponent> List<T> getDescendantsOfType(Class<T> clazz, Container container, boolean nested) {
        ArrayList<T> tList = new ArrayList<T>();
        for (Component component : container.getComponents()) {
            if (clazz.isAssignableFrom(component.getClass())) {
                tList.add(clazz.cast(component));
            }
            if (!nested && clazz.isAssignableFrom(component.getClass())) continue;
            tList.addAll(SwingUtils.getDescendantsOfType(clazz, (Container)component, nested));
        }
        return tList;
    }

    public static <T extends JComponent> T getDescendantOfType(Class<T> clazz, Container container, String property, Object value) throws IllegalArgumentException {
        return SwingUtils.getDescendantOfType(clazz, container, property, value, true);
    }

    public static <T extends JComponent> T getDescendantOfType(Class<T> clazz, Container container, String property, Object value, boolean nested) throws IllegalArgumentException {
        List<T> list = SwingUtils.getDescendantsOfType(clazz, container, nested);
        return SwingUtils.getComponentFromList(clazz, list, property, value);
    }

    public static <T extends JComponent> List<T> getDescendantsOfClass(Class<T> clazz, Container container) {
        return SwingUtils.getDescendantsOfClass(clazz, container, true);
    }

    public static <T extends JComponent> List<T> getDescendantsOfClass(Class<T> clazz, Container container, boolean nested) {
        ArrayList<T> tList = new ArrayList<T>();
        for (Component component : container.getComponents()) {
            if (clazz.equals(component.getClass())) {
                tList.add(clazz.cast(component));
            }
            if (!nested && clazz.equals(component.getClass())) continue;
            tList.addAll(SwingUtils.getDescendantsOfClass(clazz, (Container)component, nested));
        }
        return tList;
    }

    public static <T extends JComponent> T getDescendantOfClass(Class<T> clazz, Container container, String property, Object value) throws IllegalArgumentException {
        return SwingUtils.getDescendantOfClass(clazz, container, property, value, true);
    }

    public static <T extends JComponent> T getDescendantOfClass(Class<T> clazz, Container container, String property, Object value, boolean nested) throws IllegalArgumentException {
        List<T> list = SwingUtils.getDescendantsOfClass(clazz, container, nested);
        return SwingUtils.getComponentFromList(clazz, list, property, value);
    }

    @Nullable
    private static <T extends JComponent> T getComponentFromList(Class<T> clazz, List<T> list, String property, Object value) throws IllegalArgumentException {
        Method method;
        try {
            method = clazz.getMethod("get" + property, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                method = clazz.getMethod("is" + property, new Class[0]);
            }
            catch (NoSuchMethodException ex1) {
                throw new IllegalArgumentException("Property " + property + " not found in class " + clazz.getName());
            }
        }
        try {
            for (JComponent t : list) {
                Object testVal = method.invoke((Object)t, new Object[0]);
                if ((value != NOT_NULL || testVal == null) && (value == NOT_NULL || !SwingUtils.equals(value, testVal))) continue;
                return (T)t;
            }
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("Error accessing property " + property + " in class " + clazz.getName());
        }
        catch (IllegalAccessException | SecurityException ex) {
            throw new IllegalArgumentException("Property " + property + " cannot be accessed in class " + clazz.getName());
        }
        return null;
    }

    public static boolean equals(Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static Map<JComponent, List<JComponent>> getComponentMap(JComponent container, boolean nested) {
        HashMap<JComponent, List<JComponent>> retVal = new HashMap<JComponent, List<JComponent>>();
        for (JComponent component : SwingUtils.getDescendantsOfType(JComponent.class, container, false)) {
            if (!retVal.containsKey(container)) {
                retVal.put(container, new ArrayList());
            }
            retVal.get(container).add(component);
            if (!nested) continue;
            retVal.putAll(SwingUtils.getComponentMap(component, nested));
        }
        return retVal;
    }

    public static UIDefaults getUIDefaultsOfClass(Class<?> clazz) {
        String name = clazz.getName();
        name = name.substring(name.lastIndexOf(".") + 2);
        return SwingUtils.getUIDefaultsOfClass(name);
    }

    public static UIDefaults getUIDefaultsOfClass(String className) {
        UIDefaults retVal = new UIDefaults();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        ArrayList listKeys = Collections.list(defaults.keys());
        for (Object key : listKeys) {
            String stringKey;
            if (!(key instanceof String) || !((String)key).startsWith(className)) continue;
            String property = stringKey = (String)key;
            if (stringKey.contains(".")) {
                property = stringKey.substring(stringKey.indexOf(".") + 1);
            }
            retVal.put(property, defaults.get(key));
        }
        return retVal;
    }

    public static Object getUIDefaultOfClass(Class<?> clazz, String property) {
        Object retVal = null;
        UIDefaults defaults = SwingUtils.getUIDefaultsOfClass(clazz);
        ArrayList listKeys = Collections.list(defaults.keys());
        for (Object key : listKeys) {
            if (key.equals(property)) {
                return defaults.get(key);
            }
            if (!key.toString().equalsIgnoreCase(property)) continue;
            retVal = defaults.get(key);
        }
        return retVal;
    }

    public static Map<Object, Object> getProperties(JComponent component) {
        Method[] methods;
        HashMap<Object, Object> retVal = new HashMap<Object, Object>();
        Class<?> clazz = component.getClass();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().matches("^(is|get).*") || method.getParameterTypes().length != 0) continue;
            try {
                Class<?> returnType = method.getReturnType();
                if (returnType == Void.TYPE || returnType.getName().startsWith("[") || setExclude.contains(method.getName())) continue;
                String key = method.getName();
                Object value = method.invoke((Object)component, new Object[0]);
                if (value == null || value instanceof Component) continue;
                retVal.put(key, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static <T extends JComponent> Class<?> getJClass(T component) {
        Class<?> clazz = component.getClass();
        while (!clazz.getName().matches("javax.swing.J[^.]*$")) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    static {
        setExclude.add("getFocusCycleRootAncestor");
        setExclude.add("getAccessibleContext");
        setExclude.add("getColorModel");
        setExclude.add("getGraphics");
        setExclude.add("getGraphicsConfiguration");
    }
}

