/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import ucar.ui.prefs.ComboBox;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.ImprovedFileChooser;
import ucar.ui.widget.IndependentDialog;
import ucar.util.prefs.PreferencesExt;

public class FileManager {
    private static final String BOUNDS = "Bounds";
    private static final String DEFAULT_DIR = "DefaultDir";
    private static final String DEFAULT_FILTER = "DefaultFilter";
    private static final boolean debug = false;
    private final PreferencesExt prefs;
    private IndependentDialog w;
    private final ComboBox<String> dirComboBox;
    private JFileChooser chooser;
    protected JPanel main;
    private boolean readOk = true;
    private boolean selectedFile;

    public FileManager(JFrame parent) {
        this(parent, null, null, null);
    }

    public FileManager(JFrame parent, String defDir) {
        this(parent, defDir, null, null);
    }

    public FileManager(JFrame parent, String defDir, String file_extension, String desc, PreferencesExt prefs) {
        this(parent, defDir, new FileFilter[]{new ExtFilter(file_extension, desc)}, prefs);
    }

    public FileManager(JFrame parent, String defDir, FileFilter[] filters, PreferencesExt prefs) {
        Rectangle b;
        String wantFilter;
        this.prefs = prefs;
        ArrayList<String> defaultDirs = new ArrayList<String>();
        if (defDir != null) {
            defaultDirs.add(defDir);
        } else {
            String dirName = prefs != null ? prefs.get(DEFAULT_DIR, ".") : ".";
            defaultDirs.add(dirName);
        }
        File defaultDirectory = this.findDefaultDirectory(defaultDirs);
        try {
            this.chooser = new ImprovedFileChooser(defaultDirectory);
        }
        catch (SecurityException se) {
            this.readOk = false;
            JOptionPane.showMessageDialog(null, "Sorry, this Applet does not have disk read permission.");
        }
        this.chooser.addActionListener(e -> {
            if (e.getActionCommand().equals("ApproveSelection")) {
                this.selectedFile = true;
            }
            this.w.setVisible(false);
        });
        if (filters != null) {
            for (FileFilter filter : filters) {
                this.chooser.addChoosableFileFilter(filter);
            }
        }
        if (prefs != null && (wantFilter = prefs.get(DEFAULT_FILTER, null)) != null) {
            for (FileFilter fileFilter : this.chooser.getChoosableFileFilters()) {
                if (!fileFilter.getDescription().equals(wantFilter)) continue;
                this.chooser.setFileFilter(fileFilter);
            }
        }
        AbstractAction usedirAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String item = (String)FileManager.this.dirComboBox.getSelectedItem();
                if (item != null) {
                    FileManager.this.chooser.setCurrentDirectory(new File(item));
                }
            }
        };
        BAMutil.setActionProperties(usedirAction, "FingerDown", "use this directory", false, 85, -1);
        AbstractAction savedirAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File currDir = FileManager.this.chooser.getCurrentDirectory();
                if (currDir != null) {
                    FileManager.this.dirComboBox.addItem(currDir.getPath());
                }
            }
        };
        BAMutil.setActionProperties(savedirAction, "FingerUp", "save current directory", false, 83, -1);
        AbstractAction rescanAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileManager.this.chooser.rescanCurrentDirectory();
            }
        };
        BAMutil.setActionProperties(rescanAction, "Undo", "refresh", false, 82, -1);
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        BAMutil.addActionToContainer(buttPanel, usedirAction);
        BAMutil.addActionToContainer(buttPanel, savedirAction);
        BAMutil.addActionToContainer(buttPanel, rescanAction);
        JPanel dirPanel = new JPanel(new BorderLayout());
        this.dirComboBox = new ComboBox(prefs);
        this.dirComboBox.setEditable(true);
        dirPanel.add((Component)new JLabel(" Directories: "), "West");
        dirPanel.add(this.dirComboBox, "Center");
        dirPanel.add((Component)buttPanel, "East");
        this.main = new JPanel(new BorderLayout());
        this.main.add((Component)dirPanel, "North");
        this.main.add((Component)this.chooser, "Center");
        this.w = new IndependentDialog(parent, true, "FileChooser", this.main);
        if (null != prefs && (b = (Rectangle)prefs.getObject(BOUNDS)) != null) {
            this.w.setBounds(b);
        }
    }

    public void save() {
        FileFilter currFilter;
        if (this.prefs == null) {
            return;
        }
        File currDir = this.chooser.getCurrentDirectory();
        if (currDir != null) {
            this.prefs.put(DEFAULT_DIR, currDir.getPath());
        }
        if ((currFilter = this.chooser.getFileFilter()) != null) {
            this.prefs.put(DEFAULT_FILTER, currFilter.getDescription());
        }
        if (this.dirComboBox != null) {
            this.dirComboBox.save();
        }
        this.prefs.putObject(BOUNDS, this.w.getBounds());
    }

    public JFileChooser getFileChooser() {
        return this.chooser;
    }

    public String chooseFilenameToSave(String defaultFilename) {
        this.chooser.setDialogType(1);
        String result = defaultFilename == null ? this.chooseFilename() : this.chooseFilename(defaultFilename);
        this.chooser.setDialogType(0);
        return result;
    }

    public String chooseDirectory(String defaultDirectory) {
        this.chooser.setFileSelectionMode(1);
        String result = defaultDirectory == null ? this.chooseFilename() : this.chooseFilename(defaultDirectory);
        this.chooser.setFileSelectionMode(2);
        return result;
    }

    @Nullable
    public String chooseFilename() {
        if (!this.readOk) {
            return null;
        }
        this.selectedFile = false;
        this.w.setVisible(true);
        if (this.selectedFile) {
            File file = this.chooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            try {
                return file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }

    public String chooseFilename(File def) {
        File parent = def.getParentFile();
        this.chooser.setCurrentDirectory(parent);
        this.chooser.setSelectedFile(def);
        return this.chooseFilename();
    }

    public String chooseFilename(String defaultFilename) {
        this.chooser.setSelectedFile(new File(defaultFilename));
        return this.chooseFilename();
    }

    public File[] chooseFiles() {
        this.chooser.setMultiSelectionEnabled(true);
        this.selectedFile = false;
        this.w.setVisible(true);
        if (this.selectedFile) {
            return this.chooser.getSelectedFiles();
        }
        return null;
    }

    public String getCurrentDirectory() {
        return this.chooser.getCurrentDirectory().getPath();
    }

    public void setCurrentDirectory(String dirName) {
        File dir = new File(dirName);
        this.chooser.setCurrentDirectory(dir);
    }

    private File findDefaultDirectory(List<String> tryDefaultDirectories) {
        boolean readOK = true;
        for (String tryDefaultDirectory : tryDefaultDirectories) {
            try {
                File dir = new File(tryDefaultDirectory);
                if (!dir.exists()) continue;
                return dir;
            }
            catch (SecurityException se) {
                readOK = false;
            }
        }
        if (!readOK) {
            JOptionPane.showMessageDialog(null, "Sorry, this Applet does not have disk read permission.");
        }
        return null;
    }

    public static class XMLExtFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String name = file.getName().toLowerCase();
            return file.isDirectory() || name.endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return "xml";
        }
    }

    public static class HDF5ExtFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String name = file.getName().toLowerCase();
            return file.isDirectory() || name.endsWith(".h5") || name.endsWith(".hdf");
        }

        @Override
        public String getDescription() {
            return "hdf5";
        }
    }

    public static class NetcdfExtFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String name = file.getName().toLowerCase();
            return file.isDirectory() || name.endsWith(".nc") || name.endsWith(".cdf");
        }

        @Override
        public String getDescription() {
            return "netcdf";
        }
    }

    public static class ExtFilter
    extends FileFilter {
        String file_extension;
        String desc;

        public ExtFilter(String file_extension, String desc) {
            this.file_extension = file_extension;
            this.desc = desc;
        }

        @Override
        public boolean accept(File file) {
            if (null == this.file_extension) {
                return true;
            }
            String name = file.getName();
            return file.isDirectory() || name.endsWith(this.file_extension);
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }
}

