/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class FontUtil {
    private static final boolean debug = false;
    private static final int MAX_FONTS = 15;
    private static final int fontType = 0;
    private static final Font[] stdFont = new Font[15];
    private static final FontMetrics[] stdMetrics = new FontMetrics[15];
    private static final Font[] monoFont = new Font[15];
    private static final FontMetrics[] monoMetrics = new FontMetrics[15];
    private static boolean isInit;

    private static void init() {
        if (isInit) {
            return;
        }
        FontUtil.initFontFamily("SansSerif", stdFont, stdMetrics);
        FontUtil.initFontFamily("Monospaced", monoFont, monoMetrics);
        isInit = true;
    }

    private static void initFontFamily(String name, Font[] fonts, FontMetrics[] fontMetrics) {
        for (int i = 0; i < 15; ++i) {
            int fontSize = i < 6 ? 5 + i : (i < 11 ? 10 + 2 * (i - 5) : 20 + 4 * (i - 10));
            fonts[i] = new Font(name, 0, fontSize);
            fontMetrics[i] = Toolkit.getDefaultToolkit().getFontMetrics(fonts[i]);
        }
    }

    public static StandardFont getStandardFont(int pixel_height) {
        FontUtil.init();
        return new StandardFont(stdFont, stdMetrics, pixel_height);
    }

    public static StandardFont getMonoFont(int pixel_height) {
        FontUtil.init();
        return new StandardFont(monoFont, monoMetrics, pixel_height);
    }

    public static class StandardFont {
        private int currFontNo;
        private int height;
        private final Font[] fonts;
        private final FontMetrics[] fontMetrics;

        StandardFont(Font[] fonts, FontMetrics[] fontMetrics, int pixel_height) {
            this.fonts = fonts;
            this.fontMetrics = fontMetrics;
            this.currFontNo = this.findClosest(pixel_height);
            this.height = fontMetrics[this.currFontNo].getAscent();
        }

        public Font getFont() {
            return this.fonts[this.currFontNo];
        }

        public int getFontHeight() {
            return this.height;
        }

        public Font incrFontSize() {
            if (this.currFontNo < 14) {
                ++this.currFontNo;
                this.height = this.fontMetrics[this.currFontNo].getAscent();
            }
            return this.getFont();
        }

        public Font decrFontSize() {
            if (this.currFontNo > 0) {
                --this.currFontNo;
                this.height = this.fontMetrics[this.currFontNo].getAscent();
            }
            return this.getFont();
        }

        public Dimension getBoundingBox(String s) {
            return new Dimension(this.fontMetrics[this.currFontNo].stringWidth(s), this.height);
        }

        private int findClosest(int pixel_height) {
            for (int i = 0; i < 14; ++i) {
                if (this.fontMetrics[i + 1].getAscent() <= pixel_height) continue;
                return i;
            }
            return 14;
        }
    }
}

