/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MultilineTooltip
extends JToolTip {
    static MultiLineToolTipUI sharedInstance = new MultiLineToolTipUI();
    static JToolTip tip;
    protected int columns;
    protected int fixedwidth;

    public MultilineTooltip() {
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(MultiLineToolTipUI.createUI(this));
    }

    public void setColumns(int columns) {
        this.columns = columns;
        this.fixedwidth = 0;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setFixedWidth(int width) {
        this.fixedwidth = width;
        this.columns = 0;
    }

    public int getFixedWidth() {
        return this.fixedwidth;
    }

    private static class MultiLineToolTipUI
    extends BasicToolTipUI {
        protected CellRendererPane rendererPane;
        private static JTextArea textArea;

        public static ComponentUI createUI(JComponent c) {
            return sharedInstance;
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            tip = (JToolTip)c;
            this.rendererPane = new CellRendererPane();
            c.add(this.rendererPane);
        }

        @Override
        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            c.remove(this.rendererPane);
            this.rendererPane = null;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Dimension size = c.getSize();
            textArea.setBackground(c.getBackground());
            this.rendererPane.paintComponent(g, textArea, c, 1, 1, size.width - 1, size.height - 1, true);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            String tipText = ((JToolTip)c).getTipText();
            if (tipText == null) {
                return new Dimension(0, 0);
            }
            textArea = new JTextArea(tipText);
            this.rendererPane.removeAll();
            this.rendererPane.add(textArea);
            textArea.setWrapStyleWord(true);
            int width = ((MultilineTooltip)c).getFixedWidth();
            int columns = ((MultilineTooltip)c).getColumns();
            if (columns > 0) {
                textArea.setColumns(columns);
                textArea.setSize(0, 0);
                textArea.setLineWrap(true);
                textArea.setSize(textArea.getPreferredSize());
            } else if (width > 0) {
                textArea.setLineWrap(true);
                Dimension d = textArea.getPreferredSize();
                d.width = width;
                ++d.height;
                textArea.setSize(d);
            } else {
                textArea.setLineWrap(false);
            }
            Dimension dim = textArea.getPreferredSize();
            ++dim.height;
            ++dim.width;
            return dim;
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }
    }
}

