/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import com.google.common.base.CharMatcher;
import java.awt.Component;
import java.awt.Point;
import java.util.Formatter;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class PopupManager {
    private final PopupFactory factory = PopupFactory.getSharedInstance();
    private Popup popup;
    private final JPanel main = new JPanel();
    private final JLabel info;
    private boolean isShowing;
    private Object showing;

    public PopupManager(String title) {
        this.main.setBorder(new TitledBorder(title));
        this.info = new JLabel();
        this.main.add(this.info);
        this.main.setFocusable(false);
    }

    public void show(String text, Point p, Component owner, Object forWho) {
        if (this.isShowing && this.showing == forWho) {
            return;
        }
        if (this.isShowing) {
            this.popup.hide();
        }
        this.isShowing = true;
        this.showing = forWho;
        Formatter out = new Formatter();
        String textSubbed = CharMatcher.is((char)'\n').replaceFrom((CharSequence)text, (CharSequence)"<br>");
        out.format("<html><body>%s</body></html>", textSubbed);
        this.info.setText(out.toString());
        SwingUtilities.convertPointToScreen(p, owner);
        int x = (int)p.getX();
        int y = (int)p.getY();
        this.popup = this.factory.getPopup(owner, this.main, x + 5, y + 5);
        if (this.popup != null) {
            this.popup.show();
        }
    }

    public void hide() {
        if (!this.isShowing) {
            return;
        }
        this.isShowing = false;
        if (this.popup != null) {
            this.popup.hide();
        }
    }
}

