/*
 * Decompiled with CFR 0.152.
 */
package ucar.ui.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.event.ActionValueListener;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.PrefPanel;
import ucar.ui.table.JTableSorted;
import ucar.ui.table.TableRow;
import ucar.ui.table.TableRowAbstract;
import ucar.ui.util.NamedObject;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.MyMouseAdapter;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.SpinIcon;

public class SuperComboBox
extends JPanel {
    private static final boolean debug = false;
    private static final boolean debugEvent = false;
    private ArrayList<TableRow> rows = new ArrayList();
    private final String name;
    private final MyTextField text;
    private final JWindow pulldown;
    private final JTableSorted table;
    private final IndependentWindow loopControl;
    private final ActionSourceListener actionSource;
    private boolean eventOK = true;
    private boolean sendExternalEvent = true;
    private boolean immediateMode;

    public SuperComboBox(RootPaneContainer parent, String name, boolean sortOK, Iterator<Object> iter) {
        this.name = name;
        this.text = new MyTextField(" ");
        this.text.setToolTipText(name);
        JPanel seqPanel = new JPanel(new GridLayout(1, 2));
        JButton prev = this.makeButton(SpinIcon.TypeLeft);
        prev.setToolTipText("previous");
        seqPanel.add(prev);
        JButton next = this.makeButton(SpinIcon.TypeRight);
        next.setToolTipText("next");
        seqPanel.add(next);
        JPanel bPanel = new JPanel(new BorderLayout());
        JButton down = this.makeButton(SpinIcon.TypeDown);
        down.setToolTipText("show menu");
        bPanel.add((Component)seqPanel, "North");
        bPanel.add((Component)down, "South");
        String[] colNames = new String[]{name};
        this.table = new JTableSorted(colNames, this.rows);
        this.table.setSortOK(sortOK);
        if (iter != null) {
            this.setCollection(iter);
        }
        JFrame parentComponent = parent instanceof JFrame ? (JFrame)parent : null;
        this.pulldown = new JWindow(parentComponent);
        this.pulldown.getContentPane().add(this.table);
        this.pulldown.pack();
        this.setBorder(new EtchedBorder(0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.text, "Center");
        this.add((Component)bPanel, "East");
        this.text.addMouseListener(new MyMouseAdapter(){

            @Override
            public void click(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    SuperComboBox.this.showPulldownMenu();
                }
            }
        });
        LoopControl popup = new LoopControl();
        this.text.addMouseListener(popup);
        this.loopControl = popup.getLoopControl();
        prev.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SuperComboBox.this.table.incrSelected(false);
            }
        });
        next.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SuperComboBox.this.table.incrSelected(true);
            }
        });
        down.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SuperComboBox.this.showPulldownMenu();
            }
        });
        this.table.addListSelectionListener(e -> {
            if (this.eventOK && !e.getValueIsAdjusting()) {
                this.setSelection();
                this.hidePulldownMenu();
            }
        });
        this.table.getTable().addMouseListener(new MyMouseAdapter(){

            @Override
            public void click(MouseEvent e) {
                SuperComboBox.this.hidePulldownMenu();
            }
        });
        this.actionSource = new ActionSourceListener(name){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                SuperComboBox.this.setSelectedByName(e.getValue().toString());
            }
        };
    }

    public void addActionValueListener(ActionValueListener l) {
        this.actionSource.addActionValueListener(l);
    }

    public void removeActionValueListener(ActionValueListener l) {
        this.actionSource.removeActionValueListener(l);
    }

    public ActionSourceListener getActionSourceListener() {
        return this.actionSource;
    }

    public IndependentWindow getLoopControl() {
        return this.loopControl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setCollection(Iterator<? extends Object> iter) {
        this.setCollection(iter, false);
    }

    public void setCollection(Iterator<? extends Object> iter, boolean keepIndex) {
        this.eventOK = false;
        this.rows = new ArrayList();
        if (iter != null) {
            FontMetrics fm = this.text.getFontMetrics(this.text.getFont());
            int width = 0;
            while (iter.hasNext()) {
                Object o = iter.next();
                TableRow row = o instanceof TableRow ? (TableRow)o : (o instanceof NamedObject ? new NamedObjectRow((NamedObject)o) : new SimpleRow(o));
                String s = row.getValueAt(0).toString().trim();
                int slen = fm.stringWidth(s);
                width = Math.max(width, slen);
                this.rows.add(row);
            }
            Dimension d = this.text.getPreferredSize();
            d.width = width + 10;
            this.text.setPreferredSize(d);
            this.text.revalidate();
        }
        this.table.setRows(this.rows);
        if (this.rows.isEmpty()) {
            this.setLabel("none");
        } else {
            int currIndex = this.getSelectedIndex();
            if (currIndex >= this.rows.size() || currIndex < 0 || !keepIndex) {
                this.setSelectedByIndex(0);
            }
        }
        this.eventOK = true;
    }

    public void setLabel(String s) {
        this.text.setText(s);
    }

    @Nullable
    public Object getSelectedObject() {
        TableRow selected = this.getSelectedRow();
        return selected == null ? null : selected.getUserObject();
    }

    public int getSelectedIndex() {
        return this.table.getSelectedRowIndex();
    }

    public int setSelectedByName(String choiceName) {
        for (int i = 0; i < this.rows.size(); ++i) {
            TableRow row = this.rows.get(i);
            String value = row.getValueAt(0).toString();
            if (!choiceName.equals(value)) continue;
            this.sendExternalEvent = false;
            this.setSelectedByIndex(i);
            this.sendExternalEvent = true;
            return i;
        }
        return -1;
    }

    public int setSelectedByValue(Object choice) {
        for (int i = 0; i < this.rows.size(); ++i) {
            TableRow row = this.rows.get(i);
            if (!choice.equals(row.getValueAt(0))) continue;
            this.sendExternalEvent = false;
            this.setSelectedByIndex(i);
            this.sendExternalEvent = true;
            return i;
        }
        return -1;
    }

    public void setSelectedByIndex(int index) {
        if (index >= 0 && index < this.rows.size()) {
            this.table.setSelected(index);
            this.setSelection();
        } else if (!this.rows.isEmpty()) {
            this.table.setSelected(0);
            this.setSelection();
        } else {
            this.setLabel("none");
        }
    }

    private TableRow getSelectedRow() {
        return this.table.getSelected();
    }

    private void setSelection() {
        TableRow selected = this.getSelectedRow();
        if (selected != null) {
            Object selectedObject = selected.getValueAt(0);
            String selectedName = selectedObject.toString();
            this.text.setText(selectedName.trim());
            if (selected instanceof NamedObjectRow || selected instanceof GeoGridRow) {
                this.text.setToolTipText(((NamedObject)selected.getUserObject()).getDescription());
            }
            this.repaint();
            if (selectedObject instanceof GeoGridRow) {
                selectedObject = ((GeoGridRow)selectedObject).getUserObject();
            }
            if (this.sendExternalEvent) {
                if (this.immediateMode) {
                    this.actionSource.fireActionValueEvent("redrawImmediate", selectedObject);
                } else {
                    this.actionSource.fireActionValueEvent("selected", selectedObject);
                }
            }
        }
    }

    private void showPulldownMenu() {
        if (this.pulldown.isShowing()) {
            this.pulldown.setVisible(false);
        } else {
            int height = 222;
            Dimension d = new Dimension(this.getWidth(), height);
            this.pulldown.setSize(d);
            Point p = this.text.getLocationOnScreen();
            p.y += this.text.getHeight();
            this.pulldown.setLocation(p);
            this.pulldown.setVisible(true);
        }
    }

    private void hidePulldownMenu() {
        if (this.pulldown.isShowing()) {
            this.pulldown.setVisible(false);
        }
    }

    private JButton makeButton(SpinIcon.Type type) {
        SpinIcon icon = new SpinIcon(type);
        JButton butt = new JButton(icon);
        Insets i = new Insets(0, 0, 0, 0);
        butt.setMargin(i);
        butt.setBorderPainted(false);
        butt.setFocusPainted(false);
        butt.setPreferredSize(new Dimension(icon.getIconWidth() + 2, icon.getIconHeight() + 2));
        return butt;
    }

    private class LoopControl
    extends PopupMenu.PopupTriggerListener {
        private final IndependentWindow iw;
        private final JPanel loopPanel = new JPanel();
        private final JButton moreOrLess;
        private AbstractButton loopButt;
        private AbstractButton helpButt;
        private final PrefPanel ifPanel;
        private final Field.Int stepIF;
        private final Field.Text startIF;
        private final AbstractAction loopAct;
        private final AbstractAction helpAct;
        private boolean stopped;
        private boolean forward;
        private boolean first = true;
        private boolean continuous = true;
        private boolean less = true;
        private int step = 1;
        private int start = -1;

        LoopControl() {
            AbstractAction play = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoopControl.this.start(true);
                }
            };
            BAMutil.setActionProperties(play, "VCRPlay", "play", false, 83, 102);
            BAMutil.addActionToContainer(this.loopPanel, play);
            AbstractAction fastforward = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SuperComboBox.this.setSelectedByIndex(SuperComboBox.this.rows.size() - 1);
                }
            };
            BAMutil.setActionProperties(fastforward, "VCRFastForward", "go to end", false, 70, 97);
            BAMutil.addActionToContainer(this.loopPanel, fastforward);
            AbstractAction next = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int current = LoopControl.this.incr(true, false);
                    if (current >= 0) {
                        SuperComboBox.this.setSelectedByIndex(current);
                        SuperComboBox.this.text.paintImmediately(SuperComboBox.this.text.getBounds());
                    }
                }
            };
            BAMutil.setActionProperties(next, "VCRNextFrame", "Next frame", false, 78, 34);
            BAMutil.addActionToContainer(this.loopPanel, next);
            AbstractAction stop = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoopControl.this.stopped = true;
                }
            };
            BAMutil.setActionProperties(stop, "VCRStop", "stop", false, 83, 27);
            BAMutil.addActionToContainer(this.loopPanel, stop);
            AbstractAction prev = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int current = LoopControl.this.incr(false, false);
                    if (current >= 0) {
                        SuperComboBox.this.setSelectedByIndex(current);
                        SuperComboBox.this.text.paintImmediately(SuperComboBox.this.text.getBounds());
                    }
                }
            };
            BAMutil.setActionProperties(prev, "VCRPrevFrame", "Previous frame", false, 80, 33);
            BAMutil.addActionToContainer(this.loopPanel, prev);
            AbstractAction rewind = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SuperComboBox.this.setSelectedByIndex(0);
                }
            };
            BAMutil.setActionProperties(rewind, "VCRRewind", "rewind", false, 82, 103);
            BAMutil.addActionToContainer(this.loopPanel, rewind);
            AbstractAction back = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoopControl.this.start(false);
                }
            };
            BAMutil.setActionProperties(back, "VCRBack", "play backwards", false, 66, 100);
            BAMutil.addActionToContainer(this.loopPanel, back);
            this.moreOrLess = new JButton(new SpinIcon(SpinIcon.TypeRight));
            this.moreOrLess.setBorder(BorderFactory.createEmptyBorder());
            this.moreOrLess.setMargin(new Insets(0, 0, 0, 0));
            this.moreOrLess.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LoopControl.this.less) {
                        LoopControl.this.makeMore();
                    } else {
                        LoopControl.this.makeLess();
                    }
                }
            });
            this.loopPanel.add(this.moreOrLess);
            this.iw = new IndependentWindow(SuperComboBox.this.name + " loop", null, this.loopPanel);
            this.iw.setResizable(false);
            this.loopAct = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoopControl.this.continuous = (Boolean)this.getValue("state");
                }
            };
            BAMutil.setActionProperties(this.loopAct, "MovieLoop", "continuous loop", true, 76, 0);
            this.helpAct = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                }
            };
            BAMutil.setActionProperties(this.helpAct, "Help", "online Help...", false, 72, 72);
            JSpinner stepSpinner = new JSpinner();
            stepSpinner.setToolTipText("step");
            this.ifPanel = new PrefPanel("loopControl", null);
            this.stepIF = this.ifPanel.addIntField("step", "step", 1);
            this.startIF = this.ifPanel.addTextField("start", "start", "    0");
            this.ifPanel.finish(false);
        }

        private void makeMore() {
            this.loopButt = BAMutil.addActionToContainer(this.loopPanel, this.loopAct);
            this.loopAct.putValue("state", this.continuous);
            this.helpButt = BAMutil.addActionToContainer(this.loopPanel, this.helpAct);
            this.loopPanel.add(this.ifPanel);
            this.moreOrLess.setIcon(new SpinIcon(SpinIcon.TypeLeft));
            this.moreOrLess.setToolTipText("less");
            this.loopPanel.revalidate();
            this.iw.pack();
            this.less = false;
        }

        private void makeLess() {
            this.loopPanel.remove(this.loopButt);
            this.loopPanel.remove(this.helpButt);
            this.loopPanel.remove(this.ifPanel);
            this.moreOrLess.setIcon(new SpinIcon(SpinIcon.TypeRight));
            this.moreOrLess.setToolTipText("more");
            this.loopPanel.revalidate();
            this.iw.pack();
            this.less = true;
        }

        IndependentWindow getLoopControl() {
            return this.iw;
        }

        @Override
        public void showPopup(MouseEvent e) {
            if (this.first) {
                Point pt = new Point(0, 0);
                SwingUtilities.convertPointToScreen(pt, SuperComboBox.this);
                this.iw.setLocation(pt);
                this.first = false;
            }
            this.iw.show();
        }

        private void start(boolean forward) {
            this.forward = forward;
            SuperComboBox.this.eventOK = false;
            SuperComboBox.this.immediateMode = true;
            this.stopped = false;
            this.ifPanel.accept();
            this.step = Math.min(this.stepIF.getInt(), 1);
            this.start = -1;
            String startName = this.startIF.getText();
            if (startName != null && !startName.isEmpty()) {
                this.start = SuperComboBox.this.setSelectedByName(startName);
            }
            SwingUtilities.invokeLater(new RunLoop());
        }

        private int incr(boolean forward, boolean continuous) {
            int current = SuperComboBox.this.getSelectedIndex();
            current = forward ? (current += this.step) : (current -= this.step);
            if (!(continuous || current >= 0 && current < SuperComboBox.this.rows.size())) {
                return -1;
            }
            if (current >= SuperComboBox.this.rows.size()) {
                current = Math.max(this.start, 0);
            }
            if (current < 0) {
                current = this.start >= 0 ? this.start : SuperComboBox.this.rows.size() - 1;
            }
            return current;
        }

        class RunLoop
        implements Runnable {
            RunLoop() {
            }

            @Override
            public void run() {
                LoopControl.this.loopPanel.repaint();
                if (LoopControl.this.stopped) {
                    this.stop();
                    return;
                }
                int current = LoopControl.this.incr(LoopControl.this.forward, LoopControl.this.continuous);
                if (current < 0) {
                    this.stop();
                    return;
                }
                SuperComboBox.this.setSelectedByIndex(current);
                SuperComboBox.this.text.paintImmediately(SuperComboBox.this.text.getBounds());
                SwingUtilities.invokeLater(new RunLoop());
            }

            private void stop() {
                SuperComboBox.this.immediateMode = false;
                SuperComboBox.this.eventOK = true;
            }
        }
    }

    private class MyTextField
    extends JLabel {
        private final int arrow_size = 4;
        private boolean wasDragged;
        private Rectangle b;
        private int nitems;
        private int currentItem;

        MyTextField(String name) {
            super(name);
            this.arrow_size = 4;
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.addMouseListener(new MyMouseListener());
            this.addMouseMotionListener(new MyMouseMotionListener());
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.black);
            this.b = this.getBounds();
            this.nitems = SuperComboBox.this.rows.size();
            int posx = this.getItemPos();
            int line = this.b.height - 1;
            for (int w2 = 4; w2 >= 0; --w2) {
                g.drawLine(posx - w2, line, posx + w2, line);
                --line;
            }
        }

        protected int getItemPos() {
            if (this.nitems < 1) {
                return -4;
            }
            if (this.nitems == 1) {
                return this.b.width / 2;
            }
            int item = SuperComboBox.this.table.getSelectedRowIndex();
            int eff_width = this.b.width - 8;
            int pixel = item * eff_width / (this.nitems - 1);
            return pixel + 4;
        }

        protected int getItem(int pixel) {
            if (this.nitems < 2) {
                return 0;
            }
            int eff_width = this.b.width - 8;
            double fitem = (double)(pixel - 4) * (double)(this.nitems - 1) / (double)eff_width;
            int item = (int)(fitem + 0.5);
            item = Math.max(Math.min(item, this.nitems - 1), 0);
            return item;
        }

        private class MyMouseMotionListener
        extends MouseMotionAdapter {
            private MyMouseMotionListener() {
            }

            @Override
            public void mouseDragged(MouseEvent anEvent) {
                int item = MyTextField.this.getItem(anEvent.getX());
                SuperComboBox.this.table.setSelected(item);
                MyTextField.this.repaint();
                MyTextField.this.wasDragged = true;
            }
        }

        private class MyMouseListener
        extends MouseAdapter {
            private MyMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent anEvent) {
                SuperComboBox.this.sendExternalEvent = false;
                MyTextField.this.wasDragged = false;
                MyTextField.this.currentItem = SuperComboBox.this.table.getSelectedRowIndex();
            }

            @Override
            public void mouseReleased(MouseEvent anEvent) {
                int item;
                SuperComboBox.this.sendExternalEvent = true;
                if (MyTextField.this.wasDragged && (item = MyTextField.this.getItem(anEvent.getX())) != MyTextField.this.currentItem) {
                    SuperComboBox.this.setSelection();
                }
                MyTextField.this.wasDragged = false;
            }
        }
    }

    private static class GeoGridRow
    extends TableRowAbstract
    implements NamedObject {
        NamedObject o;

        GeoGridRow(NamedObject o) {
            this.o = o;
        }

        @Override
        public Object getValueAt(int col) {
            return this;
        }

        @Override
        public Object getUserObject() {
            return this.o;
        }

        @Override
        public Object getValue() {
            return this.o;
        }

        @Override
        public String getName() {
            return this.o.getName();
        }

        @Override
        public String getDescription() {
            return this.o.getDescription();
        }

        @Override
        public String toString() {
            String desc = this.o.getDescription();
            if (desc == null || desc.isEmpty() || desc.trim().equals("-")) {
                return this.o.getName();
            }
            return this.o.getName() + " == " + this.o.getDescription();
        }
    }

    private static class NamedObjectRow
    extends TableRowAbstract
    implements NamedObject {
        NamedObject o;

        NamedObjectRow(NamedObject o) {
            this.o = o;
        }

        @Override
        public Object getValueAt(int col) {
            return this;
        }

        @Override
        public Object getUserObject() {
            return this.o;
        }

        @Override
        public Object getValue() {
            return this.o;
        }

        @Override
        public String getName() {
            return this.o.getName();
        }

        @Override
        public String getDescription() {
            return this.o.getDescription();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    private static class SimpleRow
    extends TableRowAbstract {
        Object o;

        SimpleRow(Object o) {
            this.o = o;
        }

        @Override
        public Object getValueAt(int col) {
            return this.o;
        }

        @Override
        public Object getUserObject() {
            return this.o;
        }
    }
}

