/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import ucar.util.prefs.XMLStore;

class Bean {
    private final Object o;
    private BeanParser p;

    public Bean(Object o) {
        this.o = o;
    }

    public Bean(Attributes atts) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = atts.getValue("class");
        System.out.printf("ClassForName %s", className);
        Class<?> c = Class.forName(className);
        this.o = c.newInstance();
        this.p = BeanParser.getParser(c);
        this.p.readProperties(this.o, atts);
    }

    public void writeProperties(PrintWriter out) {
        if (this.p == null) {
            this.p = BeanParser.getParser(this.o.getClass());
        }
        this.p.writeProperties(this.o, out);
    }

    public Object getObject() {
        return this.o;
    }

    public Class<?> getBeanClass() {
        return this.o.getClass();
    }

    private static class BeanParser {
        private static final boolean debugBean = false;
        private static final Map<Class<?>, BeanParser> parsers = new HashMap();
        private final Map<String, PropertyDescriptor> properties = new TreeMap<String, PropertyDescriptor>();
        private final Object[] args = new Object[1];

        static BeanParser getParser(Class<?> beanClass) {
            BeanParser parser = parsers.get(beanClass);
            if (null == parser) {
                parser = new BeanParser(beanClass);
                parsers.put(beanClass, parser);
            }
            return parser;
        }

        BeanParser(Class<?> beanClass) {
            PropertyDescriptor[] pds;
            BeanInfo info;
            try {
                info = Introspector.getBeanInfo(beanClass, Object.class);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
                return;
            }
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
                this.properties.put(pd.getName(), pd);
            }
        }

        void writeProperties(Object bean, PrintWriter out) {
            for (PropertyDescriptor pds : this.properties.values()) {
                Method getter = pds.getReadMethod();
                try {
                    Object value = getter.invoke(bean, (Object[])null);
                    if (value == null) continue;
                    if (value instanceof String) {
                        value = XMLStore.quote((String)value);
                    } else if (value instanceof Date) {
                        value = ((Date)value).getTime();
                    }
                    out.print(pds.getName() + "='" + value + "' ");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        void readProperties(Object bean, Attributes atts) {
            for (PropertyDescriptor o1 : this.properties.values()) {
                PropertyDescriptor pds = o1;
                Method setter = pds.getWriteMethod();
                if (setter == null) continue;
                try {
                    String sArg = atts.getValue(pds.getName());
                    Object arg = this.getArgument(pds.getPropertyType(), sArg);
                    if (arg == null) {
                        return;
                    }
                    this.args[0] = arg;
                    setter.invoke(bean, this.args);
                }
                catch (IllegalAccessException | NumberFormatException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        private Object getArgument(Class<?> c, String value) {
            if (c == String.class) {
                return value;
            }
            if (c == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (c == Double.TYPE) {
                return Double.valueOf(value);
            }
            if (c == Boolean.TYPE) {
                if (value == null) {
                    return null;
                }
                return Boolean.valueOf(value);
            }
            if (c == Float.TYPE) {
                return Float.valueOf(value);
            }
            if (c == Short.TYPE) {
                return Short.valueOf(value);
            }
            if (c == Long.TYPE) {
                return Long.valueOf(value);
            }
            if (c == Byte.TYPE) {
                return Byte.valueOf(value);
            }
            if (c == Date.class) {
                long time = Long.parseLong(value);
                return new Date(time);
            }
            return null;
        }
    }

    static class Collection {
        private final java.util.Collection<Object> collect;
        private Class<?> beanClass;
        private BeanParser p;

        Collection(java.util.Collection<?> collect) {
            this.collect = new ArrayList(collect);
            if (!collect.isEmpty()) {
                Iterator<?> iter = collect.iterator();
                this.beanClass = iter.next().getClass();
                this.p = BeanParser.getParser(this.beanClass);
            }
        }

        Collection(Attributes atts) throws ClassNotFoundException {
            String className = atts.getValue("class");
            this.beanClass = Class.forName(className);
            this.p = BeanParser.getParser(this.beanClass);
            this.collect = new ArrayList<Object>();
        }

        public void writeProperties(PrintWriter out, Object thiso) {
            this.p.writeProperties(thiso, out);
        }

        public java.util.Collection<?> getCollection() {
            return this.collect;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Object readProperties(Attributes atts) throws InstantiationException, IllegalAccessException {
            Object o = this.beanClass.newInstance();
            this.p.readProperties(o, atts);
            this.collect.add(o);
            return o;
        }
    }
}

