/*
 * Decompiled with CFR 0.152.
 */
package ucar.util.prefs;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Stack;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ucar.util.prefs.Bean;
import ucar.util.prefs.Indent;
import ucar.util.prefs.PreferencesExt;

public class XMLStore {
    private static final boolean debugConvert = false;
    private static final boolean showDecoderExceptions = false;
    private static final boolean debugWhichStore = false;
    private static final boolean debugWriteNested = false;
    private static final boolean debugWriteBean = false;
    private File prefsFile;
    private final PreferencesExt rootPrefs = new PreferencesExt(null, "");
    private String outputExceptionMessage;
    private static final char[] replaceChar = new char[]{'&', '<', '>', '\'', '\"', '\r', '\n'};
    private static final String[] replaceWith = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;", "&#13;", "&#10;"};

    public static XMLStore createFromFile(String fileName, XMLStore storedDefaults) throws IOException {
        File prefsFile = new File(fileName);
        BufferedInputStream primIS = null;
        BufferedInputStream objIS = null;
        if (prefsFile.exists() && prefsFile.length() > 0L) {
            primIS = new BufferedInputStream(new FileInputStream(prefsFile));
            objIS = new BufferedInputStream(new FileInputStream(prefsFile));
        }
        XMLStore store = new XMLStore(primIS, objIS, storedDefaults);
        store.prefsFile = prefsFile;
        return store;
    }

    public static XMLStore createFromInputStream(InputStream is1, InputStream is2, XMLStore storedDefaults) throws IOException {
        return new XMLStore(is1, is2, storedDefaults);
    }

    public static XMLStore createFromResource(String resourceName, XMLStore storedDefaults) throws IOException {
        Class<XMLStore> c = XMLStore.class;
        InputStream primIS = c.getResourceAsStream(resourceName);
        InputStream objIS = c.getResourceAsStream(resourceName);
        if (primIS == null) {
            throw new IOException("XMLStore.createFromResource cant find <" + resourceName + ">");
        }
        return new XMLStore(primIS, objIS, storedDefaults);
    }

    public XMLStore() {
    }

    private XMLStore(InputStream primIS, InputStream objIS, XMLStore storedDefaults) throws IOException {
        if (null != primIS) {
            InputStream convertIS;
            block5: {
                convertIS = this.convert2XmlDecoder(objIS);
                objIS.close();
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    SAXParser saxParser = factory.newSAXParser();
                    MySaxHandler handler = new MySaxHandler(convertIS);
                    saxParser.parse(primIS, (DefaultHandler)handler);
                }
                catch (IOException | ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (SAXException se) {
                    System.out.println("SAXException = " + se.getMessage());
                    se.printStackTrace();
                    Exception see = se.getException();
                    if (see == null) break block5;
                    System.out.println("from = " + see.getMessage());
                    see.printStackTrace();
                }
            }
            primIS.close();
            convertIS.close();
        }
        if (storedDefaults != null) {
            this.rootPrefs.setStoredDefaults(storedDefaults.getPreferences());
        }
    }

    private XMLDecoder openBeanDecoder(InputStream objIS) {
        return new XMLDecoder(objIS, null, e -> e.printStackTrace());
    }

    private InputStream convert2XmlDecoder(InputStream is) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        Element root = doc.getRootElement();
        Document convertDoc = new Document();
        Element convertRoot = new Element("java");
        convertRoot.setAttribute("version", "1.4.1_01");
        convertRoot.setAttribute("class", "java.beans.XMLDecoder");
        convertDoc.setRootElement(convertRoot);
        this.add(root, convertRoot);
        XMLOutputter xmlOut = new XMLOutputter();
        xmlOut.setFormat(Format.getPrettyFormat());
        return new StringBufferInputStream(xmlOut.outputString(convertDoc));
    }

    private void add(Element elem, Element parent) {
        if (elem.getName().equals("object")) {
            parent.addContent((Content)elem.clone());
            return;
        }
        for (Object child : elem.getChildren()) {
            this.add((Element)child, parent);
        }
    }

    public static String makeStandardFilename(String appName, String storeName) {
        boolean ok;
        String dirFilename;
        File f;
        String userHome = null;
        try {
            userHome = System.getProperty("user.home");
        }
        catch (Exception e) {
            System.out.println("XMLStore.makeStandardFilename: error System.getProperty(user.home) " + e);
        }
        if (null == userHome) {
            userHome = ".";
        }
        if (!(f = new File(dirFilename = userHome + "/" + appName)).exists() && !(ok = f.mkdirs())) {
            System.out.println("Error creating directories: " + f.getAbsolutePath());
        }
        return dirFilename + "/" + storeName;
    }

    public PreferencesExt getPreferences() {
        return this.rootPrefs;
    }

    String findAttribute(Attributes atts, String what) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getLocalName(i).equals(what)) continue;
            return atts.getValue(i);
        }
        return null;
    }

    public void save() throws IOException {
        File prefTemp;
        if (this.prefsFile == null) {
            throw new UnsupportedOperationException("XMLStore is read-only");
        }
        String parentFilename = this.prefsFile.getParent();
        if (parentFilename == null) {
            prefTemp = File.createTempFile("pref", ".xml");
        } else {
            File parentFile = new File(parentFilename);
            prefTemp = File.createTempFile("pref", ".xml", parentFile);
        }
        prefTemp.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(prefTemp, false);
        this.save(fos);
        fos.close();
        Path xmlBackup = Paths.get(this.prefsFile.getAbsolutePath() + ".bak", new String[0]);
        Path prefsPath = this.prefsFile.toPath();
        if (Files.exists(prefsPath, new LinkOption[0])) {
            Files.move(prefsPath, xmlBackup, StandardCopyOption.REPLACE_EXISTING);
        }
        Files.move(prefTemp.toPath(), this.prefsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void save(OutputStream out) throws IOException {
        this.outputExceptionMessage = null;
        OutputMunger bos = new OutputMunger(out);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8));
        XMLEncoder beanEncoder = new XMLEncoder(bos);
        beanEncoder.setExceptionListener(exception -> {
            System.out.println("XMLStore.save() got Exception: abort saving the preferences!");
            exception.printStackTrace();
            this.outputExceptionMessage = exception.getMessage();
        });
        pw.printf("<?xml version='1.0' encoding='UTF-8'?>%n", new Object[0]);
        pw.printf("<preferences EXTERNAL_XML_VERSION='1.0'>%n", new Object[0]);
        if (!this.rootPrefs.isUserNode()) {
            pw.printf("  <root type='system'>%n", new Object[0]);
        } else {
            pw.printf("  <root type='user'>%n", new Object[0]);
        }
        Indent indent = new Indent(2);
        indent.incr();
        this.writeXmlNode(bos, pw, this.rootPrefs, beanEncoder, indent);
        if (this.outputExceptionMessage != null) {
            throw new IOException(this.outputExceptionMessage);
        }
        pw.printf("  </root>%n", new Object[0]);
        pw.printf("</preferences>%n", new Object[0]);
        pw.flush();
    }

    private void writeXmlNode(OutputMunger bos, PrintWriter out, PreferencesExt prefs, XMLEncoder beanEncoder, Indent indent) throws IOException {
        indent.incr();
        try {
            String[] keys = prefs.keysNoDefaults();
            if (keys.length == 0) {
                out.printf("%s<map/>%n", indent);
            } else {
                out.printf("%s<map>%n", indent);
                for (String key : keys) {
                    Object bean;
                    Object value = prefs.getObjectNoDefaults(key);
                    if (value instanceof String) {
                        out.printf("%s  <entry key='%s' value='%s' />%n", indent, key, XMLStore.quote((String)value));
                        continue;
                    }
                    if (value instanceof Bean.Collection) {
                        bean = (Bean.Collection)value;
                        if (((Bean.Collection)bean).getCollection().isEmpty()) continue;
                        out.printf("%s  <beanCollection key='%s' class='%s' >%n", indent, key, ((Bean.Collection)bean).getBeanClass().getName());
                        for (Object o : ((Bean.Collection)bean).getCollection()) {
                            out.printf("%s    <bean ", indent);
                            ((Bean.Collection)bean).writeProperties(out, o);
                            out.println("/>");
                        }
                        out.printf("%s  </beanCollection>", indent);
                        continue;
                    }
                    if (value instanceof Bean) {
                        bean = (Bean)value;
                        out.printf("%s  <bean key='%s' class='%s' ", indent, key, ((Bean)bean).getBeanClass().getName());
                        ((Bean)bean).writeProperties(out);
                        out.printf("/>%n", new Object[0]);
                        continue;
                    }
                    out.printf("%s  <beanObject key='%s' >%n", indent, key);
                    out.flush();
                    bos.enterBeanStream();
                    try {
                        beanEncoder.writeObject(value);
                    }
                    catch (Exception e) {
                        System.out.println("Exception beanEncoder: " + e);
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                    beanEncoder.flush();
                    bos.exitBeanStream();
                    out.printf("%s  </beanObject>%n", indent);
                }
                out.printf("%s</map>%n", indent);
            }
            for (String kidName : prefs.childrenNames()) {
                PreferencesExt pkid = (PreferencesExt)prefs.node(kidName);
                out.printf("%s<node name='%s' >%n", indent, pkid.name());
                this.writeXmlNode(bos, out, pkid, beanEncoder, indent);
                out.printf("%s</node>%n", indent);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        indent.decr();
    }

    static String quote(String x) {
        boolean ok = true;
        for (char c : replaceChar) {
            int pos = x.indexOf(c);
            ok &= pos < 0;
        }
        if (ok) {
            return x;
        }
        StringBuffer result = new StringBuffer(x);
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            if (pos < 0) continue;
            XMLStore.replace(result, replaceChar[i], replaceWith[i]);
        }
        return result.toString();
    }

    private static void replace(StringBuffer sb, char out, String in) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != out) continue;
            sb.replace(i, i + 1, in);
            i += in.length();
        }
    }

    private static class OutputMunger
    extends BufferedOutputStream {
        boolean done;
        boolean bean;
        int countNL;

        OutputMunger(OutputStream out) {
            super(out, 1024);
        }

        void enterBeanStream() {
            this.bean = true;
        }

        void exitBeanStream() {
            this.bean = false;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.done || !this.bean) {
                super.write(b);
            } else {
                if (b == 10) {
                    ++this.countNL;
                }
                if (this.countNL == 2) {
                    this.done = true;
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.done || !this.bean) {
                super.write(b, off, len);
            } else {
                for (int i = 0; i < len; ++i) {
                    this.write(b[off + i]);
                }
            }
        }
    }

    private class MySaxHandler
    extends DefaultHandler {
        private final boolean debug = false;
        private final boolean debugDetail = false;
        private final InputStream objIS;
        private XMLDecoder beanDecoder;
        private Bean.Collection currentBeanCollection;
        private Stack<PreferencesExt> stack;
        private PreferencesExt current;

        MySaxHandler(InputStream objIS) {
            this.objIS = objIS;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equalsIgnoreCase("root")) {
                this.startRoot(attributes);
            } else if (qName.equalsIgnoreCase("map")) {
                this.startMap(attributes);
            } else if (qName.equalsIgnoreCase("node")) {
                this.startNode(attributes);
            } else if (qName.equalsIgnoreCase("entry")) {
                this.startEntry(attributes);
            } else if (qName.equalsIgnoreCase("bean")) {
                this.startBean(attributes);
            } else if (qName.equalsIgnoreCase("beanCollection")) {
                this.startBeanCollection(attributes);
            } else if (qName.equalsIgnoreCase("beanObject")) {
                this.startBeanObject(attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equalsIgnoreCase("node")) {
                this.endNode();
            }
            if (qName.equalsIgnoreCase("beanCollection")) {
                this.endBeanCollection();
            }
        }

        private void startRoot(Attributes attributes) {
            this.stack = new Stack();
            this.current = XMLStore.this.rootPrefs;
        }

        private void startMap(Attributes attributes) {
        }

        private void startNode(Attributes attributes) {
            String name = attributes.getValue("name");
            this.stack.push(this.current);
            this.current = (PreferencesExt)this.current.node(name);
        }

        private void startEntry(Attributes attributes) {
            String key = attributes.getValue("key");
            String values = attributes.getValue("value");
            this.current.put(key, values);
        }

        private void startBean(Attributes attributes) {
            String key = attributes.getValue("key");
            try {
                if (this.currentBeanCollection != null) {
                    Object object = this.currentBeanCollection.readProperties(attributes);
                } else {
                    Bean value = new Bean(attributes);
                    this.current.putObject(key, value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void startBeanCollection(Attributes attributes) {
            String key = attributes.getValue("key");
            try {
                this.currentBeanCollection = new Bean.Collection(attributes);
                this.current.putObject(key, this.currentBeanCollection);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        private void startBeanObject(Attributes attributes) {
            if (this.beanDecoder == null) {
                this.beanDecoder = XMLStore.this.openBeanDecoder(this.objIS);
            }
            String key = attributes.getValue("key");
            try {
                Object value = this.beanDecoder.readObject();
                this.current.putObject(key, value);
            }
            catch (Exception e) {
                System.out.println("#ERROR beanDecoder; beanObject key = " + key);
                e.printStackTrace();
            }
        }

        private void endBeanCollection() {
            this.currentBeanCollection = null;
        }

        private void endNode() {
            this.current = this.stack.pop();
        }
    }
}

