/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.logs.LogReader;

public class AccessLogParser
implements LogReader.LogParser {
    private SimpleDateFormat formatFrom = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    private static Pattern regPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+) - (.*) \\[(.*)] \"(.*)\" (\\d+) ([\\-\\d]+) \"(.*)\" \"(.*)\" (\\d+)");
    private static Pattern regPattern2 = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+) - (.*) \\[(.*)] \"(.*)\" (\\d+) ([\\-\\d]+)");

    @Override
    public LogReader.Log nextLog(BufferedReader dataIS) throws IOException {
        String line = dataIS.readLine();
        if (line == null) {
            return null;
        }
        LogReader.Log resultLog = this.parseLog(line);
        if (resultLog != null) {
            return resultLog;
        }
        return this.nextLog(dataIS);
    }

    LogReader.Log parseLog(String line) throws IOException {
        try {
            Matcher m = regPattern.matcher(line);
            if (m.matches()) {
                LogReader.Log log = new LogReader.Log();
                log.ip = m.group(1);
                log.date = this.convertDate(m.group(3));
                String request = m.group(4);
                log.returnCode = this.parse(m.group(5));
                log.sizeBytes = this.parseLong(m.group(6));
                log.referrer = m.group(7);
                log.client = m.group(8);
                log.msecs = this.parseLong(m.group(9));
                String[] reqss = request.split(" ");
                if (reqss.length == 3) {
                    log.verb = reqss[0].intern();
                    log.path = reqss[1];
                    log.http = reqss[2].intern();
                } else if (reqss.length == 2) {
                    log.verb = reqss[0].intern();
                    log.path = reqss[1];
                }
                return log;
            }
            m = regPattern2.matcher(line);
            if (m.matches()) {
                LogReader.Log log = new LogReader.Log();
                log.ip = m.group(1);
                log.date = this.convertDate(m.group(3));
                String request = m.group(4);
                log.returnCode = this.parse(m.group(5));
                log.sizeBytes = this.parseLong(m.group(6));
                log.referrer = "-";
                log.client = "-";
                log.msecs = -1L;
                String[] reqss = request.split(" ");
                if (reqss.length == 3) {
                    log.verb = reqss[0].intern();
                    log.path = reqss[1];
                    log.http = reqss[2].intern();
                } else if (reqss.length == 2) {
                    log.verb = reqss[0].intern();
                    log.path = reqss[1];
                }
                return log;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Cant parse " + line);
        }
        return null;
    }

    private long convertDate(String accessDateFormat) {
        try {
            Date d = this.formatFrom.parse(accessDateFormat);
            return d.getTime();
        }
        catch (Throwable t) {
            System.out.printf("Bad date format = %s err = %s%n", accessDateFormat, t.getMessage());
            return -1L;
        }
    }

    private int parse(String s) {
        if (s.equals("-")) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    private long parseLong(String s) {
        if (s.equals("-")) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static void main(String[] args) throws IOException {
        AccessLogParser p = new AccessLogParser();
        String line = "24.18.236.132 - - [04/Feb/2011:17:49:03 -0700] \"GET /thredds/fileServer//nexrad/level3/N0R/YUX/20110205/Level3_YUX_N0R_20110205_0011.nids \" 200 10409 \"-\" \"-\" 17";
        Matcher m = regPattern.matcher(line);
        System.out.printf("%s %s%n", m.matches(), m);
        for (int i = 0; i < m.groupCount(); ++i) {
            System.out.println(" " + i + " " + m.group(i));
        }
        LogReader.Log log = p.parseLog(line);
        System.out.printf("%s%n", log);
    }
}

