/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.UnitType;

public class Chart
extends JPanel {
    private TimeSeriesCollection dataset = new TimeSeriesCollection();
    private TimeSeriesCollection datasetOpenClose = new TimeSeriesCollection();
    private TimeSeriesCollection datasetHighLow = new TimeSeriesCollection();
    private String stockSymbol;

    public Chart(String title, String timeAxis, String valueAxis, TimeSeries data) {
        try {
            this.dataset.addSeries(data);
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)timeAxis, (String)valueAxis, (XYDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            XYPlot plot = chart.getXYPlot();
            plot.setBackgroundPaint((Paint)Color.lightGray);
            plot.setDomainGridlinePaint((Paint)Color.white);
            plot.setRangeGridlinePaint((Paint)Color.white);
            plot.setAxisOffset(new RectangleInsets(UnitType.ABSOLUTE, 5.0, 5.0, 5.0, 5.0));
            plot.setDomainCrosshairVisible(true);
            plot.setRangeCrosshairVisible(true);
            DateAxis axis = (DateAxis)plot.getDomainAxis();
            axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("EEE HH"));
            this.add((Component)new ChartPanel(chart));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Chart(String filename) {
        this.stockSymbol = filename.substring(0, filename.indexOf(46));
        TimeSeries open = new TimeSeries((Comparable)((Object)"Open Price"), Day.class);
        TimeSeries close = new TimeSeries((Comparable)((Object)"Close Price"), Day.class);
        TimeSeries high = new TimeSeries((Comparable)((Object)"High"), Day.class);
        TimeSeries low = new TimeSeries((Comparable)((Object)"Low"), Day.class);
        try (FileInputStream fin = new FileInputStream(filename);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fin, StandardCharsets.UTF_8));){
            br.readLine();
            String line = br.readLine();
            while (line != null && !line.startsWith("<!--")) {
                StringTokenizer st = new StringTokenizer(line, ",", false);
                Day day = this.getDay(st.nextToken());
                double openValue = Double.parseDouble(st.nextToken());
                double highValue = Double.parseDouble(st.nextToken());
                double lowValue = Double.parseDouble(st.nextToken());
                double closeValue = Double.parseDouble(st.nextToken());
                st.nextToken();
                open.add((RegularTimePeriod)day, openValue);
                close.add((RegularTimePeriod)day, closeValue);
                high.add((RegularTimePeriod)day, highValue);
                low.add((RegularTimePeriod)day, lowValue);
                line = br.readLine();
            }
            this.dataset.addSeries(open);
            this.dataset.addSeries(close);
            this.dataset.addSeries(low);
            this.dataset.addSeries(high);
            this.datasetOpenClose.addSeries(open);
            this.datasetOpenClose.addSeries(close);
            this.datasetHighLow.addSeries(high);
            this.datasetHighLow.addSeries(low);
            JFreeChart summaryChart = this.buildChart(this.dataset, "Summary", true);
            JFreeChart openCloseChart = this.buildChart(this.datasetOpenClose, "Open/Close Data", false);
            JFreeChart highLowChart = this.buildChart(this.datasetHighLow, "High/Low Data", true);
            JFreeChart highLowDifChart = this.buildDifferenceChart(this.datasetHighLow, "High/Low Difference Chart");
            this.setLayout(new GridLayout(2, 2));
            this.add((Component)new ChartPanel(summaryChart));
            this.add((Component)new ChartPanel(openCloseChart));
            this.add((Component)new ChartPanel(highLowChart));
            this.add((Component)new ChartPanel(highLowDifChart));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JFreeChart buildChart(TimeSeriesCollection dataset, String title, boolean endPoints) {
        XYItemRenderer renderer;
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Date", (String)"Price", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.getLegend();
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(UnitType.ABSOLUTE, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        if (endPoints && (renderer = plot.getRenderer()) instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setShapesFilled(true);
            rr.setItemLabelsVisible(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MMM-yyyy"));
        return chart;
    }

    private JFreeChart buildDifferenceChart(TimeSeriesCollection dataset, String title) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Date", (String)"Price", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer((XYItemRenderer)new XYDifferenceRenderer((Paint)new Color(112, 128, 222), (Paint)new Color(112, 128, 222), false));
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(UnitType.ABSOLUTE, 5.0, 5.0, 5.0, 5.0));
        DateAxis domainAxis = new DateAxis("Date");
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        plot.setDomainAxis((ValueAxis)domainAxis);
        plot.setForegroundAlpha(0.5f);
        return chart;
    }

    protected Day getDay(String date) {
        try {
            String[] st = date.split("-");
            int year = Integer.parseInt(st[0]);
            int month = Integer.parseInt(st[1]);
            int day = Integer.parseInt(st[2]);
            return new Day(day, month, year);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSymbol() {
        return this.stockSymbol;
    }

    public static void main(String[] args) {
        Chart shc = new Chart("C:/TEMP/table.csv");
        JFrame frame = new JFrame("Stock History Chart for " + shc.getSymbol());
        frame.getContentPane().add((Component)shc, "Center");
        frame.setSize(640, 480);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

