/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.coverage2;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Formatter;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.IsMissingEvaluator;
import ucar.ma2.MAMath;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.HorizCoordSys;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.coverage2.DataState;
import ucar.nc2.ui.grid.ColorScale;
import ucar.nc2.util.Optional;
import ucar.ui.prefs.Debug;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Format;
import ucar.util.prefs.PreferencesExt;

public class CoverageRenderer {
    private boolean drawGrid = true;
    private boolean drawGridLines = true;
    private boolean drawContours = false;
    private boolean drawContourLabels = false;
    private boolean drawBB = false;
    private boolean isNewField = true;
    private ColorScale colorScale = null;
    private ColorScale.MinMaxType dataMinMaxType = ColorScale.MinMaxType.horiz;
    private ProjectionImpl drawProjection = null;
    private ProjectionImpl dataProjection = null;
    private DataState dataState;
    private GeoReferencedArray dataH;
    private Array geodata;
    private double useLevel;
    private int wantLevel = -1;
    private int wantSlice = -1;
    private int wantTime = -1;
    private int horizStride = 1;
    private int wantRunTime = -1;
    private int wantEnsemble = -1;
    private int lastLevel = -1;
    private int lastTime = -1;
    private int lastStride = -1;
    private int lastRunTime = -1;
    private int lastEnsemble = -1;
    private Coverage lastGrid = null;
    private boolean useModeForProjections = false;
    private boolean sameProjection = true;
    private LatLonProjection projectll;
    private static final boolean debugHorizDraw = false;
    private static final boolean debugMiss = false;
    private boolean debugPts = false;
    private boolean debugPathShape = true;
    private Rectangle2D rect = new Rectangle2D.Double();
    private GeneralPath gpRun = new GeneralPath(0, 25);

    public CoverageRenderer(PreferencesExt store) {
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale cs) {
        this.colorScale = cs;
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        if (type != this.dataMinMaxType) {
            this.dataMinMaxType = type;
        }
    }

    public DataState setCoverage(CoverageCollection coverageDataset, Coverage grid) {
        this.dataState = new DataState(coverageDataset, grid);
        this.lastGrid = null;
        this.isNewField = true;
        return this.dataState;
    }

    public ProjectionImpl getDataProjection() {
        return this.dataProjection;
    }

    public void setDataProjection(ProjectionImpl dataProjection) {
        this.dataProjection = dataProjection;
    }

    public ProjectionImpl getDisplayProjection() {
        return this.drawProjection;
    }

    public void setViewProjection(ProjectionImpl project) {
        this.drawProjection = project;
    }

    public void setDrawBB(boolean drawBB) {
        this.drawBB = drawBB;
    }

    public void setDrawGridLines(boolean drawGrid) {
        this.drawGridLines = drawGrid;
    }

    public void setDrawContours(boolean drawContours) {
        this.drawContours = drawContours;
    }

    public void setDrawContourLabels(boolean drawContourLabels) {
        this.drawContourLabels = drawContourLabels;
    }

    public int getLevel() {
        return this.wantLevel;
    }

    public void setLevel(int level) {
        this.wantLevel = level;
    }

    public int getTime() {
        return this.wantTime;
    }

    public void setTime(int time) {
        this.wantTime = time;
    }

    public void setRunTime(int runtime) {
        this.wantRunTime = runtime;
    }

    public void setEnsemble(int ensemble) {
        this.wantEnsemble = ensemble;
    }

    public void setSlice(int slice) {
        this.wantSlice = slice;
    }

    public void setHorizStride(int horizStride) {
        this.horizStride = horizStride;
    }

    public String getXYvalueStr(ProjectionPoint loc) {
        HorizCoordSys hcs;
        Optional opt;
        if (this.lastGrid == null || this.geodata == null) {
            return "";
        }
        if (!this.sameProjection) {
            LatLonPoint llpt = this.drawProjection.projToLatLon(loc);
            loc = this.dataProjection.latLonToProj(llpt);
        }
        if (!(opt = (hcs = this.lastGrid.getCoordSys().getHorizCoordSys()).findXYindexFromCoord(loc.getX(), loc.getY())).isPresent()) {
            return opt.getErrorMessage();
        }
        HorizCoordSys.CoordReturn cr = (HorizCoordSys.CoordReturn)opt.get();
        try {
            Index imaH = this.geodata.getIndex();
            double dataValue = this.geodata.getDouble(imaH.set(cr.y, cr.x));
            return this.makeXYZvalueStr(dataValue, cr);
        }
        catch (Exception e) {
            return "error " + cr.x + " " + cr.y;
        }
    }

    private String makeXYZvalueStr(double value, HorizCoordSys.CoordReturn cr) {
        String val = this.lastGrid.isMissing(value) ? "missing value" : Format.d((double)value, (int)6);
        Formatter sbuff = new Formatter();
        sbuff.format("%s %s", val, this.lastGrid.getUnitsString());
        sbuff.format(" @ (%f,%f)", cr.xcoord, cr.ycoord);
        sbuff.format("  [%d,%d]", cr.x, cr.y);
        return sbuff.toString();
    }

    private GeoReferencedArray readHSlice(int level, int time, int ensemble, int runtime) {
        CalendarDate date;
        if (this.dataState.grid.equals(this.lastGrid) && time == this.lastTime && level == this.lastLevel && this.horizStride == this.lastStride && ensemble == this.lastEnsemble && runtime == this.lastRunTime) {
            return this.dataH;
        }
        SubsetParams subset = new SubsetParams();
        if (level >= 0 && this.dataState.zaxis != null) {
            double levelVal = this.dataState.zaxis.getCoordMidpoint(level);
            subset.set("vertCoord", (Object)levelVal);
        }
        if (time >= 0 && this.dataState.taxis != null) {
            double timeVal = this.dataState.taxis.getCoordMidpoint(time);
            date = this.dataState.taxis.makeDate(timeVal);
            subset.set("time", (Object)date);
        }
        if (runtime >= 0 && this.dataState.rtaxis != null) {
            double rtimeVal = this.dataState.rtaxis.getCoordMidpoint(runtime);
            date = this.dataState.rtaxis.makeDate(rtimeVal);
            subset.set("runtime", (Object)date);
        }
        if (ensemble >= 0 && this.dataState.ensaxis != null) {
            double ensVal = this.dataState.ensaxis.getCoordMidpoint(ensemble);
            subset.set("ensCoord", (Object)ensVal);
        }
        if (this.horizStride != 1) {
            subset.setHorizStride(this.horizStride);
        }
        try {
            this.dataH = this.dataState.grid.readData(subset);
            this.geodata = this.dataH.getData().reduce();
        }
        catch (IOException | InvalidRangeException e) {
            e.printStackTrace();
        }
        this.lastGrid = this.dataState.grid;
        this.lastTime = time;
        this.lastLevel = level;
        this.lastEnsemble = ensemble;
        this.lastRunTime = runtime;
        this.lastStride = this.horizStride;
        return this.dataH;
    }

    private void setColorScaleParams() {
        if (this.dataMinMaxType == ColorScale.MinMaxType.hold && !this.isNewField) {
            return;
        }
        this.isNewField = false;
        GeoReferencedArray dataArr = this.readHSlice(this.wantLevel, this.wantTime, this.wantEnsemble, this.wantRunTime);
        if (dataArr != null) {
            MAMath.MinMax minmax = MAMath.getMinMaxSkipMissingData((Array)dataArr.getData(), (IsMissingEvaluator)this.dataState.grid);
            this.colorScale.setMinMax(minmax.min, minmax.max);
            this.colorScale.setGeoGrid((IsMissingEvaluator)this.dataState.grid);
        }
    }

    public void renderPlanView(Graphics2D g, AffineTransform dFromN) {
        if (this.dataState.grid == null || this.colorScale == null || this.drawProjection == null) {
            return;
        }
        if (!this.drawGrid && !this.drawContours) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.dataH = this.readHSlice(this.wantLevel, this.wantTime, this.wantEnsemble, this.wantRunTime);
        if (this.dataH == null) {
            return;
        }
        this.setColorScaleParams();
        if (this.drawGrid) {
            this.drawGridHoriz(g, this.dataH);
        }
        if (this.drawGridLines) {
            this.drawGridLines(g, this.dataH);
        }
        if (this.drawBB) {
            this.drawGridBB(g, this.dataState.coverageDataset.getLatlonBoundingBox());
        }
    }

    private boolean drawGridBB(Graphics2D g, LatLonRect latLonRect) {
        g.setColor(Color.BLACK);
        this.rect.setRect(latLonRect.getLonMin(), latLonRect.getLatMin(), latLonRect.getWidth(), latLonRect.getHeight());
        g.draw(this.rect);
        return true;
    }

    private void drawGridHoriz(Graphics2D g, GeoReferencedArray geo) {
        CoverageCoordSys csData = geo.getCoordSysForData();
        HorizCoordSys hcs = csData.getHorizCoordSys();
        if (!hcs.isLatLon2D()) {
            this.drawGridHorizRegular(g, geo);
            return;
        }
        Array data = geo.getData();
        if ((data = data.reduce()).getRank() != 2) {
            throw new IllegalArgumentException("must be 2D");
        }
        Index ima = data.getIndex();
        LatLonAxis2D xaxis2D = hcs.getLonAxis2D();
        LatLonAxis2D yaxis2D = hcs.getLatAxis2D();
        ArrayDouble.D2 edgex = (ArrayDouble.D2)xaxis2D.getCoordBoundsAsArray();
        ArrayDouble.D2 edgey = (ArrayDouble.D2)yaxis2D.getCoordBoundsAsArray();
        GeneralPath gp = new GeneralPath(0, 5);
        int[] shape = xaxis2D.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                gp.reset();
                gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                gp.lineTo((float)edgex.get(y, x + 1), (float)edgey.get(y, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x + 1), (float)edgey.get(y + 1, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x), (float)edgey.get(y + 1, x));
                double val = data.getDouble(ima.set(y, x));
                int colorIndex = this.colorScale.getIndexFromValue(val);
                g.setColor(this.colorScale.getColor(colorIndex));
                g.fill(gp);
            }
        }
    }

    private void drawGridLines(Graphics2D g, GeoReferencedArray geo) {
        CoverageCoordSys geocs = geo.getCoordSysForData();
        LatLonAxis2D lataxis = geocs.getHorizCoordSys().getLatAxis2D();
        LatLonAxis2D lonaxis = geocs.getHorizCoordSys().getLonAxis2D();
        if (lataxis == null || lonaxis == null) {
            return;
        }
        ArrayDouble.D2 edgex = (ArrayDouble.D2)lonaxis.getCoordBoundsAsArray();
        ArrayDouble.D2 edgey = (ArrayDouble.D2)lataxis.getCoordBoundsAsArray();
        GeneralPath gp = new GeneralPath(0, 5);
        g.setColor(Color.BLACK);
        int[] shape = lataxis.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (int y = 0; y < ny + 1; y += 10) {
            gp.reset();
            for (int x = 0; x < nx + 1; ++x) {
                if (x == 0) {
                    gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                    continue;
                }
                gp.lineTo((float)edgex.get(y, x), (float)edgey.get(y, x));
            }
            g.draw(gp);
        }
        for (int x = 0; x < nx + 1; x += 10) {
            gp.reset();
            for (int y = 0; y < ny + 1; ++y) {
                if (y == 0) {
                    gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                    continue;
                }
                gp.lineTo((float)edgex.get(y, x), (float)edgey.get(y, x));
            }
            g.draw(gp);
        }
    }

    private void drawGridHorizRegular(Graphics2D g, GeoReferencedArray array) {
        int count = 0;
        CoverageCoordSys gsys = array.getCoordSysForData();
        CoverageCoordAxis1D xaxis = (CoverageCoordAxis1D)gsys.getXAxis();
        CoverageCoordAxis1D yaxis = (CoverageCoordAxis1D)gsys.getYAxis();
        Array data = array.getData().reduce();
        if (data.getRank() != 2) {
            System.out.printf("drawGridHorizRegular Rank equals %d, must be 2%n", data.getRank());
            return;
        }
        int nx = xaxis.getNcoords();
        int ny = yaxis.getNcoords();
        this.sameProjection = this.drawProjection.equals((Object)this.dataProjection);
        if (this.drawProjection.isLatLon()) {
            this.projectll = (LatLonProjection)this.drawProjection;
            double centerLon = this.projectll.getCenterLon();
            if (Debug.isSet((String)"projection/LatLonShift")) {
                System.out.println("projection/LatLonShift: gridDraw = " + centerLon);
            }
        }
        this.colorScale.resetHist();
        IndexIterator iiter = array.getData().getIndexIterator();
        while (iiter.hasNext()) {
            double val = iiter.getDoubleNext();
            this.colorScale.getIndexFromValue(val);
        }
        int modeColor = this.colorScale.getHistMax();
        if (this.sameProjection) {
            double xmin = Math.min(xaxis.getCoordEdge1(0), xaxis.getCoordEdgeLast());
            double xmax = Math.max(xaxis.getCoordEdge1(0), xaxis.getCoordEdgeLast());
            double ymin = Math.min(yaxis.getCoordEdge1(0), yaxis.getCoordEdgeLast());
            double ymax = Math.max(yaxis.getCoordEdge1(0), yaxis.getCoordEdgeLast());
            count += this.drawRect(g, modeColor, xmin, ymin, xmax, ymax, this.drawProjection.isLatLon());
        } else if (this.useModeForProjections) {
            this.drawPathShape(g, modeColor, xaxis, yaxis);
        }
        this.debugPts = Debug.isSet((String)"GridRenderer/showPts");
        Index imaH = data.getIndex();
        for (int y = 0; y < ny; ++y) {
            double ybeg = yaxis.getCoordEdge1(y);
            double yend = yaxis.getCoordEdge2(y);
            int lastColor = 0;
            int run = 0;
            int xbeg = 0;
            for (int x = 0; x < nx; ++x) {
                double val = data.getDouble(imaH.set(y, x));
                int thisColor = this.colorScale.getIndexFromValue(val);
                if (run == 0 || lastColor == thisColor) {
                    ++run;
                } else {
                    if (this.sameProjection) {
                        if (lastColor != modeColor) {
                            count += this.drawRect(g, lastColor, xaxis.getCoordEdge1(xbeg), ybeg, xaxis.getCoordEdge2(x), yend, this.drawProjection.isLatLon());
                        }
                    } else if (!this.useModeForProjections || lastColor != modeColor) {
                        count += this.drawPathRun(g, lastColor, ybeg, yend, xaxis, xbeg, x - 1, this.debugPts);
                    }
                    xbeg = x;
                }
                lastColor = thisColor;
            }
            if (this.sameProjection) {
                if (lastColor == modeColor) continue;
                count += this.drawRect(g, lastColor, xaxis.getCoordEdge1(xbeg), ybeg, xaxis.getCoordEdgeLast(), yend, this.drawProjection.isLatLon());
                continue;
            }
            if (this.useModeForProjections && lastColor == modeColor) continue;
            count += this.drawPathRun(g, lastColor, ybeg, yend, xaxis, xbeg, nx - 1, false);
        }
    }

    private int drawRectLatLon(Graphics2D g, int color, double lon1, double lat1, double lon2, double lat2) {
        g.setColor(this.colorScale.getColor(color));
        int count = 0;
        ProjectionRect[] rects = this.projectll.latLonToProjRect(lat1, lon1, lat2, lon2);
        for (int i = 0; i < 2; ++i) {
            if (null == rects[i]) continue;
            ProjectionRect r2 = rects[i];
            Rectangle2D.Double r = new Rectangle2D.Double(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
            g.fill(r);
            ++count;
        }
        return count;
    }

    private int drawRect(Graphics2D g, int color, double w1, double h1, double w2, double h2, boolean useLatlon) {
        if (useLatlon) {
            return this.drawRectLatLon(g, color, w1, h1, w2, h2);
        }
        g.setColor(this.colorScale.getColor(color));
        double wmin = Math.min(w1, w2);
        double hmin = Math.min(h1, h2);
        double width = Math.abs(w1 - w2);
        double height = Math.abs(h1 - h2);
        this.rect.setRect(wmin, hmin, width, height);
        g.fill(this.rect);
        return 1;
    }

    private int drawPathShape(Graphics2D g, int color, CoverageCoordAxis1D xaxis, CoverageCoordAxis1D yaxis) {
        int count = 0;
        for (int y = 0; y < yaxis.getNcoords() - 1; ++y) {
            double y1 = yaxis.getCoordEdge1(y);
            double y2 = yaxis.getCoordEdge2(y);
            count += this.drawPathRun(g, color, y1, y2, xaxis, 0, xaxis.getNcoords() - 1, false);
        }
        return count;
    }

    private int drawPathRun(Graphics2D g, int color, double y1, double y2, CoverageCoordAxis1D xaxis, int x1, int x2, boolean debugPts) {
        int e;
        int nx = xaxis.getNcoords();
        if (x1 < 0 || x2 < 0 || x2 > nx || x1 > x2) {
            return 0;
        }
        int count = 0;
        this.gpRun.reset();
        LatLonPoint llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge1(x1), y1);
        ProjectionPoint pt = this.drawProjection.latLonToProj(llp);
        if (debugPts) {
            System.out.printf("** moveTo = x1=%d (%f, %f)%n", x1, pt.getX(), pt.getY());
        }
        this.gpRun.moveTo((float)pt.getX(), (float)pt.getY());
        ProjectionPointImpl ptP1 = new ProjectionPointImpl();
        ptP1.setLocation(pt);
        for (e = x1; e <= x2; ++e) {
            llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge2(e), y1);
            pt = this.drawProjection.latLonToProj(llp);
            if (debugPts) {
                System.out.printf("%d x2=%d lineTo = (%f, %f)%n", count++, e, pt.getX(), pt.getY());
            }
            this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
            ptP1.setLocation(pt);
        }
        for (e = x2; e >= x1; --e) {
            llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge2(e), y2);
            pt = this.drawProjection.latLonToProj(llp);
            if (debugPts) {
                System.out.printf("%d x2=%d lineTo = (%f, %f)%n", count++, e, pt.getX(), pt.getY());
            }
            this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
            ptP1.setLocation(pt);
        }
        llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge1(x1), y2);
        pt = this.drawProjection.latLonToProj(llp);
        if (debugPts) {
            System.out.printf("%d (%d,y2) lineTo = [%f, %f]%n", count, x1, pt.getX(), pt.getY());
        }
        this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
        g.setColor(this.colorScale.getColor(color));
        try {
            g.fill(this.gpRun);
        }
        catch (Throwable e2) {
            System.out.println("Exception in drawPathRun = " + e2);
            return 0;
        }
        return 1;
    }
}

