/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.grib.grib2.table.Grib2TablesId;
import ucar.nc2.grib.grib2.table.WmoParamTable;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class Grib2TableViewer2
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable gribTable;
    private BeanTable entryTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private Grib2Tables current;

    public Grib2TableViewer2(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.gribTable = new BeanTable(TableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.gribTable.addListSelectionListener(e -> {
            TableBean csb = (TableBean)this.gribTable.getSelectedBean();
            this.setEntries(csb.table);
        });
        PopupMenu tablePopup = new PopupMenu((JComponent)this.gribTable.getJTable(), "Options");
        tablePopup.addAction("Select and compare two tables", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2TableViewer2.this.gribTable.getSelectedBeans();
                if (list.size() == 2) {
                    TableBean bean1 = (TableBean)list.get(0);
                    TableBean bean2 = (TableBean)list.get(1);
                    Grib2TableViewer2.this.compareTables(bean1.table, bean2.table);
                }
            }
        });
        tablePopup.addAction("Compare with WMO", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2TableViewer2.this.lookForProblems(Grib2TableViewer2.this.current);
            }
        });
        tablePopup.addAction("Show low-level details", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2TableViewer2.this.showDetails(Grib2TableViewer2.this.current);
            }
        });
        this.entryTable = new BeanTable(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        PopupMenu entryPopup = new PopupMenu((JComponent)this.entryTable.getJTable(), "Options");
        entryPopup.addAction("Show low-level details for selected enties", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2TableViewer2.this.showEntryDetails(Grib2TableViewer2.this.current, Grib2TableViewer2.this.entryTable.getSelectedBeans());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, (Component)this.gribTable, (Component)this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        try {
            ImmutableList tables = Grib2Tables.getAllRegisteredTables();
            ArrayList<TableBean> beans = new ArrayList<TableBean>();
            for (Grib2Tables t : tables) {
                beans.add(new TableBean(t));
            }
            this.gribTable.setBeans(beans);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void save() {
        this.gribTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    private void setEntries(Grib2Tables gt) {
        ImmutableList params = gt.getParameters();
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(params.size());
        for (GribTables.Parameter p : params) {
            beans.add(new EntryBean(p));
        }
        this.entryTable.setBeans(beans);
        this.current = gt;
    }

    private void lookForProblems(Grib2Tables cust) {
        int total = 0;
        int probs = 0;
        Formatter f = new Formatter();
        cust.lookForProblems(f);
        f.format("PROBLEMS with units%n", new Object[0]);
        for (Object t : this.entryTable.getBeans()) {
            GribTables.Parameter p = ((EntryBean)t).param;
            if (p.getUnit() == null || p.getUnit().length() == 0) continue;
            try {
                SimpleUnit su = SimpleUnit.factoryWithExceptions((String)p.getUnit());
                if (su.isUnknownUnit()) {
                    f.format("%s '%s' has UNKNOWN udunit%n", p.getId(), p.getUnit());
                    ++probs;
                }
            }
            catch (Exception ioe) {
                f.format("%s '%s' FAILS on udunit parse%n", p.getId(), p.getUnit());
                ++probs;
            }
            ++total;
        }
        f.format("%nUNITS: Total=%d problems=%d%n%n", total, probs);
        int local = 0;
        int extra = 0;
        int nameDiffers = 0;
        int caseDiffers = 0;
        int unitsDiffer = 0;
        f.format("Conflicts with WMO%n", new Object[0]);
        for (Object t : this.entryTable.getBeans()) {
            boolean caseDiffer;
            GribTables.Parameter p = ((EntryBean)t).param;
            if (Grib2Tables.isLocal((GribTables.Parameter)p)) {
                ++local;
                continue;
            }
            if (p.getNumber() < 0) continue;
            GribTables.Parameter wmo = WmoParamTable.getParameter((int)p.getDiscipline(), (int)p.getCategory(), (int)p.getNumber());
            if (wmo == null) {
                ++extra;
                f.format(" NEW %s%n", p);
                continue;
            }
            if (p.getName().equals(wmo.getName()) && p.getUnit().equals(wmo.getUnit())) continue;
            boolean nameDiffer = !p.getName().equals(wmo.getName());
            boolean bl = caseDiffer = nameDiffer && p.getName().equalsIgnoreCase(wmo.getName());
            if (nameDiffer) {
                ++nameDiffers;
            }
            if (caseDiffer) {
                ++caseDiffers;
            }
            if (!p.getUnit().equals(wmo.getUnit())) {
                ++unitsDiffer;
            }
            f.format("this=%10s %40s %15s%n", p.getId(), p.getName(), p.getUnit());
            f.format(" wmo=%10s %40s %15s%n%n", wmo.getId(), wmo.getName(), wmo.getUnit());
        }
        f.format("%nWMO differences: nameDiffers=%d caseDiffers=%d, unitsDiffer=%d, extra=%d local=%d%n%n", nameDiffers, caseDiffers, unitsDiffer, extra, local);
        this.infoTA.setText(f.toString());
        this.infoWindow.show();
    }

    private void compareTables(Grib2Tables t1, Grib2Tables t2) {
        GribTables.Parameter p2;
        Formatter f = new Formatter();
        f.format("Table 1 = %s (%s)%n", t1.getName(), t1.getParamTablePathUsedFor(0, 192, 192));
        f.format("Table 2 = %s (%s)%n", t2.getName(), t2.getParamTablePathUsedFor(0, 192, 192));
        int conflict = 0;
        f.format("Table 1 : %n", new Object[0]);
        for (Object t : t1.getParameters()) {
            GribTables.Parameter p1 = (GribTables.Parameter)t;
            p2 = t2.getParameterRaw(p1.getDiscipline(), p1.getCategory(), p1.getNumber());
            if (p1.getName() == null || p1.getUnit() == null) {
                f.format(" Missing name or unit in table 1 param=%s%n", p1);
                continue;
            }
            if (p2 == null || p1.getName().equals(p2.getName()) && p1.getUnit().equals(p2.getUnit()) && (p1.getAbbrev() == null || p1.getAbbrev().equals(p2.getAbbrev()))) continue;
            f.format("  t1=%10s %40s %15s  %15s %s%n", p1.getId(), p1.getName(), p1.getUnit(), p1.getAbbrev(), p1.getDescription());
            f.format("  t2=%10s %40s %15s  %15s %s%n%n", p2.getId(), p2.getName(), p2.getUnit(), p2.getAbbrev(), p2.getDescription());
            ++conflict;
        }
        f.format("%nConflicts=%d%n%n", conflict);
        int extra = 0;
        for (Object t : t1.getParameters()) {
            GribTables.Parameter p1 = (GribTables.Parameter)t;
            GribTables.Parameter p22 = t2.getParameterRaw(p1.getDiscipline(), p1.getCategory(), p1.getNumber());
            if (p22 != null) continue;
            ++extra;
            f.format(" Missing %s in table 2%n", p1);
        }
        f.format("%nextra=%d%n%n", extra);
        extra = 0;
        f.format("Table 2 has the following not in Table 1:%n", new Object[0]);
        for (Object t : t2.getParameters()) {
            p2 = (GribTables.Parameter)t;
            GribTables.Parameter p1 = t1.getParameterRaw(p2.getDiscipline(), p2.getCategory(), p2.getNumber());
            if (p1 != null) continue;
            ++extra;
            f.format(" %s%n", p2);
        }
        f.format("%ntotal extra=%d%n%n", extra);
        this.infoTA.setText(f.toString());
        this.infoWindow.show();
    }

    private void showDetails(Grib2Tables grib2Table) {
        Formatter f = new Formatter();
        grib2Table.showDetails(f);
        this.infoTA.setText(f.toString());
        this.infoWindow.show();
    }

    private void showEntryDetails(Grib2Tables grib2Table, List entries) {
        boolean total = false;
        boolean probs = false;
        Formatter f = new Formatter();
        ArrayList<GribTables.Parameter> params = new ArrayList<GribTables.Parameter>();
        for (Object bean : entries) {
            params.add(((EntryBean)bean).param);
        }
        grib2Table.showEntryDetails(f, params);
        this.infoTA.setText(f.toString());
        this.infoWindow.show();
    }

    public class EntryBean {
        GribTables.Parameter param;

        public EntryBean() {
        }

        public EntryBean(GribTables.Parameter param) {
            this.param = param;
        }

        public String getName() {
            return this.param.getName();
        }

        public String getId() {
            return this.param.getId();
        }

        public int getKey() {
            return Grib2Tables.makeParamId((int)this.param.getDiscipline(), (int)this.param.getCategory(), (int)this.param.getNumber());
        }

        public String getUnit() {
            return this.param.getUnit();
        }

        public String getAbbrev() {
            return this.param.getAbbrev();
        }

        public String getDesc() {
            return this.param.getDescription();
        }
    }

    public class TableBean
    implements Comparable<TableBean> {
        Grib2Tables table;
        Grib2TablesId id;

        public TableBean() {
        }

        public TableBean(Grib2Tables table) {
            this.table = table;
            this.id = table.getConfigId();
        }

        public String getName() {
            return this.table.getName();
        }

        public String getWmoName() {
            return CommonCodeTable.getCenterName((int)this.id.center, (int)11);
        }

        public int getCenter() {
            return this.id.center;
        }

        public int getSubcenter() {
            return this.id.subCenter;
        }

        public int getMasterVersion() {
            return this.id.masterVersion;
        }

        public int getLocalVersion() {
            return this.id.localVersion;
        }

        public int getGenProcessId() {
            return this.id.genProcessId;
        }

        public String getPath() {
            return this.table.getPath();
        }

        public String getType() {
            return this.table.getType().toString();
        }

        @Override
        public int compareTo(TableBean o) {
            int ret = this.getCenter() - o.getCenter();
            if (ret == 0) {
                ret = this.getSubcenter() - o.getSubcenter();
            }
            if (ret == 0) {
                ret = this.getMasterVersion() - o.getMasterVersion();
            }
            return ret;
        }
    }
}

