/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.grib.grib2.table.WmoCodeFlagTables;
import ucar.nc2.units.SimpleUnit;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class GribWmoCodesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable wmoTable;
    private BeanTable entryTable;
    private JSplitPane split;
    private TextHistoryPane compareTA;
    private IndependentWindow infoWindow;
    private WmoCodeFlagTables.Version currTable = null;

    public GribWmoCodesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.wmoTable = new BeanTable(CodeTableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.wmoTable.addListSelectionListener(e -> {
            CodeTableBean csb = (CodeTableBean)this.wmoTable.getSelectedBean();
            this.setEntries(csb.wmoTable);
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.wmoTable.getJTable(), "Options");
        varPopup.addAction("Show table", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                CodeTableBean csb = (CodeTableBean)GribWmoCodesPanel.this.wmoTable.getSelectedBean();
                csb.showTable(out);
                GribWmoCodesPanel.this.compareTA.setText(out.toString());
                GribWmoCodesPanel.this.compareTA.gotoTop();
                GribWmoCodesPanel.this.infoWindow.setVisible(true);
            }
        });
        this.entryTable = new BeanTable(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        AbstractButton dupButton = BAMutil.makeButtcon((String)"Select", (String)"Look for problems in this table", (boolean)false);
        dupButton.addActionListener(e -> this.lookForProblems());
        buttPanel.add(dupButton);
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, (Component)this.wmoTable, (Component)this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        this.setTable(WmoCodeFlagTables.standard);
    }

    public void setTable(WmoCodeFlagTables.Version v) {
        try {
            ArrayList<CodeTableBean> dds = new ArrayList<CodeTableBean>();
            for (WmoCodeFlagTables.WmoTable wmoTable : WmoCodeFlagTables.getInstance().getWmoTables()) {
                dds.add(new CodeTableBean(wmoTable));
            }
            this.wmoTable.setBeans(dds);
            this.currTable = v;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.wmoTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setEntries(WmoCodeFlagTables.WmoTable wmoTable) {
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>();
        for (WmoCodeFlagTables.WmoTable.WmoEntry d : wmoTable.getEntries()) {
            beans.add(new EntryBean(d));
        }
        this.entryTable.setBeans(beans);
    }

    private void lookForProblems() {
        int total = 0;
        int dups = 0;
        HashMap<String, WmoCodeFlagTables.WmoTable.WmoEntry> paramSet = new HashMap<String, WmoCodeFlagTables.WmoTable.WmoEntry>();
        try (Formatter f = new Formatter();){
            WmoCodeFlagTables.WmoTable gt;
            f.format("WMO parameter table %s%n", this.currTable);
            f.format("%nDuplicates Names%n", new Object[0]);
            for (Object t : this.wmoTable.getBeans()) {
                gt = ((CodeTableBean)t).wmoTable;
                if (gt.getType() != WmoCodeFlagTables.TableType.param) continue;
                for (WmoCodeFlagTables.WmoTable.WmoEntry p : gt.getEntries()) {
                    if (p.getMeaning().equalsIgnoreCase("Reserved") || p.getMeaning().equalsIgnoreCase("Missing") || p.getStart() != p.getStop()) continue;
                    WmoCodeFlagTables.WmoTable.WmoEntry pdup = (WmoCodeFlagTables.WmoTable.WmoEntry)paramSet.get(p.getName());
                    if (pdup != null) {
                        f.format("Duplicate %s%n", p);
                        f.format("          %s%n%n", pdup);
                        ++dups;
                    } else {
                        paramSet.put(p.getName(), p);
                    }
                    ++total;
                }
            }
            f.format("%nTotal=%d dups=%d%n%n", total, dups);
            total = 0;
            dups = 0;
            f.format("Names with parenthesis%n", new Object[0]);
            for (Object t : this.wmoTable.getBeans()) {
                gt = ((CodeTableBean)t).wmoTable;
                if (gt.getType() != WmoCodeFlagTables.TableType.param) continue;
                for (WmoCodeFlagTables.WmoTable.WmoEntry p : gt.getEntries()) {
                    if (p.getMeaning().indexOf(40) > 0) {
                        f.format("  %s:%n  org='%s'%n name='%s' %n%n", p.getId(), p.getMeaning(), p.getName());
                        ++dups;
                    }
                    ++total;
                }
            }
            f.format("%nTotal=%d parens=%d%n%n", total, dups);
            total = 0;
            dups = 0;
            f.format("non-udunits%n", new Object[0]);
            for (Object t : this.wmoTable.getBeans()) {
                gt = ((CodeTableBean)t).wmoTable;
                if (gt.getType() != WmoCodeFlagTables.TableType.param) continue;
                for (WmoCodeFlagTables.WmoTable.WmoEntry p : gt.getEntries()) {
                    if (p.getUnit() == null || p.getUnit().length() == 0) continue;
                    try {
                        SimpleUnit su = SimpleUnit.factoryWithExceptions((String)p.getUnit());
                        if (su.isUnknownUnit()) {
                            f.format("%s %s has UNKNOWN udunit%n", p.getId(), p.getUnit());
                            ++dups;
                        }
                    }
                    catch (Exception ioe) {
                        f.format("%s %s FAILS on udunit parse%n", p.getId(), p.getUnit());
                        ++dups;
                    }
                    ++total;
                }
            }
            f.format("%nTotal=%d problems=%d%n%n", total, dups);
            this.compareTA.setText(f.toString());
        }
        this.infoWindow.show();
    }

    public class EntryBean {
        WmoCodeFlagTables.WmoTable.WmoEntry entry;

        public EntryBean() {
        }

        public EntryBean(WmoCodeFlagTables.WmoTable.WmoEntry entry) {
            this.entry = entry;
        }

        public int getNumber() {
            return this.entry.getNumber();
        }

        public String getName() {
            return this.entry.getName();
        }

        public String getUnit() {
            return this.entry.getUnit();
        }

        public String getUdunit() {
            if (this.entry.getUnit() == null) {
                return "";
            }
            if (this.entry.getUnit().length() == 0) {
                return "";
            }
            try {
                SimpleUnit su = SimpleUnit.factoryWithExceptions((String)this.entry.getUnit());
                if (su.isUnknownUnit()) {
                    return "UNKNOWN";
                }
                return su.toString();
            }
            catch (Exception ioe) {
                return "FAIL";
            }
        }

        public String getStatus() {
            return this.entry.getStatus();
        }

        public int getLine() {
            return this.entry.getLine();
        }

        public int getValue() {
            return this.entry.getValue();
        }
    }

    public class CodeTableBean {
        WmoCodeFlagTables.WmoTable wmoTable;

        public CodeTableBean() {
        }

        public CodeTableBean(WmoCodeFlagTables.WmoTable wmoTable) {
            this.wmoTable = wmoTable;
        }

        public String getTitle() {
            return this.wmoTable.getName();
        }

        public String getTableNo() {
            return this.wmoTable.getId();
        }

        public String getType() {
            return this.wmoTable.getType().name();
        }

        void showTable(Formatter f) {
            f.format("Code Table %s (%s)%n", this.wmoTable.getName(), this.wmoTable.getId());
            for (WmoCodeFlagTables.WmoTable.WmoEntry entry : this.wmoTable.getEntries()) {
                f.format("  %3d: %s%n", entry.getNumber(), entry.getName());
            }
        }
    }
}

