/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.IsMissingEvaluator;
import ucar.ma2.MAMath;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ui.grid.ColorScale;
import ucar.nc2.ui.grid.ContourFeatureRenderer;
import ucar.nc2.ui.grid.ContourGrid;
import ucar.ui.prefs.Debug;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Format;

public class GridRenderer {
    private boolean drawGrid = true;
    private boolean drawGridLines = true;
    private boolean drawContours = false;
    private boolean drawContourLabels = false;
    private boolean isNewField = true;
    private ColorScale cs = null;
    private ColorScale.MinMaxType dataMinMaxType = ColorScale.MinMaxType.horiz;
    private ProjectionImpl drawProjection = null;
    private ProjectionImpl dataProjection = null;
    private GridDatatype orgGrid = null;
    private GridDatatype stridedGrid = null;
    private Array dataH;
    private Array dataV;
    private int wantLevel = -1;
    private int wantSlice = -1;
    private int wantTime = -1;
    private int horizStride = 1;
    private int wantRunTime = -1;
    private int wantEnsemble = -1;
    private int lastLevel = -1;
    private int lastTime = -1;
    private int lastSlice = -1;
    private int lastStride = -1;
    private int lastRunTime = -1;
    private int lastEnsemble = -1;
    private GridDatatype lastGrid = null;
    private boolean useModeForProjections = false;
    private boolean sameProjection = false;
    private LatLonProjection projectll;
    private ProjectionPointImpl ptP1 = new ProjectionPointImpl();
    private static final boolean debugHorizDraw = false;
    private static final boolean debugSeam = false;
    private static final boolean debugLatLon = false;
    private static final boolean debugMiss = false;
    private static boolean debugPathShape = false;
    private static boolean debugArrayShape = false;
    private static boolean debugPts = false;
    private int[] valueIndex = new int[2];
    private Rectangle2D rect = new Rectangle2D.Double();
    private GeneralPath gpRun = new GeneralPath(0, 25);

    public ColorScale getColorScale() {
        return this.cs;
    }

    public void setColorScale(ColorScale cs) {
        this.cs = cs;
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        if (type != this.dataMinMaxType) {
            this.dataMinMaxType = type;
        }
    }

    public GridDatatype getGeoGrid() {
        return this.orgGrid;
    }

    public void clear() {
        this.orgGrid = null;
        this.lastGrid = null;
        this.stridedGrid = null;
    }

    public void setGeoGrid(GridDatatype grid) {
        this.orgGrid = grid;
        this.lastGrid = null;
        this.dataProjection = grid.getProjection();
        this.makeStridedGrid();
        this.isNewField = true;
    }

    public Array getCurrentHorizDataSlice() {
        return this.dataH;
    }

    public ProjectionImpl getDataProjection() {
        return this.dataProjection;
    }

    public ProjectionImpl getProjection() {
        return this.drawProjection;
    }

    public void setProjection(ProjectionImpl project) {
        this.drawProjection = project;
    }

    public boolean getDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGridLines(boolean drawGrid) {
        this.drawGridLines = drawGrid;
    }

    public boolean getDrawContours() {
        return this.drawContours;
    }

    public void setDrawContours(boolean drawContours) {
        this.drawContours = drawContours;
    }

    public boolean getDrawContourLabels() {
        return this.drawContourLabels;
    }

    public void setDrawContourLabels(boolean drawContourLabels) {
        this.drawContourLabels = drawContourLabels;
    }

    public int getLevel() {
        return this.wantLevel;
    }

    public void setLevel(int level) {
        this.wantLevel = level;
    }

    public int getTime() {
        return this.wantTime;
    }

    public void setTime(int time) {
        this.wantTime = time;
    }

    public int getRunTime() {
        return this.wantRunTime;
    }

    public void setRunTime(int runtime) {
        this.wantRunTime = runtime;
    }

    public int getEnsemble() {
        return this.wantEnsemble;
    }

    public void setEnsemble(int ensemble) {
        this.wantEnsemble = ensemble;
    }

    public int getSlice() {
        return this.wantSlice;
    }

    public void setSlice(int slice) {
        this.wantSlice = slice;
    }

    public int getHorizStride() {
        return this.horizStride;
    }

    public void setHorizStride(int horizStride) {
        this.horizStride = horizStride;
    }

    public void makeStridedGrid() {
        if (this.horizStride > 1) {
            try {
                this.stridedGrid = this.orgGrid.makeSubset(null, null, null, 1, this.horizStride, this.horizStride);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        } else {
            this.stridedGrid = this.orgGrid;
        }
    }

    public int findLevelCoordElement(double pos) {
        if (null == this.orgGrid) {
            return -1;
        }
        GridCoordSystem geocs = this.orgGrid.getCoordinateSystem();
        CoordinateAxis1D zaxis = geocs.getVerticalAxis();
        return zaxis == null ? -1 : zaxis.findCoordElement(pos);
    }

    public int findSliceFromPoint(ProjectionPoint pp) {
        GridCoordSystem geocs;
        CoordinateAxis xaxis;
        if (null == this.drawProjection || null == this.stridedGrid) {
            return -1;
        }
        if (!this.sameProjection) {
            LatLonPoint llpt = this.drawProjection.projToLatLon(pp);
            pp = this.dataProjection.latLonToProj(llpt);
        }
        if (!((xaxis = (geocs = this.stridedGrid.getCoordinateSystem()).getXHorizAxis()) instanceof CoordinateAxis1D)) {
            return -1;
        }
        int[] index = geocs.findXYindexFromCoord(pp.getX(), pp.getY(), null);
        return index[0];
    }

    public String getXYvalueStr(ProjectionPoint loc) {
        if (this.stridedGrid == null || this.dataH == null) {
            return "";
        }
        if (!this.sameProjection) {
            LatLonPoint llpt = this.drawProjection.projToLatLon(loc);
            loc = this.dataProjection.latLonToProj(llpt);
        }
        GridCoordSystem geocs = this.stridedGrid.getCoordinateSystem();
        this.valueIndex = geocs.findXYindexFromCoord(loc.getX(), loc.getY(), this.valueIndex);
        int wantx = this.valueIndex[0];
        int wanty = this.valueIndex[1];
        if (wantx == -1 || wanty == -1) {
            return "outside grid area";
        }
        try {
            Index imaH = this.dataH.getIndex();
            double value = this.dataH.getDouble(imaH.set(wanty, wantx));
            int wantz = geocs.getVerticalAxis() == null ? -1 : this.lastLevel;
            return this.makeXYZvalueStr(value, wantx, wanty, wantz);
        }
        catch (Exception e) {
            return "error " + wantx + " " + wanty;
        }
    }

    public String getYZpositionStr(Point2D loc) {
        if (this.stridedGrid == null || this.dataV == null) {
            return "";
        }
        GridCoordSystem geocs = this.stridedGrid.getCoordinateSystem();
        StringBuilder sbuff = new StringBuilder();
        sbuff.setLength(0);
        sbuff.append(Format.d((double)loc.getX(), (int)3));
        CoordinateAxis yaxis = geocs.getYHorizAxis();
        sbuff.append(" ").append(yaxis.getUnitsString());
        sbuff.append(" ");
        sbuff.append(Format.d((double)loc.getY(), (int)3));
        CoordinateAxis1D zaxis = geocs.getVerticalAxis();
        sbuff.append(" ").append(zaxis.getUnitsString());
        return sbuff.toString();
    }

    public String getYZvalueStr(Point2D loc) {
        if (this.stridedGrid == null || this.dataV == null) {
            return "";
        }
        GridCoordSystem geocs = this.stridedGrid.getCoordinateSystem();
        CoordinateAxis1D zaxis = geocs.getVerticalAxis();
        if (zaxis == null) {
            return "";
        }
        this.valueIndex = geocs.findXYindexFromCoord(loc.getX(), (double)this.lastSlice, this.valueIndex);
        int wanty = this.valueIndex[1];
        int wantz = zaxis.findCoordElement(loc.getY());
        if (wanty == -1 || wantz == -1) {
            return "outside grid area";
        }
        Index imaV = this.dataV.getIndex();
        double value = this.dataV.getDouble(imaV.set(wantz, wanty));
        int wantx = geocs.getXHorizAxis() == null ? -1 : this.lastSlice;
        return this.makeXYZvalueStr(value, wantx, wanty, wantz);
    }

    private String makeXYZvalueStr(double value, int wantx, int wanty, int wantz) {
        if (this.stridedGrid.isMissingData(value)) {
            if (Debug.isSet((String)"pick/showGridIndexes")) {
                return "missing data @ (" + wantx + "," + wanty + ")";
            }
            return "missing data";
        }
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(Format.d((double)value, (int)6));
        sbuff.append(" ").append(this.stridedGrid.getUnitsString());
        GridCoordSystem geocs = this.stridedGrid.getCoordinateSystem();
        if (!(geocs.getXHorizAxis() instanceof CoordinateAxis1D) || !(geocs.getXHorizAxis() instanceof CoordinateAxis1D)) {
            if (Debug.isSet((String)"pick/showGridIndexes")) {
                sbuff.append("@ (").append(wantx).append(",").append(wanty).append(")");
            }
            return sbuff.toString();
        }
        CoordinateAxis1D xaxis = (CoordinateAxis1D)geocs.getXHorizAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)geocs.getYHorizAxis();
        CoordinateAxis1D zaxis = geocs.getVerticalAxis();
        sbuff.append(" @ ");
        if (wantx >= 0 && wanty >= 0) {
            Object lpt = this.dataProjection.isLatLon() ? new LatLonPointImpl(yaxis.getCoordValue(wanty), xaxis.getCoordValue(wantx)) : this.dataProjection.projToLatLon(xaxis.getCoordValue(wantx), yaxis.getCoordValue(wanty));
            sbuff.append(lpt.toString());
            if (Debug.isSet((String)"pick/showDataProjectionCoords")) {
                sbuff.append("(").append(Format.d((double)xaxis.getCoordValue(wantx), (int)3));
                sbuff.append(" ").append(Format.d((double)yaxis.getCoordValue(wanty), (int)3));
                sbuff.append(" ").append(xaxis.getUnitsString()).append(")");
            }
            if (Debug.isSet((String)"pick/showDisplayProjectionCoords")) {
                ProjectionPoint pt = this.drawProjection.latLonToProj((LatLonPoint)lpt);
                sbuff.append("(").append(Format.d((double)pt.getX(), (int)3));
                sbuff.append(" ").append(Format.d((double)pt.getY(), (int)3)).append(")");
            }
            if (Debug.isSet((String)"pick/showGridIndexes")) {
                sbuff.append("(").append(wantx).append(",").append(wanty).append(")");
            }
        } else if (wantx >= 0) {
            if (this.dataProjection.isLatLon()) {
                sbuff.append(LatLonPointImpl.latToString((double)xaxis.getCoordValue(wantx), (int)3));
            } else {
                sbuff.append(" ").append(Format.d((double)xaxis.getCoordValue(wantx), (int)3));
                sbuff.append(" ").append(xaxis.getUnitsString());
            }
        } else if (wanty >= 0) {
            if (this.dataProjection.isLatLon()) {
                sbuff.append(LatLonPointImpl.latToString((double)yaxis.getCoordValue(wanty), (int)3));
            } else {
                sbuff.append(" ").append(Format.d((double)yaxis.getCoordValue(wanty), (int)3));
                sbuff.append(" ").append(yaxis.getUnitsString());
            }
        }
        if (wantz >= 0) {
            sbuff.append(" ").append(Format.d((double)zaxis.getCoordValue(wantz), (int)3));
            sbuff.append(" ").append(zaxis.getUnitsString());
        }
        return sbuff.toString();
    }

    private Array makeHSlice(GridDatatype useG, int level, int time, int ensemble, int runtime) throws IOException {
        GridCoordSystem gcs = useG.getCoordinateSystem();
        CoordinateAxis xaxis = gcs.getXHorizAxis();
        CoordinateAxis yaxis = gcs.getYHorizAxis();
        if (xaxis == null || yaxis == null) {
            return null;
        }
        if (xaxis.getSize() <= 1L || yaxis.getSize() <= 1L) {
            return null;
        }
        if (useG.equals(this.lastGrid) && time == this.lastTime && level == this.lastLevel && this.horizStride == this.lastStride && ensemble == this.lastEnsemble && runtime == this.lastRunTime) {
            return this.dataH;
        }
        this.dataH = useG.readDataSlice(runtime, ensemble, time, level, -1, -1);
        this.lastGrid = useG;
        this.lastTime = time;
        this.lastLevel = level;
        this.lastEnsemble = ensemble;
        this.lastRunTime = runtime;
        this.lastStride = this.horizStride;
        if (debugArrayShape) {
            System.out.println("Horiz shape = ");
            for (int i = 0; i < this.dataH.getRank(); ++i) {
                System.out.println("   shape = " + this.dataH.getShape()[i]);
            }
        }
        return this.dataH;
    }

    private Array makeVSlice(GridDatatype g, int vSlice, int time, int ensemble, int runtime) {
        GridCoordSystem gcs = g.getCoordinateSystem();
        CoordinateAxis xaxis = gcs.getXHorizAxis();
        CoordinateAxis1D zaxis = gcs.getVerticalAxis();
        if (xaxis == null || zaxis == null) {
            return null;
        }
        if (xaxis.getSize() <= 1L || zaxis.getSize() <= 1L) {
            return null;
        }
        if (g.equals(this.lastGrid) && time == this.lastTime && vSlice == this.lastSlice && ensemble == this.lastEnsemble && runtime == this.lastRunTime) {
            return this.dataV;
        }
        try {
            this.dataV = g.readDataSlice(runtime, ensemble, time, -1, -1, vSlice);
        }
        catch (IOException e) {
            System.out.println("GridRender.makeHSlice Error reading netcdf file= " + e);
            return null;
        }
        this.lastGrid = g;
        this.lastTime = time;
        this.lastSlice = vSlice;
        this.lastEnsemble = ensemble;
        this.lastRunTime = runtime;
        if (debugArrayShape) {
            System.out.println("Vert shape = ");
            for (int i = 0; i < this.dataV.getRank(); ++i) {
                System.out.println("   shape = " + this.dataV.getShape()[i]);
            }
        }
        return this.dataV;
    }

    private void setColorScaleParams() throws IOException {
        if (this.dataMinMaxType == ColorScale.MinMaxType.hold && !this.isNewField) {
            return;
        }
        this.isNewField = false;
        Array dataArr = this.makeHSlice(this.stridedGrid, this.wantLevel, this.wantTime, this.wantEnsemble, this.wantRunTime);
        if (dataArr != null) {
            MAMath.MinMax minmax = this.stridedGrid.hasMissingData() ? this.stridedGrid.getMinMaxSkipMissingData(dataArr) : MAMath.getMinMax((Array)dataArr);
            this.cs.setMinMax(minmax.min, minmax.max);
            this.cs.setGeoGrid((IsMissingEvaluator)this.stridedGrid);
        }
    }

    public void renderVertView(Graphics2D g, AffineTransform dFromN) {
        if (this.stridedGrid == null || this.cs == null || this.drawProjection == null) {
            return;
        }
        if (!this.drawGrid && !this.drawContours) {
            return;
        }
        this.dataV = this.makeVSlice(this.stridedGrid, this.wantSlice, this.wantTime, this.wantEnsemble, this.wantRunTime);
        if (this.dataV == null) {
            return;
        }
        if (Debug.isSet((String)"GridRenderer/vert")) {
            System.out.println("GridRenderer/vert: redraw grid");
        }
        GridCoordSystem geocs = this.stridedGrid.getCoordinateSystem();
        CoordinateAxis1D zaxis = geocs.getVerticalAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)geocs.getYHorizAxis();
        if (yaxis == null || zaxis == null) {
            return;
        }
        int nz = (int)zaxis.getSize();
        int ny = (int)yaxis.getSize();
        if (this.drawGrid) {
            int count = 0;
            Index imaV = this.dataV.getIndex();
            for (int z = 0; z < nz; ++z) {
                double zbeg = zaxis.getCoordEdge(z);
                double zend = zaxis.getCoordEdge(z + 1);
                for (int y = 0; y < ny; ++y) {
                    double ybeg = yaxis.getCoordEdge(y);
                    double yend = yaxis.getCoordEdge(y + 1);
                    double val = this.dataV.getDouble(imaV.set(z, y));
                    int thisColor = this.cs.getIndexFromValue(val);
                    count += this.drawRect(g, thisColor, ybeg, zbeg, yend, zend, false);
                }
            }
        }
        if (this.drawContours) {
            double[] zedges = zaxis.getCoordValues();
            double[] yedges = yaxis.getCoordValues();
            int nlevels = this.cs.getNumColors();
            ArrayList<Double> levels = new ArrayList<Double>(nlevels);
            for (int i = 1; i < nlevels - 1; ++i) {
                levels.add(this.cs.getEdge(i));
            }
            long startTime = System.currentTimeMillis();
            try {
                ContourGrid conGrid = new ContourGrid(this.dataV.transpose(0, 1), levels, yedges, zedges, this.stridedGrid);
                ContourFeatureRenderer contourRendererV = new ContourFeatureRenderer(conGrid, null);
                contourRendererV.setColor(Color.black);
                contourRendererV.setShowLabels(this.drawContourLabels);
                contourRendererV.draw(g, dFromN);
            }
            catch (Exception e) {
                System.out.println("draw Contours Vert exception = " + e);
                e.printStackTrace(System.err);
            }
            if (Debug.isSet((String)"timing/contourDraw")) {
                long tookTime = System.currentTimeMillis() - startTime;
                System.out.println("timing/contourDraw: Vert:" + (double)tookTime * 0.001 + " seconds");
            }
        }
        if (this.lastLevel >= 0 && this.lastLevel < nz) {
            this.drawXORline(g, yaxis.getCoordEdge(0), zaxis.getCoordValue(this.lastLevel), yaxis.getCoordEdge(ny), zaxis.getCoordValue(this.lastLevel));
        }
    }

    public void renderPlanView(Graphics2D g, AffineTransform dFromN) throws IOException {
        if (this.stridedGrid == null || this.cs == null || this.drawProjection == null) {
            return;
        }
        if (!this.drawGrid && !this.drawContours) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.dataH = this.makeHSlice(this.stridedGrid, this.wantLevel, this.wantTime, this.wantEnsemble, this.wantRunTime);
        if (this.dataH == null) {
            return;
        }
        this.setColorScaleParams();
        if (this.drawGrid) {
            this.drawGridHoriz(g, this.dataH);
        }
        if (this.drawContours) {
            this.drawContours(g, this.dataH.transpose(0, 1), dFromN);
        }
        if (this.drawGridLines) {
            this.drawGridLines(g);
        }
    }

    private void drawGridHoriz(Graphics2D g, Array data) {
        boolean count = false;
        GridCoordSystem geocs = this.stridedGrid.getCoordinateSystem();
        CoordinateAxis xaxis = geocs.getXHorizAxis();
        CoordinateAxis yaxis = geocs.getYHorizAxis();
        if (xaxis instanceof CoordinateAxis1D && yaxis instanceof CoordinateAxis1D) {
            this.drawGridHoriz1D(g, data, (CoordinateAxis1D)xaxis, (CoordinateAxis1D)yaxis);
            return;
        }
        if ((data = data.reduce()).getRank() != 2) {
            throw new IllegalArgumentException("must be 2D");
        }
        if (!(xaxis instanceof CoordinateAxis2D) || !(yaxis instanceof CoordinateAxis2D)) {
            throw new IllegalArgumentException("must be CoordinateAxis2D");
        }
        CoordinateAxis2D xaxis2D = (CoordinateAxis2D)xaxis;
        CoordinateAxis2D yaxis2D = (CoordinateAxis2D)yaxis;
        String stag = geocs.getHorizStaggerType();
        if (stag != null && stag.equals("Arakawa-E")) {
            this.drawGridHorizRotated(g, data, xaxis2D, yaxis2D);
            return;
        }
        ArrayDouble.D2 edgex = xaxis2D.getEdges();
        ArrayDouble.D2 edgey = yaxis2D.getEdges();
        Index ima = data.getIndex();
        GeneralPath gp = new GeneralPath(0, 5);
        int[] shape = xaxis2D.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                gp.reset();
                gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                gp.lineTo((float)edgex.get(y, x + 1), (float)edgey.get(y, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x + 1), (float)edgey.get(y + 1, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x), (float)edgey.get(y + 1, x));
                double val = data.getDouble(ima.set(y, x));
                int colorIndex = this.cs.getIndexFromValue(val);
                g.setColor(this.cs.getColor(colorIndex));
                g.fill(gp);
            }
        }
    }

    private void drawGridLines(Graphics2D g) {
        boolean count = false;
        GridCoordSystem geocs = this.stridedGrid.getCoordinateSystem();
        CoordinateAxis xaxis = geocs.getXHorizAxis();
        CoordinateAxis yaxis = geocs.getYHorizAxis();
        if (!(xaxis instanceof CoordinateAxis2D) || !(yaxis instanceof CoordinateAxis2D)) {
            return;
        }
        CoordinateAxis2D xaxis2D = (CoordinateAxis2D)xaxis;
        CoordinateAxis2D yaxis2D = (CoordinateAxis2D)yaxis;
        ArrayDouble.D2 edgex = xaxis2D.getEdges();
        ArrayDouble.D2 edgey = yaxis2D.getEdges();
        GeneralPath gp = new GeneralPath(0, 5);
        g.setColor(Color.BLACK);
        int[] shape = xaxis2D.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (int y = 0; y < ny + 1; y += 10) {
            gp.reset();
            for (int x = 0; x < nx + 1; ++x) {
                if (x == 0) {
                    gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                    continue;
                }
                gp.lineTo((float)edgex.get(y, x), (float)edgey.get(y, x));
            }
            g.draw(gp);
        }
        for (int x = 0; x < nx + 1; x += 10) {
            gp.reset();
            for (int y = 0; y < ny + 1; ++y) {
                if (y == 0) {
                    gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                    continue;
                }
                gp.lineTo((float)edgex.get(y, x), (float)edgey.get(y, x));
            }
            g.draw(gp);
        }
    }

    private void drawGridHorizRotated(Graphics2D g, Array data, CoordinateAxis2D xaxis2D, CoordinateAxis2D yaxis2D) {
        int colorIndex;
        double val;
        int x;
        int y;
        ArrayDouble.D2 edgex = CoordinateAxis2D.makeXEdgesRotated((ArrayDouble.D2)xaxis2D.getCoordValuesArray());
        ArrayDouble.D2 edgey = CoordinateAxis2D.makeYEdgesRotated((ArrayDouble.D2)yaxis2D.getCoordValuesArray());
        Index ima = data.getIndex();
        GeneralPath gp = new GeneralPath(0, 5);
        int[] shape = xaxis2D.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (y = 0; y < ny - 1; y += 2) {
            for (x = 0; x < nx - 1; ++x) {
                gp.reset();
                gp.moveTo((float)edgex.get(y, x), (float)edgey.get(y, x));
                gp.lineTo((float)edgex.get(y + 1, x), (float)edgey.get(y + 1, x));
                gp.lineTo((float)edgex.get(y + 2, x), (float)edgey.get(y + 2, x));
                gp.lineTo((float)edgex.get(y + 1, x + 1), (float)edgey.get(y + 1, x + 1));
                val = data.getDouble(ima.set(y, x));
                colorIndex = this.cs.getIndexFromValue(val);
                g.setColor(this.cs.getColor(colorIndex));
                g.fill(gp);
            }
        }
        for (y = 1; y < ny - 1; y += 2) {
            for (x = 0; x < nx - 1; ++x) {
                gp.reset();
                gp.moveTo((float)edgex.get(y, x + 1), (float)edgey.get(y, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x), (float)edgey.get(y + 1, x));
                gp.lineTo((float)edgex.get(y + 2, x + 1), (float)edgey.get(y + 2, x + 1));
                gp.lineTo((float)edgex.get(y + 1, x + 1), (float)edgey.get(y + 1, x + 1));
                val = data.getDouble(ima.set(y, x));
                colorIndex = this.cs.getIndexFromValue(val);
                g.setColor(this.cs.getColor(colorIndex));
                g.fill(gp);
            }
        }
    }

    private void drawGridHoriz1D(Graphics2D g, Array data, CoordinateAxis1D xaxis1D, CoordinateAxis1D yaxis1D) {
        int count = 0;
        int nx = (int)xaxis1D.getSize();
        int ny = (int)yaxis1D.getSize();
        this.sameProjection = this.drawProjection.equals((Object)this.dataProjection);
        if (this.drawProjection.isLatLon()) {
            this.projectll = (LatLonProjection)this.drawProjection;
            double centerLon = this.projectll.getCenterLon();
            if (Debug.isSet((String)"projection/LatLonShift")) {
                System.out.println("projection/LatLonShift: gridDraw = " + centerLon);
            }
        }
        int modeColor = this.cs.getHistMax();
        this.cs.resetHist();
        IndexIterator iiter = data.getIndexIterator();
        while (iiter.hasNext()) {
            double val = iiter.getDoubleNext();
            this.cs.getIndexFromValue(val);
        }
        modeColor = this.cs.getHistMax();
        if (this.sameProjection) {
            count += this.drawRect(g, modeColor, xaxis1D.getCoordEdge(0), yaxis1D.getCoordEdge(0), xaxis1D.getCoordEdge(nx), yaxis1D.getCoordEdge(ny), this.drawProjection.isLatLon());
        } else if (this.useModeForProjections) {
            this.drawPathShape(g, modeColor, xaxis1D, yaxis1D);
        }
        debugPts = Debug.isSet((String)"GridRenderer/showPts");
        Index imaH = this.dataH.getIndex();
        for (int y = 0; y < ny; ++y) {
            double ybeg = yaxis1D.getCoordEdge(y);
            double yend = yaxis1D.getCoordEdge(y + 1);
            int lastColor = 0;
            int run = 0;
            int xbeg = 0;
            debugPts = debugPts && y == 0;
            for (int x = 0; x < nx; ++x) {
                int thisColor;
                try {
                    double val = data.getDouble(imaH.set(y, x));
                    thisColor = this.cs.getIndexFromValue(val);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("bad");
                    throw e;
                }
                if (run == 0 || lastColor == thisColor) {
                    ++run;
                } else {
                    if (this.sameProjection) {
                        if (lastColor != modeColor) {
                            count += this.drawRect(g, lastColor, xaxis1D.getCoordEdge(xbeg), ybeg, xaxis1D.getCoordEdge(x), yend, this.drawProjection.isLatLon());
                        }
                    } else {
                        count += this.drawPathRun(g, lastColor, ybeg, yend, xaxis1D, xbeg, x);
                    }
                    xbeg = x;
                }
                lastColor = thisColor;
            }
            if (this.sameProjection) {
                if (lastColor == modeColor) continue;
                count += this.drawRect(g, lastColor, xaxis1D.getCoordEdge(xbeg), ybeg, xaxis1D.getCoordEdge(nx), yend, this.drawProjection.isLatLon());
                continue;
            }
            count += this.drawPathRun(g, lastColor, ybeg, yend, xaxis1D, xbeg, nx - 1);
        }
    }

    private int drawRectLatLon(Graphics2D g, int color, double lon1, double lat1, double lon2, double lat2) {
        g.setColor(this.cs.getColor(color));
        int count = 0;
        ProjectionRect[] rect = this.projectll.latLonToProjRect(lat1, lon1, lat2, lon2);
        for (int i = 0; i < 2; ++i) {
            if (null == rect[i]) continue;
            ProjectionRect r2 = rect[i];
            Rectangle2D.Double r = new Rectangle2D.Double(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
            g.fill(r);
        }
        return count;
    }

    private int drawRect(Graphics2D g, int color, double w1, double h1, double w2, double h2, boolean useLatlon) {
        if (useLatlon) {
            return this.drawRectLatLon(g, color, w1, h1, w2, h2);
        }
        g.setColor(this.cs.getColor(color));
        double wmin = Math.min(w1, w2);
        double hmin = Math.min(h1, h2);
        double width = Math.abs(w1 - w2);
        double height = Math.abs(h1 - h2);
        this.rect.setRect(wmin, hmin, width, height);
        g.fill(this.rect);
        return 1;
    }

    private int drawPathRun(Graphics2D g, int color, double y1, double y2, CoordinateAxis1D xaxis, int x1, int x2) {
        int e;
        int nx = (int)xaxis.getSize();
        if (x1 < 0 || x2 < 0 || x2 > nx || x1 > x2) {
            return 0;
        }
        this.gpRun.reset();
        LatLonPoint llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge(x1), y1);
        ProjectionPoint pt = this.drawProjection.latLonToProj(llp);
        if (debugPts) {
            System.out.println("** moveTo = " + pt.getX() + " " + pt.getY());
        }
        this.gpRun.moveTo((float)pt.getX(), (float)pt.getY());
        this.ptP1.setLocation(pt);
        for (e = x1 + 1; e <= x2 + 1; ++e) {
            llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge(e), y1);
            pt = this.drawProjection.latLonToProj(llp);
            if (this.drawProjection.crossSeam((ProjectionPoint)this.ptP1, pt)) {
                int x = e - 1;
                if (debugPathShape) {
                    System.out.println("split1 at x = " + x + " " + x1 + " " + x2);
                }
                int count = 0;
                count += this.drawPathRun(g, color, y1, y2, xaxis, x1, x - 1);
                return count += this.drawPathRun(g, color, y1, y2, xaxis, x + 1, x2);
            }
            if (debugPts) {
                System.out.println("  lineTo = " + pt.getX() + " " + pt.getY());
            }
            this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
            this.ptP1.setLocation(pt);
        }
        for (e = x2 + 1; e >= x1; --e) {
            llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge(e), y2);
            pt = this.drawProjection.latLonToProj(llp);
            if (this.drawProjection.crossSeam((ProjectionPoint)this.ptP1, pt)) {
                int x;
                int n = x = e == x2 + 1 ? x2 : e;
                if (debugPathShape) {
                    System.out.println("split2 at x = " + x + " " + x1 + " " + x2);
                }
                int count = 0;
                count += this.drawPathRun(g, color, y1, y2, xaxis, x1, x - 1);
                return count += this.drawPathRun(g, color, y1, y2, xaxis, x + 1, x2);
            }
            if (debugPts) {
                System.out.println("  lineTo = " + pt.getX() + " " + pt.getY());
            }
            this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
            this.ptP1.setLocation(pt);
        }
        g.setColor(this.cs.getColor(color));
        try {
            g.fill(this.gpRun);
        }
        catch (Throwable e2) {
            System.out.println("Exception in drawPathRun = " + e2);
            return 0;
        }
        return 1;
    }

    private int drawPathShape(Graphics2D g, int color, CoordinateAxis1D xaxis, CoordinateAxis1D yaxis) {
        int count = 0;
        int y = 0;
        while ((long)y < yaxis.getSize() - 1L) {
            double y1 = yaxis.getCoordEdge(y);
            double y2 = yaxis.getCoordEdge(y + 1);
            count += this.drawPathRun(g, color, y1, y2, xaxis, 0, (int)xaxis.getSize() - 1);
            ++y;
        }
        return count;
    }

    private void drawXORline(Graphics2D g, double x1, double y1, double x2, double y2) {
        this.gpRun.reset();
        this.gpRun.moveTo((float)x1, (float)y1);
        this.gpRun.lineTo((float)x2, (float)y2);
        g.setColor(Color.black);
        if (Double.isInfinite(x1) || Double.isInfinite(x2) || Double.isInfinite(y1) || Double.isInfinite(y2)) {
            return;
        }
        g.draw(this.gpRun);
    }

    private void drawContours(Graphics2D g, Array hslice, AffineTransform dFromN) {
        ContourFeatureRenderer contourRenderer;
        GridCoordSystem geocs = this.stridedGrid.getCoordinateSystem();
        CoordinateAxis1D xaxis = (CoordinateAxis1D)geocs.getXHorizAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)geocs.getYHorizAxis();
        double[] xedges = xaxis.getCoordValues();
        double[] yedges = yaxis.getCoordValues();
        int nlevels = this.cs.getNumColors();
        ArrayList<Double> levels = new ArrayList<Double>(nlevels);
        for (int i = 1; i < nlevels - 1; ++i) {
            levels.add(this.cs.getEdge(i));
        }
        long startTime = System.currentTimeMillis();
        try {
            ContourGrid conGrid = new ContourGrid(hslice, levels, xedges, yedges, this.stridedGrid);
            contourRenderer = new ContourFeatureRenderer(conGrid, this.dataProjection);
        }
        catch (Exception e) {
            System.out.println("make Contours exception = " + e);
            e.printStackTrace(System.out);
            return;
        }
        if (Debug.isSet((String)"timing/contourMake")) {
            long tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing/contourMake: " + (double)tookTime * 0.001 + " seconds");
        }
        startTime = System.currentTimeMillis();
        try {
            contourRenderer.setProjection(this.drawProjection);
            contourRenderer.setColor(Color.black);
            contourRenderer.setShowLabels(this.drawContourLabels);
            contourRenderer.draw(g, dFromN);
        }
        catch (Exception e) {
            System.out.println("draw Contours exception = " + e);
            e.printStackTrace(System.err);
        }
        if (Debug.isSet((String)"timing/contourDraw")) {
            long tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing/contourDraw: " + (double)tookTime * 0.001 + " seconds");
        }
    }
}

