/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.image.image.ImageDatasetFactory;
import ucar.nc2.dt.image.image.ImageFactoryRandom;
import ucar.nc2.ui.image.PicturePane;
import ucar.ui.widget.BAMutil;

public class ImageViewPanel
extends JPanel {
    private static boolean debug = false;
    private ImageDatasetFactory imageDatasetFactory = new ImageDatasetFactory();
    private ImageFactoryRandom imageFactoryRandom;
    private String location;
    private boolean movieIsPlaying = false;
    private Timer timer;
    private int delay = 4000;
    private JSpinner spinner;
    private Random random = new Random(System.currentTimeMillis());
    private long start = 0L;
    private boolean fullscreenMode = false;
    private PicturePane pixPane = new PicturePane();
    private JFrame fullFrame;

    public ImageViewPanel(Container buttPanel) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pixPane, "Center");
        if (buttPanel == null) {
            buttPanel = new JPanel();
            this.add((Component)buttPanel, "North");
        }
        AbstractAction prevAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewPanel.this.setImage(ImageViewPanel.this.imageDatasetFactory.getNextImage(false));
            }
        };
        BAMutil.setActionProperties((AbstractAction)prevAction, (String)"VCRPrevFrame", (String)"previous", (boolean)false, (int)80, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)prevAction);
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewPanel.this.setImage(ImageViewPanel.this.imageDatasetFactory.getNextImage(true));
            }
        };
        BAMutil.setActionProperties((AbstractAction)nextAction, (String)"VCRNextFrame", (String)"next", (boolean)false, (int)78, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)nextAction);
        AbstractAction loopAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageViewPanel.this.movieIsPlaying) {
                    if (ImageViewPanel.this.timer != null) {
                        ImageViewPanel.this.timer.stop();
                    }
                    ImageViewPanel.this.movieIsPlaying = false;
                } else {
                    if (ImageViewPanel.this.location == null) {
                        return;
                    }
                    File f = new File(ImageViewPanel.this.location);
                    if (!f.exists()) {
                        return;
                    }
                    ImageViewPanel.this.imageFactoryRandom = new ImageFactoryRandom(f.getParentFile());
                    ImageViewPanel.this.timer = new Timer(ImageViewPanel.this.delay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            ImageViewPanel.this.setImage(ImageViewPanel.this.imageFactoryRandom.getNextImage());
                            int delayMsecs = ImageViewPanel.this.delay + ImageViewPanel.this.random.nextInt() % ImageViewPanel.this.delay / 2;
                            ImageViewPanel.this.timer.setDelay(delayMsecs);
                            long time = System.currentTimeMillis();
                            long took = time - ImageViewPanel.this.start;
                            ImageViewPanel.this.start = time;
                            System.out.printf(" delay=%d; took=%d%n ", delayMsecs, took);
                        }
                    });
                    ImageViewPanel.this.timer.start();
                    ImageViewPanel.this.movieIsPlaying = true;
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)loopAction, (String)"MovieLoop", (String)"loop", (boolean)true, (int)78, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)loopAction);
        this.spinner = new JSpinner(new SpinnerNumberModel(5000, 10, 20000, 1000));
        this.spinner.addChangeListener(e -> {
            Integer value = (Integer)this.spinner.getModel().getValue();
            this.delay = value;
            if (this.timer != null) {
                this.timer.setDelay(this.delay);
            }
        });
        buttPanel.add(this.spinner);
        AbstractAction fullscreenAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = ge.getDefaultScreenDevice();
                System.out.println("isFullScreenSupported= " + device.isFullScreenSupported());
                ImageViewPanel.this.fullFrame = new JFrame();
                ImageViewPanel.this.fullFrame.setUndecorated(true);
                ImageViewPanel.this.fullFrame.getContentPane().add(ImageViewPanel.this.pixPane);
                ImageViewPanel.this.fullscreenMode = true;
                device.setFullScreenWindow(ImageViewPanel.this.fullFrame);
                MyKeyEventDispatcher dispatcher = new MyKeyEventDispatcher();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(dispatcher);
            }
        };
        BAMutil.setActionProperties((AbstractAction)fullscreenAction, (String)"Export", (String)"fullscreen", (boolean)true, (int)78, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)fullscreenAction);
    }

    private void resetPane() {
        this.add((Component)this.pixPane, "Center");
        this.revalidate();
    }

    public void setImageFromGrid(GridDatatype grid) {
        try {
            BufferedImage image = this.imageDatasetFactory.openDataset(grid);
            this.setImage(image);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Error on dataset\n" + this.imageDatasetFactory.getErrorMessages());
            e2.printStackTrace();
        }
    }

    public boolean setImageFromUrl(String location) {
        this.location = location;
        if (location.startsWith("http")) {
            URL url;
            try {
                url = new URL(location);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return false;
            }
            this.pixPane.setPicture(url, "legendParam", 0.0);
        } else {
            try {
                BufferedImage image = this.imageDatasetFactory.open(location);
                if (image == null) {
                    JOptionPane.showMessageDialog(null, "Cant open dataset as image = " + location + "\n" + this.imageDatasetFactory.getErrorMessages());
                    return false;
                }
                this.setImage(image);
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(null, "Error on dataset = " + location + "\n" + this.imageDatasetFactory.getErrorMessages());
                e2.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void setImage(BufferedImage im) {
        if (im == null) {
            return;
        }
        if (debug) {
            System.out.println("ImageViewPanel setImage ");
        }
        this.pixPane.setBufferedImage(im, "setImage");
        this.pixPane.repaint();
    }

    public static void main(String[] args) {
        String[] writerMimes;
        String[] writers;
        String[] readerMimes;
        String[] readers;
        for (String reader : readers = ImageIO.getReaderFormatNames()) {
            System.out.println(" reader = " + reader);
        }
        System.out.println("-------------------------------------------");
        for (String readerMime : readerMimes = ImageIO.getReaderMIMETypes()) {
            System.out.println(" readerMimes = " + readerMime);
        }
        System.out.println("-------------------------------------------");
        for (String writer : writers = ImageIO.getWriterFormatNames()) {
            System.out.println(" writers = " + writer);
        }
        System.out.println("-------------------------------------------");
        for (String writerMime : writerMimes = ImageIO.getWriterMIMETypes()) {
            System.out.println(" writerMimes = " + writerMime);
        }
        System.out.println("-------------------------------------------");
    }

    private class MyKeyEventDispatcher
    implements KeyEventDispatcher {
        private MyKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            System.out.printf(" dispatchKeyEvent=%s code = %d %n", e, e.getKeyCode());
            if (e.getKeyCode() == 127) {
                ImageViewPanel.this.imageFactoryRandom.delete();
                return false;
            }
            if (ImageViewPanel.this.fullscreenMode) {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = ge.getDefaultScreenDevice();
                device.setFullScreenWindow(null);
                ImageViewPanel.this.fullscreenMode = false;
            }
            ImageViewPanel.this.resetPane();
            if (ImageViewPanel.this.fullFrame != null) {
                ImageViewPanel.this.fullFrame.dispose();
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            return false;
        }
    }
}

