/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.ma2.Array;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.util.CompareNetcdf2;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class AggTable
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable datasetTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private TextHistoryPane aggTA;
    private IndependentWindow infoWindow;
    private NetcdfDataset current;

    public AggTable(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.datasetTable = new BeanTable(DatasetBean.class, (PreferencesExt)prefs.node("DatasetBean"), false);
        PopupMenu varPopup = new PopupMenu((JComponent)this.datasetTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.datasetTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openNetcdfFile", null, dsb.acquireFile());
            }
        });
        varPopup.addAction("Check CoordSystems", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.datasetTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openCoordSystems", null, dsb.acquireFile());
            }
        });
        varPopup.addAction("Open as GridDataset", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean dsb = (DatasetBean)AggTable.this.datasetTable.getSelectedBean();
                if (dsb == null) {
                    return;
                }
                AggTable.this.firePropertyChange("openGridDataset", null, dsb.acquireFile());
            }
        });
        AbstractButton compareButton = BAMutil.makeButtcon((String)"Select", (String)"Check files", (boolean)false);
        compareButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.compare(f);
            this.checkAggCoordinate(f);
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        });
        buttPanel.add(compareButton);
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.aggTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, (Component)this.datasetTable, (Component)this.aggTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.datasetTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void clear() {
        this.datasetTable.clearBeans();
        this.aggTA.clear();
    }

    public void setAggDataset(NetcdfDataset ncd) throws IOException {
        this.current = ncd;
        Aggregation agg = ncd.getAggregation();
        ArrayList<DatasetBean> beanList = new ArrayList<DatasetBean>();
        for (Aggregation.Dataset dataset : agg.getDatasets()) {
            beanList.add(new DatasetBean(dataset));
        }
        this.datasetTable.setBeans(beanList);
        Formatter f = new Formatter();
        agg.getDetailInfo(f);
        this.aggTA.setText(f.toString());
    }

    private void checkAggCoordinate(Formatter f) {
        if (null == this.current) {
            return;
        }
        try {
            Aggregation agg = this.current.getAggregation();
            String aggDimName = agg.getDimensionName();
            Variable aggCoord = this.current.findVariable(aggDimName);
            Array data = aggCoord.read();
            f.format("   Aggregated coordinate variable %s%n", aggCoord);
            f.format(NCdumpW.toString((Array)data, (String)aggDimName, null), new Object[0]);
            for (Object bean : this.datasetTable.getBeans()) {
                DatasetBean dbean = (DatasetBean)bean;
                Aggregation.Dataset ads = dbean.ds;
                NetcdfFile aggFile = ads.acquireFile(null);
                Throwable throwable = null;
                try {
                    f.format("   Component file %s%n", aggFile.getLocation());
                    Variable aggCoordp = aggFile.findVariable(aggDimName);
                    if (aggCoordp == null) {
                        f.format("   doesnt have coordinate variable%n", new Object[0]);
                        continue;
                    }
                    data = aggCoordp.read();
                    f.format(NCdumpW.toString((Array)data, (String)(aggCoordp.getNameAndDimensions() + " (" + aggCoordp.getUnitsString() + ")"), null), new Object[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (aggFile == null) continue;
                    if (throwable != null) {
                        try {
                            aggFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    aggFile.close();
                }
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(10000);
            t.printStackTrace(new PrintWriter(sw));
            f.format(sw.toString(), new Object[0]);
        }
    }

    private void compare(Formatter f) {
        try {
            NetcdfFile org = null;
            for (Object bean : this.datasetTable.getBeans()) {
                DatasetBean dbean = (DatasetBean)bean;
                Aggregation.Dataset ads = dbean.ds;
                NetcdfFile ncd = ads.acquireFile(null);
                if (org == null) {
                    org = ncd;
                    continue;
                }
                CompareNetcdf2 cn = new CompareNetcdf2(f, false, false, false);
                cn.compareVariables(org, ncd);
                ncd.close();
                f.format("--------------------------------%n", new Object[0]);
            }
            if (org != null) {
                org.close();
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(10000);
            t.printStackTrace(new PrintWriter(sw));
            f.format(sw.toString(), new Object[0]);
        }
    }

    public class DatasetBean {
        Aggregation.Dataset ds;

        @Nullable
        protected NetcdfFile acquireFile() {
            try {
                return this.ds.acquireFile(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public DatasetBean(Aggregation.Dataset ds) {
            this.ds = ds;
        }

        public String getLocation() throws IOException {
            return this.ds.getLocation();
        }

        public String getCacheLocation() {
            return this.ds.getCacheLocation();
        }

        public String getId() {
            return this.ds.getId();
        }
    }
}

