/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.util.IO;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class CdmrFeaturePanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable messTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane infoPopup3;
    private IndependentWindow infoWindow2;
    private IndependentWindow infoWindow3;
    private NetcdfFile ncd;

    public CdmrFeaturePanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.messTable = new BeanTable(MessBean.class, (PreferencesExt)prefs.node("CdmMessage"), false);
        this.messTable.addListSelectionListener(e -> {
            MessBean bean = (MessBean)this.messTable.getSelectedBean();
            if (bean == null) {
                return;
            }
            this.infoTA.setText(bean.getDesc());
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.messTable.getJTable(), "Options");
        varPopup.addAction("Show record -> variable data assignments", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessBean bean = (MessBean)CdmrFeaturePanel.this.messTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                CdmrFeaturePanel.this.infoTA.setText(bean.getDesc());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", (Object)new Rectangle(300, 300, 500, 300)));
        this.infoPopup3 = new TextHistoryPane();
        this.infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoPopup3);
        this.infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", (Object)new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane(0, false, (Component)this.messTable, (Component)this.infoTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 800));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.messTable.saveState(false);
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNcStream(String stream) throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        long total = 0L;
        ArrayList<MessBean> messages = new ArrayList<MessBean>();
        try (InputStream is = null;){
            System.out.printf("open %s%n", stream);
            is = stream.startsWith("http:") ? IO.getInputStreamFromUrl((String)stream) : new FileInputStream(stream);
            if (is == null) {
                return;
            }
            block12: while (true) {
                Mess mess = new Mess();
                mess.magic = PointStream.readMagic((InputStream)is);
                messages.add(new MessBean(mess));
                if (mess.magic == PointStream.MessageType.Eos) {
                    break;
                }
                total += 4L;
                if (mess.magic == PointStream.MessageType.Start || mess.magic == PointStream.MessageType.End) continue;
                mess.vlen = NcStream.readVInt((InputStream)is);
                byte[] m = new byte[mess.vlen];
                NcStream.readFully((InputStream)is, (byte[])m);
                total += (long)mess.vlen;
                switch (mess.magic) {
                    case Header: {
                        mess.obj = NcStreamProto.Header.parseFrom((byte[])m);
                        continue block12;
                    }
                    case Data: {
                        mess.obj = NcStreamProto.Data.parseFrom((byte[])m);
                        mess.dlen = NcStream.readVInt((InputStream)is);
                        total += is.skip(mess.dlen);
                        continue block12;
                    }
                    case Error: {
                        mess.obj = NcStreamProto.Error.parseFrom((byte[])m);
                        continue block12;
                    }
                    case StationList: {
                        mess.obj = PointStreamProto.StationList.parseFrom((byte[])m);
                        continue block12;
                    }
                    case PointFeatureCollection: {
                        mess.obj = PointStreamProto.PointFeatureCollection.parseFrom((byte[])m);
                        continue block12;
                    }
                    case PointFeature: {
                        mess.obj = PointStreamProto.PointFeature.parseFrom((byte[])m);
                        continue block12;
                    }
                }
                mess.obj = "unknown";
            }
        }
        this.messTable.setBeans(messages);
        System.out.printf(" nmess = %d nbytes=%d%n", messages.size(), total);
    }

    public void closeOpenFiles() throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        this.ncd = null;
    }

    public void showInfo(Formatter f) {
        if (this.ncd == null) {
            return;
        }
        f.format("%s", this.ncd.toString());
    }

    public class MessBean {
        Mess mess;

        MessBean() {
        }

        MessBean(Mess m) {
            this.mess = m;
        }

        public String getMagic() {
            return this.mess.magic.toString();
        }

        public String getObjClass() {
            return this.mess.obj == null ? "" : this.mess.obj.getClass().toString();
        }

        public String getDesc() {
            return this.mess.obj == null ? "" : this.mess.obj.toString();
        }

        public int getSize() {
            return this.mess.vlen;
        }

        public int getDSize() {
            return this.mess.dlen;
        }
    }

    private static class Mess {
        PointStream.MessageType magic;
        int vlen;
        int dlen;
        Object obj;

        private Mess() {
        }
    }
}

