/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.op.RadialDatasetTable;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class RadialPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private RadialDatasetTable dsTable;
    private JSplitPane split;
    private RadialDatasetSweep ds;

    public RadialPanel(PreferencesExt prefs) {
        super(prefs, "dataset:", true, false);
        this.dsTable = new RadialDatasetTable(prefs);
        this.add((Component)this.dsTable, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Parse Info", (boolean)false);
        infoButton.addActionListener(e -> {
            try (RadialDatasetSweep radialDataset = this.dsTable.getRadialDataset();){
                Formatter info = new Formatter();
                radialDataset.getDetailInfo(info);
                this.detailTA.setText(info.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
        this.buttPanel.add(infoButton);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            NetcdfDataset newds = NetcdfDataset.openDataset((String)command, (boolean)true, null);
            if (newds == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cannot open " + command);
                return false;
            }
            Formatter errlog = new Formatter();
            RadialDatasetSweep rds = (RadialDatasetSweep)FeatureDatasetFactoryManager.wrap((FeatureType)FeatureType.RADIAL, (NetcdfDataset)newds, null, (Formatter)errlog);
            if (rds == null) {
                JOptionPane.showMessageDialog(null, "FeatureDatasetFactoryManager cannot open " + command + "as RADIAL dataset\n" + errlog.toString());
                err = true;
            } else {
                this.setDataset(rds);
            }
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cannot open " + command + "\n" + ioe.getMessage());
            ioe.printStackTrace();
            err = true;
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter(5000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    public void setDataset(RadialDatasetSweep newds) {
        if (newds == null) {
            return;
        }
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (IOException ioe) {
            logger.warn("close failed");
        }
        this.ds = newds;
        this.dsTable.setDataset(newds);
        this.setSelectedItem(newds.getLocation());
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ds != null) {
            this.ds.close();
        }
        this.ds = null;
    }

    @Override
    public void save() {
        super.save();
        this.dsTable.save();
    }
}

