/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JButton;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.ui.prefs.Debug;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class UnitConvert
extends OpPanel {
    private TextHistoryPane ta;
    private DateFormatter formatter = new DateFormatter();

    public UnitConvert(PreferencesExt prefs) {
        super(prefs, "unit:", false, false);
        this.ta = new TextHistoryPane(true);
        this.add((Component)this.ta, "Center");
        JButton compareButton = new JButton("Compare");
        compareButton.addActionListener(e -> this.compare(this.cb.getSelectedItem()));
        this.buttPanel.add(compareButton);
        JButton dateButton = new JButton("UdunitDate");
        dateButton.addActionListener(e -> this.checkUdunits(this.cb.getSelectedItem()));
        this.buttPanel.add(dateButton);
        JButton cdateButton = new JButton("CalendarDate");
        cdateButton.addActionListener(e -> this.checkCalendarDate(this.cb.getSelectedItem()));
        this.buttPanel.add(cdateButton);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        try {
            SimpleUnit su = SimpleUnit.factoryWithExceptions((String)command);
            this.ta.setText("parse=" + command + "\n");
            this.ta.appendLine("SimpleUnit.toString()          =" + su.toString() + "\n");
            this.ta.appendLine("SimpleUnit.getCanonicalString  =" + su.getCanonicalString());
            this.ta.appendLine("SimpleUnit.getImplementingClass= " + su.getImplementingClass());
            this.ta.appendLine("SimpleUnit.isUnknownUnit       = " + su.isUnknownUnit());
            return true;
        }
        catch (Exception e) {
            if (Debug.isSet((String)"Xdeveloper")) {
                StringWriter sw = new StringWriter(10000);
                e.printStackTrace(new PrintWriter(sw));
                this.ta.setText(sw.toString());
            } else {
                this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
            }
            return false;
        }
    }

    @Override
    public void closeOpenFiles() {
    }

    public void compare(Object o) {
        String command = (String)o;
        StringTokenizer stoke = new StringTokenizer(command);
        ArrayList<String> list = new ArrayList<String>();
        while (stoke.hasMoreTokens()) {
            list.add(stoke.nextToken());
        }
        try {
            String unitS1 = (String)list.get(0);
            String unitS2 = (String)list.get(1);
            SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)unitS1);
            SimpleUnit su2 = SimpleUnit.factoryWithExceptions((String)unitS2);
            this.ta.setText("<" + su1.toString() + "> isConvertable to <" + su2.toString() + ">=" + SimpleUnit.isCompatibleWithExceptions((String)unitS1, (String)unitS2));
        }
        catch (Exception e) {
            if (Debug.isSet((String)"Xdeveloper")) {
                StringWriter sw = new StringWriter(10000);
                e.printStackTrace(new PrintWriter(sw));
                this.ta.setText(sw.toString());
            }
            this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
        }
    }

    private void checkUdunits(Object o) {
        String command = (String)o;
        boolean isDate = false;
        try {
            DateUnit du = new DateUnit(command);
            this.ta.appendLine("\nFrom udunits:\n <" + command + "> isDateUnit = " + du);
            Date d = du.getDate();
            this.ta.appendLine("getStandardDateString = " + this.formatter.toDateTimeString(d));
            this.ta.appendLine("getDateOrigin = " + this.formatter.toDateTimeString(du.getDateOrigin()));
            isDate = true;
            Date d2 = DateUnit.getStandardOrISO((String)command);
            if (d2 == null) {
                this.ta.appendLine("\nDateUnit.getStandardOrISO = false");
            } else {
                this.ta.appendLine("\nDateUnit.getStandardOrISO = " + this.formatter.toDateTimeString(d2));
            }
        }
        catch (Exception du) {
            // empty catch block
        }
        this.ta.appendLine("isDate = " + isDate);
        if (!isDate) {
            try {
                SimpleUnit su = SimpleUnit.factory((String)command);
                boolean isTime = su instanceof TimeUnit;
                this.ta.setText("<" + command + "> isTimeUnit= " + isTime);
                if (isTime) {
                    TimeUnit du = (TimeUnit)su;
                    this.ta.appendLine("\nTimeUnit = " + du);
                }
            }
            catch (Exception e) {
                if (Debug.isSet((String)"Xdeveloper")) {
                    StringWriter sw = new StringWriter(10000);
                    e.printStackTrace(new PrintWriter(sw));
                    this.ta.setText(sw.toString());
                }
                this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
            }
        }
    }

    private void checkCalendarDate(Object o) {
        String command = (String)o;
        try {
            this.ta.setText("\nParse CalendarDate: <" + command + ">\n");
            CalendarDate cd = CalendarDate.parseUdunits(null, (String)command);
            this.ta.appendLine("CalendarDate = " + cd);
        }
        catch (Throwable t) {
            this.ta.appendLine("not a CalendarDateUnit= " + t.getMessage());
        }
        try {
            this.ta.appendLine("\nParse CalendarDateUnit: <" + command + ">\n");
            CalendarDateUnit cdu = CalendarDateUnit.of(null, (String)command);
            this.ta.appendLine("CalendarDateUnit = " + cdu);
            this.ta.appendLine(" Calendar        = " + cdu.getCalendar());
            this.ta.appendLine(" PeriodField     = " + cdu.getCalendarPeriod().getField());
            this.ta.appendLine(" PeriodValue     = " + cdu.getCalendarPeriod().getValue());
            this.ta.appendLine(" Base            = " + cdu.getBaseCalendarDate());
            this.ta.appendLine(" isCalendarField = " + cdu.isCalendarField());
        }
        catch (Exception e) {
            this.ta.appendLine("not a CalendarDateUnit= " + e.getMessage());
            try {
                String[] s = command.split("%");
                if (s.length == 2) {
                    Double val = Double.parseDouble(s[0].trim());
                    this.ta.appendLine("\nval= " + val + " unit=" + s[1]);
                    CalendarDateUnit cdu = CalendarDateUnit.of(null, (String)s[1].trim());
                    this.ta.appendLine("CalendarDateUnit= " + cdu);
                    CalendarDate cd = cdu.makeCalendarDate(val.doubleValue());
                    this.ta.appendLine(" CalendarDate = " + cd);
                    Date d = cd.toDate();
                    this.ta.appendLine(" Date.toString() = " + d);
                    DateFormatter format = new DateFormatter();
                    this.ta.appendLine(" DateFormatter= " + format.toDateTimeString(cd.toDate()));
                }
            }
            catch (Exception ee) {
                this.ta.appendLine("Failed on CalendarDateUnit " + ee.getMessage());
            }
        }
    }
}

