/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.units.SimpleUnit;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class UnitDatasetCheck
extends OpPanel {
    private TextHistoryPane ta = new TextHistoryPane(true);

    UnitDatasetCheck(PreferencesExt p) {
        super(p, "dataset:");
        this.add((Component)this.ta, "Center");
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try (NetcdfDataset ncfile = NetcdfDataset.openDataset((String)command, (boolean)this.addCoords, null);){
            this.ta.setText("Variables for " + command + ":");
            for (Variable o1 : ncfile.getVariables()) {
                VariableEnhanced vs = (VariableEnhanced)o1;
                String units = vs.getUnitsString();
                StringBuilder sb = new StringBuilder();
                sb.append("   ").append(vs.getShortName()).append(" has unit= <").append(units).append(">");
                if (units != null) {
                    try {
                        SimpleUnit su = SimpleUnit.factoryWithExceptions((String)units);
                        sb.append(" unit convert = ").append(su.toString());
                        if (su.isUnknownUnit()) {
                            sb.append(" UNKNOWN UNIT");
                        }
                    }
                    catch (Exception ioe) {
                        sb.append(" unit convert failed ");
                        sb.insert(0, "**** Fail ");
                    }
                }
                this.ta.appendLine(sb.toString());
            }
        }
        catch (FileNotFoundException ioe) {
            this.ta.setText("Failed to open <" + command + ">");
            err = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        this.ta.clear();
    }
}

