/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.time.CalendarTimeZone;
import ucar.ui.widget.FileManager;
import ucar.util.prefs.PreferencesExt;

public class VariableTable
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PreferencesExt prefs;
    private FileManager fileChooser;
    List col0;
    Array[] data;
    int col0Dim = -1;
    private boolean col0isDate;
    NetcdfFile file;
    NetcdfDataset fds;
    String[] columnNames;
    VariableTableModel dataModel = new VariableTableModel();
    JCheckBox includeGlobals;

    public VariableTable(PreferencesExt prefs) {
        this.prefs = prefs;
        PreferencesExt fcPrefs = prefs == null ? null : (PreferencesExt)prefs.node("FileManager");
        this.fileChooser = new FileManager(null, null, "csv", "comma seperated values", fcPrefs);
    }

    public void clear() {
        if (this.dataModel != null) {
            this.dataModel.clear();
        }
        this.col0 = null;
    }

    public void saveState() {
        this.fileChooser.save();
    }

    public void setVariableList(List<Variable> vl) {
        int length;
        int i = 0;
        for (Variable v : vl) {
            int[] shape = v.getShape();
            length = 1;
            for (int j = 1; j < shape.length; ++j) {
                length *= shape[j];
            }
            log.info("Length " + length + " i = " + (i += length) + " var " + v.getDimensionsString());
        }
        length = i;
        this.columnNames = new String[length + 1];
        this.data = new Array[length];
        i = 0;
        for (Variable v : vl) {
            log.info("Variable " + v.getShortName());
            List vd = v.getDimensions();
            int dimNo = 0;
            for (Dimension d : vd) {
                Attribute axis;
                Variable dimVar = this.file.findVariable(d.getShortName());
                if (dimVar != null && (axis = dimVar.findAttribute("axis")) != null && axis.isString() && axis.getStringValue().compareTo("T") == 0) {
                    try {
                        CoordinateAxis1DTime tm = CoordinateAxis1DTime.factory((NetcdfDataset)this.fds, (VariableDS)new VariableDS(null, dimVar, true), null);
                        this.col0 = tm.getCalendarDates();
                        this.col0Dim = dimNo;
                        this.col0isDate = true;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++dimNo;
            }
            int[] shape = v.getShape();
            if (this.col0Dim < 0) {
                this.col0 = new ArrayList();
                for (int j = 0; j < shape[0]; ++j) {
                    this.col0.add(j);
                }
                this.col0Dim = 0;
            }
            this.columnNames[0] = ((Dimension)vd.get(this.col0Dim)).getShortName();
            try {
                if (shape.length > 1 && shape[1] > 1) {
                    Variable dimVar = this.file.findVariable(v.getDimension(1).getShortName());
                    Array dimArray = null;
                    if (dimVar != null) {
                        dimArray = dimVar.read();
                    }
                    for (int j = 0; j < shape[1]; ++j) {
                        this.data[i] = v.slice(1, j).read();
                        this.columnNames[i + 1] = dimVar != null ? v.getShortName() + "[" + dimArray.getDouble(j) + "]" : v.getShortName() + "[" + j + "]";
                        Attribute unit = v.findAttribute("units");
                        if (unit != null && unit.isString()) {
                            int n = i + 1;
                            this.columnNames[n] = this.columnNames[n] + " (" + unit.getStringValue() + ")";
                        }
                        ++i;
                    }
                    continue;
                }
                this.data[i] = v.read();
                this.columnNames[i + 1] = v.getShortName();
                Attribute unit = v.findAttribute("units");
                if (unit != null && unit.isString()) {
                    int n = i + 1;
                    this.columnNames[n] = this.columnNames[n] + " (" + unit.getStringValue() + ")";
                }
                ++i;
            }
            catch (IOException | InvalidRangeException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDataset(NetcdfFile ds) {
        this.file = ds;
        try {
            this.fds = new NetcdfDataset(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createTable() {
        this.setLayout(new BorderLayout());
        JTable table = new JTable(this.dataModel);
        table.setPreferredScrollableViewportSize(new java.awt.Dimension(500, 70));
        if (this.col0isDate) {
            table.getColumnModel().getColumn(0).setCellRenderer(new DateRenderer());
        }
        table.setAutoResizeMode(4);
        JScrollPane scrollPane = new JScrollPane(table);
        this.removeAll();
        table.setFillsViewportHeight(true);
        this.add(scrollPane);
        this.includeGlobals = new JCheckBox("Export Attributes");
        JButton export = new JButton("Export");
        export.addActionListener(e -> this.export());
        JPanel holderPanel = new JPanel(new BorderLayout());
        holderPanel.add((Component)export, "East");
        holderPanel.add((Component)this.includeGlobals, "Center");
        this.add((Component)holderPanel, "Last");
    }

    private void export() {
        String filename = this.fileChooser.chooseFilename();
        if (filename == null) {
            return;
        }
        CalendarDateFormatter printForm = new CalendarDateFormatter("yyyy-MM-dd HH:mm:ss", CalendarTimeZone.UTC);
        try (FileOutputStream fos = new FileOutputStream(filename);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             PrintWriter pw = new PrintWriter(osw);){
            pw.println("; file name : " + this.fds.getLocation());
            if (this.includeGlobals.isSelected()) {
                List gAtts = this.fds.getGlobalAttributes();
                for (Attribute a : gAtts) {
                    pw.println("; " + a.toString(false));
                }
            }
            pw.println("; this file written : " + new Date());
            VariableTableModel model = this.dataModel;
            for (int col = 0; col < model.getColumnCount(); ++col) {
                if (col > 0) {
                    pw.print(",");
                }
                pw.print(model.getColumnName(col));
            }
            pw.println();
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < model.getColumnCount(); ++col) {
                    Object o;
                    if (col > 0) {
                        pw.print(",");
                    }
                    if ((o = model.getValueAt(row, col)) instanceof CalendarDate) {
                        CalendarDate d = (CalendarDate)o;
                        pw.print(printForm.toString(d));
                        continue;
                    }
                    pw.print(o.toString());
                }
                pw.println();
            }
            pw.close();
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
        this.fileChooser.save();
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        private CalendarDateFormatter newForm;
        private CalendarDateFormatter oldForm = new CalendarDateFormatter("yyyy-MM-dd HH:mm:ss", CalendarTimeZone.UTC);
        private CalendarDate cutoff;

        DateRenderer() {
            this.newForm = new CalendarDateFormatter("dd MMM HH:mm:ss", CalendarTimeZone.UTC);
            CalendarDate now = CalendarDate.present();
            this.cutoff = now.add(-1.0, CalendarPeriod.Field.Year);
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                CalendarDate date = (CalendarDate)value;
                if (date.isBefore(this.cutoff)) {
                    this.setText(this.oldForm.toString(date));
                } else {
                    this.setText(this.newForm.toString(date));
                }
            }
        }
    }

    class VariableTableModel
    extends AbstractTableModel {
        VariableTableModel() {
        }

        public void clear() {
        }

        @Override
        public int getColumnCount() {
            return VariableTable.this.data.length + 1;
        }

        @Override
        public String getColumnName(int col) {
            return VariableTable.this.columnNames[col];
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return VariableTable.this.col0.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return VariableTable.this.col0.get(row);
            }
            return VariableTable.this.data[col - 1].getObject(row);
        }
    }
}

