/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.tools.CatalogXmlWriter;
import ucar.nc2.util.IO;
import ucar.nc2.util.net.HttpClientManager;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.ProgressMonitor;
import ucar.ui.widget.ProgressMonitorTask;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class TextGetPutPane
extends TextHistoryPane {
    private PreferencesExt prefs;
    private JComboBox cb;
    private JPanel buttPanel;
    private boolean addFileButton = true;
    private AbstractAction fileAction = null;
    private FileManager fileChooserReader;
    private GetContentsTask task;
    private EventListenerList listenerList = new EventListenerList();

    public TextGetPutPane(PreferencesExt prefs) {
        super(true);
        this.prefs = prefs;
        this.cb = new JComboBox();
        this.cb.setEditable(true);
        if (prefs != null) {
            this.setList((ArrayList)prefs.getBean("list", null));
        }
        if (this.addFileButton) {
            this.fileChooserReader = new FileManager(null, null, "xml", "THREDDS catalogs", prefs == null ? null : (PreferencesExt)prefs.node("fileChooserReader"));
            this.fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = TextGetPutPane.this.fileChooserReader.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    TextGetPutPane.this.cb.setSelectedItem("file:" + filename);
                }
            };
            BAMutil.setActionProperties((AbstractAction)this.fileAction, (String)"FileChooser", (String)"open Local dataset...", (boolean)false, (int)76, (int)-1);
        }
        JButton getButton = new JButton("Get");
        getButton.setToolTipText("GET URL contents");
        getButton.addActionListener(e -> this.setURL((String)this.cb.getSelectedItem()));
        JButton validButton = new JButton("Validate");
        validButton.setToolTipText("Validate catalog");
        validButton.addActionListener(e -> this.validate((String)this.cb.getSelectedItem()));
        JButton putButton = new JButton("Put");
        putButton.setToolTipText("PUT URL contents");
        putButton.addActionListener(e -> {
            try {
                this.putURL((String)this.cb.getSelectedItem());
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, e1.getMessage());
            }
            this.firePutActionEvent();
        });
        this.buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        if (null != this.fileAction) {
            BAMutil.addActionToContainer((Container)this.buttPanel, (Action)this.fileAction);
        }
        this.buttPanel.add(getButton);
        this.buttPanel.add(validButton);
        this.buttPanel.add(putButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("URL:"), "West");
        topPanel.add((Component)this.cb, "Center");
        topPanel.add((Component)this.buttPanel, "East");
        this.add(topPanel, "North");
    }

    public void addButton(Component c) {
        this.buttPanel.add(c);
    }

    public void addPutActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removePutActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void firePutActionEvent() {
        ActionEvent event = new ActionEvent((Object)this, 0, "Put");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void setURL(String urlString) {
        if (urlString == null) {
            return;
        }
        if (urlString.startsWith("file:")) {
            String contents;
            urlString = urlString.substring(5);
            try {
                contents = IO.readFile((String)urlString);
            }
            catch (IOException e2) {
                contents = e2.getMessage();
            }
            this.ta.setText(contents);
            return;
        }
        this.task = new GetContentsTask(urlString);
        ProgressMonitor pm = new ProgressMonitor((ProgressMonitorTask)this.task, e -> {
            this.ta.setText(this.task.contents);
            ArrayList list = this.getList();
            if (!list.contains(this.task.urlString)) {
                this.cb.addItem(this.task.urlString);
            }
            this.cb.setSelectedItem(this.task.urlString);
        });
        pm.start((Component)((Object)this), "Open URL " + urlString, 10);
    }

    public void setCatalog(String urlString, Catalog cat) throws IOException {
        ArrayList list = this.getList();
        if (!list.contains(urlString)) {
            this.cb.addItem(urlString);
        }
        this.cb.setSelectedItem(urlString);
        ByteArrayOutputStream os = new ByteArrayOutputStream(20000);
        CatalogXmlWriter writer = new CatalogXmlWriter();
        writer.writeXML(cat, (OutputStream)os, false);
        this.ta.setText(os.toString("UTF-8"));
    }

    void validate(String urlString) {
        if (urlString == null) {
            return;
        }
        try {
            URI uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(null, "URISyntaxException on URL (" + urlString + ") " + e.getMessage() + "\n");
            return;
        }
        String contents = this.getText();
        ByteArrayInputStream is = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
        try {
            CatalogBuilder catFactory = new CatalogBuilder();
            Catalog cat = catFactory.buildFromLocation(urlString, null);
            boolean isValid = !catFactory.hasFatalError();
            JOptionPane.showMessageDialog((Component)((Object)this), "Catalog Validation = " + isValid + "\n" + catFactory.getErrorMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void putURL(String uriString) throws IOException {
        URI uri;
        if (uriString == null) {
            return;
        }
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            System.out.println("** TextGetPutPane URISyntaxException=" + uriString);
            return;
        }
        String contents = this.ta.getText();
        String s = uri.getScheme();
        if (s.equalsIgnoreCase("file")) {
            String path = uri.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            IO.writeToFile((String)contents, (String)path);
        } else {
            int status = HttpClientManager.putContent(uriString, contents);
            JOptionPane.showMessageDialog((Component)((Object)this), "Status code= " + status);
        }
    }

    void setList(ArrayList list) {
        if (list == null) {
            return;
        }
        this.cb.removeAllItems();
        for (Object o : list) {
            this.cb.addItem(o);
        }
        this.cb.revalidate();
    }

    ArrayList getList() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.cb.getItemCount(); ++i) {
            list.add(this.cb.getItemAt(i));
        }
        return list;
    }

    public void save() {
        if (this.prefs != null) {
            this.prefs.putBeanObject("list", (Object)this.getList());
        }
    }

    public void clear() {
        this.ta.setText(null);
    }

    public String getText() {
        return this.ta.getText();
    }

    public void gotoTop() {
        this.ta.setCaretPosition(0);
    }

    public void setText(String text) {
        this.ta.setText(text);
    }

    private static class GetContentsTask
    extends ProgressMonitorTask {
        String urlString;
        String contents;

        GetContentsTask(String urlString) {
            this.urlString = urlString;
        }

        public void run() {
            try {
                this.contents = HttpClientManager.getContentAsString(null, this.urlString);
            }
            catch (Exception e) {
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            this.success = !this.cancel;
            this.done = true;
        }
    }
}

