/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.tools.DataFactory;
import thredds.ui.catalog.ThreddsUI;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPSession;
import ucar.nc2.FileWriter2;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.Grib;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.ui.DebugProxyHandler;
import ucar.nc2.ui.GetDataRunnable;
import ucar.nc2.ui.GetDataTask;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsSplashScreen;
import ucar.nc2.ui.dialog.DiskCache2Form;
import ucar.nc2.ui.grib.CdmIndexReportPanel;
import ucar.nc2.ui.grib.Grib1ReportPanel;
import ucar.nc2.ui.grib.Grib2ReportPanel;
import ucar.nc2.ui.menu.DebugMenu;
import ucar.nc2.ui.menu.HelpMenu;
import ucar.nc2.ui.menu.ModesMenu;
import ucar.nc2.ui.menu.SystemMenu;
import ucar.nc2.ui.op.AggPanel;
import ucar.nc2.ui.op.BufrCdmIndexOpPanel;
import ucar.nc2.ui.op.BufrCodePanel;
import ucar.nc2.ui.op.BufrPanel;
import ucar.nc2.ui.op.BufrReportPanel;
import ucar.nc2.ui.op.BufrTableBPanel;
import ucar.nc2.ui.op.BufrTableDPanel;
import ucar.nc2.ui.op.CdmIndexOpPanel;
import ucar.nc2.ui.op.CdmrFeatureOpPanel;
import ucar.nc2.ui.op.CollectionSpecPanel;
import ucar.nc2.ui.op.CoordSysPanel;
import ucar.nc2.ui.op.CoveragePanel;
import ucar.nc2.ui.op.DatasetViewerPanel;
import ucar.nc2.ui.op.DatasetWriterPanel;
import ucar.nc2.ui.op.DirectoryPartitionPanel;
import ucar.nc2.ui.op.FeatureScanOpPanel;
import ucar.nc2.ui.op.FmrcPanel;
import ucar.nc2.ui.op.GeoGridPanel;
import ucar.nc2.ui.op.GeotiffPanel;
import ucar.nc2.ui.op.Grib1CollectionOpPanel;
import ucar.nc2.ui.op.Grib1DataOpPanel;
import ucar.nc2.ui.op.Grib1TablePanel;
import ucar.nc2.ui.op.Grib2CollectionOpPanel;
import ucar.nc2.ui.op.Grib2DataOpPanel;
import ucar.nc2.ui.op.Grib2TablePanel;
import ucar.nc2.ui.op.GribCodePanel;
import ucar.nc2.ui.op.GribFilesOpPanel;
import ucar.nc2.ui.op.GribIndexOpPanel;
import ucar.nc2.ui.op.GribRewriteOpPanel;
import ucar.nc2.ui.op.GribTemplatePanel;
import ucar.nc2.ui.op.Hdf4Panel;
import ucar.nc2.ui.op.Hdf5DataPanel;
import ucar.nc2.ui.op.Hdf5ObjectPanel;
import ucar.nc2.ui.op.ImagePanel;
import ucar.nc2.ui.op.NCdumpPanel;
import ucar.nc2.ui.op.NcStreamOpPanel;
import ucar.nc2.ui.op.NcmlEditorPanel;
import ucar.nc2.ui.op.PointFeaturePanel;
import ucar.nc2.ui.op.RadialPanel;
import ucar.nc2.ui.op.ReportOpPanel;
import ucar.nc2.ui.op.SimpleGeomPanel;
import ucar.nc2.ui.op.StationRadialPanel;
import ucar.nc2.ui.op.UnitsPanel;
import ucar.nc2.ui.op.WmoCCPanel;
import ucar.nc2.ui.op.WmsPanel;
import ucar.nc2.ui.util.SocketMessage;
import ucar.nc2.ui.widget.URLDumpPane;
import ucar.nc2.ui.widget.UrlAuthenticatorDialog;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.xml.RuntimeConfigParser;
import ucar.ui.prefs.Debug;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.ProgressMonitor;
import ucar.ui.widget.ProgressMonitorTask;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;

public class ToolsUI
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DIALOG_VERSION = "5.0";
    public static final String WORLD_DETAIL_MAP = "/resources/ui/maps/Countries.shp";
    public static final String US_MAP = "/resources/ui/maps/us_state.shp";
    public static final String FRAME_SIZE = "FrameSize";
    public static final String GRIDVIEW_FRAME_SIZE = "GridUIWindowSize";
    public static final String GRIDIMAGE_FRAME_SIZE = "GridImageWindowSize";
    private static boolean debugListen;
    private static ToolsUI ui;
    private static JFrame frame;
    private static PreferencesExt prefs;
    private static XMLStore store;
    private static boolean done;
    private static String wantDataset;
    private final JFrame parentFrame;
    private final FileManager fileChooser;
    private FileManager bufrFileChooser;
    private final JTabbedPane tabbedPane;
    private final JTabbedPane iospTabPane;
    private final JTabbedPane bufrTabPane;
    private final JTabbedPane gribTabPane;
    private final JTabbedPane grib2TabPane;
    private final JTabbedPane grib1TabPane;
    private final JTabbedPane hdf5TabPane;
    private final JTabbedPane ftTabPane;
    private final JTabbedPane fcTabPane;
    private final JTabbedPane fmrcTabPane;
    private final JTabbedPane ncmlTabPane;
    private final PreferencesExt mainPrefs;
    private AggPanel aggPanel;
    private BufrPanel bufrPanel;
    private BufrTableBPanel bufrTableBPanel;
    private BufrTableDPanel bufrTableDPanel;
    private ReportOpPanel bufrReportPanel;
    private BufrCdmIndexOpPanel bufrCdmIndexPanel;
    private BufrCodePanel bufrCodePanel;
    private CdmrFeatureOpPanel cdmremotePanel;
    private CdmIndexOpPanel cdmIndexPanel;
    private ReportOpPanel cdmIndexReportPanel;
    private CollectionSpecPanel fcPanel;
    private CoordSysPanel coordSysPanel;
    private CoveragePanel coveragePanel;
    private DatasetViewerPanel viewerPanel;
    private DatasetViewerPanel nc4viewer;
    private DatasetWriterPanel writerPanel;
    private DirectoryPartitionPanel dirPartPanel;
    private FeatureScanOpPanel ftPanel;
    private FmrcPanel fmrcPanel;
    private GeoGridPanel gridPanel;
    private GeotiffPanel geotiffPanel;
    private GribCodePanel gribCodePanel;
    private GribFilesOpPanel gribFilesPanel;
    private GribIndexOpPanel gribIdxPanel;
    private GribRewriteOpPanel gribRewritePanel;
    private GribTemplatePanel gribTemplatePanel;
    private Grib1CollectionOpPanel grib1CollectionPanel;
    private ReportOpPanel grib1ReportPanel;
    private Grib1TablePanel grib1TablePanel;
    private Grib2CollectionOpPanel grib2CollectionPanel;
    private Grib2TablePanel grib2TablePanel;
    private ReportOpPanel grib2ReportPanel;
    private Grib1DataOpPanel grib1DataPanel;
    private Grib2DataOpPanel grib2DataPanel;
    private Hdf5ObjectPanel hdf5ObjectPanel;
    private Hdf5DataPanel hdf5DataPanel;
    private Hdf4Panel hdf4Panel;
    private ImagePanel imagePanel;
    private NcStreamOpPanel ncStreamPanel;
    private NCdumpPanel ncdumpPanel;
    private NcmlEditorPanel ncmlEditorPanel;
    private PointFeaturePanel pointFeaturePanel;
    private SimpleGeomPanel simpleGeomPanel;
    private StationRadialPanel stationRadialPanel;
    private RadialPanel radialPanel;
    private ThreddsUI threddsUI;
    private UnitsPanel unitsPanel;
    private URLDumpPane urlPanel;
    private WmoCCPanel wmoCommonCodePanel;
    private WmsPanel wmsPanel;
    private final DataFactory threddsDataFactory = new DataFactory();
    private boolean useRecordStructure;
    private DiskCache2Form diskCache2Form;
    private final DebugFlags debugFlags;
    private String downloadStatus;

    private ToolsUI(PreferencesExt prefs, JFrame parentFrame) {
        this.mainPrefs = prefs;
        this.parentFrame = parentFrame;
        FileFilter[] filters = new FileFilter[]{new FileManager.HDF5ExtFilter(), new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parentFrame, null, filters, (PreferencesExt)prefs.node("FileManager"));
        OpPanel.setFileChooser(this.fileChooser);
        this.tabbedPane = new JTabbedPane(1);
        this.iospTabPane = new JTabbedPane(1);
        this.gribTabPane = new JTabbedPane(1);
        this.grib2TabPane = new JTabbedPane(1);
        this.grib1TabPane = new JTabbedPane(1);
        this.bufrTabPane = new JTabbedPane(1);
        this.ftTabPane = new JTabbedPane(1);
        this.fcTabPane = new JTabbedPane(1);
        this.fmrcTabPane = new JTabbedPane(1);
        this.hdf5TabPane = new JTabbedPane(1);
        this.ncmlTabPane = new JTabbedPane(1);
        this.viewerPanel = new DatasetViewerPanel((PreferencesExt)this.mainPrefs.node("varTable"), false);
        this.tabbedPane.addTab("Viewer", this.viewerPanel);
        this.tabbedPane.addTab("Writer", new JLabel("Writer"));
        this.tabbedPane.addTab("NCDump", new JLabel("NCDump"));
        this.tabbedPane.addTab("Iosp", this.iospTabPane);
        this.tabbedPane.addTab("CoordSys", new JLabel("CoordSys"));
        this.tabbedPane.addTab("FeatureTypes", this.ftTabPane);
        this.tabbedPane.addTab("THREDDS", new JLabel("THREDDS"));
        this.tabbedPane.addTab("Fmrc", this.fmrcTabPane);
        this.tabbedPane.addTab("GeoTiff", new JLabel("GeoTiff"));
        this.tabbedPane.addTab("Units", new JLabel("Units"));
        this.tabbedPane.addTab("NcML", this.ncmlTabPane);
        this.tabbedPane.addTab("URLdump", new JLabel("URLdump"));
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(e -> {
            Component c = this.tabbedPane.getSelectedComponent();
            if (c instanceof JLabel) {
                int idx = this.tabbedPane.getSelectedIndex();
                String title = this.tabbedPane.getTitleAt(idx);
                this.makeComponent(this.tabbedPane, title);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.iospTabPane.addTab("BUFR", this.bufrTabPane);
        this.iospTabPane.addTab("GRIB", this.gribTabPane);
        this.iospTabPane.addTab("GRIB2", this.grib2TabPane);
        this.iospTabPane.addTab("GRIB1", this.grib1TabPane);
        this.iospTabPane.addTab("HDF5", this.hdf5TabPane);
        this.iospTabPane.addTab("HDF4", new JLabel("HDF4"));
        this.iospTabPane.addTab("NcStream", new JLabel("NcStream"));
        this.iospTabPane.addTab("CdmrFeature", new JLabel("CdmrFeature"));
        this.addListeners(this.iospTabPane);
        this.bufrTabPane.addTab("BUFR", new JLabel("BUFR"));
        this.bufrTabPane.addTab("BufrCdmIndex", new JLabel("BufrCdmIndex"));
        this.bufrTabPane.addTab("BUFRTableB", new JLabel("BUFRTableB"));
        this.bufrTabPane.addTab("BUFRTableD", new JLabel("BUFRTableD"));
        this.bufrTabPane.addTab("BUFR-CODES", new JLabel("BUFR-CODES"));
        this.bufrTabPane.addTab("BufrReports", new JLabel("BufrReports"));
        this.addListeners(this.bufrTabPane);
        this.gribTabPane.addTab("CdmIndex4", new JLabel("CdmIndex4"));
        this.gribTabPane.addTab("CdmIndexReport", new JLabel("CdmIndexReport"));
        this.gribTabPane.addTab("GribIndex", new JLabel("GribIndex"));
        this.gribTabPane.addTab("WMO-COMMON", new JLabel("WMO-COMMON"));
        this.gribTabPane.addTab("WMO-CODES", new JLabel("WMO-CODES"));
        this.gribTabPane.addTab("WMO-TEMPLATES", new JLabel("WMO-TEMPLATES"));
        this.gribTabPane.addTab("GRIB-Rewrite", new JLabel("GRIB-Rewrite"));
        this.addListeners(this.gribTabPane);
        this.grib2TabPane.addTab("GRIB2collection", new JLabel("GRIB2collection"));
        this.grib2TabPane.addTab("GRIB2-REPORT", new JLabel("GRIB2-REPORT"));
        this.grib2TabPane.addTab("GRIB2data", new JLabel("GRIB2data"));
        this.grib2TabPane.addTab("GRIB2-TABLES", new JLabel("GRIB2-TABLES"));
        this.addListeners(this.grib2TabPane);
        this.grib1TabPane.addTab("GRIB1collection", new JLabel("GRIB1collection"));
        this.grib1TabPane.addTab("GRIB-FILES", new JLabel("GRIB-FILES"));
        this.grib1TabPane.addTab("GRIB1-REPORT", new JLabel("GRIB1-REPORT"));
        this.grib1TabPane.addTab("GRIB1data", new JLabel("GRIB1data"));
        this.grib1TabPane.addTab("GRIB1-TABLES", new JLabel("GRIB1-TABLES"));
        this.addListeners(this.grib1TabPane);
        this.hdf5TabPane.addTab("HDF5-Objects", new JLabel("HDF5-Objects"));
        this.hdf5TabPane.addTab("HDF5-Data", new JLabel("HDF5-Data"));
        this.hdf5TabPane.addTab("Netcdf4-JNI", new JLabel("Netcdf4-JNI"));
        this.addListeners(this.hdf5TabPane);
        this.ftTabPane.addTab("Grids", new JLabel("Grids"));
        this.ftTabPane.addTab("Coverages", new JLabel("Coverages"));
        this.ftTabPane.addTab("SimpleGeometry", new JLabel("SimpleGeometry"));
        this.ftTabPane.addTab("WMS", new JLabel("WMS"));
        this.ftTabPane.addTab("PointFeature", new JLabel("PointFeature"));
        this.ftTabPane.addTab("Images", new JLabel("Images"));
        this.ftTabPane.addTab("Radial", new JLabel("Radial"));
        this.ftTabPane.addTab("FeatureScan", new JLabel("FeatureScan"));
        this.ftTabPane.addTab("FeatureCollection", this.fcTabPane);
        this.addListeners(this.ftTabPane);
        this.fcTabPane.addTab("DirectoryPartition", new JLabel("DirectoryPartition"));
        this.fcTabPane.addTab("CollectionSpec", new JLabel("CollectionSpec"));
        this.addListeners(this.fcTabPane);
        this.fmrcTabPane.addTab("Fmrc", new JLabel("Fmrc"));
        this.fmrcTabPane.addTab("Collections", new JLabel("Collections"));
        this.addListeners(this.fmrcTabPane);
        this.ncmlTabPane.addTab("NcmlEditor", new JLabel("NcmlEditor"));
        this.ncmlTabPane.addTab("Aggregation", new JLabel("Aggregation"));
        this.addListeners(this.ncmlTabPane);
        this.debugFlags = (DebugFlags)Proxy.newProxyInstance(DebugFlags.class.getClassLoader(), new Class[]{DebugFlags.class}, (InvocationHandler)new DebugProxyHandler());
        JMenuBar mb = this.makeMenuBar();
        parentFrame.setJMenuBar(mb);
        this.setDebugFlags();
    }

    private void addListeners(final JTabbedPane tabPane) {
        tabPane.addChangeListener(e -> {
            Component c = tabPane.getSelectedComponent();
            if (c instanceof JLabel) {
                int idx = tabPane.getSelectedIndex();
                String title = tabPane.getTitleAt(idx);
                this.makeComponent(tabPane, title);
            }
        });
        tabPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component c = tabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = tabPane.getSelectedIndex();
                    String title = tabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(tabPane, title);
                }
            }
        });
    }

    private void makeComponent(JTabbedPane parent, String title) {
        Object c;
        String cTitle;
        int idx;
        if (parent == null) {
            parent = this.tabbedPane;
        }
        int n = parent.getTabCount();
        for (idx = 0; idx < n && !(cTitle = parent.getTitleAt(idx)).equals(title); ++idx) {
        }
        if (idx >= n) {
            log.debug("Cant find {} in {}", (Object)title, (Object)parent);
            return;
        }
        switch (title) {
            case "Aggregation": {
                this.aggPanel = new AggPanel((PreferencesExt)this.mainPrefs.node("NcMLAggregation"));
                c = this.aggPanel;
                break;
            }
            case "BUFR": {
                this.bufrPanel = new BufrPanel((PreferencesExt)this.mainPrefs.node("bufr"));
                c = this.bufrPanel;
                break;
            }
            case "BUFRTableB": {
                this.bufrTableBPanel = new BufrTableBPanel((PreferencesExt)this.mainPrefs.node("bufr2"));
                c = this.bufrTableBPanel;
                break;
            }
            case "BUFRTableD": {
                this.bufrTableDPanel = new BufrTableDPanel((PreferencesExt)this.mainPrefs.node("bufrD"));
                c = this.bufrTableDPanel;
                break;
            }
            case "BufrReports": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("bufrReports");
                BufrReportPanel rp = new BufrReportPanel(prefs);
                this.bufrReportPanel = new ReportOpPanel(prefs, rp);
                c = this.bufrReportPanel;
                break;
            }
            case "BUFR-CODES": {
                this.bufrCodePanel = new BufrCodePanel((PreferencesExt)this.mainPrefs.node("bufr-codes"));
                c = this.bufrCodePanel;
                break;
            }
            case "CdmrFeature": {
                this.cdmremotePanel = new CdmrFeatureOpPanel((PreferencesExt)this.mainPrefs.node("CdmrFeature"));
                c = this.cdmremotePanel;
                break;
            }
            case "CollectionSpec": {
                this.fcPanel = new CollectionSpecPanel((PreferencesExt)this.mainPrefs.node("collSpec"));
                c = this.fcPanel;
                break;
            }
            case "DirectoryPartition": {
                this.dirPartPanel = new DirectoryPartitionPanel((PreferencesExt)this.mainPrefs.node("dirPartition"));
                c = this.dirPartPanel;
                break;
            }
            case "NcStream": {
                this.ncStreamPanel = new NcStreamOpPanel((PreferencesExt)this.mainPrefs.node("NcStream"));
                c = this.ncStreamPanel;
                break;
            }
            case "GRIB1collection": {
                this.grib1CollectionPanel = new Grib1CollectionOpPanel((PreferencesExt)this.mainPrefs.node("grib1raw"));
                c = this.grib1CollectionPanel;
                break;
            }
            case "GRIB1data": {
                this.grib1DataPanel = new Grib1DataOpPanel((PreferencesExt)this.mainPrefs.node("grib1Data"));
                c = this.grib1DataPanel;
                break;
            }
            case "GRIB-FILES": {
                this.gribFilesPanel = new GribFilesOpPanel((PreferencesExt)this.mainPrefs.node("gribFiles"));
                c = this.gribFilesPanel;
                break;
            }
            case "GRIB2collection": {
                this.grib2CollectionPanel = new Grib2CollectionOpPanel((PreferencesExt)this.mainPrefs.node("gribNew"));
                c = this.grib2CollectionPanel;
                break;
            }
            case "GRIB2data": {
                this.grib2DataPanel = new Grib2DataOpPanel((PreferencesExt)this.mainPrefs.node("grib2Data"));
                c = this.grib2DataPanel;
                break;
            }
            case "BufrCdmIndex": {
                this.bufrCdmIndexPanel = new BufrCdmIndexOpPanel((PreferencesExt)this.mainPrefs.node("bufrCdmIdx"));
                c = this.bufrCdmIndexPanel;
                break;
            }
            case "CdmIndex4": {
                this.cdmIndexPanel = new CdmIndexOpPanel((PreferencesExt)this.mainPrefs.node("cdmIdx3"));
                c = this.cdmIndexPanel;
                break;
            }
            case "CdmIndexReport": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("CdmIndexReport");
                CdmIndexReportPanel rp = new CdmIndexReportPanel(prefs);
                this.cdmIndexReportPanel = new ReportOpPanel(prefs, rp);
                c = this.cdmIndexReportPanel;
                break;
            }
            case "GribIndex": {
                this.gribIdxPanel = new GribIndexOpPanel((PreferencesExt)this.mainPrefs.node("gribIdx"));
                c = this.gribIdxPanel;
                break;
            }
            case "GRIB1-REPORT": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("grib1Report");
                Grib1ReportPanel rp = new Grib1ReportPanel(prefs);
                this.grib1ReportPanel = new ReportOpPanel(prefs, rp);
                c = this.grib1ReportPanel;
                break;
            }
            case "GRIB2-REPORT": {
                PreferencesExt prefs = (PreferencesExt)this.mainPrefs.node("gribReport");
                Grib2ReportPanel rp = new Grib2ReportPanel(prefs);
                this.grib2ReportPanel = new ReportOpPanel(prefs, rp);
                c = this.grib2ReportPanel;
                break;
            }
            case "WMO-COMMON": {
                this.wmoCommonCodePanel = new WmoCCPanel((PreferencesExt)this.mainPrefs.node("wmo-common"));
                c = this.wmoCommonCodePanel;
                break;
            }
            case "WMO-CODES": {
                this.gribCodePanel = new GribCodePanel((PreferencesExt)this.mainPrefs.node("wmo-codes"));
                c = this.gribCodePanel;
                break;
            }
            case "WMO-TEMPLATES": {
                this.gribTemplatePanel = new GribTemplatePanel((PreferencesExt)this.mainPrefs.node("wmo-templates"));
                c = this.gribTemplatePanel;
                break;
            }
            case "GRIB1-TABLES": {
                this.grib1TablePanel = new Grib1TablePanel((PreferencesExt)this.mainPrefs.node("grib1-tables"));
                c = this.grib1TablePanel;
                break;
            }
            case "GRIB2-TABLES": {
                this.grib2TablePanel = new Grib2TablePanel((PreferencesExt)this.mainPrefs.node("grib2-tables"));
                c = this.grib2TablePanel;
                break;
            }
            case "GRIB-Rewrite": {
                this.gribRewritePanel = new GribRewriteOpPanel((PreferencesExt)this.mainPrefs.node("grib-rewrite"));
                c = this.gribRewritePanel;
                break;
            }
            case "CoordSys": {
                this.coordSysPanel = new CoordSysPanel((PreferencesExt)this.mainPrefs.node("CoordSys"));
                c = this.coordSysPanel;
                break;
            }
            case "FeatureScan": {
                this.ftPanel = new FeatureScanOpPanel((PreferencesExt)this.mainPrefs.node("ftPanel"));
                c = this.ftPanel;
                break;
            }
            case "GeoTiff": {
                this.geotiffPanel = new GeotiffPanel((PreferencesExt)this.mainPrefs.node("WCS"));
                c = this.geotiffPanel;
                break;
            }
            case "Grids": {
                this.gridPanel = new GeoGridPanel((PreferencesExt)this.mainPrefs.node("grid"));
                c = this.gridPanel;
                break;
            }
            case "SimpleGeometry": {
                this.simpleGeomPanel = new SimpleGeomPanel((PreferencesExt)this.mainPrefs.node("simpleGeom"));
                c = this.simpleGeomPanel;
                break;
            }
            case "Coverages": {
                this.coveragePanel = new CoveragePanel((PreferencesExt)this.mainPrefs.node("coverage2"));
                c = this.coveragePanel;
                break;
            }
            case "HDF5-Objects": {
                this.hdf5ObjectPanel = new Hdf5ObjectPanel((PreferencesExt)this.mainPrefs.node("hdf5"));
                c = this.hdf5ObjectPanel;
                break;
            }
            case "HDF5-Data": {
                this.hdf5DataPanel = new Hdf5DataPanel((PreferencesExt)this.mainPrefs.node("hdf5data"));
                c = this.hdf5DataPanel;
                break;
            }
            case "Netcdf4-JNI": {
                c = this.nc4viewer = new DatasetViewerPanel((PreferencesExt)this.mainPrefs.node("nc4viewer"), true);
                break;
            }
            case "HDF4": {
                this.hdf4Panel = new Hdf4Panel((PreferencesExt)this.mainPrefs.node("hdf4"));
                c = this.hdf4Panel;
                break;
            }
            case "Images": {
                this.imagePanel = new ImagePanel((PreferencesExt)this.mainPrefs.node("images"));
                c = this.imagePanel;
                break;
            }
            case "Fmrc": {
                this.fmrcPanel = new FmrcPanel((PreferencesExt)this.mainPrefs.node("fmrc2"));
                c = this.fmrcPanel;
                break;
            }
            case "NCDump": {
                this.ncdumpPanel = new NCdumpPanel((PreferencesExt)this.mainPrefs.node("NCDump"));
                c = this.ncdumpPanel;
                break;
            }
            case "NcmlEditor": {
                this.ncmlEditorPanel = new NcmlEditorPanel((PreferencesExt)this.mainPrefs.node("NcmlEditor"));
                c = this.ncmlEditorPanel;
                break;
            }
            case "PointFeature": {
                this.pointFeaturePanel = new PointFeaturePanel((PreferencesExt)this.mainPrefs.node("pointFeature"));
                c = this.pointFeaturePanel;
                break;
            }
            case "Radial": {
                this.radialPanel = new RadialPanel((PreferencesExt)this.mainPrefs.node("radial"));
                c = this.radialPanel;
                break;
            }
            case "StationRadial": {
                this.stationRadialPanel = new StationRadialPanel((PreferencesExt)this.mainPrefs.node("stationRadar"));
                c = this.stationRadialPanel;
                break;
            }
            case "THREDDS": {
                this.threddsUI = new ThreddsUI(this.parentFrame, (PreferencesExt)this.mainPrefs.node("thredds"));
                this.threddsUI.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if (e.getPropertyName().equals("InvAccess")) {
                            Access access = (Access)e.getNewValue();
                            ToolsUI.this.jumptoThreddsDatatype(access);
                        }
                        if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("CoordSys") || e.getPropertyName().equals("File")) {
                            Dataset ds = (Dataset)e.getNewValue();
                            ToolsUI.this.setThreddsDatatype(ds, e.getPropertyName());
                        }
                    }
                });
                c = this.threddsUI;
                break;
            }
            case "Units": {
                this.unitsPanel = new UnitsPanel((PreferencesExt)this.mainPrefs.node("units"));
                c = this.unitsPanel;
                break;
            }
            case "URLdump": {
                this.urlPanel = new URLDumpPane((PreferencesExt)this.mainPrefs.node("urlDump"));
                c = this.urlPanel;
                break;
            }
            case "Viewer": {
                c = this.viewerPanel;
                break;
            }
            case "Writer": {
                this.writerPanel = new DatasetWriterPanel((PreferencesExt)this.mainPrefs.node("writer"));
                c = this.writerPanel;
                break;
            }
            case "WMS": {
                this.wmsPanel = new WmsPanel((PreferencesExt)this.mainPrefs.node("wms"));
                c = this.wmsPanel;
                break;
            }
            default: {
                log.warn("tabbedPane unknown component {}", (Object)title);
                return;
            }
        }
        parent.setComponentAt(idx, (Component)c);
        log.trace("tabbedPane changed {} added ", (Object)title);
    }

    private JMenuBar makeMenuBar() {
        JMenuBar mb = new JMenuBar();
        SystemMenu sysMenu = new SystemMenu(this);
        mb.add(sysMenu);
        ModesMenu modeMenu = new ModesMenu(this);
        mb.add(modeMenu);
        DebugMenu debugMenu = new DebugMenu(this);
        mb.add(debugMenu);
        HelpMenu helpMenu = new HelpMenu(this);
        mb.add(helpMenu);
        return mb;
    }

    public DatasetViewerPanel getDatasetViewerPanel() {
        return this.viewerPanel;
    }

    public void setDebugFlags() {
        log.debug("setDebugFlags");
        NetcdfFile.setDebugFlags((DebugFlags)this.debugFlags);
        H5iosp.setDebugFlags((DebugFlags)this.debugFlags);
        NcMLReader.setDebugFlags((DebugFlags)this.debugFlags);
        DODSNetcdfFile.setDebugFlags((DebugFlags)this.debugFlags);
        CdmRemote.setDebugFlags((DebugFlags)this.debugFlags);
        Nc4Iosp.setDebugFlags((DebugFlags)this.debugFlags);
        DataFactory.setDebugFlags((DebugFlags)this.debugFlags);
        FileWriter2.setDebugFlags((DebugFlags)this.debugFlags);
        PointDatasetStandardFactory.setDebugFlags((DebugFlags)this.debugFlags);
        Grib.setDebugFlags((DebugFlags)this.debugFlags);
    }

    public void setUseRecordStructure(boolean use) {
        this.useRecordStructure = use;
    }

    public void setGribDiskCache() {
        if (this.diskCache2Form == null) {
            this.diskCache2Form = new DiskCache2Form((Frame)this.parentFrame, GribIndexCache.getDiskCache2());
        }
        this.diskCache2Form.setVisible(true);
    }

    private void save() {
        this.fileChooser.save();
        if (this.aggPanel != null) {
            this.aggPanel.save();
        }
        if (this.bufrFileChooser != null) {
            this.bufrFileChooser.save();
        }
        if (this.bufrPanel != null) {
            this.bufrPanel.save();
        }
        if (this.bufrTableBPanel != null) {
            this.bufrTableBPanel.save();
        }
        if (this.bufrTableDPanel != null) {
            this.bufrTableDPanel.save();
        }
        if (this.bufrReportPanel != null) {
            this.bufrReportPanel.save();
        }
        if (this.bufrCodePanel != null) {
            this.bufrCodePanel.save();
        }
        if (this.coordSysPanel != null) {
            this.coordSysPanel.save();
        }
        if (this.coveragePanel != null) {
            this.coveragePanel.save();
        }
        if (this.cdmIndexPanel != null) {
            this.cdmIndexPanel.save();
        }
        if (this.cdmIndexReportPanel != null) {
            this.cdmIndexReportPanel.save();
        }
        if (this.cdmremotePanel != null) {
            this.cdmremotePanel.save();
        }
        if (this.dirPartPanel != null) {
            this.dirPartPanel.save();
        }
        if (this.bufrCdmIndexPanel != null) {
            this.bufrCdmIndexPanel.save();
        }
        if (this.fcPanel != null) {
            this.fcPanel.save();
        }
        if (this.ftPanel != null) {
            this.ftPanel.save();
        }
        if (this.fmrcPanel != null) {
            this.fmrcPanel.save();
        }
        if (this.geotiffPanel != null) {
            this.geotiffPanel.save();
        }
        if (this.gribFilesPanel != null) {
            this.gribFilesPanel.save();
        }
        if (this.grib2CollectionPanel != null) {
            this.grib2CollectionPanel.save();
        }
        if (this.grib2DataPanel != null) {
            this.grib2DataPanel.save();
        }
        if (this.grib1DataPanel != null) {
            this.grib1DataPanel.save();
        }
        if (this.gribCodePanel != null) {
            this.gribCodePanel.save();
        }
        if (this.gribIdxPanel != null) {
            this.gribIdxPanel.save();
        }
        if (this.gribTemplatePanel != null) {
            this.gribTemplatePanel.save();
        }
        if (this.grib1CollectionPanel != null) {
            this.grib1CollectionPanel.save();
        }
        if (this.grib1ReportPanel != null) {
            this.grib1ReportPanel.save();
        }
        if (this.grib2ReportPanel != null) {
            this.grib2ReportPanel.save();
        }
        if (this.grib1TablePanel != null) {
            this.grib1TablePanel.save();
        }
        if (this.grib2TablePanel != null) {
            this.grib2TablePanel.save();
        }
        if (this.gribRewritePanel != null) {
            this.gribRewritePanel.save();
        }
        if (this.gridPanel != null) {
            this.gridPanel.save();
        }
        if (this.hdf5ObjectPanel != null) {
            this.hdf5ObjectPanel.save();
        }
        if (this.hdf5DataPanel != null) {
            this.hdf5DataPanel.save();
        }
        if (this.hdf4Panel != null) {
            this.hdf4Panel.save();
        }
        if (this.imagePanel != null) {
            this.imagePanel.save();
        }
        if (this.ncdumpPanel != null) {
            this.ncdumpPanel.save();
        }
        if (this.ncStreamPanel != null) {
            this.ncStreamPanel.save();
        }
        if (this.nc4viewer != null) {
            this.nc4viewer.save();
        }
        if (this.ncmlEditorPanel != null) {
            this.ncmlEditorPanel.save();
        }
        if (this.pointFeaturePanel != null) {
            this.pointFeaturePanel.save();
        }
        if (this.radialPanel != null) {
            this.radialPanel.save();
        }
        if (this.stationRadialPanel != null) {
            this.stationRadialPanel.save();
        }
        if (this.threddsUI != null) {
            this.threddsUI.storePersistentData();
        }
        if (this.unitsPanel != null) {
            this.unitsPanel.save();
        }
        if (this.urlPanel != null) {
            this.urlPanel.save();
        }
        if (this.viewerPanel != null) {
            this.viewerPanel.save();
        }
        if (this.writerPanel != null) {
            this.writerPanel.save();
        }
        if (this.wmoCommonCodePanel != null) {
            this.wmoCommonCodePanel.save();
        }
        if (this.wmsPanel != null) {
            this.wmsPanel.save();
        }
    }

    public static ToolsUI getToolsUI() {
        return ui;
    }

    public static JFrame getToolsFrame() {
        return ui.getFramePriv();
    }

    private JFrame getFramePriv() {
        return this.parentFrame;
    }

    public static DataFactory getThreddsDataFactory() {
        return ui.getThreddsDataFactoryPriv();
    }

    private DataFactory getThreddsDataFactoryPriv() {
        return this.threddsDataFactory;
    }

    public static FileManager getBufrFileChooser() {
        return ui.getBufrFileChooserPriv();
    }

    private FileManager getBufrFileChooserPriv() {
        if (this.bufrFileChooser == null) {
            this.bufrFileChooser = new FileManager(this.parentFrame, null, null, (PreferencesExt)this.mainPrefs.node("bufrFileManager"));
        }
        return this.bufrFileChooser;
    }

    public static void setNCdumpPanel(NetcdfFile ds) {
        ui.setNCdumpPanelPriv(ds);
    }

    private void setNCdumpPanelPriv(NetcdfFile ds) {
        if (this.ncdumpPanel == null) {
            log.debug("make ncdumpPanel");
            this.makeComponent(this.tabbedPane, "NCDump");
        }
        this.ncdumpPanel.setNetcdfFile(ds);
        this.tabbedPane.setSelectedComponent(this.ncdumpPanel);
    }

    public static Object getPrefsBean(String key, Object defaultVal) {
        return ui.getPrefsBeanPriv(key, defaultVal);
    }

    private Object getPrefsBeanPriv(String key, Object defaultVal) {
        return this.mainPrefs.getBean(key, defaultVal);
    }

    public static void putPrefsBeanObject(String key, Object newVal) {
        ui.putPrefsBeanObjectPriv(key, newVal);
    }

    private void putPrefsBeanObjectPriv(String key, Object newVal) {
        this.mainPrefs.putBean(key, newVal);
    }

    public void openNetcdfFile(String datasetName) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    public void openNetcdfFile(NetcdfFile ncfile) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.setDataset(ncfile);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    public void openCoordSystems(String datasetName) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    public void openCoordSystems(NetcdfDataset dataset) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    public void openNcML(String datasetName) {
        this.makeComponent(this.ncmlTabPane, "NcmlEditor");
        this.ncmlEditorPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ncmlTabPane);
        this.ncmlTabPane.setSelectedComponent(this.ncmlEditorPanel);
    }

    public void openPointFeatureDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "PointFeature");
        this.pointFeaturePanel.setPointFeatureDataset(FeatureType.ANY_POINT, datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.pointFeaturePanel);
    }

    public void openGrib1Collection(String collection) {
        this.makeComponent(this.grib1TabPane, "GRIB1collection");
        this.grib1CollectionPanel.setCollection(collection);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib1TabPane);
        this.grib1TabPane.setSelectedComponent(this.grib1CollectionPanel);
    }

    public void openGrib2Collection(String collection) {
        this.makeComponent(this.grib2TabPane, "GRIB2collection");
        this.grib2CollectionPanel.setCollection(collection);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib2TabPane);
        this.grib2TabPane.setSelectedComponent(this.grib2CollectionPanel);
    }

    public void openGrib2Data(String datasetName) {
        this.makeComponent(this.grib2TabPane, "GRIB2data");
        this.grib2DataPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib2TabPane);
        this.grib2TabPane.setSelectedComponent(this.grib2DataPanel);
    }

    public void openGrib1Data(String datasetName) {
        this.makeComponent(this.grib1TabPane, "GRIB1data");
        this.grib1DataPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.iospTabPane);
        this.iospTabPane.setSelectedComponent(this.grib1TabPane);
        this.grib1TabPane.setSelectedComponent(this.grib1DataPanel);
    }

    public void openGridDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    public void openCoverageDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Coverages");
        this.coveragePanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.coveragePanel);
    }

    public void openGridDataset(NetcdfDataset dataset) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    public void openGridDataset(GridDataset dataset) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    public void openRadialDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Radial");
        this.radialPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.radialPanel);
    }

    private void openWMSDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "WMS");
        this.wmsPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.wmsPanel);
    }

    private void setThreddsDatatype(Dataset invDataset, String wants) {
        if (invDataset == null) {
            return;
        }
        boolean wantsViewer = wants.equals("File");
        boolean wantsCoordSys = wants.equals("CoordSys");
        try {
            if (wantsViewer) {
                this.openNetcdfFile((NetcdfFile)this.threddsDataFactory.openDataset(invDataset, true, null, null));
                return;
            }
            if (wantsCoordSys) {
                NetcdfDataset ncd = this.threddsDataFactory.openDataset(invDataset, true, null, null);
                ncd.enhance();
                this.openCoordSystems(ncd);
                return;
            }
            DataFactory.Result threddsData = this.threddsDataFactory.openFeatureDataset(invDataset, null);
            if (threddsData.fatalError) {
                JOptionPane.showMessageDialog(null, "Failed to open err=" + threddsData.errLog);
                return;
            }
            this.jumptoThreddsDatatype(threddsData);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void jumptoThreddsDatatype(Access invAccess) {
        if (invAccess == null) {
            return;
        }
        Service s = invAccess.getService();
        if (s.getType() == ServiceType.HTTPServer) {
            this.downloadFile(invAccess.getStandardUrlName());
            return;
        }
        if (s.getType() == ServiceType.WMS) {
            this.openWMSDataset(invAccess.getStandardUrlName());
            return;
        }
        if (s.getType() == ServiceType.CdmrFeature) {
            this.openCoverageDataset(invAccess.getWrappedUrlName());
            return;
        }
        Dataset ds = invAccess.getDataset();
        if (ds.getFeatureType() == null) {
            try {
                this.openNetcdfFile((NetcdfFile)this.threddsDataFactory.openDataset(invAccess, true, null, null));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
            }
            return;
        }
        try {
            DataFactory.Result threddsData = this.threddsDataFactory.openFeatureDataset(invAccess, null);
            if (threddsData.fatalError) {
                JOptionPane.showMessageDialog(null, "Failed to open err=" + threddsData.errLog);
                return;
            }
            this.jumptoThreddsDatatype(threddsData);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error on setThreddsDatatype = " + ioe.getMessage());
        }
    }

    private void jumptoThreddsDatatype(DataFactory.Result threddsData) {
        if (threddsData.fatalError) {
            JOptionPane.showMessageDialog(this, "Cant open dataset=" + threddsData.errLog);
            try {
                threddsData.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if (threddsData.featureType.isCoverageFeatureType()) {
            if (threddsData.featureDataset instanceof FeatureDatasetCoverage) {
                this.makeComponent(this.ftTabPane, "Coverages");
                this.coveragePanel.setDataset(threddsData.featureDataset);
                this.tabbedPane.setSelectedComponent(this.ftTabPane);
                this.ftTabPane.setSelectedComponent(this.coveragePanel);
            } else if (threddsData.featureDataset instanceof GridDataset) {
                this.makeComponent(this.ftTabPane, "Grids");
                this.gridPanel.setDataset((GridDataset)threddsData.featureDataset);
                this.tabbedPane.setSelectedComponent(this.ftTabPane);
                this.ftTabPane.setSelectedComponent(this.gridPanel);
            }
        } else if (threddsData.featureType == FeatureType.IMAGE) {
            this.makeComponent(this.ftTabPane, "Images");
            this.imagePanel.setImageLocation(threddsData.imageURL);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.imagePanel);
        } else if (threddsData.featureType == FeatureType.RADIAL) {
            this.makeComponent(this.ftTabPane, "Radial");
            this.radialPanel.setDataset((RadialDatasetSweep)threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.radialPanel);
        } else if (threddsData.featureType.isPointFeatureType()) {
            this.makeComponent(this.ftTabPane, "PointFeature");
            this.pointFeaturePanel.setPointFeatureDataset((FeatureDatasetPoint)((PointDatasetImpl)threddsData.featureDataset));
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.pointFeaturePanel);
        } else if (threddsData.featureType == FeatureType.STATION_RADIAL) {
            this.makeComponent(this.ftTabPane, "StationRadial");
            this.stationRadialPanel.setStationRadialDataset(threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.stationRadialPanel);
        }
    }

    public NetcdfFile openFile(String location, boolean addCoords, CancelTask task) {
        Object ncfile = null;
        try {
            DatasetUrl durl = DatasetUrl.findDatasetUrl((String)location);
            ncfile = addCoords ? NetcdfDataset.acquireDataset((DatasetUrl)durl, (boolean)true, (CancelTask)task) : NetcdfDataset.acquireFile((DatasetUrl)durl, (CancelTask)task);
            if (ncfile == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cannot open " + location);
            } else if (this.useRecordStructure) {
                ncfile.sendIospMessage((Object)"AddRecordStructure");
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (null == message && ioe instanceof EOFException) {
                message = "Premature End of File";
            }
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cannot open " + location + "%n" + message);
            if (!(ioe instanceof FileNotFoundException)) {
                ioe.printStackTrace();
            }
            ncfile = null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cannot open " + location + "%n" + e.getMessage());
            log.error("NetcdfDataset.open cannot open " + location, (Throwable)e);
            e.printStackTrace();
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException ee) {
                System.out.printf("close failed%n", new Object[0]);
            }
            ncfile = null;
        }
        return ncfile;
    }

    private void downloadFile(String urlString) {
        int pos = urlString.lastIndexOf(47);
        String defFilename = pos >= 0 ? urlString.substring(pos) : urlString;
        String fileOutName = this.fileChooser.chooseFilename(defFilename);
        if (fileOutName == null) {
            return;
        }
        String[] values = new String[]{fileOutName, urlString};
        GetDataRunnable runner = new GetDataRunnable(){

            @Override
            public void run(Object o) {
                String[] values = (String[])o;
                try (FileOutputStream fos = new FileOutputStream(values[0]);){
                    BufferedOutputStream out = new BufferedOutputStream(fos, 60000);
                    IO.copyUrlB((String)values[1], (OutputStream)out, (int)60000);
                    ToolsUI.this.downloadStatus = values[1] + " written to " + values[0];
                }
                catch (IOException ioe) {
                    ToolsUI.this.downloadStatus = "Error opening " + values[0] + " and reading " + values[1] + "%n" + ioe.getMessage();
                }
            }
        };
        GetDataTask task = new GetDataTask(runner, urlString, values);
        ProgressMonitor pm = new ProgressMonitor((ProgressMonitorTask)task);
        pm.addActionListener(e -> {
            JOptionPane.showMessageDialog(null, e.getActionCommand() + "%n" + this.downloadStatus);
            this.downloadStatus = null;
        });
        pm.start((Component)this, "Download", 30);
    }

    public static void exit() {
        ToolsUI.doSavePrefsAndUI();
        System.exit(0);
    }

    private static void doSavePrefsAndUI() {
        ui.save();
        Rectangle bounds = frame.getBounds();
        prefs.putBeanObject(FRAME_SIZE, (Object)bounds);
        try {
            store.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        done = true;
        FileCacheIF cache = NetcdfDataset.getNetcdfFileCache();
        if (cache != null) {
            cache.clearCache(true);
        }
        FileCache.shutdown();
        DiskCache2.exit();
    }

    private static void setDataset() {
        SwingUtilities.invokeLater(() -> {
            int pos = wantDataset.indexOf(35);
            if (pos > 0) {
                String catName = wantDataset.substring(0, pos);
                if (catName.endsWith(".xml")) {
                    ui.makeComponent(null, "THREDDS");
                    ToolsUI.ui.threddsUI.setDataset(wantDataset);
                    ToolsUI.ui.tabbedPane.setSelectedComponent(ToolsUI.ui.threddsUI);
                }
                return;
            }
            ui.openNetcdfFile(wantDataset);
        });
    }

    private static void prepareGui() {
        block5: {
            String osName = System.getProperty("os.name").toLowerCase();
            boolean isMacOs = osName.startsWith("mac os x");
            if (isMacOs) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                Runtime.getRuntime().addShutdownHook(new Thread(ToolsUI::doSavePrefsAndUI));
            } else {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception exc) {
                    log.warn("Unable to apply Nimbus look-and-feel due to {}", (Object)exc.toString());
                    if (!log.isTraceEnabled()) break block5;
                    exc.printStackTrace();
                }
            }
        }
        SwingUtilities.invokeLater(() -> {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Font f = new Font("SansSerif", 0, 12);
            FontMetrics fm = tk.getFontMetrics(f);
        });
    }

    private static void createToolsFrame() {
        frame = new JFrame("NetCDF (5.0) Tools");
        ui = new ToolsUI(prefs, frame);
        frame.setIconImage(BAMutil.getImage((String)"nj22/NetcdfUI"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ToolsSplashScreen.getSharedInstance().setVisible(false);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!done) {
                    ToolsUI.exit();
                }
            }
        });
        frame.getContentPane().add(ui);
        Rectangle have = frame.getGraphicsConfiguration().getBounds();
        Rectangle def = new Rectangle(50, 50, 800, 800);
        Rectangle want = (Rectangle)prefs.getBean(FRAME_SIZE, (Object)def);
        if (want.getX() > have.getWidth() - 25.0) {
            want = def;
        }
        frame.setBounds(want);
        frame.pack();
        frame.setBounds(want);
        if (wantDataset != null) {
            ToolsUI.setDataset();
        }
    }

    public static void main(String[] args) {
        String filename;
        File f;
        if (debugListen) {
            System.out.println("Arguments:");
            for (String arg2 : args) {
                System.out.println(" " + arg2);
            }
            HTTPSession.setInterceptors((boolean)true);
        }
        if (args.length > 0) {
            StringBuilder sbuff = new StringBuilder();
            for (String string : args) {
                sbuff.append(string);
                sbuff.append(" ");
            }
            String arguments = sbuff.toString();
            System.out.println("ToolsUI arguments=" + arguments);
            SocketMessage sm = new SocketMessage(14444, wantDataset);
            if (sm.isAlreadyRunning()) {
                log.error("ToolsUI already running - pass argument='{}' and exit", (Object)arguments);
                System.exit(0);
            }
        } else {
            String[] sm = new SocketMessage(14444, null);
            if (sm.isAlreadyRunning()) {
                System.out.println("ToolsUI already running - start up another copy");
            } else {
                sm.addEventListener(new SocketMessage.EventListener(){

                    @Override
                    public void setMessage(SocketMessage.Event event) {
                        wantDataset = event.getMessage();
                        if (debugListen) {
                            System.out.println(" got message= '" + wantDataset);
                        }
                        ToolsUI.setDataset();
                    }
                });
            }
        }
        if (debugListen) {
            System.out.println("Arguments:");
            for (String arg4 : args) {
                System.out.println(" " + arg4);
            }
            HTTPSession.setInterceptors((boolean)true);
        }
        boolean configRead = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-nj22Config") || i >= args.length - 1) continue;
            String runtimeConfig = args[i + 1];
            ++i;
            try {
                Throwable throwable = null;
                try (FileInputStream fis = new FileInputStream(runtimeConfig);){
                    StringBuilder errlog2 = new StringBuilder();
                    RuntimeConfigParser.read((InputStream)fis, (StringBuilder)errlog2);
                    configRead = true;
                    System.out.println(errlog2);
                    continue;
                }
                catch (Throwable errlog2) {
                    Throwable throwable2 = errlog2;
                    throw errlog2;
                }
            }
            catch (IOException ioe) {
                log.warn("Error reading {} = {}", (Object)runtimeConfig, (Object)ioe.getMessage());
            }
        }
        if (!configRead && (f = new File(filename = XMLStore.makeStandardFilename((String)".unidata", (String)"nj22Config.xml"))).exists()) {
            try {
                Throwable throwable = null;
                try (FileInputStream fis = new FileInputStream(filename);){
                    StringBuilder errlog = new StringBuilder();
                    RuntimeConfigParser.read((InputStream)fis, (StringBuilder)errlog);
                    System.out.println(errlog);
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException ioe) {
                log.warn("Error reading {} = {}", (Object)filename, (Object)ioe.getMessage());
            }
        }
        try {
            String prefStoreBack;
            File file;
            String prefStore = XMLStore.makeStandardFilename((String)".unidata", (String)"ToolsUI.xml");
            File prefs44 = new File(prefStore);
            if (!prefs44.exists() && (file = new File(prefStoreBack = XMLStore.makeStandardFilename((String)".unidata", (String)"NetcdfUI22.xml"))).exists()) {
                IO.copyFile((File)file, (File)prefs44);
            }
            store = XMLStore.createFromFile((String)prefStore, null);
            prefs = store.getPreferences();
            Debug.setStore((Preferences)prefs.node("Debug"));
        }
        catch (IOException e) {
            log.warn("XMLStore creation failed - {}", (Object)e.toString());
        }
        ToolsUI.prepareGui();
        SwingUtilities.invokeLater(() -> ToolsSplashScreen.getSharedInstance().setVisible(true));
        Aggregation.setPersistenceCache((DiskCache2)new DiskCache2("/.unidata/aggCache", true, 43200, 60));
        DODSNetcdfFile.setAllowCompression((boolean)true);
        DODSNetcdfFile.setAllowSessions((boolean)true);
        RandomAccessFile.enableDefaultGlobalFileCache();
        GribCdmIndex.initDefaultCollectionCache((int)100, (int)200, (int)-1);
        try {
            Thread.sleep(2500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(() -> {
            ToolsUI.createToolsFrame();
            frame.setVisible(true);
        });
        SwingUtilities.invokeLater(() -> {
            UrlAuthenticatorDialog provider = new UrlAuthenticatorDialog(frame);
            try {
                HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider);
            }
            catch (HTTPException e) {
                log.error("Failed to set global credentials");
            }
            HTTPSession.setGlobalUserAgent((String)"ToolsUI v5.0");
            Authenticator.setDefault(provider);
        });
    }
}

