/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.VariableIF;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.MultilineTooltip;

public class DatasetTreeView
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JTree tree = new JTree(){

        @Override
        public JToolTip createToolTip() {
            return new MultilineTooltip();
        }
    };
    private DatasetTreeModel model;
    private NetcdfFile currentDataset;

    public DatasetTreeView() {
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(null, false)));
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreeNode node;
                int selRow = DatasetTreeView.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && (node = (TreeNode)DatasetTreeView.this.tree.getLastSelectedPathComponent()) instanceof VariableNode) {
                    VariableIF v = ((VariableNode)node).var;
                    DatasetTreeView.this.firePropertyChangeEvent(new PropertyChangeEvent(this, "Selection", null, v));
                }
                if (selRow == -1 || e.getClickCount() == 2) {
                    // empty if block
                }
            }
        });
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setToggleClickCount(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        this.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void setFile(NetcdfFile ds) {
        if (ds != this.currentDataset) {
            this.currentDataset = ds;
            this.model = new DatasetTreeModel(ds);
            this.tree.setModel(this.model);
        }
    }

    public void clear() {
        this.currentDataset = null;
        this.model = null;
        this.tree.setModel(null);
    }

    public void setSelected(VariableIF v) {
        if (v == null) {
            return;
        }
        ArrayList<VariableIF> vchain = new ArrayList<VariableIF>();
        vchain.add(v);
        VariableIF vp = v;
        while (vp.isMemberOfStructure()) {
            vp = vp.getParentStructure();
            vchain.add(0, vp);
        }
        ArrayList<Group> gchain = new ArrayList<Group>();
        Group gp = vp.getParentGroup();
        gchain.add(gp);
        while (gp.getParentGroup() != null) {
            gp = gp.getParentGroup();
            gchain.add(0, gp);
        }
        ArrayList<TreeNode> pathList = new ArrayList<TreeNode>();
        GroupNode gnode = (GroupNode)this.model.getRoot();
        pathList.add(gnode);
        for (int i = 1; i < gchain.size(); ++i) {
            Group parentGroup = (Group)gchain.get(i);
            gnode = gnode.findNestedGroup(parentGroup);
            assert (gnode != null);
            pathList.add(gnode);
        }
        vp = (VariableIF)vchain.get(0);
        VariableNode vnode = gnode.findNestedVariable(vp);
        if (vnode == null) {
            return;
        }
        pathList.add(vnode);
        for (int i = 1; i < vchain.size(); ++i) {
            vp = (VariableIF)vchain.get(i);
            if ((vnode = vnode.findNestedVariable(vp)) == null) {
                return;
            }
            pathList.add(vnode);
        }
        Object[] paths = pathList.toArray();
        TreePath treePath = new TreePath(paths);
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon structIcon = BAMutil.getIcon((String)"Structure", (boolean)true);
        ImageIcon dimIcon = BAMutil.getIcon((String)"nj22/Dimension", (boolean)true);
        String tooltipText;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof VariableNode) {
                VariableNode node = (VariableNode)value;
                this.tooltipText = node.getToolTipText();
                if (node.var instanceof Structure) {
                    Structure s = (Structure)node.var;
                    this.setIcon(this.structIcon);
                    this.tooltipText = s.getNameAndAttributes();
                } else {
                    this.tooltipText = node.getToolTipText();
                }
            } else if (value instanceof DimensionNode) {
                DimensionNode node = (DimensionNode)value;
                this.tooltipText = node.getToolTipText();
                this.setIcon(this.dimIcon);
            } else if (value instanceof GroupNode) {
                GroupNode node = (GroupNode)value;
                this.tooltipText = node.getToolTipText();
            }
            return c;
        }

        @Override
        public String getToolTipText() {
            return this.tooltipText;
        }
    }

    private static class DimensionNode
    implements TreeNode {
        private Dimension d;
        private TreeNode parent;

        DimensionNode(TreeNode parent, Dimension d) {
            this.parent = parent;
            this.d = d;
        }

        @Nullable
        public Enumeration children() {
            return null;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        @Nullable
        public TreeNode getChildAt(int index) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public int getIndex(TreeNode child) {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return this.d.getShortName();
        }

        public String getToolTipText() {
            return this.d.toString();
        }
    }

    private static class VariableNode
    implements TreeNode {
        private VariableIF var;
        private TreeNode parent;
        private List<Object> children;

        VariableNode(TreeNode parent, VariableIF var) {
            this.parent = parent;
            this.var = var;
            logger.debug("new var={}", (Object)var.getShortName());
        }

        public Enumeration children() {
            if (this.children == null) {
                this.makeChildren();
            }
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int index) {
            return (TreeNode)this.children.get(index);
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                this.makeChildren();
            }
            return this.children.size();
        }

        void makeChildren() {
            this.children = new ArrayList<Object>();
            if (this.var instanceof Structure) {
                Structure s = (Structure)this.var;
                List vars = s.getVariables();
                for (Object var1 : vars) {
                    this.children.add(new VariableNode(this, (VariableIF)var1));
                }
            }
            logger.debug("children={}", (Object)this.var.getShortName());
        }

        @Override
        public int getIndex(TreeNode child) {
            logger.debug("getIndex={} {}", (Object)this.var.getShortName(), (Object)child);
            return this.children.indexOf(child);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public String toString() {
            return this.var.getShortName();
        }

        @Nullable
        public VariableNode findNestedVariable(VariableIF v) {
            if (this.children == null) {
                this.makeChildren();
            }
            for (Object child : this.children) {
                VariableNode elem = (VariableNode)child;
                if (elem.var != v) continue;
                return elem;
            }
            return null;
        }

        public String getToolTipText() {
            return this.var.toString();
        }
    }

    private class GroupNode
    implements TreeNode {
        private Group group;
        private GroupNode parent;
        private List<Object> children;

        GroupNode(GroupNode parent, Group group) {
            this.parent = parent;
            this.group = group;
            logger.debug("new={}", (Object)group.getFullName());
        }

        public Enumeration children() {
            if (this.children == null) {
                this.makeChildren();
            }
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int index) {
            return (TreeNode)this.children.get(index);
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                this.makeChildren();
            }
            return this.children.size();
        }

        void makeChildren() {
            this.children = new ArrayList<Object>();
            List dims = this.group.getDimensions();
            for (Object dim : dims) {
                this.children.add(new DimensionNode(this, (Dimension)dim));
            }
            List vars = this.group.getVariables();
            for (Object var : vars) {
                this.children.add(new VariableNode(this, (VariableIF)var));
            }
            List groups = this.group.getGroups();
            for (Object group1 : groups) {
                this.children.add(new GroupNode(this, (Group)group1));
            }
            logger.debug("children={}", (Object)this.group.getFullName());
        }

        @Override
        public int getIndex(TreeNode child) {
            logger.debug("getIndex={} {}", (Object)this.group.getFullName(), (Object)child);
            return this.children.indexOf(child);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            if (this.parent == null) {
                return DatasetTreeView.this.currentDataset.getLocation();
            }
            return this.group.getShortName();
        }

        @Nullable
        public GroupNode findNestedGroup(Group g) {
            if (this.children == null) {
                this.makeChildren();
            }
            for (Object child : this.children) {
                if (!(child instanceof GroupNode)) continue;
                GroupNode elem = (GroupNode)child;
                if (elem.group != g) continue;
                return elem;
            }
            return null;
        }

        @Nullable
        public VariableNode findNestedVariable(VariableIF v) {
            if (this.children == null) {
                this.makeChildren();
            }
            for (Object child : this.children) {
                VariableNode vnode;
                TreeNode node = (TreeNode)child;
                if (!(node instanceof VariableNode) || (vnode = (VariableNode)node).var != v) continue;
                return vnode;
            }
            return null;
        }

        public String getToolTipText() {
            return this.group.getNameAndAttributes();
        }
    }

    private class DatasetTreeModel
    extends DefaultTreeModel {
        DatasetTreeModel(NetcdfFile file) {
            super(new GroupNode(null, file.getRootGroup()), false);
        }
    }
}

