/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.PrefPanel;
import ucar.ui.widget.IndependentDialog;

public class UrlAuthenticatorDialog
extends Authenticator
implements CredentialsProvider {
    private IndependentDialog dialog;
    private UsernamePasswordCredentials pwa;
    private Field.Text serverF;
    private Field.Text realmF;
    private Field.Text userF;
    private Field.Password passwF;
    private boolean debug;

    public UrlAuthenticatorDialog(JFrame parent) {
        PrefPanel pp = new PrefPanel("UrlAuthenticatorDialog", null);
        this.serverF = pp.addTextField("server", "Server", "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww");
        this.realmF = pp.addTextField("realm", "Realm", "");
        this.serverF.setEditable(false);
        this.realmF.setEditable(false);
        this.userF = pp.addTextField("user", "User", "");
        this.passwF = pp.addPasswordField("password", "Password", "");
        pp.addActionListener(e -> {
            char[] pw = this.passwF.getPassword();
            if (pw == null) {
                return;
            }
            this.pwa = new UsernamePasswordCredentials(this.userF.getText(), new String(pw));
            this.dialog.setVisible(false);
        });
        JButton cancel = new JButton("Cancel");
        pp.addButton((JComponent)cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UrlAuthenticatorDialog.this.pwa = null;
                UrlAuthenticatorDialog.this.dialog.setVisible(false);
            }
        });
        pp.finish();
        this.dialog = new IndependentDialog(parent, true, "HTTP Authentication", (Component)pp);
        this.dialog.setLocationRelativeTo((Component)parent);
        this.dialog.setLocation(100, 100);
    }

    public void clear() {
    }

    public void setCredentials(AuthScope scope, Credentials cred) {
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.pwa == null) {
            throw new IllegalStateException();
        }
        if (this.debug) {
            System.out.println("site= " + this.getRequestingSite());
            System.out.println("port= " + this.getRequestingPort());
            System.out.println("protocol= " + this.getRequestingProtocol());
            System.out.println("prompt= " + this.getRequestingPrompt());
            System.out.println("scheme= " + this.getRequestingScheme());
        }
        this.serverF.setText(this.getRequestingHost() + ":" + this.getRequestingPort());
        this.realmF.setText(this.getRequestingPrompt());
        this.dialog.setVisible(true);
        if (this.debug) {
            System.out.println("user= (" + this.pwa.getUserName() + ")");
            System.out.println("password= (" + this.pwa.getPassword() + ")");
        }
        return new PasswordAuthentication(this.pwa.getUserName(), this.pwa.getPassword().toCharArray());
    }

    public Credentials getCredentials(AuthScope scope) {
        this.serverF.setText(scope.getHost() + ":" + scope.getPort());
        this.realmF.setText(scope.getRealm());
        this.dialog.setVisible(true);
        if (this.pwa == null) {
            throw new IllegalStateException();
        }
        if (this.debug) {
            System.out.println("user= (" + this.pwa.getUserName() + ")");
            System.out.println("password= (" + this.pwa.getPassword() + ")");
        }
        UsernamePasswordCredentials upc = new UsernamePasswordCredentials(this.pwa.getUserName(), this.pwa.getPassword());
        return upc;
    }
}

