/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.coverage2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.HorizCoordSys;
import ucar.nc2.util.Misc;
import ucar.nc2.util.NamedObject;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class CoverageTable
extends JPanel {
    private PreferencesExt prefs;
    private FeatureDatasetCoverage coverageCollection;
    private BeanTable dsTable;
    private BeanTable covTable;
    private BeanTable csysTable;
    private BeanTable axisTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane split3;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private CoverageCollection currDataset;

    public CoverageTable(JPanel buttPanel, PreferencesExt prefs) {
        this.prefs = prefs;
        this.dsTable = new BeanTable(DatasetBean.class, (PreferencesExt)prefs.node("DatasetBeans"), false, "CoverageDatasets", "ucar.nc2.ft2.coverage.CoverageDataset", null);
        this.dsTable.addListSelectionListener(e -> {
            DatasetBean pb = (DatasetBean)this.dsTable.getSelectedBean();
            if (pb != null) {
                this.currDataset = pb.cds;
                this.setDataset(pb.cds);
            }
        });
        this.covTable = new BeanTable(CoverageBean.class, (PreferencesExt)prefs.node("CoverageBeans"), false, "Coverages", "ucar.nc2.ft2.coverage.Coverage", (Object)new CoverageBean());
        this.csysTable = new BeanTable(CoordSysBean.class, (PreferencesExt)prefs.node("CoverageCoordSysBeans"), false, "CoverageCoordSys", "ucar.nc2.ft2.coverage.CoverageCoordSys", null);
        this.csysTable.addListSelectionListener(e -> {
            CoordSysBean bean = (CoordSysBean)this.csysTable.getSelectedBean();
            if (null != bean) {
                ArrayList<CoverageBean> result = new ArrayList<CoverageBean>();
                for (Object cbean : this.covTable.getBeans()) {
                    CoverageBean covBean = (CoverageBean)cbean;
                    if (!covBean.getCoordSysName().equals(bean.getName())) continue;
                    result.add(covBean);
                }
                this.covTable.setSelectedBeans(result);
            }
        });
        this.axisTable = new BeanTable(AxisBean.class, (PreferencesExt)prefs.node("CoverageCoordAxisBeans"), false, "CoverageCoordAxes", "ucar.nc2.ft2.coverage.CoverageCoordAxis", null);
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.split = new JSplitPane(0, false, (Component)this.dsTable, (Component)this.covTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 300));
        this.split2 = new JSplitPane(0, false, this.split, (Component)this.csysTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 200));
        this.split3 = new JSplitPane(0, false, this.split2, (Component)this.axisTable);
        this.split3.setDividerLocation(prefs.getInt("splitPos3", 200));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split3, "Center");
        JTable jtable = this.dsTable.getJTable();
        PopupMenu dsPopup = new PopupMenu((JComponent)jtable, "Options");
        dsPopup.addAction("Show", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean bean = (DatasetBean)CoverageTable.this.dsTable.getSelectedBean();
                CoverageTable.this.infoTA.clear();
                CoverageTable.this.infoTA.appendLine(bean.cds.toString());
                CoverageTable.this.infoTA.gotoTop();
                CoverageTable.this.infoWindow.show();
            }
        });
        jtable = this.covTable.getJTable();
        PopupMenu csPopup = new PopupMenu((JComponent)jtable, "Options");
        csPopup.addAction("Show Declaration", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageBean vb = (CoverageBean)CoverageTable.this.covTable.getSelectedBean();
                CoverageTable.this.infoTA.clear();
                CoverageTable.this.infoTA.appendLine(vb.geogrid.toString());
                CoverageTable.this.infoTA.gotoTop();
                CoverageTable.this.infoWindow.show();
            }
        });
        jtable = this.csysTable.getJTable();
        csPopup = new PopupMenu((JComponent)jtable, "Options");
        csPopup.addAction("Show CoordSys", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordSysBean bean = (CoordSysBean)CoverageTable.this.csysTable.getSelectedBean();
                CoverageTable.this.infoTA.clear();
                CoverageTable.this.infoTA.appendLine(bean.gcs.toString());
                CoverageTable.this.infoTA.gotoTop();
                CoverageTable.this.infoWindow.show();
            }
        });
        csPopup.addAction("Show Transforms", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordSysBean bean = (CoordSysBean)CoverageTable.this.csysTable.getSelectedBean();
                CoverageTable.this.infoTA.clear();
                for (CoverageTransform ct : bean.gcs.getTransforms()) {
                    if (ct.isHoriz()) continue;
                    CoverageTable.this.infoTA.appendLine(ct.toString());
                }
                HorizCoordSys hcs = bean.gcs.getHorizCoordSys();
                if (hcs.getTransform() != null) {
                    CoverageTable.this.infoTA.appendLine(hcs.getTransform().toString());
                }
                CoverageTable.this.infoTA.gotoTop();
                CoverageTable.this.infoWindow.show();
            }
        });
        jtable = this.axisTable.getJTable();
        csPopup = new PopupMenu((JComponent)jtable, "Options");
        csPopup.addAction("Show Axis", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoverageTable.this.axisTable.getSelectedBean();
                CoverageTable.this.infoTA.clear();
                CoverageTable.this.infoTA.appendLine(bean.axis.toString());
                CoverageTable.this.infoTA.gotoTop();
                CoverageTable.this.infoWindow.show();
            }
        });
        csPopup.addAction("Show Coord Value differences", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)CoverageTable.this.axisTable.getSelectedBean();
                CoverageTable.this.infoTA.clear();
                CoverageTable.this.infoTA.appendLine(bean.showCoordValueDiffs());
                CoverageTable.this.infoTA.gotoTop();
                CoverageTable.this.infoWindow.show();
            }
        });
    }

    public void clear() {
        this.dsTable.clearBeans();
        this.covTable.clearBeans();
        this.csysTable.clearBeans();
        this.axisTable.clearBeans();
        this.currDataset = null;
    }

    public void save() {
        this.dsTable.saveState(false);
        this.covTable.saveState(false);
        this.csysTable.saveState(false);
        this.axisTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        this.prefs.putInt("splitPos3", this.split3.getDividerLocation());
    }

    public void showInfo(Formatter result) {
        if (this.coverageCollection == null) {
            return;
        }
        this.coverageCollection.getDetailInfo(result);
    }

    public void setCollection(FeatureDatasetCoverage gds) {
        this.coverageCollection = gds;
        this.clear();
        ArrayList<DatasetBean> dsList = new ArrayList<DatasetBean>();
        for (CoverageCollection ds : this.coverageCollection.getCoverageCollections()) {
            dsList.add(new DatasetBean(ds));
        }
        this.dsTable.setBeans(dsList);
    }

    public void setDataset(CoverageCollection coverageDataset) {
        ArrayList<CoverageBean> beanList = new ArrayList<CoverageBean>();
        for (Object g : coverageDataset.getCoverages()) {
            beanList.add(new CoverageBean((Coverage)g));
        }
        this.covTable.setBeans(beanList);
        ArrayList<CoordSysBean> csList = new ArrayList<CoordSysBean>();
        for (CoverageCoordSys gcs : coverageDataset.getCoordSys()) {
            csList.add(new CoordSysBean(coverageDataset, gcs));
        }
        this.csysTable.setBeans(csList);
        ArrayList<AxisBean> axisList = new ArrayList<AxisBean>();
        for (CoverageCoordAxis axis : coverageDataset.getCoordAxes()) {
            axisList.add(new AxisBean(axis));
        }
        this.axisTable.setBeans(axisList);
    }

    private boolean contains(List<AxisBean> axisList, String name) {
        for (AxisBean axis : axisList) {
            if (!axis.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public CoverageCollection getCoverageDataset() {
        return this.currDataset;
    }

    public List<CoverageBean> getCoverageBeans() {
        return this.covTable.getBeans();
    }

    public List<String> getSelectedGrids() {
        List grids = this.covTable.getSelectedBeans();
        ArrayList<String> result = new ArrayList<String>();
        for (Object bean : grids) {
            CoverageBean gbean = (CoverageBean)bean;
            result.add(gbean.getName());
        }
        return result;
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        return new Dialog(parent, title, modal);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)CoverageTable.this, "Center");
            this.pack();
        }
    }

    public static class AxisBean {
        CoverageCoordAxis axis;
        String name;
        String desc;
        String units;
        DataType dataType;
        AxisType axisType;
        long nvalues;
        boolean indepenent;

        public AxisBean() {
        }

        public AxisBean(CoverageCoordAxis v) {
            this.axis = v;
            this.name = v.getName();
            this.dataType = v.getDataType();
            this.axisType = v.getAxisType();
            this.units = v.getUnits();
            this.desc = v.getDescription();
            this.nvalues = v.getNcoords();
        }

        public String getName() {
            return this.name;
        }

        public String getAxisType() {
            return this.axisType == null ? "" : this.axisType.name();
        }

        public String getDescription() {
            return this.desc;
        }

        public String getUnits() {
            return this.units;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public String getSpacing() {
            CoverageCoordAxis.Spacing sp = this.axis.getSpacing();
            return sp == null ? "" : sp.toString();
        }

        public long getNvalues() {
            return this.nvalues;
        }

        public double getStartValue() {
            return this.axis.getStartValue();
        }

        public double getEndValue() {
            return this.axis.getEndValue();
        }

        public double getResolution() {
            return this.axis.getResolution();
        }

        public boolean getHasData() {
            return this.axis.getHasData();
        }

        public String getDependsOn() {
            if (this.axis.getDependenceType() != CoverageCoordAxis.DependenceType.independent) {
                return this.axis.getDependenceType() + ": " + this.axis.getDependsOn();
            }
            return this.axis.getDependenceType().toString();
        }

        String showCoordValueDiffs() {
            Formatter f = new Formatter();
            switch (this.axis.getSpacing()) {
                case regularInterval: 
                case regularPoint: {
                    f.format("%n%s resolution=%f%n", this.axis.getSpacing(), this.axis.getResolution());
                    break;
                }
                case irregularPoint: 
                case contiguousInterval: {
                    double[] values = this.axis.getValues();
                    int n = values.length;
                    f.format("%n%s (npts=%d)%n", this.axis.getSpacing(), n);
                    for (int i = 0; i < n - 1; ++i) {
                        double diff = values[i + 1] - values[i];
                        f.format("%10f %10f == %10f%n", values[i], values[i + 1], diff);
                    }
                    f.format("%n", new Object[0]);
                    break;
                }
                case discontiguousInterval: {
                    double[] values = this.axis.getValues();
                    int n = values.length;
                    f.format("%ndiscontiguous intervals (npts=%d)%n", n);
                    for (int i = 0; i < n; i += 2) {
                        double diff = values[i + 1] - values[i];
                        f.format("(%10f,%10f) = %10f%n", values[i], values[i + 1], diff);
                    }
                    f.format("%n", new Object[0]);
                }
            }
            return f.toString();
        }
    }

    public static class CoordTransBean {
        private CoverageTransform gcs;
        String params;
        boolean isHoriz;

        public CoordTransBean() {
        }

        public CoordTransBean(CoverageTransform gcs) {
            this.gcs = gcs;
            this.isHoriz = gcs.isHoriz();
            Formatter buff = new Formatter();
            for (Attribute att : gcs.getAttributes()) {
                buff.format("%s, ", att);
            }
            this.params = buff.toString();
        }

        public String getName() {
            return this.gcs.getName();
        }

        public String getParams() {
            return this.params;
        }

        public String getIsHoriz() {
            return Boolean.toString(this.isHoriz);
        }
    }

    public static class CoordSysBean {
        private CoverageCoordSys gcs;
        private String coordTrans;
        private String runtimeName;
        private String timeName;
        private String ensName;
        private String vertName;
        private int nIndAxis;
        private int nCov;

        public CoordSysBean() {
        }

        public CoordSysBean(CoverageCollection coverageDataset, CoverageCoordSys gcs) {
            this.gcs = gcs;
            Formatter buff = new Formatter();
            for (String ct : gcs.getTransformNames()) {
                buff.format("%s,", ct);
            }
            this.coordTrans = buff.toString();
            for (CoverageCoordAxis axis : gcs.getAxes()) {
                AxisType axisType;
                if (axis.getDependenceType() == CoverageCoordAxis.DependenceType.independent) {
                    ++this.nIndAxis;
                }
                if ((axisType = axis.getAxisType()) == null) continue;
                if (axisType == AxisType.RunTime) {
                    this.runtimeName = axis.getName();
                    continue;
                }
                if (axisType.isTime()) {
                    this.timeName = axis.getName();
                    continue;
                }
                if (axisType == AxisType.Ensemble) {
                    this.ensName = axis.getName();
                    continue;
                }
                if (!axisType.isVert()) continue;
                this.vertName = axis.getName();
            }
            for (Coverage cov : coverageDataset.getCoverages()) {
                if (cov.getCoordSys() != gcs) continue;
                ++this.nCov;
            }
        }

        public String getName() {
            return this.gcs.getName();
        }

        public String getType() {
            FeatureType type = this.gcs.getCoverageType();
            return type == null ? "" : type.toString();
        }

        public int getNIndCoords() {
            return this.nIndAxis;
        }

        public int getNCov() {
            return this.nCov;
        }

        public String getRuntime() {
            return this.runtimeName;
        }

        public String getTime() {
            return this.timeName;
        }

        public String getEns() {
            return this.ensName;
        }

        public String getVert() {
            return this.vertName;
        }

        public String getCoordTransforms() {
            return this.coordTrans;
        }
    }

    public static class CoverageBean
    implements NamedObject {
        Coverage geogrid;
        String name;
        String desc;
        String units;
        String coordSysName;
        DataType dataType;

        public String hiddenProperties() {
            return "value";
        }

        public CoverageBean() {
        }

        public CoverageBean(Coverage geogrid) {
            this.geogrid = geogrid;
            this.name = geogrid.getName();
            this.desc = geogrid.getDescription();
            this.units = geogrid.getUnitsString();
            this.dataType = geogrid.getDataType();
            this.coordSysName = geogrid.getCoordSysName();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public Object getValue() {
            return this.geogrid;
        }

        public String getUnits() {
            return this.units;
        }

        public String getCoordSysName() {
            return this.coordSysName;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public String getShape() {
            return Misc.showInts((int[])this.geogrid.getCoordSys().getShape());
        }
    }

    public static class DatasetBean {
        CoverageCollection cds;

        public DatasetBean() {
        }

        public DatasetBean(CoverageCollection cds) {
            this.cds = cds;
        }

        public String getName() {
            return this.cds.getName();
        }

        public String getType() {
            return this.cds.getCoverageType().toString();
        }

        public String getCalendar() {
            return this.cds.getCalendar().toString();
        }

        public String getDateRange() {
            return this.cds.getCalendarDateRange() == null ? "null" : this.cds.getCalendarDateRange().toString();
        }

        public String getLLBB() {
            return this.cds.getLatlonBoundingBox() == null ? "null" : this.cds.getLatlonBoundingBox().toString();
        }

        public int getNCoverages() {
            return this.cds.getCoverageCount();
        }

        public int getNCooordSys() {
            return this.cds.getCoordSys().size();
        }

        public int getNAxes() {
            return this.cds.getCoordAxes().size();
        }
    }
}

