/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.ma2.DataType;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.Grib2Show;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.Grib2Variable;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Misc;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Grib2DataPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(Grib2DataPanel.class);
    private PreferencesExt prefs;
    private BeanTable param2BeanTable;
    private BeanTable record2BeanTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane drsInfo;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private FileManager fileChooser;
    private String spec;
    private MCollection dcm;
    private List<MFile> fileList;
    private Grib2Tables cust;

    public Grib2DataPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.param2BeanTable = new BeanTable(Grib2ParameterBean.class, (PreferencesExt)prefs.node("Param2Bean"), false, "UniquePDSVariables", "from Grib2Input.getRecords()", null);
        this.param2BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)Grib2DataPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    Grib2DataPanel.this.record2BeanTable.setBeans(pb.getRecordBeans());
                }
            }
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.param2BeanTable.getJTable(), "Options");
        varPopup.addAction("Show PDS", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2ParameterBean pb = (Grib2ParameterBean)Grib2DataPanel.this.param2BeanTable.getSelectedBean();
                if (pb != null) {
                    Formatter f = new Formatter();
                    Grib2Show.showPdsTemplate((Grib2SectionProductDefinition)pb.gr.getPDSsection(), (Formatter)f, (Grib2Tables)Grib2DataPanel.this.cust);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        this.record2BeanTable = new BeanTable(Grib2RecordBean.class, (PreferencesExt)prefs.node("Record2Bean"), false, "DataRepresentation", "from Grib2Input.getRecords()", null);
        this.record2BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Grib2RecordBean pb = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (pb != null) {
                    Grib2DataPanel.this.drsInfo.setText(pb.drs.toString());
                }
            }
        });
        varPopup = new PopupMenu((JComponent)this.record2BeanTable.getJTable(), "Options");
        varPopup.addAction("Compare GridRecord", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2RecordBean bean1 = (Grib2RecordBean)list.get(0);
                    Grib2RecordBean bean2 = (Grib2RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.compare(bean1, bean2, f);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show raw PDS bytes", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                List list = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                for (Object o : list) {
                    Grib2RecordBean bean = (Grib2RecordBean)o;
                    bean.toRawPdsString(f);
                }
                Grib2DataPanel.this.infoPopup.setText(f.toString());
                Grib2DataPanel.this.infoPopup.gotoTop();
                Grib2DataPanel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Show complete GridRecord", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib2Show.showCompleteGribRecord((Formatter)f, (String)((MFile)Grib2DataPanel.this.fileList.get(bean.gr.getFile())).getPath(), (Grib2Record)bean.gr, (Grib2Tables)Grib2DataPanel.this.cust);
                    Grib2DataPanel.this.infoPopup.setText(f.toString());
                    Grib2DataPanel.this.infoPopup.gotoTop();
                    Grib2DataPanel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Show Processed GridRecord", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                Formatter f = new Formatter();
                for (Object o : list) {
                    Grib2RecordBean bean = (Grib2RecordBean)o;
                    bean.showProcessedGridRecord(f);
                }
                Grib2DataPanel.this.infoPopup2.setText(f.toString());
                Grib2DataPanel.this.infoPopup2.gotoTop();
                Grib2DataPanel.this.infoWindow2.show();
            }
        });
        varPopup.addAction("Compare Data", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib2RecordBean bean1 = (Grib2RecordBean)list.get(0);
                    Grib2RecordBean bean2 = (Grib2RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.compareData(bean1, bean2, f);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Data", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib2DataPanel.this.showData(bean, f);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Extract GribRecord to File", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = Grib2DataPanel.this.record2BeanTable.getSelectedBeans();
                if (!beans.isEmpty()) {
                    Grib2DataPanel.this.writeToFile(beans);
                }
            }
        });
        varPopup.addAction("Show Bitmap", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    try {
                        Grib2DataPanel.this.showBitmap(bean, f);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Compute Scale/offset of data", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib2RecordBean bean = (Grib2RecordBean)Grib2DataPanel.this.record2BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    GribData.calcScaleOffset((GribData.Bean)bean, (Formatter)f);
                    Grib2DataPanel.this.infoPopup2.setText(f.toString());
                    Grib2DataPanel.this.infoPopup2.gotoTop();
                    Grib2DataPanel.this.infoWindow2.show();
                }
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", (Object)new Rectangle(300, 300, 500, 300)));
        this.drsInfo = new TextHistoryPane();
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, (Component)this.param2BeanTable, (Component)this.record2BeanTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, (Component)this.drsInfo);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.param2BeanTable.saveState(false);
        this.record2BeanTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", (Object)this.infoWindow2.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void setCollection(String spec) throws IOException {
        this.spec = spec;
        this.cust = null;
        Formatter f = new Formatter();
        this.dcm = this.scanCollection(spec, f);
        if (this.dcm == null) {
            JOptionPane.showMessageDialog(this, "Collection is null\n" + f);
            return;
        }
        HashMap<Grib2Variable, Grib2ParameterBean> pdsSet = new HashMap<Grib2Variable, Grib2ParameterBean>();
        HashMap<Integer, Grib2SectionGridDefinition> gdsSet = new HashMap<Integer, Grib2SectionGridDefinition>();
        ArrayList<Grib2ParameterBean> params = new ArrayList<Grib2ParameterBean>();
        int fileno = 0;
        for (MFile mfile : this.fileList) {
            f.format("%n %s%n", mfile.getPath());
            RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");
            Throwable throwable = null;
            try {
                raf.order(ByteOrder.BIG_ENDIAN);
                this.processGribFile(mfile, fileno++, raf, pdsSet, gdsSet, params, f);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (raf == null) continue;
                if (throwable != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                raf.close();
            }
        }
        this.param2BeanTable.setBeans(params);
    }

    private void processGribFile(MFile mfile, int fileno, RandomAccessFile raf, Map<Grib2Variable, Grib2ParameterBean> pdsSet, Map<Integer, Grib2SectionGridDefinition> gdsSet, List<Grib2ParameterBean> params, Formatter f) throws IOException {
        Grib2Index index = new Grib2Index();
        if (!index.readIndex(mfile.getPath(), mfile.getLastModified())) {
            index.makeIndex(mfile.getPath(), null);
        }
        for (Grib2SectionGridDefinition gds : index.getGds()) {
            int hash = gds.getGDS().hashCode();
            gdsSet.putIfAbsent(hash, gds);
        }
        for (Grib2Record gr : index.getRecords()) {
            if (this.cust == null) {
                this.cust = Grib2Tables.factory((Grib2Record)gr);
            }
            gr.setFile(fileno);
            Grib2Variable gv = new Grib2Variable(this.cust, gr, 0, FeatureCollectionConfig.intvMergeDef, FeatureCollectionConfig.useGenTypeDef);
            Grib2ParameterBean bean = pdsSet.get(gv);
            if (bean == null) {
                bean = new Grib2ParameterBean(gr, gv);
                pdsSet.put(gv, bean);
                params.add(bean);
            }
            bean.addRecord(gr, raf);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MCollection scanCollection(String spec, Formatter f) {
        try (MCollection dc = CollectionAbstract.open((String)spec, (String)spec, null, (Formatter)f);){
            this.fileList = Misc.getList((Iterable)dc.getFilesSorted());
            MCollection throwable3 = dc;
            return throwable3;
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            f.format(sw.toString(), new Object[0]);
            return null;
        }
    }

    public void showInfo(Formatter f) {
        if (this.dcm == null) {
            if (this.spec == null) {
                return;
            }
            this.dcm = this.scanCollection(this.spec, f);
            if (this.dcm == null) {
                return;
            }
        }
        f.format("dcm = %s%n", this.dcm);
        try {
            for (MFile mfile : this.dcm.getFilesSorted()) {
                f.format("  %s%n", mfile.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int nrecords = 0;
        long dataSize = 0L;
        long msgSize = 0L;
        for (Object o : this.param2BeanTable.getBeans()) {
            Grib2ParameterBean p = (Grib2ParameterBean)o;
            for (Grib2RecordBean r : p.getRecordBeans()) {
                ++nrecords;
                dataSize += r.getDataLength();
                msgSize += r.getMsgLength();
            }
        }
        f.format("nrecords = %d, total grib data size = %d, total grib msg sizes = %d", nrecords, dataSize, msgSize);
    }

    public void checkProblems(Formatter f) {
        this.checkDuplicates(f);
    }

    private void checkDuplicates(Formatter f) {
        HashSet<Long> pdsMap = new HashSet<Long>();
        int dups = 0;
        int count = 0;
        HashMap<CalendarDate, DateCount> dateMap = new HashMap<CalendarDate, DateCount>();
        List params = this.param2BeanTable.getBeans();
        for (Grib2ParameterBean param : params) {
            for (Grib2RecordBean record : param.getRecordBeans()) {
                CalendarDate d = record.gr.getReferenceDate();
                DateCount dc = (DateCount)dateMap.get(d);
                if (dc == null) {
                    dc = new DateCount(d);
                    dateMap.put(d, dc);
                }
                ++dc.count;
                Grib2SectionProductDefinition pdss = record.gr.getPDSsection();
                long crc = pdss.calcCRC();
                if (pdsMap.contains(crc)) {
                    ++dups;
                } else {
                    pdsMap.add(crc);
                }
                ++count;
            }
        }
        f.format("PDS duplicates = %d / %d%n%n", dups, count);
        ArrayList dcList = new ArrayList(dateMap.values());
        Collections.sort(dcList);
        f.format("Run Dates%n", new Object[0]);
        int total = 0;
        for (DateCount dc : dcList) {
            f.format(" %s == %d%n", dc.d, dc.count);
            total += dc.count;
        }
        f.format("total records = %d%n", total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(List beans) {
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
        FileOutputStream fos = null;
        java.io.RandomAccessFile raf = null;
        try {
            String filename = null;
            boolean append = false;
            int n = 0;
            MFile curr = null;
            for (Object o : beans) {
                Grib2RecordBean bean = (Grib2RecordBean)o;
                MFile mfile = this.fileList.get(bean.gr.getFile());
                if (curr == null || curr != mfile) {
                    if (raf != null) {
                        raf.close();
                    }
                    raf = new java.io.RandomAccessFile(mfile.getPath(), "r");
                    curr = mfile;
                }
                if (fos == null) {
                    String defloc = mfile.getPath();
                    filename = this.fileChooser.chooseFilenameToSave(defloc + ".grib2");
                    if (filename == null) {
                        return;
                    }
                    File f = new File(filename);
                    append = f.exists();
                    fos = new FileOutputStream(filename, append);
                }
                Grib2SectionIndicator is = bean.gr.getIs();
                int size = (int)is.getMessageLength();
                long startPos = is.getStartPos();
                if (startPos < 0L) {
                    JOptionPane.showMessageDialog(this, "Old index does not have message start - record not written");
                }
                byte[] rb = new byte[size];
                raf.seek(startPos);
                raf.readFully(rb);
                fos.write(rb);
                ++n;
            }
            JOptionPane.showMessageDialog(this, filename + ": " + n + " records successfully written, append=" + append);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void compare(Grib2RecordBean bean1, Grib2RecordBean bean2, Formatter f) {
        Grib2SectionIndicator is1 = bean1.gr.getIs();
        Grib2SectionIndicator is2 = bean2.gr.getIs();
        f.format("Indicator Section%n", new Object[0]);
        if (is1.getDiscipline() != is2.getDiscipline()) {
            f.format("getDiscipline differs %d != %d %n", is1.getDiscipline(), is2.getDiscipline());
        }
        if (is1.getMessageLength() != is2.getMessageLength()) {
            f.format("getGribLength differs %d != %d %n", is1.getMessageLength(), is2.getMessageLength());
        }
        f.format("%nId Section%n", new Object[0]);
        Grib2SectionIdentification id1 = bean1.gr.getId();
        Grib2SectionIdentification id2 = bean2.gr.getId();
        if (id1.getCenter_id() != id2.getCenter_id()) {
            f.format("Center_id differs %d != %d %n", id1.getCenter_id(), id2.getCenter_id());
        }
        if (id1.getSubcenter_id() != id2.getSubcenter_id()) {
            f.format("Subcenter_id differs %d != %d %n", id1.getSubcenter_id(), id2.getSubcenter_id());
        }
        if (id1.getMaster_table_version() != id2.getMaster_table_version()) {
            f.format("Master_table_version differs %d != %d %n", id1.getMaster_table_version(), id2.getMaster_table_version());
        }
        if (id1.getLocal_table_version() != id2.getLocal_table_version()) {
            f.format("Local_table_version differs %d != %d %n", id1.getLocal_table_version(), id2.getLocal_table_version());
        }
        if (id1.getProductionStatus() != id2.getProductionStatus()) {
            f.format("ProductionStatus differs %d != %d %n", id1.getProductionStatus(), id2.getProductionStatus());
        }
        if (id1.getTypeOfProcessedData() != id2.getTypeOfProcessedData()) {
            f.format("TypeOfProcessedData differs %d != %d %n", id1.getTypeOfProcessedData(), id2.getTypeOfProcessedData());
        }
        if (!id1.getReferenceDate().equals((Object)id2.getReferenceDate())) {
            f.format("ReferenceDate differs %s != %s %n", id1.getReferenceDate(), id2.getReferenceDate());
        }
        if (id1.getSignificanceOfRT() != id2.getSignificanceOfRT()) {
            f.format("getSignificanceOfRT differs %d != %d %n", id1.getSignificanceOfRT(), id2.getSignificanceOfRT());
        }
        Grib2SectionLocalUse lus1 = bean1.gr.getLocalUseSection();
        Grib2SectionLocalUse lus2 = bean2.gr.getLocalUseSection();
        if (lus1 == null || lus2 == null) {
            if (lus1 == lus2) {
                f.format("%nLus are both null%n", new Object[0]);
            } else {
                f.format("%nLus are different %s != %s %n", lus1, lus2);
            }
        } else {
            f.format("%nCompare LocalUseSection%n", new Object[0]);
            Misc.compare((byte[])lus1.getRawBytes(), (byte[])lus2.getRawBytes(), (Formatter)f);
        }
        this.compare(bean1.gr.getPDSsection(), bean2.gr.getPDSsection(), f);
        this.compare(bean1.gr.getGDSsection(), bean2.gr.getGDSsection(), f);
    }

    private void compare(Grib2SectionGridDefinition gdss1, Grib2SectionGridDefinition gdss2, Formatter f) {
        f.format("1 GribGDS hash = %s%n", gdss1.getGDS().hashCode());
        f.format("2 GribGDS hash = %s%n", gdss2.getGDS().hashCode());
        f.format("%nCompare Gds%n", new Object[0]);
        byte[] raw1 = gdss1.getRawBytes();
        byte[] raw2 = gdss2.getRawBytes();
        Misc.compare((byte[])raw1, (byte[])raw2, (Formatter)f);
        Grib2Gds gds1 = gdss1.getGDS();
        Grib2Gds gds2 = gdss2.getGDS();
        GdsHorizCoordSys gdsh1 = gds1.makeHorizCoordSys();
        GdsHorizCoordSys gdsh2 = gds2.makeHorizCoordSys();
        f.format("%ncompare gds1 - gds22%n", new Object[0]);
        f.format(" Start x diff : %f%n", gdsh1.getStartX() - gdsh2.getStartX());
        f.format(" Start y diff : %f%n", gdsh1.getStartY() - gdsh2.getStartY());
        f.format(" End x diff : %f%n", gdsh1.getEndX() - gdsh2.getEndX());
        f.format(" End y diff : %f%n", gdsh1.getEndY() - gdsh2.getEndY());
        LatLonPoint pt1 = gdsh1.getCenterLatLon();
        LatLonPoint pt2 = gdsh2.getCenterLatLon();
        f.format(" Center lon diff : %f%n", pt1.getLongitude() - pt2.getLongitude());
        f.format(" Center lat diff : %f%n", pt1.getLatitude() - pt2.getLatitude());
    }

    private void compare(Grib2SectionProductDefinition pds1, Grib2SectionProductDefinition pds2, Formatter f) {
        f.format("%nCompare Pds%n", new Object[0]);
        byte[] raw1 = pds1.getRawBytes();
        byte[] raw2 = pds2.getRawBytes();
        Misc.compare((byte[])raw1, (byte[])raw2, (Formatter)f);
    }

    void compareData(Grib2RecordBean bean1, Grib2RecordBean bean2, Formatter f) {
        float[] data2;
        float[] data1;
        try {
            data1 = bean1.readData();
            data2 = bean2.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        Misc.compare((float[])data1, (float[])data2, (Formatter)f);
    }

    void showData(Grib2RecordBean bean1, Formatter f) {
        float[] data;
        try {
            data = bean1.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        int count = 0;
        for (float fd : data) {
            f.format("%d: %f%n", count++, Float.valueOf(fd));
        }
    }

    void showBitmap(Grib2RecordBean bean1, Formatter f) throws IOException {
        byte[] bitmap;
        try (RandomAccessFile raf = bean1.getRaf();){
            Grib2SectionBitMap bms = bean1.gr.getBitmapSection();
            f.format("%s%n", bms);
            bitmap = bms.getBitmap(raf);
        }
        if (bitmap == null) {
            f.format(" no bitmap%n", new Object[0]);
            return;
        }
        int count = 0;
        int bits = 0;
        for (byte b : bitmap) {
            short s = DataType.unsignedByteToShort((byte)b);
            bits += Long.bitCount(s);
            f.format("%8s", Long.toBinaryString(s));
            if (++count % 10 != 0) continue;
            f.format("%n", new Object[0]);
        }
        f.format("%n%n#bits on = %d%n", bits);
        f.format("total nbits = %d%n", 8 * count);
        f.format("bitmap nbytes = %d%n", bitmap.length);
    }

    public class Grib2RecordBean
    implements GribData.Bean {
        Grib2Record gr;
        Grib2Pds pds;
        Grib2Drs drs;
        Grib2SectionData dataSection;
        long drsLength;
        GribData.Info info;
        double minimum;
        double maximum;
        double scale;

        public Grib2RecordBean() {
        }

        public Grib2RecordBean(Grib2Record m, RandomAccessFile raf) throws IOException {
            this.gr = m;
            this.pds = this.gr.getPDS();
            Grib2SectionDataRepresentation drss = this.gr.getDataRepresentationSection();
            this.drs = drss.getDrs(raf);
            this.drsLength = drss.getLength(raf);
            this.dataSection = this.gr.getDataSection();
            this.info = this.gr.getBinaryDataInfo(raf);
            double pow10 = Math.pow(10.0, -this.getDecScale());
            this.minimum = (float)(pow10 * (double)this.info.referenceValue);
            this.scale = (float)(pow10 * Math.pow(2.0, this.getBinScale()));
            double maxPacked = Math.pow(2.0, this.getNBits()) - 1.0;
            this.maximum = this.minimum + this.scale * maxPacked;
        }

        public int getDrsTemplate() {
            return this.gr.getDataRepresentationSection().getDataTemplate();
        }

        public int getNDataPoints() {
            return this.info.ndataPoints;
        }

        public int getNPoints() {
            return this.info.nPoints;
        }

        public int getNGroups() {
            return this.drs.getNGroups();
        }

        public float getAvgBits() {
            float len = this.getDataLength();
            int n = this.getNDataPoints();
            return len * 8.0f / (float)n;
        }

        public int getNBits() {
            return this.info.numberOfBits;
        }

        public long getMsgLength() {
            return this.info.msgLength;
        }

        public long getDataLength() {
            return this.info.dataLength;
        }

        public int getBinScale() {
            return this.info.binaryScaleFactor;
        }

        public int getDecScale() {
            return this.info.decimalScaleFactor;
        }

        public double getMinimum() {
            return this.minimum;
        }

        public double getMaximum() {
            return this.maximum;
        }

        public double getScale() {
            return this.scale;
        }

        public String getPrecision() {
            return String.format("%.5g", this.scale / 2.0);
        }

        public int getBitMap() {
            return this.gr.getBitmapSection().getBitMapIndicator();
        }

        public boolean getBitMapReplaced() {
            return this.gr.isBmsReplaced();
        }

        public long getStartPos() {
            return this.gr.getIs().getStartPos();
        }

        public String getHeader() {
            return Grib2Utils.cleanupHeader((byte[])this.gr.getHeader());
        }

        public final int getTime() {
            return this.pds.getForecastTime();
        }

        public String getLevel() {
            int v1 = this.pds.getLevelType1();
            int v2 = this.pds.getLevelType2();
            if (v1 == 255) {
                return "";
            }
            if (v2 == 255) {
                return "" + this.pds.getLevelValue1();
            }
            if (v1 != v2) {
                return this.pds.getLevelValue1() + "-" + this.pds.getLevelValue2() + " level2 type= " + v2;
            }
            return this.pds.getLevelValue1() + "-" + this.pds.getLevelValue2();
        }

        public void toRawPdsString(Formatter f) {
            byte[] bytes = this.gr.getPDSsection().getRawBytes();
            int count = 1;
            for (byte b : bytes) {
                short s = DataType.unsignedByteToShort((byte)b);
                f.format(" %d : %d%n", count++, s);
            }
        }

        public void showProcessedGridRecord(Formatter f) {
            f.format("%nFile=%s (%d)%n", ((MFile)Grib2DataPanel.this.fileList.get(this.gr.getFile())).getPath(), this.gr.getFile());
            Grib2Show.showProcessedGridRecord((Grib2Tables)Grib2DataPanel.this.cust, (Grib2Record)this.gr, (Formatter)f);
        }

        public float[] readData() throws IOException {
            try (RandomAccessFile raf = this.getRaf();){
                raf.order(0);
                float[] fArray = this.gr.readData(raf);
                return fArray;
            }
        }

        RandomAccessFile getRaf() throws IOException {
            int fileno = this.gr.getFile();
            MFile mfile = (MFile)Grib2DataPanel.this.fileList.get(fileno);
            return new RandomAccessFile(mfile.getPath(), "r");
        }
    }

    public class Grib2ParameterBean {
        Grib2Record gr;
        Grib2SectionIdentification id;
        Grib2Pds pds;
        List<Grib2RecordBean> records;
        int discipline;
        Grib2Variable gv;
        private double minScale;
        private double maxScale;
        private int minBits;
        private int maxBits;
        private float nbits = -1.0f;
        private float avgbits;
        private float compress;

        public Grib2ParameterBean() {
        }

        public Grib2ParameterBean(Grib2Record r, Grib2Variable gv) throws IOException {
            this.gr = r;
            this.gv = gv;
            this.pds = r.getPDS();
            this.id = r.getId();
            this.discipline = r.getDiscipline();
            this.records = new ArrayList<Grib2RecordBean>();
        }

        public String getCdmHash() {
            return Integer.toHexString(this.gv.hashCode());
        }

        void addRecord(Grib2Record r, RandomAccessFile raf) throws IOException {
            this.records.add(new Grib2RecordBean(r, raf));
        }

        List<Grib2RecordBean> getRecordBeans() {
            return this.records;
        }

        public String getParamNo() {
            return this.discipline + "-" + this.pds.getParameterCategory() + "-" + this.pds.getParameterNumber();
        }

        public int getPDS() {
            return this.gr.getPDSsection().getPDSTemplateNumber();
        }

        public int getN() {
            return this.records.size();
        }

        public int getLevelType() {
            return this.pds.getLevelType1();
        }

        public String getLevelName() {
            return Grib2DataPanel.this.cust.getLevelNameShort(this.pds.getLevelType1());
        }

        public int getGDS() {
            return this.gr.getGDSsection().getGDS().hashCode();
        }

        public String toString() {
            Formatter f = new Formatter();
            Grib2Show.showPdsTemplate((Grib2SectionProductDefinition)this.gr.getPDSsection(), (Formatter)f, (Grib2Tables)Grib2DataPanel.this.cust);
            return f.toString();
        }

        public String toProcessedString() {
            Formatter f = new Formatter();
            Grib2Show.showProcessedPds((Grib2Tables)Grib2DataPanel.this.cust, (Grib2Pds)this.pds, (int)this.discipline, (Formatter)f);
            return f.toString();
        }

        public String getNBits() {
            this.calcBits();
            if (this.minBits == this.maxBits) {
                return Integer.toString(this.minBits);
            }
            return this.minBits + "-" + this.maxBits;
        }

        public String getScale() {
            this.calcBits();
            Formatter f = new Formatter();
            if (this.minScale == Double.MAX_VALUE) {
                f.format("N/A", new Object[0]);
            }
            if (Misc.nearlyEquals((double)this.minScale, (double)this.maxScale)) {
                f.format("%g", this.minScale);
            } else {
                f.format("(%g,%g)", this.minScale, this.maxScale);
            }
            return f.toString();
        }

        public float getAvgBits() {
            this.calcBits();
            return this.avgbits;
        }

        public float getCompress() {
            this.calcBits();
            return this.compress;
        }

        private void calcBits() {
            if (this.nbits >= 0.0f) {
                return;
            }
            this.nbits = 0.0f;
            int count = 0;
            this.minScale = 3.4028234663852886E38;
            this.maxScale = -3.4028234663852886E38;
            this.minBits = Integer.MAX_VALUE;
            for (Grib2RecordBean bean : this.records) {
                this.minBits = Math.min(this.minBits, bean.getNBits());
                this.maxBits = Math.max(this.maxBits, bean.getNBits());
                if (0 != bean.getNBits()) {
                    this.minScale = Math.min(this.minScale, bean.getScale());
                    this.maxScale = Math.max(this.maxScale, bean.getScale());
                }
                this.nbits += (float)bean.getNBits();
                this.avgbits += bean.getAvgBits();
                ++count;
            }
            this.compress = this.nbits / this.avgbits;
            if (count > 0) {
                this.nbits /= (float)count;
                this.avgbits /= (float)count;
            }
        }

        public String getName() {
            return GribUtils.makeNameFromDescription((String)Grib2DataPanel.this.cust.getVariableName(this.gr));
        }

        public String getUnits() {
            GribTables.Parameter p = Grib2DataPanel.this.cust.getParameter(this.discipline, this.pds);
            return p == null ? "?" : p.getUnit();
        }

        public final String getCenter() {
            return this.id.getCenter_id() + "/" + this.id.getSubcenter_id();
        }

        public final String getTable() {
            return this.id.getMaster_table_version() + "-" + this.id.getLocal_table_version();
        }
    }

    private static class DateCount
    implements Comparable<DateCount> {
        CalendarDate d;
        int count;

        private DateCount(CalendarDate d) {
            this.d = d;
        }

        @Override
        public int compareTo(DateCount o) {
            return this.d.compareTo(o.d);
        }
    }
}

