/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.menu;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import thredds.client.catalog.tools.DataFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.iosp.hdf4.H4header;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.nc2.ui.ToolsUI;
import ucar.ui.widget.BAMutil;

public class ModesMenu
extends JMenu {
    private ToolsUI toolsui;

    public ModesMenu(ToolsUI tui) {
        super("Modes");
        this.setMnemonic('M');
        this.toolsui = tui;
        this.addNetcdfFileSubmenu();
        this.addNetcdfDatasetSubmenu();
        this.addHdfeosSubmenu();
        this.addGribSubmenu();
        this.addFmrcSubmenu();
    }

    private void addNetcdfFileSubmenu() {
        JMenu ncMenu = new JMenu("NetcdfFile");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                ModesMenu.this.toolsui.setUseRecordStructure(state);
            }
        };
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"Netcdf3: use records", (boolean)false, (int)86, (int)-1);
        BAMutil.addActionToMenu((JMenu)ncMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                ModesMenu.this.toolsui.setUseBuilders(state);
            }
        };
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"use builders", (boolean)true, (int)66, (int)-1);
        BAMutil.addActionToMenu((JMenu)ncMenu, (Action)a);
        this.add(ncMenu);
    }

    private void addNetcdfDatasetSubmenu() {
        JMenu dsMenu = new JMenu("NetcdfDataset");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                CoordSysBuilder.setUseMaximalCoordSys((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"Set Use Maximal CoordSystem", (boolean)CoordSysBuilder.getUseMaximalCoordSys(), (int)78, (int)-1);
        BAMutil.addActionToMenu((JMenu)dsMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setFillValueIsMissing((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"Use _FillValue attribute for missing values", (boolean)NetcdfDataset.getFillValueIsMissing(), (int)70, (int)-1);
        BAMutil.addActionToMenu((JMenu)dsMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setInvalidDataIsMissing((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"Use valid_range attribute for missing values", (boolean)NetcdfDataset.getInvalidDataIsMissing(), (int)86, (int)-1);
        BAMutil.addActionToMenu((JMenu)dsMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setMissingDataIsMissing((boolean)state);
            }
        };
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"Use missing_value attribute for missing values", (boolean)NetcdfDataset.getMissingDataIsMissing(), (int)77, (int)-1);
        BAMutil.addActionToMenu((JMenu)dsMenu, (Action)a);
        this.add(dsMenu);
    }

    private void addHdfeosSubmenu() {
        JMenu subMenu = new JMenu("HDF-EOS");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                H5iosp.useHdfEos((boolean)state);
            }
        };
        a.putValue("state", true);
        BAMutil.setActionProperties((AbstractAction)a, null, (String)"Use HDF-EOS StructMetadata to augment HDF5", (boolean)true, (int)53, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                H4header.useHdfEos((boolean)state);
            }
        };
        a.putValue("state", true);
        BAMutil.setActionProperties((AbstractAction)a, null, (String)"Use HDF-EOS StructMetadata to augment HDF4", (boolean)true, (int)52, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                Nc4Iosp.useHdfEos((boolean)state);
            }
        };
        a.putValue("state", true);
        BAMutil.setActionProperties((AbstractAction)a, null, (String)"Use HDF-EOS StructMetadata to augment netcdf4 (JNI)", (boolean)true, (int)78, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        this.add(subMenu);
    }

    private void addGribSubmenu() {
        JMenu subMenu = new JMenu("GRIB");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModesMenu.this.toolsui.setGribDiskCache();
            }
        };
        BAMutil.setActionProperties((AbstractAction)a, null, (String)"Set Grib disk cache\u2026", (boolean)false, (int)71, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                Grib1ParamTables.setStrict((boolean)state);
            }
        };
        boolean strictMode = Grib1ParamTables.isStrict();
        a.putValue("state", strictMode);
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"GRIB1 strict", (boolean)strictMode, (int)83, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = (Boolean)this.getValue("state");
                GribData.setInterpolationMethod((GribData.InterpolationMethod)(state ? GribData.InterpolationMethod.cubic : GribData.InterpolationMethod.linear));
            }
        };
        boolean useCubic = GribData.getInterpolationMethod() == GribData.InterpolationMethod.cubic;
        a.putValue("state", useCubic);
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"Use Cubic Interpolation on Thin Grids", (boolean)useCubic, (int)73, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useGenTypeDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useGenTypeDef);
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"useGenType", (boolean)FeatureCollectionConfig.useGenTypeDef, (int)83, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useTableVersionDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useTableVersionDef);
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"useTableVersion", (boolean)FeatureCollectionConfig.useTableVersionDef, (int)83, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.intvMergeDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.intvMergeDef);
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"intvMerge", (boolean)FeatureCollectionConfig.intvMergeDef, (int)83, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureCollectionConfig.useCenterDef = (Boolean)this.getValue("state");
            }
        };
        a.putValue("state", FeatureCollectionConfig.useCenterDef);
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"useCenter", (boolean)FeatureCollectionConfig.useCenterDef, (int)83, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        this.add(subMenu);
    }

    private void addFmrcSubmenu() {
        JMenu subMenu = new JMenu("FMRC");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                FeatureCollectionConfig.setRegularizeDefault((boolean)state);
            }
        };
        FeatureCollectionConfig.setRegularizeDefault((boolean)true);
        a.putValue("state", true);
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"regularize", (boolean)true, (int)82, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                DataFactory.setPreferCdm((boolean)state);
            }
        };
        DataFactory.setPreferCdm((boolean)true);
        a.putValue("state", true);
        BAMutil.setActionPropertiesToggle((AbstractAction)a, null, (String)"preferCdm", (boolean)true, (int)80, (int)-1);
        BAMutil.addActionToMenu((JMenu)subMenu, (Action)a);
        this.add(subMenu);
    }
}

