/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionConfigBuilder;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.DirectoryBuilder;
import thredds.inventory.partition.DirectoryPartition;
import thredds.inventory.partition.IndexReader;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.ui.MFileTable;
import ucar.nc2.ui.grib.CdmIndexPanel;
import ucar.ui.prefs.BeanTable;
import ucar.ui.prefs.ComboBox;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;

public class DirectoryPartitionViewer
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PreferencesExt prefs;
    private FeatureCollectionConfig config;
    private String collectionName;
    private CdmIndexPanel cdmIndexTables;
    private PartitionsTable partitionsTable;
    private JPanel tablePanel;
    private JSplitPane mainSplit;
    private PartitionTreeBrowser partitionTreeBrowser;
    private MFileTable fileTable;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private ComboBox<String> cb;
    private FileManager dirFileChooser;
    private boolean isFromIndex;
    private Component current;

    public DirectoryPartitionViewer(PreferencesExt prefs, JPanel topPanel, JPanel buttPanel) {
        this.prefs = prefs;
        this.partitionTreeBrowser = new PartitionTreeBrowser();
        this.partitionsTable = new PartitionsTable((PreferencesExt)prefs.node("partTable"));
        this.cdmIndexTables = new CdmIndexPanel((PreferencesExt)prefs.node("cdmIdx"), buttPanel);
        this.cdmIndexTables.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirectoryPartitionViewer.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        if (topPanel != null && buttPanel != null) {
            this.cb = new ComboBox((PersistenceManager)prefs);
            this.cb.addActionListener(e -> {
                String filename = (String)this.cb.getSelectedItem();
                if (filename == null) {
                    return;
                }
                File d = new File(filename);
                if (d.isDirectory()) {
                    this.setDirectory(d);
                } else if (d.getName().endsWith(".xml")) {
                    this.setCollectionFromConfig(d.getPath());
                } else if (d.getName().endsWith(".ncx4")) {
                    this.setCollectionFromIndex(d.getPath());
                }
                this.cb.addItem((Object)filename);
            });
            topPanel.add((Component)new JLabel("dir,ncx3,or config:"), "West");
            topPanel.add((Component)this.cb, "Center");
            this.dirFileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("fileChooser"));
            this.dirFileChooser.getFileChooser().setFileSelectionMode(2);
            AbstractAction dirFileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String filename = DirectoryPartitionViewer.this.dirFileChooser.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    DirectoryPartitionViewer.this.cb.setSelectedItem((Object)filename);
                }
            };
            BAMutil.setActionProperties((AbstractAction)dirFileAction, (String)"FileChooser", (String)"choose file or directory...", (boolean)false, (int)76, (int)-1);
            BAMutil.addActionToContainer((Container)buttPanel, (Action)dirFileAction);
        }
        this.setLayout(new BorderLayout());
        JScrollPane treeScroll = new JScrollPane(this.partitionTreeBrowser.tree);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)treeScroll, "Center");
        treePanel.add((Component)this.partitionTreeBrowser.view, "South");
        this.tablePanel = new JPanel(new BorderLayout());
        this.tablePanel.add((Component)this.cdmIndexTables, "Center");
        this.current = this.cdmIndexTables;
        this.mainSplit = new JSplitPane(1, false, treePanel, this.tablePanel);
        this.mainSplit.setDividerLocation(prefs.getInt("mainSplit", 100));
        this.add((Component)this.mainSplit, "Center");
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.fileTable = new MFileTable((PreferencesExt)prefs.node("MFileTable"), true);
        this.fileTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DirectoryPartitionViewer.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public void save() {
        if (this.mainSplit != null) {
            this.prefs.putInt("mainSplit", this.mainSplit.getDividerLocation());
        }
        if (this.cb != null) {
            this.cb.save();
        }
        if (this.dirFileChooser != null) {
            this.dirFileChooser.save();
        }
        this.cdmIndexTables.save();
        this.partitionsTable.save();
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.fileTable.save();
    }

    public void clear() {
        this.cdmIndexTables.clear();
        this.partitionsTable.clear();
    }

    private void swap(Component want) {
        if (this.current == want) {
            return;
        }
        this.tablePanel.remove(this.current);
        this.tablePanel.add(want, "Center");
        this.tablePanel.revalidate();
        this.current = want;
        this.repaint();
    }

    public void showInfo() {
        Formatter f = new Formatter();
        if (this.current == this.partitionsTable) {
            this.partitionsTable.showGroupDiffs(f);
        } else if (this.current == this.cdmIndexTables) {
            this.cdmIndexTables.showInfo(f);
        } else {
            return;
        }
        this.infoTA.setText(f.toString());
        this.infoTA.gotoTop();
        this.infoWindow.show();
    }

    public void showDetailInfo() {
        Formatter f = new Formatter();
        if (this.current == this.partitionsTable) {
            this.partitionsTable.showGroupDiffs(f);
        } else if (this.current == this.cdmIndexTables) {
            this.cdmIndexTables.showInfo(f);
        } else {
            return;
        }
        this.infoTA.setText(f.toString());
        this.infoTA.gotoTop();
        this.infoWindow.show();
    }

    private void setDirectory(File dir) {
        this.config = new FeatureCollectionConfig();
        if (dir.isDirectory()) {
            this.partitionTreeBrowser.setRoot(dir.toPath());
        }
    }

    private void setCollectionFromConfig(String name) {
        Document doc;
        Path f = Paths.get(name, new String[0]);
        if (!Files.exists(f, new LinkOption[0])) {
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(f.toFile());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error parsing featureCollection: " + e.getMessage());
            return;
        }
        XMLOutputter xmlOut = new XMLOutputter();
        System.out.println(xmlOut.outputString(doc));
        Formatter errlog = new Formatter();
        FeatureCollectionConfigBuilder builder = new FeatureCollectionConfigBuilder(errlog);
        this.config = builder.readConfig(doc.getRootElement());
        CollectionSpecParser spec = new CollectionSpecParser(this.config.spec, errlog);
        this.partitionTreeBrowser.setRoot(Paths.get(spec.getRootDir(), new String[0]));
    }

    private void setCollectionFromIndex(String indexFilename) {
        this.isFromIndex = true;
        this.config = new FeatureCollectionConfig();
        File indexFile = new File(indexFilename);
        File parentFile = indexFile.getParentFile();
        String name = indexFile.getName();
        String dirName = parentFile.getName();
        name = StringUtil2.removeFromEnd((String)name, (String)".ncx4");
        name = StringUtil2.removeFromEnd((String)name, (String)dirName);
        this.collectionName = name = StringUtil2.removeFromEnd((String)name, (String)"-");
        this.setDirectory(parentFile);
    }

    private void cmdSummarizePartitions(final NodeInfo node) {
        Thread background = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Iterator iterator;
                ArrayList<GribCollectionMutable> gclist;
                Formatter out = new Formatter();
                GribCdmIndex indexReader = new GribCdmIndex(logger);
                try (DirectoryPartition dpart = new DirectoryPartition(DirectoryPartitionViewer.this.config, node.dir, true, (IndexReader)indexReader, ".ncx4", logger);){
                    dpart.putAuxInfo("fcConfig", (Object)DirectoryPartitionViewer.this.config);
                    try {
                        Throwable throwable;
                        PartitionCollectionMutable tp;
                        block48: {
                            block49: {
                                tp = (PartitionCollectionMutable)GribCdmIndex.openMutableGCFromIndex((String)dpart.getIndexFilename(".ncx4"), (FeatureCollectionConfig)DirectoryPartitionViewer.this.config, (boolean)false, (boolean)true, (Logger)logger);
                                throwable = null;
                                if (tp != null) break block48;
                                if (tp == null) return;
                                if (throwable == null) break block49;
                                try {
                                    tp.close();
                                    return;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return;
                                }
                            }
                            tp.close();
                            return;
                        }
                        try {
                            for (MCollection dcmp : dpart.makePartitions(null)) {
                                dcmp.putAuxInfo("fcConfig", (Object)DirectoryPartitionViewer.this.config);
                                tp.addPartition(dcmp);
                            }
                            gclist = new ArrayList<GribCollectionMutable>();
                            iterator = tp.getPartitions().iterator();
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                        finally {
                            if (tp != null) {
                                if (throwable != null) {
                                    try {
                                        tp.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    tp.close();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        JOptionPane.showMessageDialog(DirectoryPartitionViewer.this, node.dir + " showPartitions failed: " + t.getMessage());
                        return;
                    }
                }
                while (true) {
                    if (!iterator.hasNext()) {
                        SwingUtilities.invokeLater(() -> {
                            DirectoryPartitionViewer.this.partitionsTable.clear();
                            DirectoryPartitionViewer.this.partitionsTable.setHeader(dpart.getCollectionName());
                            for (GribCollectionMutable gc : gclist) {
                                DirectoryPartitionViewer.this.partitionsTable.addGribCollection(gc);
                            }
                            DirectoryPartitionViewer.this.swap(DirectoryPartitionViewer.this.partitionsTable);
                        });
                        return;
                    }
                    PartitionCollectionMutable.Partition tpp = (PartitionCollectionMutable.Partition)iterator.next();
                    try {
                        GribCollectionMutable gc = tpp.makeGribCollection();
                        Throwable throwable = null;
                        try {
                            if (gc == null) continue;
                            gclist.add(gc);
                            continue;
                        }
                        catch (Throwable throwable6) {
                            throwable = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (gc == null) continue;
                            if (throwable != null) {
                                try {
                                    gc.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            gc.close();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        out.format("Failed to open partition %s%n", tpp.getName());
                        logger.error(" Failed to open partition " + tpp.getName(), t);
                        continue;
                    }
                    break;
                }
            }
        };
        background.start();
    }

    private void cmdShowIndex(NodeInfo node) {
        try {
            Path index = node.part.getIndex();
            if (index == null) {
                node.part.findIndex();
            }
            this.cdmIndexTables.setIndexFile(node.part.getIndex(), this.config);
            this.swap(this.cdmIndexTables);
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this, node + " showIndex failed: " + t.getMessage());
        }
    }

    private void cmdMakeIndex(NodeInfo node) {
        Formatter out = new Formatter();
        out.format("makeTimePartitionIndex %s%n%n", node);
        try {
            boolean ok = GribCdmIndex.makeIndex((FeatureCollectionConfig)this.config, (Formatter)out, (Path)node.dir);
            out.format("makeTimePartitionIndex success %s%n%n", ok);
            this.infoTA.setText(out.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
            node.refresh();
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this, node + " makeIndex failed: " + t.getMessage());
        }
    }

    public static class VarBean {
        GribCollectionMutable.VariableIndex v;
        GribCollectionMutable.GroupGC group;

        public VarBean() {
        }

        public VarBean(GribCollectionMutable.VariableIndex v, GribCollectionMutable.GroupGC group) {
            this.v = v;
            this.group = group;
        }

        public String getTimeCoord() {
            if (0 <= this.v.getCoordinateIdx(Coordinate.Type.time)) {
                return Coordinate.Type.time.toString();
            }
            if (0 <= this.v.getCoordinateIdx(Coordinate.Type.timeIntv)) {
                return Coordinate.Type.timeIntv.toString();
            }
            if (0 <= this.v.getCoordinateIdx(Coordinate.Type.time2D)) {
                return Coordinate.Type.time2D.toString();
            }
            return "ERR";
        }

        public int getVertCoord() {
            return this.v.getCoordinateIdx(Coordinate.Type.vert);
        }

        public int getEnsCoord() {
            return this.v.getCoordinateIdx(Coordinate.Type.ens);
        }

        public int getLevelType() {
            return this.v.levelType;
        }

        public int getIntvType() {
            return this.v.intvType;
        }

        public int getProbType() {
            return this.v.probType;
        }

        public int getEnsType() {
            return this.v.ensDerivedType;
        }

        public int getGenType() {
            return this.v.genProcessType;
        }

        public String getIntvName() {
            return this.v.getTimeIntvName();
        }

        public String getProbName() {
            return this.v.probabilityName;
        }

        public int getHash() {
            return this.v.hashCode();
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public String getVariableId() {
            return this.v.discipline + "-" + this.v.category + "-" + this.v.parameter;
        }
    }

    public static class GroupBean {
        String partitionName;
        String datasetName;
        GribCollectionMutable.GroupGC group;

        public GroupBean(GribCollectionMutable.GroupGC g, String datasetName, String partitionName) {
            this.group = g;
            this.partitionName = partitionName;
            this.datasetName = datasetName;
        }

        public GroupBean() {
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public int getGdsHash() {
            return this.group.getGdsHash().hashCode();
        }

        public int getNFiles() {
            return this.group.getNFiles();
        }

        public String getPartition() {
            return this.partitionName;
        }

        public String getDataset() {
            return this.datasetName;
        }

        void showFilesUsed(Formatter f) {
            List files = this.group.getFiles();
            for (MFile file : files) {
                f.format(" %s%n", file.getName());
            }
        }
    }

    public class GroupsBean {
        GribCollectionMutable.GroupGC group;
        List<GroupBean> beans = new ArrayList<GroupBean>(50);
        RangeTracker nvars;
        RangeTracker nfiles;
        RangeTracker ncoords;
        RangeTracker ntimes;

        public GroupsBean(GribCollectionMutable.GroupGC g) {
            this.group = g;
            this.nvars = new RangeTracker(this.count(g.getVariables().iterator()));
            this.nfiles = new RangeTracker(g.getNFiles());
            this.ncoords = new RangeTracker(this.count(g.getCoordinates().iterator()));
            this.ntimes = new RangeTracker(this.countTimes(g.getCoordinates().iterator()));
        }

        public GroupsBean() {
        }

        private int count(Iterator iter) {
            int count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            return count;
        }

        private int countTimes(Iterator<Coordinate> iter) {
            int count = 0;
            while (iter.hasNext()) {
                Coordinate c = iter.next();
                if (c.getType() != Coordinate.Type.time && c.getType() != Coordinate.Type.timeIntv && c.getType() != Coordinate.Type.time2D) continue;
                ++count;
            }
            return count;
        }

        public void addGroup(GribCollectionMutable.GroupGC g, String dataset, String partitionName) {
            this.beans.add(new GroupBean(g, dataset, partitionName));
            this.nvars.add(this.count(g.getVariables().iterator()));
            this.nfiles.add(g.getNFiles());
            this.ncoords.add(this.count(g.getCoordinates().iterator()));
            this.ntimes.add(this.countTimes(g.getCoordinates().iterator()));
        }

        public int getNPartitions() {
            return this.beans.size();
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public int getGdsHash() {
            return this.group.getGdsHash().hashCode();
        }

        public String getNVars() {
            return this.nvars.toString();
        }

        public String getNFiles() {
            return this.nfiles.toString();
        }

        public String getNCoords() {
            return this.ncoords.toString();
        }

        public String getNTimes() {
            return this.ntimes.toString();
        }
    }

    private static class RangeTracker {
        int min;
        int max;

        RangeTracker(int value) {
            this.min = value;
            this.max = value;
        }

        void add(int value) {
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
        }

        public String toString() {
            Formatter f = new Formatter();
            if (this.min == this.max) {
                f.format("%3d", this.min);
            } else {
                f.format("%3d - %3d", this.min, this.max);
            }
            return f.toString();
        }
    }

    private class PartitionsTable
    extends JPanel {
        private PreferencesExt prefs;
        private BeanTable groupsTable;
        private BeanTable groupTable;
        private BeanTable varTable;
        private JSplitPane split;
        Map<String, GroupsBean> groupsBeans = new HashMap<String, GroupsBean>(50);
        SortedSet<String> partitionsAll = new TreeSet<String>();

        public PartitionsTable(PreferencesExt prefs) {
            this.prefs = prefs;
            this.groupsTable = new BeanTable(GroupsBean.class, (PreferencesExt)prefs.node("GroupsBean"), false, "Groups", "GribCollection.GroupHcs", null);
            this.groupsTable.addListSelectionListener(e -> {
                GroupsBean bean = (GroupsBean)this.groupsTable.getSelectedBean();
                if (bean != null) {
                    this.setGroups(bean);
                }
            });
            this.groupTable = new BeanTable(GroupBean.class, (PreferencesExt)prefs.node("GroupBean"), false, "Partitions for this Group", "GribCollection.GroupGC", null);
            this.groupTable.addListSelectionListener(e -> {
                GroupBean bean = (GroupBean)this.groupTable.getSelectedBean();
                if (bean != null) {
                    this.setGroup(bean.group);
                }
            });
            PopupMenu varPopup = new PopupMenu((JComponent)this.groupTable.getJTable(), "Options");
            varPopup.addAction("Show Files Used", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupBean bean = (GroupBean)PartitionsTable.this.groupTable.getSelectedBean();
                    if (bean != null && bean.group != null) {
                        PartitionsTable.this.showFiles(null, bean.group);
                    }
                }
            });
            varPopup.addAction("Show Variable Difference", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List beans = PartitionsTable.this.groupTable.getSelectedBeans();
                    if (beans.size() == 2) {
                        Formatter f = new Formatter();
                        PartitionsTable.this.showVariableDifferences((GroupBean)beans.get(0), (GroupBean)beans.get(1), f);
                        DirectoryPartitionViewer.this.infoTA.setText(f.toString());
                        DirectoryPartitionViewer.this.infoTA.gotoTop();
                        DirectoryPartitionViewer.this.infoWindow.show();
                    }
                }
            });
            this.varTable = new BeanTable(VarBean.class, (PreferencesExt)prefs.node("Grib2Bean"), false, "Variables in group", "GribCollection.VariableIndex", null);
            varPopup = new PopupMenu((JComponent)this.varTable.getJTable(), "Options");
            varPopup.addAction("Show Variable", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VarBean bean = (VarBean)PartitionsTable.this.varTable.getSelectedBean();
                    if (bean != null) {
                        DirectoryPartitionViewer.this.infoTA.setText(bean.v.toStringComplete());
                        DirectoryPartitionViewer.this.infoTA.gotoTop();
                        DirectoryPartitionViewer.this.infoWindow.show();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.split = new JSplitPane(0, false, (Component)this.groupsTable, (Component)this.groupTable);
            this.split.setDividerLocation(prefs.getInt("splitPos2", 600));
            this.split = new JSplitPane(0, false, this.split, (Component)this.varTable);
            this.split.setDividerLocation(prefs.getInt("splitPos", 900));
            this.add((Component)this.split, "Center");
        }

        public void save() {
            this.groupsTable.saveState(false);
            this.groupTable.saveState(false);
            this.varTable.saveState(false);
            if (this.split != null) {
                this.prefs.putInt("splitPos", this.split.getDividerLocation());
            }
        }

        private void setHeader(String header) {
            this.groupsTable.setHeader(header);
        }

        private void setGroups(GroupsBean groups) {
            this.groupTable.setBeans(groups.beans);
        }

        private void setGroup(GribCollectionMutable.GroupGC group) {
            ArrayList<VarBean> vars = new ArrayList<VarBean>();
            for (GribCollectionMutable.VariableIndex v : group.getVariables()) {
                vars.add(new VarBean(v, group));
            }
            this.varTable.setBeans(vars);
        }

        private void showFiles(GribCollectionMutable gc, GribCollectionMutable.GroupGC group) {
            Collection files = group == null ? gc.getFiles() : group.getFiles();
            File dir = gc == null ? null : gc.getDirectory();
            DirectoryPartitionViewer.this.fileTable.setFiles(dir, files);
        }

        void showGroupDiffs(Formatter out) {
            HashMap<Integer, Groups> map = new HashMap<Integer, Groups>(100);
            for (GroupsBean gsbean : this.groupsBeans.values()) {
                for (GroupBean gbean : gsbean.beans) {
                    Groups gs = (Groups)map.get(gbean.getGdsHash());
                    if (gs == null) {
                        gs = new Groups(gsbean.getGroupId());
                        map.put(gbean.getGdsHash(), gs);
                    }
                    gs.parts.add(gbean.getPartition());
                }
            }
            ArrayList groups = new ArrayList(map.values());
            Collections.sort(groups);
            out.format("=======================Groups%n", new Object[0]);
            for (Groups gs : groups) {
                if (gs.parts.size() >= this.partitionsAll.size()) continue;
                out.format("Missing partitions for group %s:%n", gs.groupId);
                for (String p : this.partitionsAll) {
                    if (gs.parts.contains(p)) continue;
                    out.format("   %s%n", p);
                }
            }
            out.format("=======================Partitions%n", new Object[0]);
            for (String p : this.partitionsAll) {
                out.format("%s Missing groups:%n", p);
                for (Groups gs : groups) {
                    if (gs.parts.contains(p)) continue;
                    out.format("   %s%n", gs.groupId);
                }
            }
        }

        void clear() {
            this.groupsBeans = new HashMap<String, GroupsBean>(50);
            this.partitionsAll = new TreeSet<String>();
        }

        void addGribCollection(GribCollectionMutable gc) {
            String partitionName = gc.getLocation();
            int pos = partitionName.lastIndexOf("/");
            if (pos < 0) {
                pos = partitionName.lastIndexOf("\\");
            }
            if (pos > 0) {
                partitionName = partitionName.substring(0, pos);
            }
            this.partitionsAll.add(partitionName);
            for (GribCollectionMutable.Dataset ds : gc.getDatasets()) {
                for (GribCollectionMutable.GroupGC g : ds.getGroups()) {
                    GroupsBean bean = this.groupsBeans.get(g.getId());
                    if (bean == null) {
                        bean = new GroupsBean(g);
                        this.groupsBeans.put(g.getId(), bean);
                    }
                    bean.addGroup(g, ds.gctype.toString(), partitionName);
                }
            }
            this.groupsTable.setBeans(new ArrayList<GroupsBean>(this.groupsBeans.values()));
        }

        void showVariableDifferences(GroupBean bean1, GroupBean bean2, Formatter f) {
            f.format("Compare %s to %s%n", bean1.getPartition(), bean2.getPartition());
            for (GribCollectionMutable.VariableIndex var1 : bean1.group.getVariables()) {
                if (bean2.group.findVariableByHash(var1) != null) continue;
                f.format("Var1 %s missing in partition 2%n", var1.id());
            }
            for (GribCollectionMutable.VariableIndex var2 : bean2.group.getVariables()) {
                if (bean1.group.findVariableByHash(var2) != null) continue;
                f.format("Var2 %s missing in partition 1%n", var2.id());
            }
        }

        private class Groups
        implements Comparable<Groups> {
            String groupId;
            SortedSet<String> parts = new TreeSet<String>();

            private Groups(String id) {
                this.groupId = id;
            }

            @Override
            public int compareTo(Groups o2) {
                return this.groupId.compareTo(o2.groupId);
            }
        }
    }

    private class PartitionTreeBrowser {
        private Icon dirIcon = UIManager.getIcon("FileView.directoryIcon");
        private Icon fileIcon = UIManager.getIcon("FileView.fileIcon");
        private NodeInfo currentNode;
        JTree tree;
        private DefaultTreeModel treeModel;
        private JProgressBar progressBar;
        JPanel view;
        private JLabel nodeName;
        private JTextField path;
        private JLabel date;
        private JLabel size;
        private JCheckBox readable;
        private JCheckBox writable;
        private JRadioButton isDirectory;
        private JRadioButton isFile;

        public void setRoot(Path rootDir) {
            if (!Files.isDirectory(rootDir, new LinkOption[0])) {
                return;
            }
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            root.setUserObject(new NodeInfo(rootDir));
            this.treeModel = new DefaultTreeModel(root);
            this.tree.setModel(this.treeModel);
            this.tree.setSelectionInterval(0, 0);
        }

        public PartitionTreeBrowser() {
            int ii;
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            this.treeModel = new DefaultTreeModel(root);
            TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent tse) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tse.getPath().getLastPathComponent();
                    PartitionTreeBrowser.this.showChildren(node);
                    PartitionTreeBrowser.this.currentNode = (NodeInfo)node.getUserObject();
                    PartitionTreeBrowser.this.setFileDetails(PartitionTreeBrowser.this.currentNode);
                }
            };
            this.tree = new JTree(this.treeModel);
            this.tree.setRootVisible(true);
            this.tree.addTreeSelectionListener(treeSelectionListener);
            this.tree.setCellRenderer(new FileTreeCellRenderer());
            this.tree.expandRow(0);
            this.tree.setToggleClickCount(1);
            this.tree.setVisibleRowCount(15);
            JScrollPane treeScroll = new JScrollPane(this.tree);
            Dimension preferredSize = treeScroll.getPreferredSize();
            Dimension widePreferred = new Dimension(200, (int)preferredSize.getHeight());
            treeScroll.setPreferredSize(widePreferred);
            this.makePopups();
            JPanel filePanel = new JPanel(new BorderLayout(4, 2));
            filePanel.setBorder(new EmptyBorder(0, 6, 0, 6));
            JPanel fileDetailsLabels = new JPanel(new GridLayout(0, 1, 2, 2));
            filePanel.add((Component)fileDetailsLabels, "West");
            JPanel fileDetailsValues = new JPanel(new GridLayout(0, 1, 2, 2));
            filePanel.add((Component)fileDetailsValues, "Center");
            fileDetailsLabels.add(new JLabel("File", 11));
            this.nodeName = new JLabel();
            fileDetailsValues.add(this.nodeName);
            fileDetailsLabels.add(new JLabel("Path/name", 11));
            this.path = new JTextField(5);
            this.path.setEditable(false);
            fileDetailsValues.add(this.path);
            fileDetailsLabels.add(new JLabel("Last Modified", 11));
            this.date = new JLabel();
            fileDetailsValues.add(this.date);
            fileDetailsLabels.add(new JLabel("File size", 11));
            this.size = new JLabel();
            fileDetailsValues.add(this.size);
            fileDetailsLabels.add(new JLabel("Type", 11));
            JPanel flags = new JPanel(new FlowLayout(3, 4, 0));
            this.isDirectory = new JRadioButton("Directory");
            flags.add(this.isDirectory);
            this.isFile = new JRadioButton("File");
            flags.add(this.isFile);
            fileDetailsValues.add(flags);
            flags.add(new JLabel("::  Flags"));
            this.readable = new JCheckBox("Read  ");
            this.readable.setMnemonic('a');
            flags.add(this.readable);
            this.writable = new JCheckBox("Write  ");
            this.writable.setMnemonic('w');
            flags.add(this.writable);
            int count = fileDetailsLabels.getComponentCount();
            for (ii = 0; ii < count; ++ii) {
                fileDetailsLabels.getComponent(ii).setEnabled(false);
            }
            count = flags.getComponentCount();
            for (ii = 0; ii < count; ++ii) {
                flags.getComponent(ii).setEnabled(false);
            }
            this.progressBar = new JProgressBar();
            this.progressBar.setVisible(true);
            this.view = new JPanel(new BorderLayout(3, 3));
            this.view.add((Component)this.progressBar, "North");
            this.view.add((Component)filePanel, "Center");
        }

        private void makePopups() {
            PopupMenu varPopup = new PopupMenu((JComponent)this.tree, "Options");
            varPopup.addAction("Make Index(es)", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath[] selectionPaths = PartitionTreeBrowser.this.tree.getSelectionPaths();
                    if (selectionPaths == null) {
                        selectionPaths = new TreePath[]{};
                    }
                    for (TreePath path : selectionPaths) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        DirectoryPartitionViewer.this.cmdMakeIndex((NodeInfo)node.getUserObject());
                    }
                }
            });
            varPopup.addAction("Show Index", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DirectoryPartitionViewer.this.cmdShowIndex(PartitionTreeBrowser.this.currentNode);
                }
            });
            varPopup.addAction("Summarize Children Partitions", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            DirectoryPartitionViewer.this.cmdSummarizePartitions(PartitionTreeBrowser.this.currentNode);
                        }
                    }.start();
                }
            });
        }

        private void showChildren(final DefaultMutableTreeNode node) {
            this.tree.setEnabled(false);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            final ArrayList<NodeInfo> result = new ArrayList<NodeInfo>(100);
            NodeInfo uobj = (NodeInfo)node.getUserObject();
            if (uobj.hasIndex && uobj.isPartition) {
                result.addAll(uobj.getChildren());
            } else {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(uobj.dir);){
                    for (Path child : stream) {
                        if (!Files.isDirectory(child, new LinkOption[0])) continue;
                        result.add(new NodeInfo(child));
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            if (result.isEmpty()) {
                this.progressBar.setIndeterminate(false);
                this.tree.setEnabled(true);
                return;
            }
            SwingWorker<Void, NodeInfo> worker = new SwingWorker<Void, NodeInfo>(){

                @Override
                public Void doInBackground() {
                    for (NodeInfo child : result) {
                        this.publish(child);
                    }
                    return null;
                }

                @Override
                protected void process(List<NodeInfo> chunks) {
                    for (NodeInfo child : chunks) {
                        node.add(new DefaultMutableTreeNode(child));
                    }
                }

                @Override
                protected void done() {
                    PartitionTreeBrowser.this.progressBar.setIndeterminate(false);
                    PartitionTreeBrowser.this.tree.setEnabled(true);
                }
            };
            worker.execute();
        }

        private void setFileDetails(NodeInfo node) {
            BasicFileAttributes attr;
            try {
                attr = Files.readAttributes(node.dir, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                logger.warn("An I/O error occurred.", (Throwable)e);
                return;
            }
            this.nodeName.setIcon(attr.isDirectory() ? this.dirIcon : this.fileIcon);
            this.nodeName.setText(node.dir.toString());
            this.path.setText(node.dir.toString());
            this.date.setText(attr.lastModifiedTime().toString());
            this.size.setText(attr.size() + " bytes");
            this.readable.setSelected(Files.isReadable(node.dir));
            this.writable.setSelected(Files.isWritable(node.dir));
            this.isDirectory.setSelected(attr.isDirectory());
            DirectoryPartitionViewer.this.repaint();
        }

        private class FileTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private JLabel label = new JLabel();

            FileTreeCellRenderer() {
                this.label.setOpaque(true);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                NodeInfo uobj = (NodeInfo)node.getUserObject();
                if (uobj != null) {
                    this.label.setIcon(uobj.hasIndex ? PartitionTreeBrowser.this.fileIcon : PartitionTreeBrowser.this.dirIcon);
                    this.label.setText(uobj.hasIndex ? uobj.part.getIndex().toString() : uobj.dir.toString());
                }
                if (selected) {
                    this.label.setBackground(this.backgroundSelectionColor);
                    this.label.setForeground(this.textSelectionColor);
                } else {
                    this.label.setBackground(this.backgroundNonSelectionColor);
                    this.label.setForeground(this.textNonSelectionColor);
                }
                return this.label;
            }
        }
    }

    private class NodeInfo {
        Path dir;
        DirectoryBuilder part;
        boolean hasIndex;
        boolean isPartition = true;

        NodeInfo(Path dir) {
            this.dir = dir;
            try {
                this.part = new DirectoryBuilder(DirectoryPartitionViewer.this.collectionName, dir, null, ".ncx4");
                this.hasIndex = this.part.getIndex() != null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        NodeInfo(DirectoryBuilder part) {
            this.part = part;
            this.dir = part.getDir();
            this.hasIndex = part.getIndex() != null;
        }

        List<NodeInfo> getChildren() {
            return DirectoryPartitionViewer.this.isFromIndex ? this.getChildrenFromIndex() : this.getChildrenFromScan();
        }

        private List<NodeInfo> getChildrenFromIndex() {
            ArrayList<NodeInfo> result = new ArrayList<NodeInfo>(100);
            try {
                for (DirectoryBuilder child : this.part.constructChildrenFromIndex((IndexReader)new GribCdmIndex(logger), true)) {
                    result.add(new NodeInfo(child));
                }
                this.isPartition = !result.isEmpty();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        }

        private List<NodeInfo> getChildrenFromScan() {
            ArrayList<NodeInfo> result = new ArrayList<NodeInfo>(100);
            try {
                for (DirectoryBuilder child : this.part.constructChildren((IndexReader)new GribCdmIndex(logger), CollectionUpdateType.test)) {
                    result.add(new NodeInfo(child));
                }
                this.isPartition = !result.isEmpty();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        }

        void refresh() {
            try {
                this.hasIndex = this.part.findIndex();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("NodeInfo{ dir= %s", this.dir);
            if (this.hasIndex) {
                f.format(" index= %s", this.part.getIndex());
            }
            f.format("}", new Object[0]);
            return f.toString();
        }
    }
}

