/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.geoloc;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import ucar.nc2.ui.geoloc.Rubberband;

public class RubberbandRectangleHandles
extends Rubberband {
    public static double handleSizePixels = 6.0;
    private Rectangle current;
    private int minDiff;

    public RubberbandRectangleHandles(Component c, boolean listen) {
        super(c, listen);
    }

    public void setRectangle(Rectangle current) {
        this.current = current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(int deltax, int deltay) {
        this.lastPt.x = this.stretchedPt.x;
        this.lastPt.y = this.stretchedPt.y;
        Graphics2D g = (Graphics2D)this.component.getGraphics();
        if (g != null) {
            try {
                g.setXORMode(this.component.getBackground());
                if (this.firstStretch) {
                    this.firstStretch = false;
                } else {
                    this.drawLast(g);
                }
                this.anchorPt.x = this.current.x + deltax;
                this.anchorPt.y = this.current.y + deltay;
                this.stretchedPt.x = this.current.x + this.current.width + deltax;
                this.stretchedPt.y = this.current.y + this.current.height + deltay;
                this.drawNext(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    @Override
    public boolean anchor(Point p) {
        if (this.current == null) {
            return false;
        }
        this.minDiff = Integer.MAX_VALUE;
        this.testDiff(p, this.current.x, this.current.y, this.current.x + this.current.width, this.current.y + this.current.height);
        this.testDiff(p, this.current.x + this.current.width, this.current.y, this.current.x, this.current.y + this.current.height);
        this.testDiff(p, this.current.x, this.current.y + this.current.height, this.current.x + this.current.width, this.current.y);
        this.testDiff(p, this.current.x + this.current.width, this.current.y + this.current.height, this.current.x, this.current.y);
        if (this.minDiff > 100) {
            return false;
        }
        this.stretchedPt.x = this.lastPt.x = p.x;
        this.stretchedPt.y = this.lastPt.y = p.y;
        this.firstStretch = true;
        return true;
    }

    private void testDiff(Point p, int x, int y, int anchor_x, int anchor_y) {
        int dx = p.x - x;
        int dy = p.y - y;
        int diff = dx * dx + dy * dy;
        if (diff < this.minDiff) {
            this.minDiff = diff;
            this.anchorPt.x = anchor_x;
            this.anchorPt.y = anchor_y;
        }
    }

    @Override
    public void drawLast(Graphics2D graphics) {
        RubberbandRectangleHandles.drawHandledRect(graphics, this.lastBounds(), handleSizePixels);
    }

    @Override
    public void drawNext(Graphics2D graphics) {
        RubberbandRectangleHandles.drawHandledRect(graphics, this.getBounds(), handleSizePixels);
    }

    public static void drawHandledRect(Graphics2D graphics, Rectangle2D rect, double handleSize) {
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        graphics.draw(rect);
        Rectangle2D.Double hr = new Rectangle2D.Double();
        ((Rectangle2D)hr).setRect(x - handleSize / 2.0, y - handleSize / 2.0, handleSize, handleSize);
        graphics.fill(hr);
        ((Rectangle2D)hr).setRect(x + w - handleSize / 2.0, y - handleSize / 2.0, handleSize, handleSize);
        graphics.fill(hr);
        ((Rectangle2D)hr).setRect(x - handleSize / 2.0, y + h - handleSize / 2.0, handleSize, handleSize);
        graphics.fill(hr);
        ((Rectangle2D)hr).setRect(x + w - handleSize / 2.0, y + h - handleSize / 2.0, handleSize, handleSize);
        graphics.fill(hr);
    }
}

