/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.AbstractButton;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.op.Fmrc2Panel;
import ucar.ui.widget.BAMutil;
import ucar.util.prefs.PreferencesExt;

public class FmrcPanel
extends OpPanel {
    private Fmrc2Panel table;

    public FmrcPanel(PreferencesExt dbPrefs) {
        super(dbPrefs, "collection:", true, false);
        this.table = new Fmrc2Panel(this.prefs);
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                switch (e.getPropertyName()) {
                    case "openNetcdfFile": {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.getToolsUI().openNetcdfFile((String)e.getNewValue());
                            break;
                        }
                        ToolsUI.getToolsUI().openNetcdfFile((NetcdfFile)e.getNewValue());
                        break;
                    }
                    case "openCoordSys": {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.getToolsUI().openCoordSystems((String)e.getNewValue());
                            break;
                        }
                        ToolsUI.getToolsUI().openCoordSystems((NetcdfDataset)e.getNewValue());
                        break;
                    }
                    case "openGridDataset": {
                        if (e.getNewValue() instanceof String) {
                            ToolsUI.getToolsUI().openGridDataset((String)e.getNewValue());
                            break;
                        }
                        ToolsUI.getToolsUI().openGridDataset((GridDataset)e.getNewValue());
                    }
                }
            }
        });
        this.add((Component)this.table, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Detail Info", (boolean)false);
        infoButton.addActionListener(e -> {
            Formatter f = new Formatter();
            try {
                this.table.showInfo(f);
            }
            catch (IOException e1) {
                StringWriter sw = new StringWriter(5000);
                e1.printStackTrace(new PrintWriter(sw));
                f.format("%s", sw.toString());
            }
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(infoButton);
        AbstractButton collectionButton = BAMutil.makeButtcon((String)"Information", (String)"Collection Parsing Info", (boolean)false);
        collectionButton.addActionListener(e -> this.table.showCollectionInfo(true));
        this.buttPanel.add(collectionButton);
        AbstractButton viewButton = BAMutil.makeButtcon((String)"Dump", (String)"Show Dataset", (boolean)false);
        viewButton.addActionListener(e -> {
            try {
                this.table.showDataset();
            }
            catch (IOException e1) {
                StringWriter sw = new StringWriter(5000);
                e1.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(viewButton);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        if (command == null) {
            return false;
        }
        try {
            this.table.setFmrc(command);
            return true;
        }
        catch (Exception ioe) {
            StringWriter sw = new StringWriter(5000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
            return false;
        }
    }

    @Override
    public void save() {
        this.table.save();
        super.save();
    }

    @Override
    public void closeOpenFiles() throws IOException {
        this.table.closeOpenFiles();
    }
}

