/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.EventObject;
import javax.swing.JPanel;
import ucar.nc2.ui.geoloc.CursorMoveEvent;
import ucar.nc2.ui.geoloc.CursorMoveEventListener;
import ucar.nc2.ui.geoloc.PickEvent;
import ucar.nc2.ui.geoloc.PickEventListener;
import ucar.nc2.util.ListenerManager;

public class ScaledPanel
extends JPanel {
    private Color backColor = Color.white;
    private Rectangle2D screenBounds = new Rectangle2D.Double();
    private Bounds worldBounds = new Bounds();
    private Point2D worldPt = new Point2D.Double();
    private AffineTransform transform = new AffineTransform();
    private BufferedImage bImage;
    private MyImageObserver imageObs = new MyImageObserver();
    private ListenerManager lmPick;
    private ListenerManager lmMove;
    private boolean debugDraw;
    private boolean debugTransform;
    private boolean debugBounds;

    public ScaledPanel() {
        this.setDoubleBuffered(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                boolean sameSize;
                Rectangle nb = ScaledPanel.this.getBounds();
                boolean bl = sameSize = (double)nb.width == ScaledPanel.this.screenBounds.getWidth() && (double)nb.height == ScaledPanel.this.screenBounds.getHeight();
                if (ScaledPanel.this.debugBounds) {
                    System.out.println("TPanel setBounds old= " + ScaledPanel.this.screenBounds);
                }
                ScaledPanel.this.screenBounds.setRect(nb);
                if (ScaledPanel.this.bImage != null && sameSize) {
                    return;
                }
                if (ScaledPanel.this.debugBounds) {
                    System.out.println("  newBounds = " + nb);
                }
                if (nb.width > 0 && nb.height > 0) {
                    ScaledPanel.this.bImage = new BufferedImage(nb.width, nb.height, 1);
                } else {
                    ScaledPanel.this.bImage = null;
                }
                ScaledPanel.this.transform = null;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ScaledPanel.this.lmPick.hasListeners() && ScaledPanel.this.transform != null) {
                    try {
                        ScaledPanel.this.transform.inverseTransform(e.getPoint(), ScaledPanel.this.worldPt);
                        ScaledPanel.this.lmPick.sendEvent((EventObject)new PickEvent((Object)ScaledPanel.this, ScaledPanel.this.worldPt));
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ScaledPanel.this.lmMove.hasListeners() && ScaledPanel.this.transform != null) {
                    try {
                        ScaledPanel.this.transform.inverseTransform(e.getPoint(), ScaledPanel.this.worldPt);
                        ScaledPanel.this.lmMove.sendEvent((EventObject)new CursorMoveEvent((Object)ScaledPanel.this, ScaledPanel.this.worldPt));
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                }
            }
        });
        this.lmPick = new ListenerManager("ucar.nc2.ui.geoloc.PickEventListener", "ucar.nc2.ui.geoloc.PickEvent", "actionPerformed");
        this.lmMove = new ListenerManager("ucar.nc2.ui.geoloc.CursorMoveEventListener", "ucar.nc2.ui.geoloc.CursorMoveEvent", "actionPerformed");
    }

    public void addCursorMoveEventListener(CursorMoveEventListener l) {
        this.lmMove.addListener((Object)l);
    }

    public void removeCursorMoveEventListener(CursorMoveEventListener l) {
        this.lmMove.removeListener((Object)l);
    }

    public void addPickEventListener(PickEventListener l) {
        this.lmPick.addListener((Object)l);
    }

    public void removePickEventListener(PickEventListener l) {
        this.lmPick.removeListener((Object)l);
    }

    public void setWorldBounds(Bounds world) {
        this.worldBounds.set(world);
        this.transform = null;
        if (this.debugBounds) {
            System.out.println("  setWorldBounds = " + this.worldBounds);
        }
    }

    public Bounds getWorldBounds() {
        return this.worldBounds;
    }

    public Graphics2D getBufferedImageGraphics() {
        if (this.bImage == null) {
            return null;
        }
        Graphics2D g2 = this.bImage.createGraphics();
        if (this.transform == null) {
            this.transform = this.calcTransform(this.screenBounds, this.worldBounds);
        }
        g2.setTransform(this.transform);
        g2.setStroke(new BasicStroke(0.0f));
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setBackground(this.backColor);
        g2.setClip(this.worldBounds.getRect());
        return g2;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.bImage != null) {
            g.drawImage(this.bImage, 0, 0, this.backColor, this.imageObs);
        }
    }

    public void drawNow() {
        Graphics g = this.getGraphics();
        if (null != g) {
            this.paintComponent(g);
            g.dispose();
        }
    }

    private AffineTransform calcTransform(Rectangle2D screen, Bounds world) {
        double xs = screen.getWidth() / (world.getRight() - world.getLeft());
        double ys = screen.getHeight() / (world.getLower() - world.getUpper());
        AffineTransform cat = new AffineTransform();
        cat.setToScale(xs, ys);
        cat.translate(-world.getLeft(), -world.getUpper());
        if (this.debugTransform) {
            System.out.println("TPanel calcTransform = ");
            System.out.println("  screen = " + screen);
            System.out.println("  world = " + world);
            System.out.println("  transform = " + cat.getScaleX() + " " + cat.getShearX() + " " + cat.getTranslateX());
            System.out.println("              " + cat.getShearY() + " " + cat.getScaleY() + " " + cat.getTranslateY());
            Point2D.Double src = new Point2D.Double(world.getLeft(), world.getUpper());
            Point2D.Double dst = new Point2D.Double(0.0, 0.0);
            System.out.println("  upper left pt = " + src);
            System.out.println("  transform = " + cat.transform(src, dst));
            src = new Point2D.Double(world.getRight(), world.getLower());
            System.out.println("  lower right pt = " + src);
            System.out.println("  transform = " + cat.transform(src, dst));
        }
        return cat;
    }

    public static class Bounds {
        private double left;
        private double right;
        private double upper;
        private double lower;

        public Bounds() {
            this(0.0, 0.0, 0.0, 0.0);
        }

        public Bounds(double left, double right, double upper, double lower) {
            this.left = left;
            this.right = right;
            this.upper = upper;
            this.lower = lower;
        }

        public double getUpper() {
            return this.upper;
        }

        public double getLower() {
            return this.lower;
        }

        public double getRight() {
            return this.right;
        }

        public double getLeft() {
            return this.left;
        }

        public void set(Bounds b) {
            this.upper = b.getUpper();
            this.lower = b.getLower();
            this.right = b.getRight();
            this.left = b.getLeft();
        }

        public Rectangle2D getRect() {
            return new Rectangle2D.Double(Math.min(this.left, this.right), Math.min(this.lower, this.upper), Math.abs(this.right - this.left), Math.abs(this.lower - this.upper));
        }

        public String toString() {
            return "left: " + this.left + " right: " + this.right + " upper: " + this.upper + " lower: " + this.lower;
        }
    }

    private static class MyImageObserver
    implements ImageObserver {
        private MyImageObserver() {
        }

        @Override
        public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
            return true;
        }
    }
}

