/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class CdmIndexScan
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(CdmIndexScan.class);
    private final PreferencesExt prefs;
    private final BeanTable<IndexScanBean> indexBeanTable;
    private final JSplitPane split;
    private final TextHistoryPane dumpTA;
    private final IndependentWindow infoWindow;
    private boolean subdirs = true;
    String lastFilename;

    public CdmIndexScan(PreferencesExt prefs) {
        this.prefs = prefs;
        this.indexBeanTable = new BeanTable(IndexScanBean.class, (PreferencesExt)prefs.node("IndexScanBeans"), false);
        this.indexBeanTable.addListSelectionListener(e -> this.setSelectedBean((IndexScanBean)this.indexBeanTable.getSelectedBean()));
        PopupMenu varPopup = new PopupMenu((JComponent)this.indexBeanTable.getJTable(), "Options");
        varPopup.addAction("Open Index File", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexScanBean ftb = (IndexScanBean)CdmIndexScan.this.indexBeanTable.getSelectedBean();
                if (ftb != null) {
                    CdmIndexScan.this.firePropertyChange("openIndexFile", null, ftb.path);
                }
            }
        });
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, (Component)this.indexBeanTable, (Component)this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.indexBeanTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
    }

    public void clear() {
        this.indexBeanTable.setBeans(new ArrayList());
    }

    public boolean setScanDirectory(String dirName) {
        List<IndexScanBean> beans;
        this.clear();
        try {
            beans = this.scan(dirName);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.dumpTA.setText(e.getMessage());
            return false;
        }
        if (beans.isEmpty()) {
            this.dumpTA.setText("No .ncx4 files were found");
            return false;
        }
        this.indexBeanTable.setBeans(beans);
        return true;
    }

    private void setSelectedBean(IndexScanBean ftb) {
        if (ftb == null) {
            return;
        }
        this.dumpTA.setText(ftb.toString());
        this.dumpTA.gotoTop();
    }

    public List<IndexScanBean> scan(String topDir) throws IOException {
        ArrayList<IndexScanBean> result = new ArrayList<IndexScanBean>();
        File topFile = new File(topDir);
        if (!topFile.exists()) {
            this.dumpTA.appendLine(String.format("File %s does not exist", topDir));
            return result;
        }
        Formatter info = new Formatter();
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, result, info);
        } else {
            Accum accum = new Accum();
            this.openCdmIndex(topFile.getPath(), accum, result, info);
            info.format("%n%s%n", accum);
        }
        this.dumpTA.setText(info.toString());
        return result;
    }

    private void scanDirectory(File dir, List<IndexScanBean> result, Formatter info) throws IOException {
        if (dir.getName().equals("exclude") || dir.getName().equals("problem")) {
            return;
        }
        File[] fila = dir.listFiles();
        if (fila == null) {
            return;
        }
        for (File f : fila) {
            if (f.isDirectory() || !f.getName().endsWith(".ncx4")) continue;
            Accum totalAccum = new Accum();
            this.openCdmIndex(f.getPath(), totalAccum, result, info);
            info.format("%n%s%n", totalAccum);
        }
        if (this.subdirs) {
            for (File f : fila) {
                if (!f.isDirectory() || f.getName().equals("exclude")) continue;
                this.scanDirectory(f, result, info);
            }
        }
    }

    private void openCdmIndex(String path, Accum accum, List<IndexScanBean> result, Formatter info) throws IOException {
        info.format("%nFile %s%n", path);
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        try (GribCollectionImmutable gc = GribCdmIndex.openCdmIndex((String)path, (FeatureCollectionConfig)config, (boolean)false, (Logger)logger);){
            if (gc == null) {
                info.format("Not a grib collection index file=%s%n" + path, new Object[0]);
                return;
            }
            for (GribCollectionImmutable.Dataset ds : gc.getDatasets()) {
                info.format("%nDataset %s%n", ds.getType());
                int groupno = 0;
                for (GribCollectionImmutable.GroupGC g : ds.getGroups()) {
                    if (g.getType() == GribCollectionImmutable.Type.Best) continue;
                    Formatter localInfo = new Formatter();
                    localInfo.format("File %s%n", path);
                    Accum groupAccum = new Accum();
                    localInfo.format(" Group %s%n", g.getDescription());
                    for (GribCollectionImmutable.VariableIndex v : g.getVariables()) {
                        localInfo.format("  %s%n", v.toStringFrom());
                        this.showIfNonZero(info, v, path);
                        groupAccum.add(v);
                        accum.add(v);
                    }
                    info.format(" total %s%n", groupAccum);
                    localInfo.format(" total %s%n", groupAccum);
                    result.add(new IndexScanBean(path, ds, g, groupno++, groupAccum, localInfo.toString()));
                }
            }
        }
    }

    void showIfNonZero(Formatter info, GribCollectionImmutable.VariableIndex v, String filename) {
        if (v.getNdups() != 0 || v.getNmissing() != 0) {
            if (!filename.equals(this.lastFilename)) {
                info.format(" %s%n  %s%n", filename, v.toStringFrom());
            } else {
                info.format("  %s%n", v.toStringFrom());
            }
            this.lastFilename = filename;
        }
    }

    public static class IndexScanBean {
        public String path;
        public String name;
        public Accum accum;
        public String info;
        public String time2D;
        public GribCollectionImmutable.Dataset ds;
        public int groupno;

        public IndexScanBean() {
        }

        public IndexScanBean(String path, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, int groupno, Accum accum, String info) {
            this.path = path;
            int pos = path.lastIndexOf(47);
            this.name = ".." + path.substring(pos);
            this.accum = accum;
            this.ds = ds;
            this.groupno = groupno;
            this.info = info;
            boolean hasTime2D = false;
            boolean hasOrthogonal = false;
            boolean hasRegular = false;
            for (Coordinate coord : group.getCoordinates()) {
                if (coord.getType() != Coordinate.Type.time2D) continue;
                hasTime2D = true;
                CoordinateTime2D c2d = (CoordinateTime2D)coord;
                if (c2d.isOrthogonal()) {
                    hasOrthogonal = true;
                }
                if (!c2d.isRegular()) continue;
                hasRegular = true;
            }
            this.time2D = hasRegular ? "reg" : (hasOrthogonal ? "orth" : (hasTime2D ? "time2D" : ""));
        }

        public String getName() {
            return this.name;
        }

        public int getNrecords() {
            return this.accum.nrecords;
        }

        public int getNdups() {
            return this.accum.ndups;
        }

        public float getNdupPct() {
            return this.accum.nrecords == 0 ? 0.0f : 100.0f * (float)this.accum.ndups / (float)this.accum.nrecords;
        }

        public int getNmissing() {
            return this.accum.nmissing;
        }

        public float getNmissPct() {
            return this.accum.nrecords == 0 ? 0.0f : 100.0f * (float)this.accum.nmissing / (float)this.accum.nrecords;
        }

        public String getType() {
            return this.ds.getType().toString();
        }

        public int getGroupNo() {
            return this.groupno;
        }

        public String getTime2D() {
            return this.time2D;
        }

        public String toString() {
            return this.info;
        }
    }

    private static class Accum {
        int nrecords;
        int ndups;
        int nmissing;

        private Accum() {
        }

        Accum add(GribCollectionImmutable.VariableIndex v) {
            this.nrecords += v.getNrecords();
            this.ndups += v.getNdups();
            this.nmissing += v.getSize() - v.getNrecords();
            return this;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("Accum{nrecords=%d, ", this.nrecords);
            double fn = (double)this.nrecords / 100.0;
            f.format("ndups=%d (%3.1f %%), ", this.ndups, (double)this.ndups / fn);
            f.format("nmissing=%d (%3.1f %%)}", this.nmissing, (double)this.nmissing / fn);
            return f.toString();
        }
    }
}

