/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Utils;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTableReader;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.ui.ReportPanel;
import ucar.nc2.util.Counters;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Grib1ReportPanel
extends ReportPanel {
    private Grib1Customizer cust;

    public Grib1ReportPanel(PreferencesExt prefs) {
        super(prefs);
    }

    @Override
    public Object[] getOptions() {
        return Report.values();
    }

    @Override
    protected void doReport(Formatter f, Object option, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        this.cust = null;
        switch ((Report)((Object)option)) {
            case checkTables: {
                this.doCheckTables(f, dcm, useIndex);
                break;
            }
            case gds: {
                this.doUniqueGds(f, dcm, useIndex);
                break;
            }
            case showLocalParams: {
                this.doCheckLocalParams(f, dcm, useIndex);
                break;
            }
            case summary: {
                this.doScanIssues(f, dcm, useIndex, eachFile, extra);
                break;
            }
            case rename: {
                this.doRename(f, dcm, useIndex);
                break;
            }
            case showEncoding: {
                this.doShowEncoding(f, dcm);
                break;
            }
            case gribIndex: {
                this.doGribIndex(f, dcm, eachFile);
            }
        }
    }

    private Grib1Index createIndex(MFile mf) throws IOException {
        Grib1Index index = new Grib1Index();
        String path = mf.getPath();
        if (!index.readIndex(path, mf.getLastModified())) {
            try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
                if (!Grib1RecordScanner.isValidFile((RandomAccessFile)raf)) {
                    Grib1Index grib1Index = null;
                    return grib1Index;
                }
                index.makeIndex(path, raf);
            }
        }
        return index;
    }

    private void doGribIndex(Formatter f, MCollection dcm, boolean eachFile) throws IOException {
        Counters counters = new Counters();
        try (MCollection dcm2 = this.getCollectionUnfiltered(this.spec, f);){
            for (MFile mfile : dcm2.getFilesSorted()) {
                String path = mfile.getPath();
                f.format(" %s%n", path);
                this.doGribIndex(f, mfile, counters, eachFile);
            }
        }
        counters.show(f);
    }

    private void doGribIndex(Formatter fm, MFile ff, Counters counters, boolean eachFile) throws IOException {
        String path = ff.getPath();
        Grib1Index g1idx = new Grib1Index();
        g1idx.readIndex(path, 0L, CollectionUpdateType.nocheck);
        counters.count("GDS", (Comparable)Integer.valueOf(g1idx.getGds().size()));
        HashSet<Integer> gdsHash = new HashSet<Integer>();
        for (Grib1SectionGridDefinition gdss : g1idx.getGds()) {
            gdsHash.add(gdss.getGDS().hashCode());
        }
        counters.count("GDShashes", (Comparable)Integer.valueOf(gdsHash.size()));
        if (eachFile) {
            fm.format("   count=%d countHash=%d%n", g1idx.getGds().size(), gdsHash.size());
        }
    }

    private void doCheckLocalParams(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Check Grib-1 Parameter Tables for local entries%n", new Object[0]);
        int[] accum = new int[4];
        for (MFile mfile : dcm.getFilesSorted()) {
            String path = mfile.getPath();
            f.format("%n %s%n", path);
            try {
                this.doCheckLocalParams(mfile, f, accum);
            }
            catch (Throwable t) {
                System.out.printf("FAIL on %s%n", mfile.getPath());
                t.printStackTrace();
            }
        }
        f.format("%nGrand total=%d local = %d missing = %d%n", accum[0], accum[2], accum[3]);
    }

    private void doCheckLocalParams(MFile ff, Formatter fm, int[] accum) throws IOException {
        int local = 0;
        int miss = 0;
        int nonop = 0;
        int total = 0;
        try (GridDataset ncfile = GridDataset.open((String)ff.getPath());){
            Attribute gatt = ncfile.attributes().findAttribute("GRIB table");
            if (gatt != null) {
                String[] s = gatt.getStringValue().split("-");
                Grib1ParamTableReader gtable = new Grib1ParamTables().getParameterTable(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
                fm.format("  %s == %s%n", gatt, gtable.getPath());
            }
            for (GridDatatype dt : ncfile.getGrids()) {
                String currName = dt.getName();
                ++total;
                Attribute att = dt.findAttributeIgnoreCase("Grib_Parameter");
                int number = att == null ? 0 : att.getNumericValue().intValue();
                if (number < 128) continue;
                fm.format("  local parameter = %s (%d) units=%s %n", currName, number, dt.getUnitsString());
                ++local;
                if (!currName.startsWith("VAR")) continue;
                ++miss;
            }
        }
        fm.format("total=%d local = %d miss=%d %n", total, local, miss);
        accum[0] = accum[0] + total;
        accum[1] = accum[1] + nonop;
        accum[2] = accum[2] + local;
        accum[3] = accum[3] + miss;
    }

    private void doCheckTables(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        Counters counters = new Counters();
        for (MFile mfile : dcm.getFilesSorted()) {
            String path = mfile.getPath();
            f.format(" %s%n", path);
            if (useIndex) {
                this.doCheckTablesWithIndex(f, mfile, counters);
                continue;
            }
            this.doCheckTablesNoIndex(f, mfile, counters);
        }
        f.format("Check Parameter Tables%n", new Object[0]);
        counters.show(f);
    }

    private void doCheckTablesWithIndex(Formatter mf, MFile ff, Counters counters) throws IOException {
        Grib1Index index = this.createIndex(ff);
        if (index == null) {
            return;
        }
        for (Grib1Record gr : index.getRecords()) {
            this.doCheckTables(gr, counters);
        }
    }

    private void doCheckTablesNoIndex(Formatter fm, MFile ff, Counters counters) throws IOException {
        String path = ff.getPath();
        try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
            raf.order(0);
            raf.seek(0L);
            Grib1RecordScanner reader = new Grib1RecordScanner(raf);
            while (reader.hasNext()) {
                Grib1Record gr = reader.next();
                if (gr == null) {
                    break;
                }
                this.doCheckTables(gr, counters);
            }
        }
        catch (Throwable ioe) {
            fm.format("Failed on %s == %s%n", path, ioe.getMessage());
            System.out.printf("Failed on %s%n", path);
            ioe.printStackTrace();
        }
    }

    private void doCheckTables(Grib1Record gr, Counters counters) throws IOException {
        Grib1ParamTableReader table;
        Grib1SectionProductDefinition pds = gr.getPDSsection();
        String key = Grib1Utils.extractParameterCode((Grib1Record)gr);
        counters.count("center", (Comparable)Integer.valueOf(pds.getCenter()));
        counters.count("tableVersion", (Comparable)((Object)key));
        if (pds.getParameterNumber() > 127) {
            counters.count("local", (Comparable)((Object)key));
        }
        if ((table = new Grib1ParamTables().getParameterTable(pds.getCenter(), pds.getSubCenter(), pds.getTableVersion())) == null || null == table.getParameter(pds.getParameterNumber())) {
            counters.count("missing", (Comparable)((Object)key));
        }
    }

    private void doScanIssues(Formatter f, MCollection dcm, boolean useIndex, boolean eachFile, boolean extraInfo) throws IOException {
        Counters countersAll = new Counters();
        for (MFile mfile : dcm.getFilesSorted()) {
            Counters countersOneFile = countersAll.makeSubCounters();
            String path = mfile.getPath();
            f.format(" %s%n", path);
            if (useIndex) {
                this.doScanIssuesWithIndex(f, mfile, extraInfo, countersOneFile);
            } else {
                this.doScanIssuesNoIndex(f, mfile, extraInfo, countersOneFile);
            }
            if (eachFile) {
                countersOneFile.show(f);
            }
            countersAll.addTo(countersOneFile);
        }
        f.format("ScanIssues - all files%n", new Object[0]);
        countersAll.show(f);
    }

    private void doScanIssuesWithIndex(Formatter fm, MFile ff, boolean extraInfo, Counters counters) throws IOException {
        Grib1Index index = this.createIndex(ff);
        if (index == null) {
            return;
        }
        for (Grib1Record gr : index.getRecords()) {
            this.doScanIssues(gr, fm, ff.getPath(), extraInfo, counters);
        }
    }

    private void doScanIssuesNoIndex(Formatter fm, MFile ff, boolean extraInfo, Counters counters) throws IOException {
        String path = ff.getPath();
        try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
            raf.order(0);
            raf.seek(0L);
            Grib1RecordScanner reader = new Grib1RecordScanner(raf);
            while (reader.hasNext()) {
                Grib1Record gr = reader.next();
                if (gr == null) {
                    break;
                }
                this.doScanIssues(gr, fm, path, extraInfo, counters);
            }
        }
        catch (Throwable ioe) {
            fm.format("Failed on %s == %s%n", path, ioe.getMessage());
            System.out.printf("Failed on %s%n", path);
            ioe.printStackTrace();
        }
    }

    private void doScanIssues(Grib1Record gr, Formatter fm, String path, boolean extraInfo, Counters counters) throws IOException {
        Grib1SectionGridDefinition gdss = gr.getGDSsection();
        Grib1Gds gds = gdss.getGDS();
        Grib1SectionProductDefinition pds = gr.getPDSsection();
        String table = pds.getCenter() + "-" + pds.getSubCenter() + "-" + pds.getTableVersion();
        counters.count("table version", (Comparable)((Object)table));
        counters.count("param", (Comparable)Integer.valueOf(pds.getParameterNumber()));
        counters.count("timeRangeIndicator", (Comparable)Integer.valueOf(pds.getTimeRangeIndicator()));
        counters.count("vertCoord", (Comparable)Integer.valueOf(pds.getLevelType()));
        counters.count("referenceDate", (Comparable)((Object)pds.getReferenceDate().toString()));
        if (this.cust == null) {
            this.cust = Grib1Customizer.factory((Grib1Record)gr, null);
        }
        Grib1ParamTime ptime = this.cust.getParamTime(pds);
        counters.count("timeCoord", (Comparable)((Object)ptime.getTimeCoord()));
        counters.count("earthShape", (Comparable)Integer.valueOf(gds.getEarthShape()));
        counters.count("UVisReletiveToEastNorth", (Comparable)((Object)(gds.getUVisReletiveToEastNorth() ? "true" : "false")));
        if (gdss.isThin()) {
            if (extraInfo) {
                fm.format("  THIN= (gds=%d) %s%n", gdss.getGridTemplate(), path);
            }
            counters.count("thin", (Comparable)Integer.valueOf(gdss.getGridTemplate()));
        }
        if (!pds.gdsExists()) {
            if (extraInfo) {
                fm.format("   PREDEFINED GDS= %s%n", path);
            }
            counters.count("predefined", (Comparable)Integer.valueOf(gdss.getPredefinedGridDefinition()));
        }
        if (gdss.hasVerticalCoordinateParameters()) {
            if (extraInfo) {
                fm.format("   Has vertical coordinates in GDS= %s%n", path);
            }
            counters.count("vertCoordInGDS", (Comparable)Integer.valueOf(pds.getLevelType()));
        }
    }

    private void doShowEncoding(Formatter f, MCollection dcm) throws IOException {
        Counters countersAll = new Counters();
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format(" %s%n", mfile.getPath());
            this.doShowEncodingNoIndex(f, mfile, countersAll);
        }
        countersAll.show(f);
    }

    private void doShowEncodingNoIndex(Formatter fm, MFile ff, Counters counters) throws IOException {
        String path = ff.getPath();
        try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
            raf.order(0);
            raf.seek(0L);
            Grib1RecordScanner reader = new Grib1RecordScanner(raf);
            while (reader.hasNext()) {
                Grib1Record gr = reader.next();
                if (gr == null) {
                    break;
                }
                GribData.Info info = gr.getBinaryDataInfo(raf);
                counters.count("decimalScale", (Comparable)Integer.valueOf(info.decimalScaleFactor));
                counters.count("binScale", (Comparable)Integer.valueOf(info.binaryScaleFactor));
                counters.count("nbits", (Comparable)Integer.valueOf(info.numberOfBits));
                counters.count("gridType", (Comparable)((Object)info.getGridPointS()));
                counters.count("packing", (Comparable)((Object)info.getPackingS()));
                counters.count("dataType", (Comparable)((Object)info.getDataTypeS()));
                counters.count("hasOctet14", (Comparable)Integer.valueOf(info.hasOctet14() ? 1 : 0));
                if (info.binaryScaleFactor != 0 && info.decimalScaleFactor != 0) {
                    counters.count("scale", (Comparable)Integer.valueOf(1));
                    continue;
                }
                counters.count("scale", (Comparable)Integer.valueOf(0));
            }
        }
        catch (Throwable ioe) {
            fm.format("Failed on %s == %s%n", path, ioe.getMessage());
            System.out.printf("Failed on %s%n", path);
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doRename(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("CHECK Grib-1 Names: Old vs New for collection %s%n", dcm.getCollectionName());
        ArrayList<VarName> varNames = new ArrayList<VarName>(3000);
        HashMap<String, List> gridsAll = new HashMap<String, List>(1000);
        for (MFile mfile : dcm.getFilesSorted()) {
            GridMatch gmOld;
            GridMatch match;
            f.format("%n%s%n", mfile.getPath());
            Map<Integer, GridMatch> gridsNew = this.getGridsNew(mfile, f);
            Map<Integer, GridMatch> gridsOld = this.getGridsOld(mfile, f);
            for (GridMatch gridMatch : gridsNew.values()) {
                match = (GridMatch)gridsOld.get(gridMatch.hashCode());
                if (match == null) continue;
                gridMatch.match = match;
                match.match = gridMatch;
            }
            for (GridMatch gridMatch : gridsNew.values()) {
                if (gridMatch.match != null || (match = this.altMatch(gridMatch, gridsOld.values())) == null) continue;
                gridMatch.match = match;
                match.match = gridMatch;
            }
            f.format("%n", new Object[0]);
            ArrayList<GridMatch> listNew = new ArrayList<GridMatch>(gridsNew.values());
            Collections.sort(listNew);
            for (Object gm3 : listNew) {
                f.format(" %s%n", ((GridMatch)gm3).grid.getFullName());
                if (((GridMatch)gm3).match != null) {
                    f.format(" %s%n", ((GridMatch)gm3).match.grid.getFullName());
                }
                f.format("%n", new Object[0]);
            }
            f.format("%nMISSING MATCHES IN NEW%n", new Object[0]);
            ArrayList<GridMatch> arrayList = new ArrayList<GridMatch>(gridsNew.values());
            Collections.sort(arrayList);
            for (GridMatch gridMatch : arrayList) {
                if (gridMatch.match != null) continue;
                f.format(" %s (%s) == %s%n", gridMatch.grid.getFullName(), gridMatch.show(), gridMatch.grid.getDescription());
            }
            f.format("%nMISSING MATCHES IN OLD%n", new Object[0]);
            ArrayList listOld = new ArrayList(gridsOld.values());
            Collections.sort(listOld);
            Iterator iterator = listOld.iterator();
            while (iterator.hasNext()) {
                GridMatch gm5 = (GridMatch)iterator.next();
                if (gm5.match != null) continue;
                f.format(" %s (%s)%n", gm5.grid.getFullName(), gm5.show());
            }
            Iterator iterator2 = listOld.iterator();
            while (iterator2.hasNext()) {
                String keyNew;
                gmOld = (GridMatch)iterator2.next();
                String key = gmOld.grid.getFullName();
                List newGrids = gridsAll.computeIfAbsent(key, k -> new ArrayList());
                if (gmOld.match == null || newGrids.contains(keyNew = gmOld.match.grid.getFullName() + " == " + gmOld.match.grid.getDescription())) continue;
                newGrids.add(keyNew);
            }
            Iterator iterator3 = listOld.iterator();
            while (iterator3.hasNext()) {
                gmOld = (GridMatch)iterator3.next();
                if (gmOld.match == null) {
                    f.format("MISSING %s (%s)%n", gmOld.grid.getFullName(), gmOld.show());
                    continue;
                }
                Attribute att = gmOld.match.grid.findAttributeIgnoreCase("Grib_Variable_Id");
                String varId = att == null ? "" : att.getStringValue();
                varNames.add(new VarName(mfile.getName(), gmOld.grid.getShortName(), gmOld.match.grid.getShortName(), varId));
            }
        }
        f.format("%nOLD -> NEW MAPPINGS%n", new Object[0]);
        ArrayList keys = new ArrayList(gridsAll.keySet());
        int total = keys.size();
        int dups = 0;
        Collections.sort(keys);
        for (String key : keys) {
            f.format(" OLD %s%n", key);
            List list = (List)gridsAll.get(key);
            Collections.sort(list);
            if (list.size() > 1) {
                ++dups;
            }
            for (String string : list) {
                f.format(" NEW %s%n", string);
            }
            f.format("%n", new Object[0]);
        }
        f.format("Number with more than one map=%d total=%d%n", dups, total);
        if (!useIndex) {
            Element rootElem = new Element("gribVarMap");
            Document doc = new Document(rootElem);
            rootElem.setAttribute("collection", dcm.getCollectionName());
            Object var11_21 = null;
            Element dsElem = null;
            for (VarName vn : varNames) {
                void var11_22;
                if (!vn.dataset.equals(var11_22)) {
                    dsElem = new Element("dataset");
                    rootElem.addContent((Content)dsElem);
                    dsElem.setAttribute("name", vn.dataset);
                    String string = vn.dataset;
                }
                Element param = new Element("param");
                dsElem.addContent((Content)param);
                param.setAttribute("oldName", vn.oldVar);
                param.setAttribute("newName", vn.newVar);
                param.setAttribute("varId", vn.varId);
            }
            FileOutputStream fileOutputStream = new FileOutputStream("C:/tmp/grib1VarMap.xml");
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            fmt.output(doc, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
    }

    private GridMatch altMatch(GridMatch want, Collection<GridMatch> test) {
        for (GridMatch gm : test) {
            if (gm.match != null || !gm.altMatch(want)) continue;
            return gm;
        }
        for (GridMatch gm : test) {
            if (gm.match != null || !gm.altMatchNoProb(want)) continue;
            return gm;
        }
        return null;
    }

    private Map<Integer, GridMatch> getGridsNew(MFile ff, Formatter f) throws IOException {
        HashMap<Integer, GridMatch> grids = new HashMap<Integer, GridMatch>(100);
        try (GridDataset ncfile = GridDataset.open((String)ff.getPath());){
            for (GridDatatype dt : ncfile.getGrids()) {
                GridMatch gm = new GridMatch(ncfile, dt, true);
                GridMatch dup = (GridMatch)grids.get(gm.hashCode());
                if (dup != null) {
                    f.format(" DUP NEW (%d == %d) = %s (%s) and DUP %s (%s)%n", gm.hashCode(), dup.hashCode(), gm.grid.getFullName(), gm.show(), dup.grid.getFullName(), dup.show());
                    continue;
                }
                grids.put(gm.hashCode(), gm);
            }
        }
        return grids;
    }

    private Map<Integer, GridMatch> getGridsOld(MFile ff, Formatter f) throws IOException {
        HashMap<Integer, GridMatch> grids = new HashMap<Integer, GridMatch>(100);
        try (NetcdfFile ncfile = NetcdfFiles.open((String)ff.getPath(), (String)"ucar.nc2.iosp.grib.GribServiceProvider", (int)-1, null, null);){
            NetcdfDataset ncd = new NetcdfDataset(ncfile);
            GridDataset grid = new GridDataset(ncd);
            for (GridDatatype dt : grid.getGrids()) {
                GridMatch gm = new GridMatch(grid, dt, false);
                GridMatch dup = (GridMatch)grids.get(gm.hashCode());
                if (dup != null) {
                    f.format(" DUP OLD (%d == %d) = %s (%s) and DUP %s (%s)%n", gm.hashCode(), dup.hashCode(), gm.grid.getFullName(), gm.show(), dup.grid.getFullName(), dup.show());
                    continue;
                }
                grids.put(gm.hashCode(), gm);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return grids;
    }

    private void doUniqueGds(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Show Unique GDS%n", new Object[0]);
        HashMap<Integer, GdsList> gdsSet = new HashMap<Integer, GdsList>();
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format(" %s%n", mfile.getPath());
            this.doUniqueGds(mfile, gdsSet, f);
        }
        ArrayList sorted = new ArrayList(gdsSet.values());
        Collections.sort(sorted);
        for (GdsList gdsl : sorted) {
            f.format("%nGDS %s template= %d %n", gdsl.gds.getNameShort(), gdsl.gds.template);
            for (FileCount fc : gdsl.fileList) {
                f.format("  %5d %s %n", fc.countRecords, fc.f.getPath());
            }
        }
    }

    private void doUniqueGds(MFile mf, Map<Integer, GdsList> gdsSet, Formatter f) throws IOException {
        Grib1Index g1idx = new Grib1Index();
        String path = mf.getPath();
        boolean ok = g1idx.readIndex(path, 0L, CollectionUpdateType.nocheck);
        if (!ok) {
            f.format("**Cant open %s%n", path);
            return;
        }
        for (Grib1Record gr : g1idx.getRecords()) {
            int template = gr.getGDSsection().getGDS().template;
            gdsSet.computeIfAbsent(template, k -> new GdsList(gr.getGDSsection().getGDS()));
            GdsList gdsList = gdsSet.get(template);
            FileCount fc = gdsList.findOrAdd(mf);
            ++fc.countRecords;
        }
    }

    private static class FileCount {
        MFile f;
        int countRecords;

        private FileCount(MFile f) {
            this.f = f;
        }
    }

    private class GdsList
    implements Comparable<GdsList> {
        Grib1Gds gds;
        List<FileCount> fileList = new ArrayList<FileCount>();

        private GdsList(Grib1Gds gds) {
            this.gds = gds;
        }

        FileCount findOrAdd(MFile f) {
            for (FileCount fc : this.fileList) {
                if (!fc.f.getPath().equals(f.getPath())) continue;
                return fc;
            }
            FileCount fc = new FileCount(f);
            this.fileList.add(fc);
            return fc;
        }

        @Override
        public int compareTo(GdsList o) {
            return this.gds.template - o.gds.template;
        }
    }

    private static class GridMatch
    implements Comparable<GridMatch> {
        GridDatatype grid;
        GridMatch match;
        boolean isNew;
        int[] param = new int[3];
        int level;
        boolean isLayer;
        boolean isError;
        int interval = -1;
        int prob = -1;
        int ens = -1;
        int probLimit;

        private GridMatch(GridDataset gds, GridDatatype grid, boolean aNew) {
            this.grid = grid;
            this.isNew = aNew;
            GridCoordSystem gcs = grid.getCoordinateSystem();
            CoordinateAxis1D zaxis = gcs.getVerticalAxis();
            if (zaxis != null) {
                this.isLayer = zaxis.isInterval();
            }
            if (this.isNew) {
                int intv;
                Attribute att = grid.findAttributeIgnoreCase("Grib1_Center");
                this.param[0] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("Grib1_Subcenter");
                this.param[1] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("Grib1_Parameter");
                this.param[2] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("Grib1_Level_Type");
                this.level = att.getNumericValue().intValue();
                this.isError = grid.getName().contains("error");
                att = grid.findAttributeIgnoreCase("Grib1_Statistical_Interval_Type");
                if (att != null && (intv = att.getNumericValue().intValue()) != 255) {
                    this.interval = intv;
                }
                if ((att = grid.findAttributeIgnoreCase("Grib1_Probability_Type")) != null) {
                    this.prob = att.getNumericValue().intValue();
                }
                if ((att = grid.findAttributeIgnoreCase("Grib1_Probability_Name")) != null) {
                    String pname = att.getStringValue();
                    int pos = pname.indexOf(95);
                    pname = pname.substring(pos + 1);
                    this.probLimit = (int)(1000.0 * Double.parseDouble(pname));
                }
                if ((att = grid.findAttributeIgnoreCase("Grib1_Ensemble_Derived_Type")) != null) {
                    this.ens = att.getNumericValue().intValue();
                }
            } else {
                Attribute att = grid.findAttributeIgnoreCase("GRIB_center_id");
                this.param[0] = att.getNumericValue().intValue();
                att = gds.attributes().findAttribute("Originating_subcenter_id");
                this.param[1] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("GRIB_param_number");
                this.param[2] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("GRIB_level_type");
                this.level = att.getNumericValue().intValue();
                this.isError = grid.getName().contains("error");
                String desc = grid.getDescription();
                if (desc.contains("Accumulation")) {
                    this.interval = 4;
                }
                if ((att = grid.findAttributeIgnoreCase("GRIB_probability_type")) != null) {
                    this.prob = att.getNumericValue().intValue();
                }
                if (this.prob == 0) {
                    att = grid.findAttributeIgnoreCase("GRIB_probability_lower_limit");
                    if (att != null) {
                        this.probLimit = (int)(1000.0 * att.getNumericValue().doubleValue());
                    }
                } else if (this.prob == 1 && (att = grid.findAttributeIgnoreCase("GRIB_probability_upper_limit")) != null) {
                    this.probLimit = (int)(1000.0 * att.getNumericValue().doubleValue());
                }
                if ((att = grid.findAttributeIgnoreCase("GRIB_ensemble_derived_type")) != null) {
                    this.ens = att.getNumericValue().intValue();
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridMatch gridMatch = (GridMatch)o;
            if (!Arrays.equals(this.param, gridMatch.param)) {
                return false;
            }
            if (this.ens != gridMatch.ens) {
                return false;
            }
            if (this.interval != gridMatch.interval) {
                return false;
            }
            if (this.isError != gridMatch.isError) {
                return false;
            }
            if (this.isLayer != gridMatch.isLayer) {
                return false;
            }
            if (this.level != gridMatch.level) {
                return false;
            }
            if (this.prob != gridMatch.prob) {
                return false;
            }
            return this.probLimit == gridMatch.probLimit;
        }

        public boolean altMatch(GridMatch gridMatch) {
            if (!this.altMatchNoProb(gridMatch)) {
                return false;
            }
            if (this.probLimit / 1000 == gridMatch.probLimit) {
                return true;
            }
            return this.probLimit == gridMatch.probLimit / 1000;
        }

        public boolean altMatchNoProb(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridMatch gridMatch = (GridMatch)o;
            if (this.ens != gridMatch.ens) {
                return false;
            }
            if (this.interval != gridMatch.interval) {
                return false;
            }
            if (this.isError != gridMatch.isError) {
                return false;
            }
            if (this.isLayer != gridMatch.isLayer) {
                return false;
            }
            if (this.level != gridMatch.level) {
                return false;
            }
            return this.prob == gridMatch.prob;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.level;
            result = 31 * result + this.param[0];
            result = 31 * result + (this.isLayer ? 1 : 0);
            result = 31 * result + (this.isError ? 1 : 0);
            result = 31 * result + this.param[1];
            result = 31 * result + this.interval;
            result = 31 * result + this.prob;
            result = 31 * result + this.param[2];
            result = 31 * result + this.ens;
            result = 31 * result + this.probLimit;
            return result;
        }

        @Override
        public int compareTo(GridMatch o) {
            return this.grid.compareTo((Object)o.grid);
        }

        String show() {
            Formatter f = new Formatter();
            f.format("%d-%d-%d-", this.param[0], this.param[1], this.param[2]);
            f.format("%d", this.level);
            if (this.isLayer) {
                f.format("_layer", new Object[0]);
            }
            if (this.interval >= 0) {
                f.format("_intv%d", this.interval);
            }
            if (this.prob >= 0) {
                f.format("_prob%d_%d", this.prob, this.probLimit);
            }
            if (this.ens >= 0) {
                f.format("_ens%d", this.ens);
            }
            if (this.isError) {
                f.format("_error", new Object[0]);
            }
            return f.toString();
        }
    }

    private static class VarName {
        String dataset;
        String oldVar;
        String newVar;
        String varId;

        private VarName(String dataset, String oldVar, String newVar, String varId) {
            this.dataset = dataset;
            this.oldVar = oldVar;
            this.newVar = newVar;
            this.varId = varId;
        }
    }

    public static enum Report {
        checkTables,
        showLocalParams,
        summary,
        rename,
        showEncoding,
        gribIndex,
        gds;

    }
}

