/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.JPanel;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionFiltered;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public abstract class ReportPanel
extends JPanel {
    protected PreferencesExt prefs;
    protected TextHistoryPane reportPane;
    protected String spec;

    protected ReportPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.reportPane = new TextHistoryPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.reportPane, "Center");
    }

    public void addOptions(JPanel buttPanel) {
    }

    public void save() {
    }

    protected abstract void doReport(Formatter var1, Object var2, MCollection var3, boolean var4, boolean var5, boolean var6) throws IOException;

    public abstract Object[] getOptions();

    public void doReport(String spec, boolean useIndex, boolean eachFile, boolean extra, Object option) throws IOException {
        Formatter f = new Formatter();
        f.format("%s on %s useIndex=%s eachFile=%s extra=%s%n", option, spec, useIndex, eachFile, extra);
        this.spec = spec;
        try (MCollection dcm = this.getCollection(spec, f);){
            if (dcm == null) {
                return;
            }
            f.format("top dir = %s%n", dcm.getRoot());
            this.reportPane.setText(f.toString());
            File top = new File(dcm.getRoot());
            if (!top.exists()) {
                f.format("top dir = %s does not exist%n", dcm.getRoot());
            } else {
                this.doReport(f, option, dcm, useIndex, eachFile, extra);
            }
            this.reportPane.setText(f.toString());
            this.reportPane.gotoTop();
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter(50000);
            ioe.printStackTrace(new PrintWriter(sw));
            f.format(sw.toString(), new Object[0]);
            ioe.printStackTrace();
        }
    }

    public boolean showCollection(String spec) {
        Formatter f = new Formatter();
        f.format("collection = %s%n", spec);
        boolean hasFiles = false;
        try (MCollection dcm = this.getCollection(spec, f);){
            if (dcm == null) {
                boolean bl = false;
                return bl;
            }
            try {
                for (MFile mfile : dcm.getFilesSorted()) {
                    f.format(" %s%n", mfile.getPath());
                    hasFiles = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.reportPane.setText(f.toString());
            this.reportPane.gotoTop();
            boolean bl = hasFiles;
            return bl;
        }
    }

    MCollection getCollection(String spec, Formatter f) {
        try {
            MCollection org = CollectionAbstract.open((String)spec, (String)spec, null, (Formatter)f);
            CollectionFiltered filteredCollection = new CollectionFiltered("GribReportPanel", org, new MFileFilter(){

                public boolean accept(MFile mfile) {
                    String suffix = mfile.getName();
                    return !suffix.contains(".gbx");
                }
            });
            return filteredCollection;
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter(10000);
            e.printStackTrace(new PrintWriter(sw));
            this.reportPane.setText(sw.toString());
            return null;
        }
    }

    protected MCollection getCollectionUnfiltered(String spec, Formatter f) {
        try {
            return CollectionAbstract.open((String)spec, (String)spec, null, (Formatter)f);
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter(10000);
            e.printStackTrace(new PrintWriter(sw));
            this.reportPane.setText(sw.toString());
            return null;
        }
    }
}

